/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.semarchy.xdi.designer.core.services.IInternalResourceRegistry;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.osgi.framework.Bundle;

public class TemporaryFolderOutputURIConverter
implements URIConverter {
    public static final IPath temporaryBuildLocation;
    private URIConverter wrappedConverter;

    static {
        IPath path = Platform.getStateLocation((Bundle)Platform.getBundle((String)"com.indy.gmf.map"));
        temporaryBuildLocation = path = path.append("/tempBuiltFiles");
        ((IInternalResourceRegistry)E4InjectorHelper.getService(IInternalResourceRegistry.class)).generateInternalResourceFiles();
    }

    public TemporaryFolderOutputURIConverter(URIConverter base) {
        this.wrappedConverter = base;
    }

    public URI normalize(URI uri) {
        return this.wrappedConverter.normalize(uri);
    }

    public Map<URI, URI> getURIMap() {
        return this.wrappedConverter.getURIMap();
    }

    public EList<URIHandler> getURIHandlers() {
        return this.wrappedConverter.getURIHandlers();
    }

    public URIHandler getURIHandler(URI uri) {
        return this.wrappedConverter.getURIHandler(uri);
    }

    public EList<ContentHandler> getContentHandlers() {
        return this.wrappedConverter.getContentHandlers();
    }

    public InputStream createInputStream(URI uri) throws IOException {
        return this.wrappedConverter.createInputStream(uri);
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        return this.wrappedConverter.createInputStream(uri, options);
    }

    public OutputStream createOutputStream(URI uri) throws IOException {
        return this.createOutputStream(uri, null);
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        if (uri.isPlatformPlugin() && uri.segmentCount() > 1 && "com.indy.gmf.map".equals(uri.segment(1))) {
            IPath p = temporaryBuildLocation.append(uri.lastSegment());
            File file = p.toFile();
            String parent = file.getParent();
            if (parent != null) {
                new File(parent).mkdirs();
            }
            return new BufferedOutputStream(new FileOutputStream(file));
        }
        return this.wrappedConverter.createOutputStream(uri, options);
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        if (uri.isPlatformPlugin() && uri.segmentCount() > 1 && "".equals(uri.segment(1))) {
            IPath p = temporaryBuildLocation.append(uri.lastSegment());
            Files.deleteIfExists(p.toFile().toPath());
        } else {
            this.wrappedConverter.delete(uri, options);
        }
    }

    public Map<String, ?> contentDescription(URI uri, Map<?, ?> options) throws IOException {
        return this.wrappedConverter.contentDescription(uri, options);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return this.wrappedConverter.exists(uri, options);
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        return this.wrappedConverter.getAttributes(uri, options);
    }

    public void setAttributes(URI uri, Map<String, ?> attributes, Map<?, ?> options) throws IOException {
        this.wrappedConverter.setAttributes(uri, attributes, options);
    }
}

