/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.Link;
import com.indy.gmf.proc.LinkType;
import com.indy.gmf.proc.MandatoryType;
import com.indy.gmf.proc.MetaDataLink;
import com.indy.gmf.proc.ProcFactory;
import com.indy.gmf.proc.impl.MetaDataLinkImpl;
import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.ISerde;
import com.indy.map.Query;
import com.indy.map.QueryField;
import com.indy.map.SerdeField;
import javax.xml.namespace.QName;
import org.eclipse.emf.ecore.EObject;

public class Utils {
    private Utils() {
    }

    public static String computeWorkName(String str) {
        return str.replaceAll("[^\\w]", "_");
    }

    public static String truncation(String name) {
        if (name.length() > 30) {
            return name.substring(0, 30);
        }
        return name;
    }

    public static MetaDataLink addMdREFOnAction(Action action, EObject node, String name) {
        MetaDataLink mdl = ProcFactory.eINSTANCE.createMetaDataLink();
        mdl.setName(new QName(name));
        action.getMetaDataLink().add((Object)mdl);
        ((MetaDataLinkImpl)mdl).setTarget(node);
        return mdl;
    }

    public static void link(Action source, Action target) {
        if (source != null && target != null) {
            for (Link lnk : source.getLink()) {
                if (lnk.getTargetId() != target) continue;
                return;
            }
            Link link = ProcFactory.eINSTANCE.createLink();
            link.setMandatory(MandatoryType.MANDATORY);
            link.setGenerationType(LinkType.OKKO);
            link.setTargetId(target);
            source.getLink().add((Object)link);
        }
    }

    public static boolean isGeneratedAsDatastore(IContainer container) {
        if (container instanceof Datastore) {
            return true;
        }
        if (container instanceof Query) {
            for (ILogicalField f : container.getLogicalField()) {
                if (!(f instanceof QueryField) || ((IMetaData)f).basicGetRef() == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isGeneratedAsQuery(IContainer container) {
        if (container instanceof Query) {
            for (ILogicalField f : container.getLogicalField()) {
                if (!(f instanceof QueryField) || ((IMetaData)f).basicGetRef() == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isGeneratedAsDatastoreField(Object field) {
        if (((EObject)field).eContainer() instanceof ISerde) {
            if (field instanceof SerdeField && ((SerdeField)field).basicGetRef() != null) {
                return true;
            }
            return Utils.isGeneratedAsDatastore((IContainer)((ILogicalField)field).eContainer());
        }
        if (field instanceof QueryField || field instanceof Field) {
            if (field instanceof QueryField) {
                return Utils.isGeneratedAsDatastore((IContainer)((ILogicalField)field).eContainer());
            }
            return true;
        }
        return false;
    }

    public static boolean isGeneratedAsQueryField(Object field) {
        if (field instanceof QueryField) {
            return !Utils.isGeneratedAsDatastore((IContainer)((QueryField)field).eContainer());
        }
        return false;
    }
}

