/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal.debug;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

class DebugMdModel {
    List<Step> steps = new ArrayList<Step>();
    List<MdLink> mdLinks = new ArrayList<MdLink>();
    List<PlaceHolder> placeHolders = new ArrayList<PlaceHolder>();

    DebugMdModel() {
    }

    PlaceHolder placeHolder(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        PlaceHolder h = new PlaceHolder();
        h.readValue = value;
        this.placeHolders.add(h);
        return h;
    }

    PlaceHolder placeHolder4TrgField(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        PlaceHolderV3 h = new PlaceHolderV3();
        h.readValue = value;
        this.placeHolders.add(h);
        return h;
    }

    public void replacePlaceHolders() {
        for (PlaceHolder h : this.placeHolders) {
            h.performReplace();
        }
    }

    static class Constraint {
        String name;
        PlaceHolder target;
        String type;

        Constraint() {
        }
    }

    static class ExtraStatic {
        PlaceHolder child;
        PlaceHolder parent;

        ExtraStatic() {
        }
    }

    static class Field {
        String name;
        PlaceHolder expression;
        String location;
        String workName;
        PlaceHolder target;
        List<PlaceHolder> targets = new ArrayList<PlaceHolder>();
        PlaceHolder base;
        String insert;
        String update;
        String updateKey;
        List<String> tags = new ArrayList<String>();
        List<PlaceHolder> sources = new ArrayList<PlaceHolder>();
        String sourceSetName;
        String number;
        String version;
        List<PlaceHolder> sourceNames = new ArrayList<PlaceHolder>();
        List<String> sourceContainers = new ArrayList<String>();
        String outlinerOutput;
        String outlinerInput;
        String mdNodeFieldReference;
        List<ExtraStatic> extraStaticRelation = new ArrayList<ExtraStatic>();

        Field() {
        }
    }

    static class Filter {
        PlaceHolder expression;
        String aggregate;
        String qualify;
        List<PlaceHolder> sources = new ArrayList<PlaceHolder>();
        List<PlaceHolder> sourceNames = new ArrayList<PlaceHolder>();
        String sourceSetName;
        String version;
        List<String> sourceContainers = new ArrayList<String>();
        List<String> tags = new ArrayList<String>();
        String operator;
        String location;

        Filter() {
        }
    }

    static class Join {
        PlaceHolder expression;
        String left;
        String right;
        String order;
        String type;
        String mode;
        List<PlaceHolder> sources = new ArrayList<PlaceHolder>();
        String sourceSetName;
        String version;
        List<PlaceHolder> sourceNames = new ArrayList<PlaceHolder>();
        List<String> sourceContainers = new ArrayList<String>();
        List<String> tags = new ArrayList<String>();

        Join() {
        }
    }

    static class MdLink {
        String name;
        String referenceURI;

        MdLink() {
        }
    }

    class PlaceHolder {
        String readValue;
        String replacedValue;

        PlaceHolder() {
        }

        public String toString() {
            return this.replacedValue == null ? this.readValue : this.replacedValue;
        }

        public boolean isNull() {
            return this.readValue == null || this.readValue.isEmpty();
        }

        protected void performReplace() {
            if (this.readValue.startsWith("$MD_")) {
                Optional<MdLink> lnk = DebugMdModel.this.mdLinks.stream().filter(l -> this.readValue.substring(1).equals(l.name)).findFirst();
                if (lnk.isPresent()) {
                    this.replacedValue = "$MD_" + lnk.get().referenceURI;
                }
            } else {
                int currIndex = 0;
                StringBuilder b = new StringBuilder();
                while (currIndex < this.readValue.length()) {
                    int start = this.readValue.indexOf("%{MD_", currIndex);
                    if (start == -1) {
                        b.append(this.readValue.substring(currIndex));
                        break;
                    }
                    int end = this.readValue.indexOf("}%", start);
                    Optional<MdLink> lnk = DebugMdModel.this.mdLinks.stream().filter(l -> this.readValue.substring(start + 2, end).equals(l.name)).findFirst();
                    b.append(this.readValue.substring(currIndex, start));
                    b.append("%{MD_");
                    if (lnk.isPresent()) {
                        b.append(lnk.get().referenceURI);
                    }
                    b.append("}%");
                    currIndex = end + 2;
                }
                this.replacedValue = b.toString();
            }
        }
    }

    class PlaceHolderV3
    extends PlaceHolder {
        PlaceHolderV3() {
        }

        @Override
        protected void performReplace() {
            super.performReplace();
            int currIndex = 0;
            StringBuilder b = new StringBuilder();
            while (currIndex < this.replacedValue.length()) {
                int start = this.replacedValue.indexOf("$MD_", currIndex);
                if (start == -1) {
                    b.append(this.replacedValue.substring(currIndex));
                    break;
                }
                int index = start + 4;
                StringBuilder indexBuffer = new StringBuilder();
                while (index < this.replacedValue.length() && Character.isDigit(this.replacedValue.charAt(index))) {
                    indexBuffer.append(this.replacedValue.charAt(index));
                    ++index;
                }
                String name = "MD_" + indexBuffer.toString();
                Optional<MdLink> lnk = DebugMdModel.this.mdLinks.stream().filter(l -> name.equals(l.name)).findFirst();
                b.append(this.readValue.substring(currIndex, start));
                b.append("$MD_");
                if (lnk.isPresent()) {
                    b.append(lnk.get().referenceURI);
                }
                currIndex = index;
            }
            this.replacedValue = b.toString();
        }
    }

    static class Source {
        String name;
        PlaceHolder target;
        String isCDC;
        String sourceSetName;
        List<String> tags = new ArrayList<String>();
        String order;
        String number;
        String filteringSource;
        String stepName;

        Source() {
        }
    }

    static class Step {
        String name;
        String type;
        String number;
        String setExpression;
        PlaceHolder targetUpdateKeyRef;
        String outputStructureReference;
        List<String> integrationStepNames;
        List<Source> source = new ArrayList<Source>();
        List<Field> field = new ArrayList<Field>();
        List<Join> join = new ArrayList<Join>();
        List<Filter> filter = new ArrayList<Filter>();
        List<Constraint> constraint = new ArrayList<Constraint>();

        Step() {
        }
    }
}

