/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.model.xdg.internal;

import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.util.synchro.updaters.impl.FieldUpdater;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.stambia.md.Attribute;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.MdRootNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;

class Builder {
    private static final String TECH_ID = "UUID_TECH_XDI_HARVESTED";
    private static final String LVL_MODEL = "com.semarchy.xdi.harvest.model";
    private static final String LVL_MAPPING_RESOURCE = "com.semarchy.xdi.harvest.mapping";
    private static final String LVL_MD_RESOURCE = "com.semarchy.xdi.harvest.metadata";
    private static final String LVL_SOURCESET = "com.semarchy.xdi.harvest.sourceset";
    private static final String LVL_SOURCESET_FIELD = "com.semarchy.xdi.harvest.sourcesetfield";
    private static final String LVL_DATASTORE = "com.semarchy.xdi.harvest.datastore";
    private static final String LVL_DATASTORE_FIELD = "com.semarchy.xdi.harvest.datastorefield";
    private static final String LVL_STORE = "com.semarchy.xdi.harvest.store";
    private static final String LVL_SS_TO_TRG_DATASTORE_RELATION = "com.semarchy.xdi.harvest.sourceSetToTargetDatastore";
    private static final String LVL_SS_DATASTORE_FIELD_MAPPING_RELATION = "com.semarchy.xdi.harvest.sourceSetDatastoreFieldMapping";
    private static final String LVL_FIELD_LINEAGE_RELATION = "com.semarchy.xdi.harvest.fieldLineage";
    private static final String LVL_DATASTORE_PHYSICALSTORE_RELATION = "com.semarchy.xdi.harvest.dataStorePhysicalStorage";
    private static final String LVL_RESOURCEOWNER_RELATION = "com.semarchy.xdi.harvest.resourceOwner";
    private static final String ATT_MODEL_ID = "modelId";
    private static final String ATT_MODEL_NAME = "modelName";
    private static final String ATT_SOURCE = "sourceRef";
    private static final String ATT_TARGET = "targetRef";
    private static final String ATT_MDREF = "mdRef";
    java.util.Map<IContainer, MdNode> datastoreNodes = new HashMap<IContainer, MdNode>();
    java.util.Map<ILogicalField, MdNode> datastoreFieldNodes = new HashMap<ILogicalField, MdNode>();
    java.util.Map<ILogicalField, MdNode> sourceSetFieldNodes = new HashMap<ILogicalField, MdNode>();
    List<MdNode> physicalDatastores = new ArrayList<MdNode>();
    java.util.Map<IContainer, MdNode> sourceSetPerTarget = new HashMap<IContainer, MdNode>();
    List<MdNode> datastores2PhysicalRelation = new ArrayList<MdNode>();
    List<MdNode> resourcesOwnerRelation = new ArrayList<MdNode>();
    List<MdNode> sourceSetToTargetDatastoreRelations = new ArrayList<MdNode>();
    List<MdNode> lineageRelations = new ArrayList<MdNode>();
    List<MdNode> ssFieldToDatastoreFieldRelations = new ArrayList<MdNode>();
    java.util.Map<String, MdNode> mdResource = new HashMap<String, MdNode>();
    MdNode mapResource;
    ICacheService indexService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);

    Builder() {
    }

    void setMappingResource(Map model) {
        this.mapResource = MdFactory.eINSTANCE.createMdNode();
        this.mapResource.setDefType(LVL_MAPPING_RESOURCE);
        this.setAttribute(this.mapResource, ATT_MODEL_ID, this.indexService.getSourceId(model.eResource().getURI()));
        this.setAttribute(this.mapResource, ATT_MODEL_NAME, URIUtils.toPath((URI)model.eResource().getURI().trimFileExtension()).lastSegment());
    }

    private Attribute getOrCreateAttribute(MdNode node, String shortCode) {
        Attribute att = node.getAttributeByShortCode(shortCode);
        if (att == null) {
            att = MdFactory.eINSTANCE.createAttribute();
            att.setDefType(String.format("%s.%s", node.getDefType(), shortCode));
            node.getAttribute().add((Object)att);
        }
        return att;
    }

    private void setAttribute(MdNode node, String shortCode, String value) {
        Attribute att = this.getOrCreateAttribute(node, shortCode);
        att.setValue(value);
    }

    private void setAttributeRef(MdNode node, String shortCode, MdNode ref) {
        Attribute att = this.getOrCreateAttribute(node, shortCode);
        att.setRef((EObject)ref);
    }

    void createDatastore(IContainer container) {
        MdNode node = MdFactory.eINSTANCE.createMdNode();
        node.setDefType(LVL_DATASTORE);
        this.setAttribute(node, ATT_MODEL_ID, container.getId());
        this.setAttribute(node, ATT_MODEL_NAME, container.getAlias().toString());
        this.datastoreNodes.put(container, node);
        container.getLogicalField().forEach(r -> {
            boolean bl = node.getNode().add((Object)this.createDatastoreField((ILogicalField)r));
        });
        this.createStore(container);
        MdNode resourceOwner = MdFactory.eINSTANCE.createMdNode();
        resourceOwner.setDefType(LVL_RESOURCEOWNER_RELATION);
        this.setAttributeRef(resourceOwner, ATT_SOURCE, this.mapResource);
        this.setAttributeRef(resourceOwner, ATT_TARGET, node);
        this.resourcesOwnerRelation.add(resourceOwner);
    }

    private void createStore(IContainer container) {
        EObject containerRef = ((IMetaData)container).getRef();
        MdNode node = MdFactory.eINSTANCE.createMdNode();
        node.setDefType(LVL_STORE);
        this.setAttributeRef(node, ATT_MDREF, (MdNode)containerRef);
        this.physicalDatastores.add(node);
        MdNode r = MdFactory.eINSTANCE.createMdNode();
        r.setDefType(LVL_DATASTORE_PHYSICALSTORE_RELATION);
        this.setAttributeRef(r, ATT_SOURCE, this.datastoreNodes.get(container));
        this.setAttributeRef(r, ATT_TARGET, node);
        this.datastores2PhysicalRelation.add(r);
        MdNode res = this.mdResource.computeIfAbsent(this.indexService.getSourceId(containerRef.eResource().getURI()), k -> {
            MdNode resource = MdFactory.eINSTANCE.createMdNode();
            resource.setDefType(LVL_MD_RESOURCE);
            this.setAttribute(resource, ATT_MODEL_ID, (String)k);
            this.setAttribute(resource, ATT_MODEL_NAME, URIUtils.toPath((URI)containerRef.eResource().getURI().trimFileExtension()).lastSegment());
            return resource;
        });
        MdNode resourceOwner = MdFactory.eINSTANCE.createMdNode();
        resourceOwner.setDefType(LVL_RESOURCEOWNER_RELATION);
        this.setAttributeRef(resourceOwner, ATT_SOURCE, res);
        this.setAttributeRef(resourceOwner, ATT_TARGET, node);
        this.resourcesOwnerRelation.add(resourceOwner);
    }

    private MdNode createDatastoreField(ILogicalField f) {
        MdNode node = MdFactory.eINSTANCE.createMdNode();
        node.setDefType(LVL_DATASTORE_FIELD);
        this.setAttributeRef(node, ATT_MDREF, (MdNode)((IMetaData)f).getRef());
        this.setAttribute(node, ATT_MODEL_ID, (String)f.eGet((EStructuralFeature)MapPackage.eINSTANCE.getMapModelItem_Id()));
        this.setAttribute(node, ATT_MODEL_NAME, this.getLogicalFieldFullPath(f));
        this.datastoreFieldNodes.put(f, node);
        return node;
    }

    private String getLogicalFieldFullPath(ILogicalField f) {
        StringBuilder sb = new StringBuilder();
        if (f instanceof Field) {
            Field field = (Field)f;
            EObject eObject = f.eContainer();
            if (eObject instanceof IContainer) {
                IContainer container = (IContainer)eObject;
                sb.append(container.getAlias());
                sb.append(".");
            }
            sb.append(FieldUpdater.getFullAlias((Field)field, (boolean)false));
        } else {
            sb.append(f.getFullPath());
        }
        return sb.toString();
    }

    void createSourceSet(IContainer target) {
        MdNode node = MdFactory.eINSTANCE.createMdNode();
        node.setDefType(LVL_SOURCESET);
        this.setAttribute(node, ATT_MODEL_NAME, "Source " + target.getAlias().toString());
        this.setAttribute(node, ATT_MODEL_ID, "ss-" + String.valueOf(target.eGet((EStructuralFeature)MapPackage.eINSTANCE.getMapModelItem_Id())));
        this.sourceSetPerTarget.put(target, node);
        MdNode sourceSetToTargetDatastore = MdFactory.eINSTANCE.createMdNode();
        sourceSetToTargetDatastore.setDefType(LVL_SS_TO_TRG_DATASTORE_RELATION);
        this.setAttributeRef(sourceSetToTargetDatastore, ATT_SOURCE, node);
        this.setAttributeRef(sourceSetToTargetDatastore, ATT_TARGET, this.datastoreNodes.get(target));
        this.sourceSetToTargetDatastoreRelations.add(sourceSetToTargetDatastore);
        MdNode resourceOwner = MdFactory.eINSTANCE.createMdNode();
        resourceOwner.setDefType(LVL_RESOURCEOWNER_RELATION);
        this.setAttributeRef(resourceOwner, ATT_SOURCE, this.mapResource);
        this.setAttributeRef(resourceOwner, ATT_TARGET, node);
        this.resourcesOwnerRelation.add(resourceOwner);
    }

    void createSourceSetField(ILogicalField srcField, IContainer targetContainer) {
        MdNode node = MdFactory.eINSTANCE.createMdNode();
        node.setDefType(LVL_SOURCESET_FIELD);
        this.setAttribute(node, ATT_MODEL_NAME, "Source " + this.getLogicalFieldFullPath(srcField));
        this.setAttribute(node, ATT_MODEL_ID, "ssf-" + String.valueOf(srcField.eGet((EStructuralFeature)MapPackage.eINSTANCE.getMapModelItem_Id())));
        this.sourceSetFieldNodes.put(srcField, node);
        MdNode sourceSetNode = this.sourceSetPerTarget.get(targetContainer);
        sourceSetNode.getNode().add((Object)node);
        MdNode ffFieldToDatastoreField = MdFactory.eINSTANCE.createMdNode();
        ffFieldToDatastoreField.setDefType(LVL_SS_DATASTORE_FIELD_MAPPING_RELATION);
        this.setAttributeRef(ffFieldToDatastoreField, ATT_SOURCE, node);
        this.setAttributeRef(ffFieldToDatastoreField, ATT_TARGET, this.datastoreFieldNodes.get(srcField));
        this.ssFieldToDatastoreFieldRelations.add(ffFieldToDatastoreField);
    }

    void createLineage(ILogicalField srcField, ILogicalField mappedField) {
        MdNode lineage = MdFactory.eINSTANCE.createMdNode();
        lineage.setDefType(LVL_FIELD_LINEAGE_RELATION);
        this.setAttributeRef(lineage, ATT_SOURCE, this.sourceSetFieldNodes.get(srcField));
        this.setAttributeRef(lineage, ATT_TARGET, this.datastoreFieldNodes.get(mappedField));
        this.lineageRelations.add(lineage);
    }

    MdRootNode createRootMd(String mappingId) {
        MdRootNode root = MdFactory.eINSTANCE.createMdRootNode();
        root.setId(String.format("%s-xdg", mappingId));
        AnyType proxy = XMLTypeFactory.eINSTANCE.createAnyType();
        String uri = String.format("resource.tech#%s?fileId=%s?", TECH_ID, TECH_ID);
        ((InternalEObject)proxy).eSetProxyURI(URI.createURI((String)uri));
        root.setRef((EObject)proxy);
        root.setDefType(LVL_MODEL);
        root.getNode().add((Object)this.mapResource);
        root.getNode().addAll(this.mdResource.values());
        root.getNode().addAll(this.sourceSetPerTarget.values());
        root.getNode().addAll(this.datastoreNodes.values());
        root.getNode().addAll(this.physicalDatastores);
        root.getNode().addAll(this.sourceSetToTargetDatastoreRelations);
        root.getNode().addAll(this.ssFieldToDatastoreFieldRelations);
        root.getNode().addAll(this.lineageRelations);
        root.getNode().addAll(this.datastores2PhysicalRelation);
        root.getNode().addAll(this.resourcesOwnerRelation);
        return root;
    }
}

