/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.gene;

import com.semarchy.xdi.designer.generation.xsl.gene.StackedVariableManager;
import com.semarchy.xdi.designer.generation.xsl.global.Functions;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GlobalVariable;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.style.ExtensionInstruction;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;

public class Push
extends ExtensionInstruction {
    Expression select;
    Expression variableName;
    Expr instruction = null;
    private int mode = 0;
    private boolean isMdLink = false;
    private static final int MODE_XSL = 0;
    private static final int MODE_XPATH = 1;

    protected void prepareAttributes() throws XPathException {
        String mdLink;
        String variableName = this.getAttributeValue("", "variableName");
        if (variableName == null) {
            throw new XPathException("missing variableName attribute");
        }
        this.variableName = this.makeExpression(variableName);
        String select = this.getAttributeValue("", "select");
        if (select == null) {
            throw new XPathException("missing select attribute");
        }
        this.select = this.makeExpression(select);
        String evalXPath = this.getAttributeValue("", "mode");
        if (evalXPath != null) {
            if (evalXPath.equals("xsl")) {
                this.mode = 0;
            } else if (evalXPath.equals("xpath")) {
                this.mode = 1;
            } else {
                throw new XPathException("The pushVar extension only supports xsl|xpath value for mode attribute");
            }
        }
        if ((mdLink = this.getAttributeValue("", "isMdLink")) != null) {
            try {
                this.isMdLink = Boolean.valueOf(mdLink);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void validate() throws XPathException {
        this.typeCheck("select", this.select);
        this.typeCheck("variableName", this.variableName);
        this.instruction = new Expr(this.select, this.variableName);
        XSLStylesheet root = this.getPrincipalStylesheet();
        AxisIterator it = root.iterateAxis((byte)3);
        NodeInfo curr = null;
        while (it.moveNext()) {
            XSLVariableDeclaration var;
            curr = (NodeInfo)it.current();
            if (!(curr instanceof XSLVariableDeclaration) || !(var = (XSLVariableDeclaration)curr).isAssignable()) continue;
            var.registerReference((BindingReference)this.instruction);
        }
        it.close();
    }

    public Expression compile(Executable exec) throws XPathException {
        return this.instruction;
    }

    public class Expr
    extends SimpleExpression
    implements BindingReference {
        public static final int SELECT = 0;
        public static final int VARIABLENAME = 1;
        private Map<String, Binding> bindings = new HashMap<String, Binding>();

        public Expr(Expression select, Expression variableName) {
            this.setArguments(new Expression[]{select, variableName});
        }

        public int getIntrinsicDependencies() {
            return 0x1000000;
        }

        public void setStaticType(SequenceType type, Value constantValue, int properties) {
        }

        public void fixup(Binding binding) {
            this.bindings.put(binding.getVariableQName().getLocalName(), binding);
        }

        private Binding getBinding(String varName) {
            return this.bindings.get(varName);
        }

        public Expression promote(PromotionOffer offer) throws XPathException {
            switch (offer.action) {
                case 10: 
                case 11: 
                case 15: {
                    return this;
                }
                case 12: 
                case 13: 
                case 14: {
                    return super.promote(offer);
                }
            }
            throw new UnsupportedOperationException(String.format("UNKNOWN promotion action %s", offer.action));
        }

        public int getCardinality() {
            return 8192;
        }

        public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
            return this;
        }

        public Item evaluateItem(final XPathContext context) throws XPathException {
            StackedVariableManager.StackedVariable var;
            Item i = this.arguments[1].evaluateItem(context);
            String evaluatedVarName = i.getStringValue();
            Item rep = null;
            try {
                rep = this.arguments[0].evaluateItem(context);
            }
            catch (Exception ex) {
                throw new XPathException(String.format("Failed to evaluate variable %s:%s. You should check those variables order.", evaluatedVarName, ex.getMessage()), (Throwable)ex);
            }
            if (Push.this.mode == 1) {
                try {
                    Object l = Functions._evaluate(context, (NodeInfo)context.getContextItem(), rep.getStringValue(), XPathConstants.NODESET, new XPathVariableResolver(){

                        @Override
                        public Object resolveVariable(QName variableName) {
                            Binding binding = Expr.this.getBinding(variableName.getLocalPart());
                            if (binding != null) {
                                return context.getController().getBindery().getGlobalVariableValue((GlobalVariable)binding);
                            }
                            return null;
                        }
                    }, false);
                    if (l instanceof ValueRepresentation) {
                        rep = (ValueRepresentation)l;
                    } else if (l == null) {
                        rep = null;
                    }
                }
                catch (Exception ex) {
                    throw new XPathException(String.format("pushVar extension Failed to evaluate variable %s with\n%s", evaluatedVarName, rep.getStringValue()), (Throwable)ex);
                }
            }
            if (rep instanceof Closure) {
                rep = SequenceExtent.makeSequenceExtent((SequenceIterator)((Closure)rep).iterate());
            }
            if ((var = StackedVariableManager.INSTANCE.getVariable(evaluatedVarName)) == null) {
                var = StackedVariableManager.INSTANCE.createStackedVariable(evaluatedVarName, null);
            }
            var.pushValue((ValueRepresentation)rep, Push.this.isMdLink);
            context.getController().getBindery().assignGlobalVariable((GlobalVariable)this.getBinding(evaluatedVarName), (ValueRepresentation)rep);
            return null;
        }
    }
}

