/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.gene;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ValueRepresentation;

public class StackedVariableManager {
    private Map<String, StackedVariable> variables = new HashMap<String, StackedVariable>();
    private Map<String, NodeInfo> storedValues = new HashMap<String, NodeInfo>();
    public static final StackedVariableManager INSTANCE = new StackedVariableManager();

    private StackedVariableManager() {
    }

    public void clear() {
        this.variables.clear();
        this.storedValues.clear();
    }

    public static void storeValue(String id, NodeInfo value) {
        StackedVariableManager.INSTANCE.storedValues.put(id, value);
    }

    public static NodeInfo getStoredValue(String id) {
        return StackedVariableManager.INSTANCE.storedValues.get(id);
    }

    public static ValueRepresentation getCurrentValue(String variableName, boolean onlyMdLink) {
        return INSTANCE.getVariable(variableName).peekValue(onlyMdLink);
    }

    public StackedVariable getVariable(String name) {
        StackedVariable var = this.variables.get(name);
        return var;
    }

    public Collection<StackedVariable> getAllStackedVariables() {
        return new ArrayList<StackedVariable>(this.variables.values());
    }

    protected StackedVariable createStackedVariable(String name) {
        StackedVariable v = new StackedVariable();
        v.name = name;
        this.variables.put(name, v);
        return v;
    }

    public StackedVariable createStackedVariable(String name, ValueRepresentation value) {
        StackedVariable v = this.createStackedVariable(name);
        v.stackValues.push(new ValueRepresentationWrapper(value, false));
        return v;
    }

    public class StackedVariable {
        String name;
        Stack<ValueRepresentationWrapper> stackValues = new Stack();

        public void pushValue(ValueRepresentation val, boolean isMdLink) {
            this.stackValues.push(new ValueRepresentationWrapper(val, isMdLink));
        }

        public ValueRepresentation popValue() {
            this.stackValues.pop();
            return this.stackValues.peek().value;
        }

        public ValueRepresentation peekValue(boolean onlyMdLink) {
            if (onlyMdLink) {
                int i = this.stackValues.size() - 1;
                while (i >= 0) {
                    if (i == 0 || ((ValueRepresentationWrapper)this.stackValues.get((int)i)).isMdLink) {
                        return ((ValueRepresentationWrapper)this.stackValues.get((int)i)).value;
                    }
                    --i;
                }
                return ((ValueRepresentationWrapper)this.stackValues.get((int)0)).value;
            }
            return this.stackValues.peek().value;
        }

        public String getName() {
            return this.name;
        }
    }

    class ValueRepresentationWrapper {
        ValueRepresentation value;
        boolean isMdLink;

        public ValueRepresentationWrapper(ValueRepresentation value, boolean isMdLink) {
            this.isMdLink = isMdLink;
            this.value = value;
        }
    }
}

