/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.gene.process.internal;

import com.semarchy.xdi.designer.generation.xsl.DiagnosticException;
import com.semarchy.xdi.designer.generation.xsl.TransformerFactoryImpl;
import com.semarchy.xdi.designer.generation.xsl.gene.GenerationMap;
import com.semarchy.xdi.designer.generation.xsl.gene.StackWrapper;
import com.semarchy.xdi.designer.generation.xsl.gene.StackedVariableManager;
import com.semarchy.xdi.designer.generation.xsl.gene.process.Graph;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.EventHandler;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.Messages;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.OneProceParser;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.XSLEvaluationGenerator;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.XSLParseGenerator;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.XSLProcGenerator;
import com.semarchy.xdi.designer.generation.xsl.global.Functions;
import com.semarchy.xdi.designer.generation.xsl.global.Xpath;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.TextFragmentValue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.InputSource;

public class OneProcCompilation {
    private Logger logger = LogManager.getLogger(OneProcCompilation.class);
    XMLInputFactory factory = null;
    private String stambiaRuntimeHome;

    public OneProcCompilation(String stambiaRuntimeHome) {
        this.stambiaRuntimeHome = stambiaRuntimeHome;
        this.factory = XMLInputFactory.newInstance();
        this.factory.setProperty("javax.xml.stream.supportDTD", false);
        this.factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
    }

    private String getStambiaRuntimeHome() {
        return this.stambiaRuntimeHome;
    }

    /*
     * Unable to fully structure code
     */
    private boolean generateEvaluationGraphXSL(Graph gr, XMLOutputFactory outputFactory, TransformerFactory factory, File outputFolder, File oneProc, InputStream graphStream) throws XMLStreamException, IOException, TransformerException {
        block39: {
            os = null;
            writer = null;
            res = false;
            xslToInject = new ByteArrayOutputStream();
            try {
                try {
                    bos = new ByteArrayOutputStream();
                    writer = outputFactory.createXMLStreamWriter(new BufferedOutputStream(bos), StandardCharsets.UTF_8.name());
                    gen = new XSLParseGenerator(writer);
                    gen.generateXSLStuff(gr);
                    source = new SAXSource(new InputSource(new BufferedInputStream(new ByteArrayInputStream(bos.toByteArray()))));
                    u = outputFolder.getAbsolutePath();
                    if (!u.startsWith("/")) {
                        u = "/" + (String)u;
                    }
                    source.setSystemId("file:" + OneProcCompilation.formatURI((String)u) + "/foo1");
                    tr = factory.newTransformer(source);
                    substitutionMap = new GenerationMap();
                    tr.setParameter("substitutionMap", substitutionMap);
                    ss = new SAXSource(new InputSource(new BufferedInputStream(graphStream)));
                    ss.setSystemId("file:" + (String)u + "/foo");
                    outputTarget = new StreamResult(xslToInject);
                    tr.transform(ss, outputTarget);
                    gr.applySubstitution(substitutionMap.getAll());
                    res = substitutionMap.getAll().isEmpty() == false;
                    break block39;
                }
                catch (XPathException ex) {
                    ctx = ex.getXPathContext();
                    ** while (ctx != null)
                }
lbl-1000:
                // 1 sources

                {
                    i = 0;
                    for (E var : ctx.getStackFrame().getStackFrameMap().getVariableMap()) {
                        if (var.toString().equals("__templateId") && (result = ctx.getStackFrame().getStackFrameValues()[i]) instanceof TextFragmentValue) {
                            tpl = ((TextFragmentValue)result).getStringValue();
                            tplType = tpl.substring(0, tpl.indexOf("_"));
                            id = tpl.substring(tpl.indexOf("_") + 1);
                            if (tplType.equals("initParameter")) {
                                path = gr.getParameterDiagnosticPath(id);
                                if (path != null) {
                                    throw new DiagnosticException(String.format(Messages.OneProcCompilation_0, new Object[]{"PARAMETER", path, ex.getMessage()}), ex);
                                }
                            } else if (tplType.equals("initVar")) {
                                path = gr.getXslVariableDiagnosticPath(id);
                                if (path != null) {
                                    throw new DiagnosticException(String.format(Messages.OneProcCompilation_0, new Object[]{"XslVariable", path, ex.getMessage()}), ex);
                                }
                            } else {
                                n = gr.getNodeBySrcId(id);
                                if (n != null) {
                                    type = tplType;
                                    if (tplType.equals("initAction")) {
                                        type = "Step Code";
                                    } else if (tplType.equals("initActionModuleName")) {
                                        type = "Step ModuleName";
                                    } else if (tplType.equals("initStepSemaphoreName")) {
                                        type = "Step SemaphoreName";
                                    } else if (tplType.equals("initStepDynamicName")) {
                                        type = "Step DynamicName";
                                    }
                                    throw new DiagnosticException(String.format(Messages.OneProcCompilation_0, new Object[]{type, n.getDiagnosticPath(), ex.getMessage()}), ex);
                                }
                            }
                        }
                        ++i;
                    }
                    ctx = ctx.getCaller();
                    continue;
                }
lbl64:
                // 1 sources

                throw ex;
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
                if (os != null) {
                    os.close();
                }
            }
        }
        is = new BufferedInputStream(this.getClass().getResourceAsStream("evalgraph.xsl"));
        evalOs = new ByteArrayOutputStream();
        buf = new byte[2048];
        sz = -1;
        while ((sz = is.read(buf)) != -1) {
            evalOs.write(buf, 0, sz);
        }
        evalOs.flush();
        evalOs.close();
        is.close();
        try {
            block40: {
                var15_20 = null;
                var16_23 = null;
                bos = new BufferedOutputStream(new FileOutputStream(new File(outputFolder, "__evaluation.xsl")));
                try {
                    writer = outputFactory.createXMLStreamWriter(bos, StandardCharsets.UTF_8.name());
                    gene = new XSLEvaluationGenerator(writer);
                    gene.generateXSL(gr, new ByteArrayInputStream(xslToInject.toByteArray()), new ByteArrayInputStream(evalOs.toByteArray()), oneProc);
                    writer.close();
                    var20_33 = res;
                    if (bos == null) break block40;
                }
                catch (Throwable var15_22) {
                    try {
                        if (bos != null) {
                            bos.close();
                        }
                        throw var15_22;
                    }
                    catch (Throwable var16_25) {
                        if (var15_20 == null) {
                            var15_20 = var16_25;
                        } else if (var15_20 != var16_25) {
                            var15_20.addSuppressed(var16_25);
                        }
                        throw var15_20;
                    }
                }
                bos.close();
            }
            return var20_33;
        }
        finally {
            StackedVariableManager.INSTANCE.clear();
        }
    }

    private GenerationHelper createDeliveryGraph(TransformerFactory factory, File outputFolder, File oneProc, InputStream graphStream) throws TransformerException, IOException {
        File file = new File(outputFolder, "__evaluation.xsl");
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            SAXSource source = new SAXSource(new InputSource(is));
            Object u = file.getAbsolutePath();
            if (!((String)u).startsWith("/")) {
                u = "/" + (String)u;
            }
            source.setSystemId("file:" + OneProcCompilation.formatURI((String)u));
            Transformer tr = factory.newTransformer(source);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamResult outputTarget = new StreamResult(bos);
            GenerationHelper res = new GenerationHelper();
            tr.setParameter("genMap", res.generatedCode);
            tr.setParameter("__jStack", new StackWrapper());
            SAXSource ss = new SAXSource(new InputSource(new BufferedInputStream(graphStream)));
            try {
                URI uri = new URI(oneProc.toURI().toString().replace("/wrk1/", "/wrk2/") + "/../graph");
                uri = uri.normalize();
                ss.setSystemId(uri.toString());
            }
            catch (Exception ex) {
                u = oneProc.getAbsolutePath().substring(0, oneProc.getAbsolutePath().replace("\\", "/").lastIndexOf("/")) + "/graph";
                if (!((String)u).startsWith("/")) {
                    u = "/" + (String)u;
                }
                ss.setSystemId(OneProcCompilation.formatURI((String)u));
            }
            tr.transform(ss, outputTarget);
            res.mdStuffToInject = new ByteArrayInputStream(bos.toByteArray());
            return res;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public synchronized String generateXSL(File outputFolder, String procResourceURI, String defaultScriptingEngine, ErrorListener errorListener) throws Exception {
        StackedVariableManager.INSTANCE.clear();
        Functions.clear();
        Xpath.clear();
        URI oneProcURI = this.initOneProcURI(procResourceURI);
        XMLEventReader reader = null;
        OneProceParser parser = null;
        TransformerFactory f = TransformerFactory.newInstance(TransformerFactoryImpl.class.getName(), TransformerFactoryImpl.class.getClassLoader());
        f.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        f.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        if (errorListener != null) {
            f.setErrorListener(errorListener);
        }
        try {
            String string;
            block18: {
                Throwable throwable = null;
                Object var10_11 = null;
                BufferedInputStream is = new BufferedInputStream(oneProcURI.toURL().openStream());
                try {
                    EventHandler handler = new EventHandler();
                    reader = this.factory.createXMLEventReader(is, "UTF-8");
                    parser = new OneProceParser(reader);
                    while (parser.hasNext()) {
                        Object event = parser.next();
                        if (event == null) break;
                        handler.handleEvent(event);
                    }
                    Graph gr = handler.createGraph();
                    outputFolder.mkdirs();
                    XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
                    final File oneProc = new File(oneProcURI);
                    URIResolver uriResolver = new URIResolver(){

                        @Override
                        public Source resolve(String href, String base) throws TransformerException {
                            try {
                                if (href.endsWith(".md")) {
                                    URI uri = null;
                                    BufferedInputStream inputStream = null;
                                    if (base.endsWith("/graph") || base.endsWith(".oneProc.proc")) {
                                        String b = OneProcCompilation.formatURI(oneProc.toURI().normalize().getPath());
                                        Object u = OneProcCompilation.formatURI(this.getStambiaRuntimeGeneration());
                                        if (!((String)u).startsWith("/")) {
                                            u = "/" + (String)u;
                                        }
                                        URI runtimeURI = new URI("file:" + OneProcCompilation.formatURI((String)u)).normalize();
                                        try {
                                            b = b.replace(OneProcCompilation.formatURI(runtimeURI.getPath()), "");
                                            b = b.replace("/wrk1", "");
                                            if (b.contains("/")) {
                                                b = b.substring(0, b.lastIndexOf("/"));
                                            }
                                            uri = new URI(runtimeURI.toString() + "/wrk2/" + OneProcCompilation.formatURI(b) + "/" + OneProcCompilation.formatURI(href));
                                            uri = uri.normalize();
                                            inputStream = new BufferedInputStream(uri.toURL().openStream());
                                        }
                                        catch (FileNotFoundException ex) {
                                            b = OneProcCompilation.formatURI(oneProc.toURI().normalize().getPath());
                                            b = b.replace(OneProcCompilation.formatURI(runtimeURI.getPath()), "");
                                            b = b.replace("/wrk1/", "/wrk2/");
                                            if (b.contains("/")) {
                                                b = b.substring(0, b.lastIndexOf("/"));
                                            }
                                            uri = new URI("file:" + b + "/" + OneProcCompilation.formatURI(href));
                                            uri = uri.normalize();
                                            inputStream = new BufferedInputStream(uri.toURL().openStream());
                                        }
                                    } else {
                                        uri = new URI(OneProcCompilation.formatURI(base.substring(0, base.lastIndexOf("/"))) + "/" + OneProcCompilation.formatURI(href));
                                        uri = uri.normalize();
                                        inputStream = new BufferedInputStream(uri.toURL().openStream());
                                    }
                                    SAXSource src = new SAXSource(new InputSource(inputStream));
                                    src.setSystemId(uri.toString());
                                    return src;
                                }
                                if (href.equals("udf.xsl")) {
                                    String s = OneProcCompilation.this.getStambiaRuntimeHome() + "/build/tmp/wrk1/__udf__/udf.xsl";
                                    URI uri = new URI("file:" + OneProcCompilation.formatURI(s));
                                    uri = uri.normalize();
                                    URI __uri = new URI("file:" + (!s.startsWith("/") ? "/" : "") + OneProcCompilation.formatURI(s));
                                    File file = new File(__uri = __uri.normalize());
                                    if (file.exists()) {
                                        SAXSource src = new SAXSource(new InputSource(new BufferedInputStream(uri.toURL().openStream())));
                                        src.setSystemId(uri.toString());
                                        return src;
                                    }
                                    s = OneProcCompilation.this.getStambiaRuntimeHome() + "/build/xsl/udf.xsl";
                                    uri = new URI("file:" + OneProcCompilation.formatURI(s));
                                    uri = uri.normalize();
                                    SAXSource src = new SAXSource(new InputSource(new BufferedInputStream(uri.toURL().openStream())));
                                    src.setSystemId(uri.toString());
                                    return src;
                                }
                                if (href.replace("\\", "/").equals(oneProc.toURI().toString())) {
                                    SAXSource src = new SAXSource(new InputSource(new BufferedInputStream(new FileInputStream(oneProc))));
                                    src.setSystemId(oneProc.toURI().normalize().toString());
                                    return src;
                                }
                                String s = OneProcCompilation.this.getStambiaRuntimeHome() + "/build";
                                if (!(s = s + "/xsl/" + href).startsWith("/")) {
                                    s = "/" + s;
                                }
                                URI uri = new URI("file:" + OneProcCompilation.formatURI(s));
                                uri = uri.normalize();
                                SAXSource src = new SAXSource(new InputSource(new BufferedInputStream(uri.toURL().openStream())));
                                src.setSystemId(uri.toString());
                                return src;
                            }
                            catch (Exception ex) {
                                OneProcCompilation.this.logger.error("Failed to resolve {}:{}", (Object)href, (Object)base, (Object)ex);
                                return null;
                            }
                        }

                        private String getStambiaRuntimeGeneration() {
                            return OneProcCompilation.this.getStambiaRuntimeHome() + "/build/tmp";
                        }
                    };
                    f.setURIResolver(uriResolver);
                    ByteArrayInputStream graphStream = this.getAsXMLStream(gr, outputFactory);
                    boolean substitution = this.generateEvaluationGraphXSL(gr, outputFactory, f, outputFolder, oneProc, graphStream);
                    Graph.setCurrentGraph(gr);
                    if (substitution) {
                        graphStream = this.getAsXMLStream(gr, outputFactory);
                    } else {
                        graphStream.reset();
                    }
                    GenerationHelper generatedCode = this.createDeliveryGraph(f, outputFolder, oneProc, graphStream);
                    string = this.generateProcCP(gr, outputFactory, outputFolder, generatedCode, defaultScriptingEngine);
                    if (is == null) break block18;
                }
                catch (Throwable throwable2) {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                ((InputStream)is).close();
            }
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            StackedVariableManager.INSTANCE.clear();
            Graph.setCurrentGraph(null);
            Functions.clear();
            Xpath.clear();
        }
    }

    private ByteArrayInputStream getAsXMLStream(Graph gr, XMLOutputFactory outputFactory) throws XMLStreamException {
        Graph.Node current = gr.getRoot();
        class Visitor {
            HashSet<String> writenIds = new HashSet();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            XMLStreamWriter writer = null;
            private final /* synthetic */ XMLOutputFactory val$outputFactory;

            Visitor(XMLOutputFactory xMLOutputFactory) {
                this.val$outputFactory = xMLOutputFactory;
            }

            void accept(Graph.Node node) throws XMLStreamException {
                this.writer = this.val$outputFactory.createXMLStreamWriter(new BufferedOutputStream(this.bos), StandardCharsets.UTF_8.name());
                this.writer.writeStartDocument();
                this.visit(node);
                this.writer.writeEndDocument();
                this.writer.close();
            }

            void visit(Graph.Node node) throws XMLStreamException {
                if (this.writenIds.add(node.getBaseId())) {
                    this.writer.writeStartElement("node");
                    this.writer.writeAttribute("id", node.getBaseId());
                    this.writer.writeAttribute("srcId", node.getSrcId());
                    if (node.getGenerationOrder() != null) {
                        this.writer.writeAttribute("generationOrder", String.valueOf(node.getGenerationOrder()));
                    }
                    if (node.getType() == Graph.Type.PROCESS) {
                        this.writer.writeAttribute("processMap", "" + node.isMapping());
                    }
                    boolean evalNeedsMdLink = false;
                    if (node.getRepetitionQuery() != null && !node.getRepetitionQuery().trim().isEmpty()) {
                        this.writer.writeAttribute("repetitionQuery", node.getRepetitionQuery());
                        this.writer.writeAttribute("repetitionQueryHash", node.getRepetitionQueryHash());
                        for (Graph.MdLink m : node.getContext().mdLink) {
                            if (!node.getRepetitionQuery().contains("$" + m.name)) continue;
                            evalNeedsMdLink = true;
                            break;
                        }
                    }
                    if (node.getRepetitionQueryVar() != null && !node.getRepetitionQueryVar().trim().isEmpty()) {
                        this.writer.writeAttribute("repetitionVar", node.getRepetitionQueryVar());
                    }
                    if (node.getCondition() != null && !node.getCondition().trim().isEmpty()) {
                        this.writer.writeAttribute("condition", node.getCondition());
                        if (!evalNeedsMdLink) {
                            for (Graph.MdLink m : node.getContext().mdLink) {
                                if (!node.getCondition().contains("$" + m.name)) continue;
                                evalNeedsMdLink = true;
                                break;
                            }
                        }
                    }
                    if (evalNeedsMdLink) {
                        this.writer.writeAttribute("evalNeedsMdLink", "true");
                    }
                    this.writer.writeAttribute("type", node.getType().name());
                    if (node.getType() != Graph.Type.LINK) {
                        this.writer.writeAttribute("withContext", "true");
                        if (!node.getContext().isEmpty()) {
                            this.writer.writeAttribute("contextHasContent", "true");
                        }
                        if (node.getModelInfo().needParse4DynamicName()) {
                            this.writer.writeAttribute("dynamicName", "true");
                        }
                        if (node.getModelInfo().needParse4SemaphoreName()) {
                            this.writer.writeAttribute("semaphoreName", "true");
                        }
                    }
                    if (node.getType() == Graph.Type.ACTION) {
                        if (((Graph.Action)node).needParse()) {
                            this.writer.writeAttribute("hasCode", "true");
                        }
                        if (((Graph.Action)node).needParseModuleName()) {
                            this.writer.writeAttribute("moduleNameNeedParse", "true");
                        } else if (((Graph.Action)node).getModuleName() != null && !((Graph.Action)node).getModuleName().trim().isEmpty()) {
                            this.writer.writeAttribute("moduleName", ((Graph.Action)node).getModuleName().trim());
                        }
                    } else if (node.getType() == Graph.Type.LINK && node.getModelInfo().needParse()) {
                        this.writer.writeAttribute("executionCondition", "true");
                    }
                    if (node.getType() != Graph.Type.LINK) {
                        for (Graph.Parameter p : node.getContext().parameter) {
                            this.writer.writeStartElement("parameter");
                            this.writer.writeAttribute("srcId", p.md5Id);
                            this.writer.writeAttribute("name", p.name);
                            if (p.needParse()) {
                                this.writer.writeAttribute("needParse", "true");
                            }
                            this.writer.writeAttribute("value", p.value);
                            this.writer.writeEndElement();
                        }
                    } else {
                        this.writer.writeAttribute("isLink", "true");
                    }
                    for (Graph.MdLink l : node.getContext().mdLink) {
                        this.writer.writeStartElement("mdLink");
                        this.writer.writeAttribute("name", l.name);
                        String[] p = l.target.split("#");
                        if (p.length < 2) {
                            this.writer.writeAttribute("expression", l.target.replace(" ", "%20"));
                        } else {
                            StringBuilder b = new StringBuilder();
                            int i = 0;
                            while (i < p.length) {
                                if (i == p.length - 1) {
                                    b.append("#");
                                } else if (i > 0) {
                                    b.append("%23");
                                }
                                b.append(p[i]);
                                ++i;
                            }
                            this.writer.writeAttribute("expression", b.toString().replace(" ", "%20"));
                        }
                        this.writer.writeEndElement();
                    }
                    for (Graph.XslVariable v : node.getContext().getSortedVariables()) {
                        this.writer.writeStartElement("xslVariable");
                        this.writer.writeAttribute("name", v.name);
                        this.writer.writeAttribute("srcId", v.md5Id);
                        this.writer.writeAttribute("type", v.varType);
                        if (v.varType.equals("xpath")) {
                            if (!v.needParse()) {
                                this.writer.writeAttribute("expression", v.code);
                            } else {
                                this.writer.writeAttribute("needParse", "true");
                            }
                        }
                        this.writer.writeEndElement();
                    }
                    for (Graph.Node n : node.getChildren()) {
                        this.visit(n);
                    }
                    this.writer.writeEndElement();
                }
            }
        }
        Visitor v = new Visitor(outputFactory);
        v.accept(current);
        return new ByteArrayInputStream(v.bos.toByteArray());
    }

    private String generateProcCP(Graph graph, XMLOutputFactory outputFactory, File outputFolder, GenerationHelper mapCode, String defaultScriptingEngine) throws Exception {
        Throwable throwable = null;
        Object var7_8 = null;
        try (EscapingAttributeBufferedOutputStream os2 = new EscapingAttributeBufferedOutputStream(new FileOutputStream(new File(outputFolder, "__finalProc.proc")));){
            XMLStreamWriter writer2 = outputFactory.createXMLStreamWriter(os2, StandardCharsets.UTF_8.name());
            XSLProcGenerator gen = new XSLProcGenerator(writer2, defaultScriptingEngine);
            String res = gen.generate(graph, graph.getDeliveryGraph(), mapCode, os2);
            writer2.close();
            return res;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String formatURI(String s) {
        Object u = s.replace(" ", "%20").replace("#", "%23").replace("\\", "/").replace("[", "%5B").replace("]", "%5D").replace("{", "%7B").replace("}", "%7D").replace("^", "%5E").replace("`", "%60");
        String backup = s;
        boolean handled = false;
        do {
            try {
                new URI((String)u);
                handled = true;
            }
            catch (URISyntaxException ex) {
                int i = ex.getIndex();
                if (((String)u).charAt(i) == '%') {
                    u = ((String)u).substring(0, i) + "%25" + ((String)u).substring(i + 1);
                    handled = false;
                    continue;
                }
                return backup;
            }
        } while (!handled);
        return u;
    }

    public static String unformatURI(String uriStr) {
        return uriStr.replace("%20", " ").replace("%23", "#").replace("%5B", "[").replace("%5D", "]").replace("%26", "&").replace("%7B", "{").replace("%7D", "}").replace("%5E", "^").replace("%60", "`");
    }

    private URI initOneProcURI(String procResourceURI) {
        File f = new File(procResourceURI);
        return f.toURI();
    }

    public class EscapingAttributeBufferedOutputStream
    extends BufferedOutputStream {
        boolean isAttribute;
        List<Integer> buffer;
        boolean buffered;

        public EscapingAttributeBufferedOutputStream(OutputStream out) {
            super(out);
            this.isAttribute = false;
            this.buffer = new ArrayList<Integer>();
            this.buffered = false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public synchronized void write(int b) throws IOException {
            if (!this.isAttribute) {
                super.write(b);
                return;
            } else {
                String str = null;
                if (this.buffered) {
                    if (b == "&quot;".charAt(this.buffer.size())) {
                        this.buffer.add(b);
                        if (b != 59) return;
                        this.buffered = false;
                        this.buffer.clear();
                        str = "&#34;";
                    } else {
                        this.buffered = false;
                        for (Integer i : this.buffer) {
                            super.write(i);
                        }
                        this.buffer.clear();
                    }
                }
                if (b == 13) {
                    str = "&#xD;";
                } else if (b == 10) {
                    str = "&#xA;";
                } else if (b == 9) {
                    str = "&#x9;";
                } else if (b == 38) {
                    this.buffer.add(b);
                    this.buffered = true;
                    return;
                }
                if (str != null) {
                    int i = 0;
                    while (i < 5) {
                        this.write(str.charAt(i));
                        ++i;
                    }
                    return;
                } else {
                    super.write(b);
                }
            }
        }

        public void setAttribute(boolean isAttribute) {
            this.isAttribute = isAttribute;
        }
    }

    class GenerationHelper {
        GenerationMap generatedCode = new GenerationMap();
        ByteArrayInputStream mdStuffToInject = null;

        GenerationHelper() {
        }
    }
}

