/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.gene.process.internal;

import com.semarchy.xdi.designer.generation.xsl.gene.process.Graph;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.Messages;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class OneProceParser {
    private static final QName ATT_ID = new QName("id");
    private static final QName ATT_GENERATION_CONDITION = new QName("generationCondition");
    private static final QName ATT_REPETITION_QUERY = new QName("repetitionQuery");
    private static final QName ATT_VALUE = new QName("value");
    private static final QName ATT_ORIGIN = new QName("origin");
    private static final QName ATT_NAME = new QName("name");
    private static final QName ATT_TARGET = new QName("target");
    private static final QName ATT_TARGET_ID = new QName("targetId");
    private static final QName ATT_GENERATION_TYPE = new QName("generationType");
    private static final QName ATT_TYPE = new QName("type");
    private static final QName ATT_CODE = new QName("code");
    private static final QName ATT_ORDER = new QName("order");
    private static final QName ATT_REPETITION_VARIABLE = new QName("repetitionVariableName");
    private static final QName ATT_IS_BEGIN = new QName("isBeginAction");
    private static final QName ATT_DYNAMICNAME = new QName("dynamicName");
    private static final QName ATT_SEMAPHORENAME = new QName("semaphoreName");
    private static final QName ATT_ENCRYPTED = new QName("encrypted");
    private static final QName ATT_EXECUTION_CONDITION = new QName("executionCondition");
    private static final QName ATT_EXECUTION_TRIGGER = new QName("mandatory");
    private static final QName ATT_EXECUTION_TYPE = new QName("executionType");
    private static final QName ATT_META_INF = new QName("metaInf");
    private static final QName ATT_NBCYCLES = new QName("nbCycles");
    private static final QName ATT_REPETITIONPUBLISHPARAM = new QName("repetitionPublishParameters");
    private static final QName ATT_RESTARTPOINT = new QName("restartPoint");
    private static final QName ATT_STOPBINDONERROR = new QName("stopBindOnError");
    private static final QName ATT_TECHNOLOGY = new QName("technology");
    private static final QName ATT_ERRORTOLERATED = new QName("toleratedError");
    private static final QName ATT_REPETITION_TYPE = new QName("repetitionMode");
    private static final QName ATT_INPUT = new QName("input");
    private static final QName ATT_OUTPUT = new QName("output");
    private static final QName ATT_FAULT = new QName("fault");
    private static final QName ATT_PUBLISH_PARAMETER = new QName("publishParameters");
    private static final QName ATT_IS_ENABLED = new QName("enable");
    private static final QName ATT_VISIBILITY = new QName("visibility");
    private static final QName ATT_GENERATION_ORDER = new QName("generationOrder");
    private static final QName ATT_MODULE_XPATH_EXPRESSION = new QName("moduleXPathExpression");
    private static final QName ATT_MODULE_NAME = new QName("moduleName");
    private static Logger logger = LogManager.getLogger(OneProceParser.class);
    private Queue<Object> eventQueue = new LinkedList<Object>();
    private XMLEventReader reader;
    private boolean inCode = false;
    private StringBuffer codeBuffer = new StringBuffer();
    private Stack<StartElement> disablementStack = new Stack();

    OneProceParser(XMLEventReader reader) {
        this.reader = reader;
    }

    public boolean hasNext() {
        return !this.eventQueue.isEmpty() || this.reader.hasNext();
    }

    /*
     * Unable to fully structure code
     */
    public Object next() throws XMLStreamException {
        if (this.eventQueue.isEmpty()) ** GOTO lbl4
        return this.eventQueue.poll();
lbl-1000:
        // 1 sources

        {
            this.handleEvent(this.reader.nextEvent());
lbl4:
            // 2 sources

            ** while (this.eventQueue.isEmpty() && this.reader.hasNext())
        }
lbl5:
        // 1 sources

        if (!this.eventQueue.isEmpty()) {
            return this.eventQueue.poll();
        }
        return null;
    }

    public void handleEvent(XMLEvent ev) throws XMLStreamException {
        switch (ev.getEventType()) {
            case 7: {
                break;
            }
            case 1: {
                this.handleStartElement(ev.asStartElement());
                break;
            }
            case 4: {
                this.handleText(ev.asCharacters());
                break;
            }
            case 2: {
                this.handleEndElement(ev.asEndElement());
                break;
            }
        }
    }

    private void handleEndElement(EndElement event) throws XMLStreamException {
        if (!this.disablementStack.isEmpty()) {
            boolean sendEvent = false;
            if (event.getName().getLocalPart().equals("link") || event.getName().getLocalPart().equals("bindLink")) {
                int i = this.disablementStack.size() - 1;
                while (i >= 0) {
                    if (((StartElement)this.disablementStack.get(i)).getName().getLocalPart().equals("subProcess") || ((StartElement)this.disablementStack.get(i)).getName().getLocalPart().equals("actionCode")) {
                        if (i != 0) break;
                        sendEvent = true;
                        break;
                    }
                    --i;
                }
            }
            this.disablementStack.pop();
            if (!sendEvent && !this.disablementStack.isEmpty()) {
                return;
            }
        }
        if (event.getName().getLocalPart().equals("process")) {
            this.eventQueue.add(new EndEvent(Graph.Type.PROCESS));
        } else if (event.getName().getLocalPart().equals("subProcess")) {
            this.eventQueue.add(new EndEvent(Graph.Type.PROCESS));
        } else if (event.getName().getLocalPart().equals("actionCode")) {
            this.eventQueue.add(new EndEvent(Graph.Type.ACTION));
        } else if (event.getName().getLocalPart().equals("code")) {
            if (this.inCode) {
                this.eventQueue.add(new Graph.CodeEvent(this.codeBuffer.toString()));
                this.codeBuffer = new StringBuffer();
                this.inCode = false;
            }
        } else if (event.getName().getLocalPart().equals("link") || event.getName().getLocalPart().equals("bindLink")) {
            this.eventQueue.add(new EndEvent(Graph.Type.LINK));
        }
    }

    private void handleText(Characters event) throws XMLStreamException {
        if (this.inCode) {
            this.codeBuffer.append(event.getData());
        }
    }

    private void handleStartElement(StartElement event) throws XMLStreamException {
        if (!this.disablementStack.isEmpty()) {
            boolean sendEvent = false;
            if (event.getName().getLocalPart().equals("link") || event.getName().getLocalPart().equals("bindLink")) {
                int i = this.disablementStack.size() - 1;
                while (i >= 0) {
                    if (((StartElement)this.disablementStack.get(i)).getName().getLocalPart().equals("subProcess") || ((StartElement)this.disablementStack.get(i)).getName().getLocalPart().equals("actionCode")) {
                        if (i != 0) break;
                        sendEvent = true;
                        break;
                    }
                    --i;
                }
            }
            this.disablementStack.push(event);
            if (!sendEvent) {
                return;
            }
        }
        if (event.getName().getLocalPart().equals("process")) {
            this.handleRoot(event);
        } else if (event.getName().getLocalPart().equals("metaDataLink")) {
            this.handleMdLink(event);
        } else if (event.getName().getLocalPart().equals("subProcess") || event.getName().getLocalPart().equals("actionCode")) {
            this.handleStep(event);
        } else if (event.getName().getLocalPart().equals("code")) {
            this.handleCode(event);
        } else if (event.getName().getLocalPart().equals("link") || event.getName().getLocalPart().equals("bindLink")) {
            this.handleLink(event);
        } else if (event.getName().getLocalPart().equals("xslVariable")) {
            this.handleVariable(event);
        } else if (event.getName().getLocalPart().equals("parameter")) {
            this.handleParameter(event);
        } else if (event.getName().getLocalPart().equals("altId")) {
            this.handleAltId(event);
        }
    }

    private String readAttribute(StartElement event, QName name) {
        Attribute att = event.getAttributeByName(name);
        if (att != null) {
            return att.getValue();
        }
        return null;
    }

    private void handleVariable(StartElement event) {
        boolean visibleInParent;
        String id = event.getAttributeByName(ATT_ID).getValue();
        String varType = event.getAttributeByName(ATT_TYPE).getValue();
        String code = event.getAttributeByName(ATT_CODE).getValue();
        String order = this.readAttribute(event, ATT_ORDER);
        String name = event.getAttributeByName(ATT_NAME).getValue();
        String visibility = this.readAttribute(event, ATT_VISIBILITY);
        boolean bl = visibleInParent = visibility == null ? false : visibility.equals("parent");
        if (!"xsl".equals(varType) && !"xpath".equals(varType)) {
            varType = "xpath";
        }
        this.eventQueue.add(new Graph.XslVariable(id, varType, code, order, name, false, visibleInParent));
    }

    private void handleLink(StartElement event) throws XMLStreamException {
        String id = event.getAttributeByName(ATT_ID).getValue();
        String generationCondition = this.readAttribute(event, ATT_GENERATION_CONDITION);
        String target = this.readAttribute(event, ATT_TARGET_ID);
        String linkType = this.readAttribute(event, ATT_GENERATION_TYPE);
        boolean isBind = event.getName().getLocalPart().equals("bindLink");
        this.eventQueue.add(new Event(id, Graph.Type.LINK, target, generationCondition, linkType, isBind, this.createModelInfo(event), null));
    }

    private void handleCode(StartElement event) throws XMLStreamException {
        this.inCode = true;
    }

    private void handleMdLink(StartElement event) {
        String id = event.getAttributeByName(ATT_ID).getValue();
        String name = event.getAttributeByName(ATT_NAME).getValue();
        String target = event.getAttributeByName(ATT_TARGET).getValue();
        String input = this.readAttribute(event, ATT_INPUT);
        String output = this.readAttribute(event, ATT_OUTPUT);
        String fault = this.readAttribute(event, ATT_FAULT);
        String publishParameter = this.readAttribute(event, ATT_PUBLISH_PARAMETER);
        String visibility = this.readAttribute(event, ATT_VISIBILITY);
        boolean visibleInParent = visibility == null ? false : visibility.equals("parent");
        this.eventQueue.add(new Graph.MdLink(target, id, name, input, output, fault, publishParameter, visibleInParent));
    }

    private void handleParameter(StartElement event) throws XMLStreamException {
        String id = event.getAttributeByName(ATT_ID).getValue();
        String value = event.getAttributeByName(ATT_VALUE).getValue();
        String name = event.getAttributeByName(ATT_NAME).getValue();
        String type = event.getAttributeByName(ATT_TYPE).getValue();
        String input = this.readAttribute(event, ATT_INPUT);
        String output = this.readAttribute(event, ATT_OUTPUT);
        String fault = this.readAttribute(event, ATT_FAULT);
        String metaInf = this.readAttribute(event, ATT_META_INF);
        this.eventQueue.add(new Graph.Parameter(id, value, name, type, input, output, fault));
        if (metaInf != null && !metaInf.trim().isEmpty()) {
            NodeList nodeList = OneProceParser.parseMetaInf(metaInf, "xslVariableName");
            if (nodeList == null) {
                throw new XMLStreamException(String.format(Messages.OneProceParser_0, name, metaInf));
            }
            if (nodeList.getLength() > 0) {
                String variableName = nodeList.item(0).getTextContent();
                Integer order = -1;
                String tt = "xsl";
                boolean visibleInParent = false;
                try {
                    int i = 0;
                    while (i < nodeList.item(0).getAttributes().getLength()) {
                        block13: {
                            String vis;
                            Node n = nodeList.item(0).getAttributes().item(i);
                            if ("order".equals(n.getNodeName())) {
                                try {
                                    order = Integer.parseInt(n.getNodeValue());
                                    break;
                                }
                                catch (Exception exception) {
                                    break block13;
                                }
                            }
                            if ("type".equals(n.getNodeName())) {
                                tt = n.getNodeValue();
                            } else if ("visibility".equals(n.getNodeName()) && "parent".equals(vis = n.getNodeValue())) {
                                visibleInParent = true;
                            }
                        }
                        ++i;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.eventQueue.add(new Graph.XslVariable(id + "_xslvar", tt, value, String.valueOf(order), variableName, true, visibleInParent));
            }
        }
    }

    public static NodeList parseMetaInf(String xml, String tagName) {
        if (xml != null && !((String)xml).isEmpty()) {
            xml = "<root>" + (String)xml + "</root>";
            try {
                DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
                parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                DocumentBuilder parser = parserFactory.newDocumentBuilder();
                Document document = parser.parse(new InputSource(new StringReader((String)xml)));
                NodeList nl = document.getElementsByTagName(tagName);
                return nl;
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                logger.error("Metainf Parsing failed", (Throwable)e);
            }
        }
        return null;
    }

    private void handleAltId(StartElement event) throws XMLStreamException {
        String value = event.getAttributeByName(ATT_VALUE).getValue();
        String origin = event.getAttributeByName(ATT_ORIGIN).getValue();
        this.eventQueue.add(new Graph.AltId(origin, value));
    }

    private void handleStep(StartElement event) throws XMLStreamException {
        String id = event.getAttributeByName(ATT_ID).getValue();
        String name = event.getAttributeByName(ATT_NAME).getValue();
        Graph.Type type = null;
        if (event.getName().getLocalPart().equals("actionCode")) {
            type = Graph.Type.ACTION;
        } else if (event.getName().getLocalPart().equals("subProcess")) {
            type = Graph.Type.PROCESS;
        } else {
            throw new RuntimeException(Messages.OneProceParser_1);
        }
        String generationCondition = null;
        Attribute att = event.getAttributeByName(ATT_GENERATION_CONDITION);
        if (att != null && !att.getValue().trim().isEmpty()) {
            generationCondition = att.getValue();
        }
        String repetitionQuery = null;
        String repetitionQueryVar = null;
        Attribute att2 = event.getAttributeByName(ATT_REPETITION_QUERY);
        if (att2 != null && !att2.getValue().trim().isEmpty()) {
            repetitionQuery = att2.getValue();
            att2 = event.getAttributeByName(ATT_REPETITION_VARIABLE);
            if (att2 != null && !att2.getValue().trim().isEmpty()) {
                repetitionQueryVar = att2.getValue();
            }
        }
        boolean isBeginAction = false;
        Attribute att3 = event.getAttributeByName(ATT_IS_BEGIN);
        if (att3 != null) {
            isBeginAction = Boolean.valueOf(att3.getValue());
        }
        boolean isEnabled = true;
        String s = this.readAttribute(event, ATT_IS_ENABLED);
        if (s != null && s.equals("false")) {
            isEnabled = false;
        }
        if (!isEnabled) {
            if (!this.disablementStack.isEmpty()) {
                throw new RuntimeException(Messages.OneProceParser_2);
            }
            this.disablementStack.push(event);
        }
        Integer generationOrder = null;
        try {
            generationOrder = Integer.valueOf(this.readAttribute(event, ATT_GENERATION_ORDER));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String moduleXpathExpression = null;
        try {
            moduleXpathExpression = this.readAttribute(event, ATT_MODULE_XPATH_EXPRESSION);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String moduleName = null;
        try {
            moduleName = this.readAttribute(event, ATT_MODULE_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.eventQueue.add(new Event(id, type, name, generationCondition, repetitionQuery, repetitionQueryVar, this.readAttribute(event, ATT_REPETITION_TYPE), isBeginAction, isEnabled, this.createModelInfo(event), generationOrder, moduleXpathExpression, moduleName));
    }

    private void handleRoot(StartElement ev) throws XMLStreamException {
        String id = ev.getAttributeByName(ATT_ID).getValue();
        String name = ev.getAttributeByName(ATT_NAME).getValue();
        this.eventQueue.add(new Event(id, Graph.Type.PROCESS, name, null, null, null, null, true, true, this.createModelInfo(ev), null, null, null));
    }

    private Graph.ModelInfo createModelInfo(StartElement ev) {
        Graph.ModelInfo i = new Graph.ModelInfo();
        i.dynamicName = this.readAttribute(ev, ATT_DYNAMICNAME);
        i.encrypted = this.readAttribute(ev, ATT_ENCRYPTED);
        i.semaphoreName = this.readAttribute(ev, ATT_SEMAPHORENAME);
        i.executionCondition = this.readAttribute(ev, ATT_EXECUTION_CONDITION);
        if (i.executionCondition != null && i.executionCondition.trim().isEmpty()) {
            i.executionCondition = null;
        }
        i.executionTrigger = this.readAttribute(ev, ATT_EXECUTION_TRIGGER);
        i.srcId = this.readAttribute(ev, ATT_ID);
        i.executionType = this.readAttribute(ev, ATT_EXECUTION_TYPE);
        i.metaInf = this.readAttribute(ev, ATT_META_INF);
        i.nbCycles = this.readAttribute(ev, ATT_NBCYCLES);
        i.repetitionPublishParameters = this.readAttribute(ev, ATT_REPETITIONPUBLISHPARAM);
        i.restartPoint = this.readAttribute(ev, ATT_RESTARTPOINT);
        i.stopBindOnError = this.readAttribute(ev, ATT_STOPBINDONERROR);
        i.technologie = this.readAttribute(ev, ATT_TECHNOLOGY);
        i.toleratedErrors = this.readAttribute(ev, ATT_ERRORTOLERATED);
        return i;
    }

    class EndEvent {
        Graph.Type type;

        EndEvent(Graph.Type type) {
            this.type = type;
        }
    }

    class Event {
        String objectId;
        Graph.Type type;
        String objectName;
        String geneCondition;
        String repetitionQuery;
        String repetitionQueryVar;
        String repetitionType;
        String linkTrgId;
        Graph.GenerationMode linkType;
        String actionCode;
        boolean isBeginAction = false;
        boolean isBind = false;
        Graph.ModelInfo modelInfo;
        boolean enabled = true;
        Integer generationOrder;
        String moduleName;

        Event(String objectId, Graph.Type type, String additional, String condition, String linkType, boolean isBind, Graph.ModelInfo modelInfo, Integer generationOrder) {
            this.isBind = isBind;
            this.objectId = objectId;
            this.type = type;
            this.linkTrgId = additional;
            this.geneCondition = condition;
            if (linkType != null) {
                this.linkType = Graph.GenerationMode.valueOf(linkType);
            }
            this.modelInfo = modelInfo;
            this.generationOrder = generationOrder;
        }

        Event(String objectId, Graph.Type type, String name, String condition, String repetitionQuery, String repetitionQueryVar, String repetitionType, boolean isBeginAction, boolean enabled, Graph.ModelInfo modelInfo, Integer generationOrder, String moduleXPathExpression, String moduleName) {
            this.objectId = objectId;
            this.type = type;
            this.geneCondition = condition;
            this.objectName = name;
            this.repetitionQuery = repetitionQuery;
            this.repetitionQueryVar = repetitionQueryVar;
            this.isBeginAction = isBeginAction;
            this.modelInfo = modelInfo;
            this.repetitionType = repetitionType;
            this.enabled = enabled;
            this.generationOrder = generationOrder;
            this.moduleName = moduleName;
            if (this.moduleName == null && moduleXPathExpression != null) {
                this.moduleName = "%x{" + moduleXPathExpression + "}x%";
            }
        }
    }
}

