/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.gene.process.internal;

import com.semarchy.xdi.designer.generation.xsl.gene.process.Graph;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XSLEvaluationGenerator {
    private Logger logger = LogManager.getLogger(XSLEvaluationGenerator.class);
    private XMLStreamWriter writer;

    public XSLEvaluationGenerator(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void generateXSL(Graph graph, InputStream xslToInject, InputStream baseEvaluationStream, File oneProc) throws XMLStreamException {
        this.writer.writeStartDocument();
        this.writer.writeStartElement("xsl:stylesheet");
        this.writer.writeNamespace("mdj", "java:com.semarchy.xdi.designer.generation.xsl.global.Functions");
        this.writer.writeNamespace("mdv", "java:com.semarchy.xdi.designer.generation.xsl.global.Variables");
        this.writer.writeNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.writer.writeNamespace("ref", "http://www.stambia.com/ref");
        this.writer.writeNamespace("saxon", "http://saxon.sf.net/");
        this.writer.writeNamespace("tech", "http://www.stambia.com/tech");
        this.writer.writeNamespace("indyParse", "http://www.stambia.com/indyParse");
        this.writer.writeNamespace("ecore", "http://www.eclipse.org/emf/2002/Ecore");
        this.writer.writeNamespace("proc", "http://www.example.org/proc");
        this.writer.writeNamespace("func", "http://www.stambia.com/func");
        this.writer.writeNamespace("rdbms", "http://www.stambia.com/rdbms");
        this.writer.writeNamespace("md", "http://www.stambia.com/md");
        this.writer.writeNamespace("user", "http://www.stambia.com/user");
        this.writer.writeNamespace("UUID", "java.util.UUID");
        this.writer.writeNamespace("mds", "java:com.semarchy.xdi.designer.generation.xsl.global.Strings");
        this.writer.writeNamespace("map", "http://www.stambia.com/map");
        this.writer.writeNamespace("saxono", "http://www.example.org/saxono");
        this.writer.writeNamespace("xslo", "http://www.example.org/xslo");
        this.writer.writeNamespace("foo", "http://www.example.org/foo");
        this.writer.writeNamespace("gen", "java:com.semarchy.xdi.designer.generation.xsl.gene.GenerationMap");
        this.writer.writeNamespace("stack", "java:com.semarchy.xdi.designer.generation.xsl.gene.StackedVariableManager");
        this.writer.writeNamespace("jstack", "java:com.semarchy.xdi.designer.generation.xsl.gene.StackWrapper");
        this.writer.writeNamespace("procGen", "http://www.stambia.com/procGen/com.semarchy.xdi.designer.generation.xsl.gene.GenerationExtensionElementFactory");
        this.writer.writeNamespace("graph", "java:com.semarchy.xdi.designer.generation.xsl.gene.process.Graph");
        this.writer.writeAttribute("version", "2.0");
        this.writer.writeAttribute("extension-element-prefixes", "saxon ref indyParse tech procGen");
        this.writer.writeStartElement("xsl:output");
        this.writer.writeAttribute("method", "xml");
        this.writer.writeAttribute("encoding", "UTF-8");
        this.writer.writeAttribute("cdata-section-elements", "generationCondition executionCondition code step resultCode metaData");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:preserve-space");
        this.writer.writeAttribute("elements", "code CData resultCode");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:namespace-alias");
        this.writer.writeAttribute("stylesheet-prefix", "xslo");
        this.writer.writeAttribute("result-prefix", "xsl");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:namespace-alias");
        this.writer.writeAttribute("stylesheet-prefix", "saxono");
        this.writer.writeAttribute("result-prefix", "saxon");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:include");
        this.writer.writeAttribute("href", "global.xsl");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:include");
        this.writer.writeAttribute("href", "udf.xsl");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:param");
        this.writer.writeAttribute("name", "graph");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:param");
        this.writer.writeAttribute("name", "__jStack");
        this.writer.writeEndElement();
        this.writer.writeStartElement("xsl:variable");
        this.writer.writeAttribute("name", "__oneProc");
        this.writer.writeAttribute("select", "document('" + oneProc.toURI().toString().replace("'", "''") + "')");
        this.writer.writeEndElement();
        for (String s : graph.getGlobalVariables()) {
            this.writer.writeStartElement("xsl:variable");
            this.writer.writeAttribute("name", s);
            if (s.equals("this")) {
                this.writer.writeAttribute("select", "$__oneProc");
            } else {
                this.writer.writeAttribute("select", "error(QName('http://www.example.org/foo', 'variable'), concat('variable " + s + " not available in the Variable stack in ', jstack:getPath($__jStack)))");
            }
            this.writer.writeAttribute("saxon:assignable", "yes");
            this.writer.writeEndElement();
        }
        this.writer.writeStartElement("xsl:variable");
        this.writer.writeAttribute("name", "this");
        this.writer.writeAttribute("select", "$__oneProc");
        this.writer.writeAttribute("saxon:assignable", "yes");
        this.writer.writeEndElement();
        if (baseEvaluationStream != null) {
            try {
                this.injectXsl(baseEvaluationStream);
            }
            catch (Exception e) {
                this.logger.error("variables XSL injection intofailed", (Throwable)e);
            }
        }
        HashSet<String> s4 = new HashSet<String>();
        s4 = new HashSet();
        this.writer.writeStartElement("xsl:function");
        this.writer.writeAttribute("name", "func:repetitionValues");
        this.writer.writeStartElement("xsl:param");
        this.writer.writeAttribute("name", "queryHash");
        this.writer.writeEndElement();
        boolean hasRepetition = false;
        for (Graph.Node n : graph.getNodes()) {
            if (n.getRepetitionQuery() == null || !s4.add(n.getRepetitionQueryHash())) continue;
            if (!hasRepetition) {
                this.writer.writeStartElement("xsl:choose");
                hasRepetition = true;
            }
            this.writer.writeStartElement("xsl:when");
            this.writer.writeAttribute("test", "$queryHash='" + n.getRepetitionQueryHash() + "'");
            this.writer.writeStartElement("xsl:sequence");
            this.writer.writeAttribute("select", n.getRepetitionQuery());
            this.writer.writeEndElement();
            this.writer.writeEndElement();
        }
        if (hasRepetition) {
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        if (xslToInject != null) {
            try {
                this.injectXsl(xslToInject);
            }
            catch (Exception e) {
                this.logger.error("XSL injection failed", (Throwable)e);
            }
        }
        this.writer.writeEndDocument();
        this.writer.close();
    }

    private void injectXsl(InputStream xslToInject) throws Exception {
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        parserFactory.setFeature("http://xml.org/sax/features/validation", false);
        parserFactory.setNamespaceAware(true);
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader saxReader = parser.getXMLReader();
        saxReader.setContentHandler(new ContentHandler(){
            boolean rootRead = false;
            int count = 0;

            @Override
            public void startPrefixMapping(String prefix, String uri) throws SAXException {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                if (!this.rootRead) {
                    this.rootRead = true;
                    return;
                }
                try {
                    XSLEvaluationGenerator.this.writer.writeStartElement(qName);
                    int i = 0;
                    while (i < atts.getLength()) {
                        XSLEvaluationGenerator.this.writer.writeAttribute(atts.getLocalName(i), atts.getValue(i));
                        ++i;
                    }
                    ++this.count;
                }
                catch (Exception ex) {
                    throw new SAXException(ex);
                }
            }

            @Override
            public void startDocument() throws SAXException {
            }

            @Override
            public void skippedEntity(String name) throws SAXException {
            }

            @Override
            public void setDocumentLocator(Locator locator) {
            }

            @Override
            public void processingInstruction(String target, String data) throws SAXException {
            }

            @Override
            public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            }

            @Override
            public void endPrefixMapping(String prefix) throws SAXException {
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (this.count >= 1) {
                    try {
                        XSLEvaluationGenerator.this.writer.writeEndElement();
                    }
                    catch (Exception ex) {
                        throw new SAXException(ex);
                    }
                    --this.count;
                }
            }

            @Override
            public void endDocument() throws SAXException {
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                try {
                    XSLEvaluationGenerator.this.writer.writeCharacters(ch, start, length);
                }
                catch (Exception ex) {
                    throw new SAXException(ex);
                }
            }
        });
        BufferedReader reader = new BufferedReader(new InputStreamReader(xslToInject, "UTF-8"));
        InputSource source = new InputSource(reader);
        try {
            saxReader.parse(source);
        }
        finally {
            ((Reader)reader).close();
            xslToInject.close();
        }
    }
}

