/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out;

import com.indy.ui.custom.out.Activator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.ui.internal.views.properties.tabbed.l10n.TabbedPropertyMessages;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabDescriptor;
import org.eclipse.ui.views.properties.tabbed.AbstractSectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.ISectionDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITypeMapper;

public class TabDescriptorProvider {
    private static final String NO_TAB_ERROR = TabbedPropertyMessages.TabbedPropertyRegistry_Non_existing_tab;
    private static final String TAB_ERROR = TabbedPropertyMessages.TabDescriptor_Tab_unknown_category;
    private static final String EXTPT_TABS = "propertyTabs";
    private static final String EXTPT_SECTIONS = "propertySections";
    private static final String ELEMENT_TAB = "propertyTab";
    private static final String ELEMENT_SECTION = "propertySection";
    private static final String ATT_CONTRIBUTOR_ID = "contributorId";
    private static final String TOP = "top";
    private static final String ELEMENT_PROPERTY_CATEGORY = "propertyCategory";
    private static final String ATT_CATEGORY = "category";
    private static final String EXTPT_CONTRIBUTOR = "propertyContributor";
    protected String contributorId;
    protected List propertyCategories;
    protected ITypeMapper typeMapper;
    protected ITabDescriptor[] tabDescriptors;
    private IConfigurationElement contributorConfigurationElement;

    public ITabDescriptor[] getAllTabDescriptors() {
        if (this.tabDescriptors == null) {
            List temp = this.readTabDescriptors();
            this.populateWithSectionDescriptors(temp);
            temp = this.sortTabDescriptorsByCategory(temp);
            temp = this.sortTabDescriptorsByAfterTab(temp);
            this.tabDescriptors = temp.toArray(new TabDescriptor[temp.size()]);
        }
        return this.tabDescriptors;
    }

    protected List sortTabDescriptorsByCategory(List descriptors) {
        Collections.sort(descriptors, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                TabDescriptor one = (TabDescriptor)arg0;
                TabDescriptor two = (TabDescriptor)arg1;
                String categoryOne = one.getCategory();
                String categoryTwo = two.getCategory();
                int categoryOnePosition = TabDescriptorProvider.this.getIndex(TabDescriptorProvider.this.propertyCategories.toArray(), categoryOne);
                int categoryTwoPosition = TabDescriptorProvider.this.getIndex(TabDescriptorProvider.this.propertyCategories.toArray(), categoryTwo);
                return categoryOnePosition - categoryTwoPosition;
            }
        });
        return descriptors;
    }

    protected List sortTabDescriptorsByAfterTab(List tabs) {
        if (tabs.size() == 0 || this.propertyCategories == null) {
            return tabs;
        }
        ArrayList sorted = new ArrayList();
        int categoryIndex = 0;
        int i = 0;
        while (i < this.propertyCategories.size()) {
            ArrayList categoryList = new ArrayList();
            String category = (String)this.propertyCategories.get(i);
            int topOfCategory = categoryIndex;
            int endOfCategory = categoryIndex;
            while (endOfCategory < tabs.size() && ((TabDescriptor)tabs.get(endOfCategory)).getCategory().equals(category)) {
                ++endOfCategory;
            }
            int j = topOfCategory;
            while (j < endOfCategory) {
                TabDescriptor tab = (TabDescriptor)tabs.get(j);
                if (tab.getAfterTab().equals(TOP)) {
                    categoryList.add(0, tabs.get(j));
                } else {
                    categoryList.add(tabs.get(j));
                }
                ++j;
            }
            Collections.sort(categoryList, new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    TabDescriptor one = (TabDescriptor)arg0;
                    TabDescriptor two = (TabDescriptor)arg1;
                    if (two.getAfterTab().equals(one.getId())) {
                        return -1;
                    }
                    if (one.getAfterTab().equals(two.getId())) {
                        return 1;
                    }
                    return 0;
                }
            });
            j = 0;
            while (j < categoryList.size()) {
                sorted.add(categoryList.get(j));
                ++j;
            }
            categoryIndex = endOfCategory;
            ++i;
        }
        return sorted;
    }

    protected void populateWithSectionDescriptors(List aTabDescriptors) {
        ISectionDescriptor[] sections = null;
        sections = this.readSectionDescriptors();
        int i = 0;
        while (i < sections.length) {
            ISectionDescriptor section = sections[i];
            this.appendToTabDescriptor(section, aTabDescriptors);
            ++i;
        }
    }

    protected void appendToTabDescriptor(ISectionDescriptor section, List aTabDescriptors) {
        for (TabDescriptor tab : aTabDescriptors) {
            if (!section.getTargetTab().equals(tab.getId())) continue;
            tab.getSectionDescriptors().add(section);
            return;
        }
        String message = MessageFormat.format(NO_TAB_ERROR, section.getId(), section.getTargetTab());
        Status status = new Status(4, "com.indy.ui.custom.out", 1, message, null);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    protected ISectionDescriptor[] readSectionDescriptors() {
        ArrayList<SectionDescriptor> result = new ArrayList<SectionDescriptor>();
        IConfigurationElement[] extensions = this.getConfigurationElements(EXTPT_SECTIONS);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement extension = extensions[i];
            IConfigurationElement[] sections = extension.getChildren(ELEMENT_SECTION);
            int j = 0;
            while (j < sections.length) {
                IConfigurationElement section = sections[j];
                SectionDescriptor descriptor = new SectionDescriptor(section, this.typeMapper);
                result.add(descriptor);
                ++j;
            }
            ++i;
        }
        return result.toArray(new ISectionDescriptor[result.size()]);
    }

    public TabDescriptorProvider(String id) {
        this.contributorId = id;
        this.propertyCategories = new ArrayList();
        IConfigurationElement[] extensions = this.getConfigurationElements(EXTPT_CONTRIBUTOR);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement configurationElement = extensions[i];
            String contributor = configurationElement.getAttribute(ATT_CONTRIBUTOR_ID);
            if (contributor != null && id.equals(contributor)) {
                this.contributorConfigurationElement = configurationElement;
                this.addPropertyCategories(configurationElement);
            }
            ++i;
        }
    }

    private void addPropertyCategories(IConfigurationElement configurationElement) {
        IConfigurationElement[] elements = configurationElement.getChildren(ELEMENT_PROPERTY_CATEGORY);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            this.propertyCategories.add(element.getAttribute(ATT_CATEGORY));
            ++i;
        }
    }

    protected List readTabDescriptors() {
        ArrayList<TabDescriptor> result = new ArrayList<TabDescriptor>();
        IConfigurationElement[] extensions = this.getConfigurationElements(EXTPT_TABS);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement extension = extensions[i];
            IConfigurationElement[] tabs = extension.getChildren(ELEMENT_TAB);
            int j = 0;
            while (j < tabs.length) {
                IConfigurationElement tab = tabs[j];
                TabDescriptor descriptor = new TabDescriptor(tab);
                if (this.getIndex(this.propertyCategories.toArray(), descriptor.getCategory()) == -1) {
                    this.handleTabError(tab, descriptor.getCategory() == null ? "" : descriptor.getCategory());
                } else {
                    result.add(descriptor);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private void handleTabError(IConfigurationElement configurationElement, String category) {
        String pluginId = configurationElement.getDeclaringExtension().getNamespaceIdentifier();
        String message = MessageFormat.format(TAB_ERROR, pluginId, category);
        Status status = new Status(4, pluginId, 3, message, null);
        Activator.getDefault().getLog().log((IStatus)status);
    }

    private int getIndex(Object[] array, Object target) {
        int i = 0;
        while (i < array.length) {
            if (array[i].equals(target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected IConfigurationElement[] getConfigurationElements(String extensionPointId) {
        if (this.contributorId == null) {
            return new IConfigurationElement[0];
        }
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui.views.properties.tabbed", extensionPointId);
        IConfigurationElement[] extensions = point.getConfigurationElements();
        ArrayList<IConfigurationElement> unordered = new ArrayList<IConfigurationElement>(extensions.length);
        int i = 0;
        while (i < extensions.length) {
            String contributor;
            IConfigurationElement extension = extensions[i];
            if (extension.getName().equals(extensionPointId) && this.contributorId.equals(contributor = extension.getAttribute(ATT_CONTRIBUTOR_ID))) {
                unordered.add(extension);
            }
            ++i;
        }
        return unordered.toArray(new IConfigurationElement[unordered.size()]);
    }

    public class SectionDescriptor
    extends AbstractSectionDescriptor {
        private static final String ATT_ID = "id";
        private static final String ATT_TARGET_TAB = "tab";
        private static final String ATT_AFTER_SECTION = "afterSection";
        private static final String ATT_CLASS = "class";
        private static final String ATT_SECTION_FILTER = "filter";
        private static final String ATT_SECTION_ENABLES_FOR = "enablesFor";
        private static final String ATT_INPUT_TYPE = "type";
        private static final String ELEMENT_INPUT = "input";
        private String id;
        private String targetTab;
        private String afterSection;
        private ArrayList inputTypes;
        private IFilter filter;
        private int enablesFor;
        private IConfigurationElement configurationElement;

        protected SectionDescriptor(IConfigurationElement configurationElement, ITypeMapper typeMapper) {
            String enablesForStr;
            int enablesForTest;
            super(typeMapper);
            this.enablesFor = -1;
            this.configurationElement = configurationElement;
            this.id = this.getConfigurationElement().getAttribute(ATT_ID);
            this.targetTab = this.getConfigurationElement().getAttribute(ATT_TARGET_TAB);
            this.afterSection = this.getConfigurationElement().getAttribute(ATT_AFTER_SECTION);
            if (this.getConfigurationElement().getAttribute(ATT_SECTION_ENABLES_FOR) != null && (enablesForTest = Integer.parseInt(enablesForStr = this.getConfigurationElement().getAttribute(ATT_SECTION_ENABLES_FOR))) > 0) {
                this.enablesFor = enablesForTest;
            }
            if (this.id == null || this.targetTab == null) {
                this.handleSectionError(null);
            }
        }

        private void handleSectionError(CoreException exception) {
            String pluginId = this.getConfigurationElement().getDeclaringExtension().getNamespaceIdentifier();
            String message = TabbedPropertyMessages.SectionDescriptor_Section_error;
            message = exception == null ? MessageFormat.format(TabbedPropertyMessages.SectionDescriptor_Section_error, pluginId) : MessageFormat.format(TabbedPropertyMessages.SectionDescriptor_class_not_found_error, pluginId);
            Status status = new Status(4, pluginId, 2, message, (Throwable)exception);
            Activator.getDefault().getLog().log((IStatus)status);
        }

        public String getId() {
            return this.id;
        }

        public IFilter getFilter() {
            if (this.filter == null) {
                try {
                    if (this.getConfigurationElement().getAttribute(ATT_SECTION_FILTER) != null) {
                        this.filter = (IFilter)this.configurationElement.createExecutableExtension(ATT_SECTION_FILTER);
                    }
                }
                catch (CoreException exception) {
                    this.handleSectionError(exception);
                }
            }
            return this.filter;
        }

        public int getEnablesFor() {
            return this.enablesFor;
        }

        public String getTargetTab() {
            return this.targetTab;
        }

        public String getAfterSection() {
            if (this.afterSection == null) {
                return super.getAfterSection();
            }
            return this.afterSection;
        }

        public ISection getSectionClass() {
            ISection section = null;
            try {
                section = (ISection)this.getConfigurationElement().createExecutableExtension(ATT_CLASS);
            }
            catch (CoreException exception) {
                this.handleSectionError(exception);
            }
            return section;
        }

        public List getInputTypes() {
            if (this.inputTypes == null) {
                this.inputTypes = new ArrayList();
                IConfigurationElement[] elements = this.getConfigurationElement().getChildren(ELEMENT_INPUT);
                int i = 0;
                while (i < elements.length) {
                    IConfigurationElement element = elements[i];
                    this.inputTypes.add(element.getAttribute(ATT_INPUT_TYPE));
                    ++i;
                }
            }
            return this.inputTypes;
        }

        public String toString() {
            return this.getId();
        }

        private IConfigurationElement getConfigurationElement() {
            return this.configurationElement;
        }
    }
}

