/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common.properties;

import com.indy.ui.custom.out.Messages;
import com.indy.ui.custom.out.common.properties.AbstractUnboundedControl;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractKeyValueControl
extends AbstractUnboundedControl {
    private Text value;
    private IKeyValueProvider keyValueProvider;
    private Control key;

    protected abstract String getKeyLabel(Object var1);

    protected abstract String getValueLabel(Object var1);

    public AbstractKeyValueControl(ILabelProvider labelProvider, IKeyValueProvider provider) {
        super(labelProvider, Messages.AbstractKeyValueControl_0);
        this.keyValueProvider = provider;
    }

    private void setKeyValue(String value) {
        if (this.keyValueProvider == null) {
            ((Text)this.key).setText(value);
        } else {
            ((Combo)this.key).setText(value);
        }
    }

    private String getKeyText() {
        if (this.keyValueProvider == null) {
            return ((Text)this.key).getText();
        }
        return ((Combo)this.key).getText();
    }

    @Override
    protected void clearValueComposite() {
        this.setKeyValue("");
        this.value.setText("");
        Event ev = new Event();
        ev.widget = this.key;
        ev.type = 24;
        this.key.notifyListeners(24, ev);
        ev = new Event();
        ev.widget = this.value;
        ev.type = 24;
        this.value.notifyListeners(24, ev);
    }

    @Override
    protected Composite createValueComposite(Composite parent) {
        Composite c = this.getWidgetFactory().createComposite(parent);
        c.setLayout((Layout)new GridLayout(2, false));
        Label l = this.getWidgetFactory().createLabel(c, Messages.AbstractKeyValueControl_3);
        l.setLayoutData((Object)new GridData());
        KeyControlListener listener = new KeyControlListener();
        if (this.keyValueProvider == null) {
            this.key = this.getWidgetFactory().createText(c, "");
            this.key.setLayoutData((Object)new GridData(4, 1, true, false));
            ((Text)this.key).addModifyListener((ModifyListener)listener);
        } else {
            this.key = new Combo(c, 0);
            this.getWidgetFactory().adapt(this.key, false, false);
            this.key.setLayoutData((Object)new GridData(4, 1, true, false));
            ((Combo)this.key).setItems(this.keyValueProvider.getKeyValues().toArray(new String[this.keyValueProvider.getKeyValues().size()]));
            ((Combo)this.key).addModifyListener((ModifyListener)listener);
            ((Combo)this.key).addSelectionListener((SelectionListener)listener);
        }
        l = this.getWidgetFactory().createLabel(c, Messages.AbstractKeyValueControl_5);
        l.setLayoutData((Object)new GridData());
        this.value = this.getWidgetFactory().createText(c, "");
        this.value.setLayoutData((Object)new GridData(4, 1, true, false));
        return c;
    }

    @Override
    protected Object getEditedValueFromValueComposite() {
        return new String[]{this.getKeyText(), this.value.getText()};
    }

    @Override
    protected void configureValuesViewer() {
        TableViewer viewer = this.getValuesViewer();
        viewer.getTable().setHeaderVisible(true);
        viewer.getTable().setLinesVisible(true);
        TableViewerColumn col = new TableViewerColumn(viewer, 16384);
        col.getColumn().setText(Messages.AbstractKeyValueControl_7);
        col.getColumn().setWidth(100);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return AbstractKeyValueControl.this.getKeyLabel(element);
            }
        });
        col = new TableViewerColumn(viewer, 16384);
        col.getColumn().setText(Messages.AbstractKeyValueControl_8);
        col.getColumn().setWidth(100);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return AbstractKeyValueControl.this.getValueLabel(element);
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    AbstractKeyValueControl.this.fillValueComposite(((IStructuredSelection)event.getSelection()).getFirstElement());
                } else {
                    AbstractKeyValueControl.this.clearValueComposite();
                }
            }
        });
    }

    @Override
    protected void fillValueComposite(Object valueObject) {
        Map.Entry e = (Map.Entry)valueObject;
        this.setKeyValue((String)e.getKey());
        if (e.getValue() == null) {
            this.value.setText("");
        } else {
            this.value.setText((String)e.getValue());
        }
        Event ev = new Event();
        ev.widget = this.key;
        ev.type = 24;
        this.key.notifyListeners(24, ev);
        ev = new Event();
        ev.widget = this.value;
        ev.type = 24;
        this.value.notifyListeners(24, ev);
    }

    public static interface IKeyValueProvider {
        public List<String> getKeyValues();
    }

    class KeyControlListener
    implements ModifyListener,
    SelectionListener {
        KeyControlListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (AbstractKeyValueControl.this.getKeyText().trim().isEmpty()) {
                AbstractKeyValueControl.this.getAddButton().setEnabled(false);
            } else {
                AbstractKeyValueControl.this.getAddButton().setEnabled(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void modifyText(ModifyEvent e) {
            if (AbstractKeyValueControl.this.getKeyText().trim().isEmpty()) {
                AbstractKeyValueControl.this.getAddButton().setEnabled(false);
            } else {
                AbstractKeyValueControl.this.getAddButton().setEnabled(true);
            }
        }
    }
}

