/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.custom.out.common.properties;

import com.indy.ui.custom.out.Messages;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public abstract class AbstractVariableUsageDecorator
implements ModifyListener,
Listener,
PaintListener {
    public static final String STRING_SUBSTITUTION_PREFERENCE_PAGE_ID = "com.indy.ui.custom.out.StringVariablePreferencePage";
    private static Pattern ALL_PATTERN = Pattern.compile("(%\\{([a-zA-Z0-9_]*)\\})%|(%(\\{env:([^\\{\\}%]+)\\})%)");
    private static Pattern EXECUTION_VARIABLE_PATTERN = Pattern.compile("(\\$\\{([a-zA-Z0-9_/.]*)\\}\\$)");
    static final Cursor scursor = new Cursor((Device)Display.getDefault(), 21);
    static final Cursor cursor = new Cursor((Device)Display.getDefault(), 20);
    private volatile StyleRange hoveredStyleRange = new StyleRange(-1, -1, null, null);
    StyleRange lastHoveredRange = null;

    protected abstract Object findMdLink(Object var1, String var2);

    protected abstract Object getContext();

    protected abstract Object getMdLinkTarget(Object var1, String var2);

    public void paintControl(PaintEvent e) {
        if (this.hoveredStyleRange.start > -1) {
            try {
                Rectangle bounds = ((StyledText)e.widget).getTextBounds(this.hoveredStyleRange.start, this.hoveredStyleRange.start + this.hoveredStyleRange.length - 1);
                e.gc.setForeground(e.display.getSystemColor(9));
                e.gc.setLineStyle(1);
                e.gc.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width, bounds.y + bounds.height - 1);
                e.gc.setAlpha(100);
                e.gc.setBackground(((StyledText)e.widget).getSelectionBackground());
                e.gc.fillRectangle(bounds);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void modifyText(ModifyEvent e) {
        Matcher m;
        StyledText ctr = (StyledText)e.widget;
        ctr.setStyleRange(null);
        String s = new String(ctr.getText());
        if (s.contains("%{")) {
            m = ALL_PATTERN.matcher(s);
            while (m.find()) {
                String mdLinkName = m.group(2);
                String varName = m.group(5);
                StyleRange r = null;
                if (mdLinkName != null) {
                    Object mdLink;
                    r = new StyleRange(m.start(1), m.end(1) - m.start(1) + 1, e.display.getSystemColor(12), null);
                    Object context = this.getContext();
                    if (context != null && (mdLink = this.findMdLink(context, mdLinkName)) == null) {
                        r.underlineStyle = 2;
                        r.underline = true;
                    }
                } else if (varName != null) {
                    r = new StyleRange(m.start(3), m.end(3) - m.start(3), e.display.getSystemColor(12), null);
                    r.underline = false;
                    try {
                        VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution("${" + varName + "}", true);
                    }
                    catch (Exception ex) {
                        r.underline = true;
                        r.underlineStyle = 2;
                        r.underlineColor = e.display.getSystemColor(3);
                    }
                }
                if (r == null) continue;
                ctr.setStyleRange(r);
            }
        }
        if (s.contains("${")) {
            m = EXECUTION_VARIABLE_PATTERN.matcher(s);
            while (m.find()) {
                StyleRange r = new StyleRange(m.start(1), m.end(1) - m.start(1), e.display.getSystemColor(9), null);
                ctr.setStyleRange(r);
            }
        }
    }

    private void handleMouseMoved(Event event) {
        StyledText st = (StyledText)event.widget;
        int offset = st.getOffsetAtPoint(new Point(event.x, event.y));
        StyleRange style = null;
        if (offset >= 0 && offset < st.getText().length()) {
            StyleRange[] styleRangeArray = st.getStyleRanges();
            int n = styleRangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                StyleRange r = styleRangeArray[n2];
                if (r.start <= offset && offset < r.start + r.length) {
                    style = r;
                    break;
                }
                ++n2;
            }
        }
        if (style == null) {
            if (this.hoveredStyleRange.start != -1 || this.hoveredStyleRange.length != -1) {
                this.hoveredStyleRange.start = -1;
                this.hoveredStyleRange.length = -1;
                st.setCursor(null);
                st.redraw();
            }
        } else if (style != this.lastHoveredRange) {
            if (this.hoveredStyleRange.start != style.start || this.hoveredStyleRange.length != style.length) {
                this.hoveredStyleRange.start = style.start;
                this.hoveredStyleRange.length = style.length;
                st.redraw();
            }
            this.lastHoveredRange = style;
        }
    }

    private void handleKeyPressed(Event event) {
        StyledText st = (StyledText)event.widget;
        Cursor c = null;
        if ((event.stateMask & 0x40000) != 0) {
            c = scursor;
        }
        if (this.lastHoveredRange != null) {
            st.setCursor(c);
        }
    }

    private void handleMouseClick(Event event) {
        StyledText st = (StyledText)event.widget;
        String fullExp = st.getText().substring(this.hoveredStyleRange.start, this.hoveredStyleRange.start + this.hoveredStyleRange.length);
        if (fullExp.startsWith("%{")) {
            String exp = fullExp.substring(2, fullExp.length() - 2);
            if (exp.startsWith("env:")) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)st.getShell(), (String)STRING_SUBSTITUTION_PREFERENCE_PAGE_ID, (String[])new String[]{STRING_SUBSTITUTION_PREFERENCE_PAGE_ID}, null);
                dialog.open();
            } else {
                String varName = exp;
                Object context = this.getContext();
                Object mdLink = this.findMdLink(context, varName);
                if (mdLink == null) {
                    MessageDialog.openInformation((Shell)st.getShell(), (String)Messages.AbstractVariableUsageDecorator_11, (String)Messages.bind((String)Messages.AbstractVariableUsageDecorator_0, (Object)varName));
                } else {
                    Object trg = this.getMdLinkTarget(mdLink, varName);
                    if (trg instanceof EObject) {
                        try {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new URIEditorInput(EcoreUtil.getURI((EObject)((EObject)trg))), "com.stambia.md.presentation.MdEditorID");
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            }
        } else {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/com.indy.ui.help/html/seidg/Working-with-Variables.html?cp=3_5_9_0_3#SyntaxtouseMetadataVariablesinExpressions");
        }
        st.notifyListeners(4, new Event());
        st.notifyListeners(24, new Event());
        st.redraw();
    }

    public void handleEvent(Event event) {
        if (event.type == 6 || event.type == 32 || event.type == 5 || event.type == 7) {
            this.handleMouseMoved(event);
        }
        if (event.type == 3 && (event.stateMask & 0x40000) == 262144) {
            this.handleMouseClick(event);
        }
        this.handleKeyPressed(event);
    }
}

