/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management.ui.internal;

import com.indy.engine.core.module.IModuleService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.ui.about.ISystemSummarySection;

public class ComponentsSystemSummarySection
implements ISystemSummarySection {
    public void write(PrintWriter writer) {
        IModuleService moduleService = (IModuleService)E4InjectorHelper.getService(IModuleService.class);
        ArrayList<IModuleService.IModule> modules = new ArrayList<IModuleService.IModule>(moduleService.getModules());
        modules.sort(new Comparator<IModuleService.IModule>(){

            @Override
            public int compare(IModuleService.IModule o1, IModuleService.IModule o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (IModuleService.IModule m : modules) {
            IModuleService.IBaseModuleInfo info = m.getDescriptor().getBaseModuleInfo();
            writer.println("Module " + m.getName());
            writer.println("\tInstallationFolder= " + String.valueOf(m.getInstallationFolder()));
            writer.println("\tBaseModule:");
            writer.println("\t\tid=" + info.getId());
            writer.println("\t\tversion=" + String.valueOf(info.getVersion()));
            if (m.getDescriptor().getBaseModuleExtensionInfo() != null) {
                IModuleService.IBaseModuleInfo ext = m.getDescriptor().getBaseModuleExtensionInfo();
                writer.println("\tBaseModuleExtension:");
                writer.println("\t\tid=" + ext.getId());
                writer.println("\t\tversion=" + String.valueOf(ext.getVersion()));
            }
            writer.println("\tInternalFiles:");
            try {
                ArrayList<URL> l = new ArrayList<URL>(m.getURLs());
                l.sort(new Comparator<URL>(){

                    @Override
                    public int compare(URL o1, URL o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                Collection fileNames = m.getDescriptor().getFileNames();
                ArrayList<String> userFiles = new ArrayList<String>();
                for (URL u : l) {
                    String s = u.toString().substring(u.toString().lastIndexOf("/") + 1);
                    if (!fileNames.contains(s)) {
                        userFiles.add(s);
                        continue;
                    }
                    writer.println("\t\t" + s);
                }
                if (!userFiles.isEmpty()) {
                    writer.println("\tUserFiles:");
                    for (String s : userFiles) {
                        writer.println("\t\t" + s);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            writer.println();
        }
    }
}

