/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.management.ui.wizard.upgrade;

import com.indy.engine.core.module.IModuleService;
import com.indy.libraries.management.ui.Activator;
import com.indy.libraries.management.ui.wizard.ModuleControler;
import com.indy.libraries.management.ui.wizard.ModuleWizard;
import com.indy.libraries.management.ui.wizard.NiceList;
import com.indy.libraries.management.ui.wizard.upgrade.Messages;
import com.indy.libraries.management.ui.wizard.upgrade.UpgradeModuleControler;
import com.semarchy.xdi.designer.core.services.IModelUpgrader;
import com.semarchy.xdi.designer.core.services.IModuleRequirmentService;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class MdModuleManagerWizard
extends Wizard {
    public static Image okIcon = Activator.imageDescriptorFromPlugin((String)"com.indy.gmf.process.diagram.non_rcp", (String)"/icons/obj16/OK1_16x16.png").createImage();
    public static Image checkAll = Activator.imageDescriptorFromPlugin((String)"com.indy.gmf.map.diagram", (String)"/icons/obj16/checkAll.png").createImage();
    public static Image uncheckAll = Activator.imageDescriptorFromPlugin((String)"com.indy.gmf.map.diagram", (String)"/icons/obj16/uncheckall.png").createImage();
    UpgradeModuleControler controler;
    MainPage page;

    public MdModuleManagerWizard() {
        IEclipseContext ctx = EclipseContextFactory.getServiceContext((BundleContext)Activator.getDefault().getBundle().getBundleContext());
        this.controler = (UpgradeModuleControler)ContextInjectionFactory.make(UpgradeModuleControler.class, (IEclipseContext)ctx);
    }

    public UpgradeModuleControler getControler() {
        return this.controler;
    }

    public void addPages() {
        this.page = new MainPage("Update Metadata Modules");
        this.page.setDescription(Messages.MdModuleManagerWizard_22);
        this.page.setTitle(Messages.MdModuleManagerWizard_23);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        Collection c = Activator.getDefault().getBundle().getBundleContext().getServiceReferences(IModelUpgrader.class, "(&(type=md)(kind=module))");
        ServiceReference sc = (ServiceReference)c.iterator().next();
        final IModelUpgrader up = (IModelUpgrader)Activator.getDefault().getBundle().getBundleContext().getService(sc);
        try {
            final HashMap<URI, IModuleService.IModule> m = new HashMap<URI, IModuleService.IModule>();
            ISchedulingRule rule = null;
            for (IFile f : this.controler.options.mdModelsToUpdate) {
                m.put(URIUtils.convertIPathToEMFURI2((IPath)f.getFullPath()), this.controler.options.moduleToApply);
                rule = MultiRule.combine((ISchedulingRule)f, rule);
            }
            WorkspaceJob job = new WorkspaceJob(Messages.MdModuleManagerWizard_25){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        try {
                            up.upgradeModels(m.keySet(), (Map)m, null, false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            IStatus iStatus = Status.OK_STATUS;
                            try {
                                Job refreshJob = MdModuleManagerWizard.this.controler.getModuleRequirementService().createRefresh();
                                refreshJob.schedule();
                                refreshJob.join();
                            }
                            catch (Exception ex2) {
                                ex2.printStackTrace();
                            }
                            return iStatus;
                        }
                    }
                    finally {
                        try {
                            Job refreshJob = MdModuleManagerWizard.this.controler.getModuleRequirementService().createRefresh();
                            refreshJob.schedule();
                            refreshJob.join();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule(rule);
            job.setUser(true);
            job.schedule();
            new ProgressMonitorDialog(this.getShell()).run(false, false, new IRunnableWithProgress((Job)job){
                private final /* synthetic */ Job val$job;
                {
                    this.val$job = job;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    this.val$job.join();
                }
            });
            this.controler.options.mdModelsToUpdate.clear();
            this.page.fill();
            StatusManager.getManager().handle(job.getResult());
        }
        catch (Throwable throwable) {
            try {
                Activator.getDefault().getBundle().getBundleContext().ungetService(sc);
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        Activator.getDefault().getBundle().getBundleContext().ungetService(sc);
        return false;
    }

    class MainPage
    extends WizardPage {
        NiceList baseModuleList;
        CheckboxTableViewer fileViewer;
        boolean showOk;
        boolean showError;
        boolean showWarning;

        protected MainPage(String pageName) {
            super(pageName);
            this.showOk = true;
            this.showError = true;
            this.showWarning = true;
        }

        public void createControl(Composite parent) {
            FontDescriptor pDesc = FontDescriptor.createFrom((Font)parent.getFont()).setStyle(1);
            final Font font = pDesc.createFont((Device)parent.getDisplay());
            parent.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    font.dispose();
                }
            });
            Composite main = new Composite(parent, 0);
            this.setControl((Control)main);
            main.setLayout((Layout)new GridLayout(2, false));
            main.setLayoutData((Object)new GridData(4, 4, true, true));
            final NiceList.TextProvider textProvider = new NiceList.TextProvider(){

                @Override
                public String getMainText(Object element) {
                    IModuleService.IBaseModule m = ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.getBaseModule((String)element);
                    if (m == null) {
                        return element.toString();
                    }
                    return m.getLabel();
                }

                @Override
                public String getSecondaryText(Object element) {
                    IModuleService.IBaseModule m = ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.getBaseModule((String)element);
                    if (m == null) {
                        return Messages.MdModuleManagerWizard_2;
                    }
                    return m.getDescription();
                }

                @Override
                public Color getColor(Object element) {
                    return MainPage.this.getContainer().getShell().getDisplay().getSystemColor(2);
                }

                @Override
                public Image getIcon(Object element) {
                    IModuleService.IBaseModule m = ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.getBaseModule((String)element);
                    if (m == null) {
                        return ModuleControler.warningIcon;
                    }
                    return null;
                }

                @Override
                public String getTooltip(Object element) {
                    IModuleService.IBaseModule m = ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.getBaseModule((String)element);
                    if (m == null) {
                        return Messages.MdModuleManagerWizard_3;
                    }
                    return null;
                }
            };
            this.baseModuleList = new NiceList(textProvider);
            Control c = this.baseModuleList.createControl(main, 68096);
            c.setLayoutData((Object)new GridData(1, 4, false, true));
            Composite cFile = new Composite(main, 2048);
            cFile.setLayout((Layout)new GridLayout());
            cFile.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite moduleC = new Composite(cFile, 0);
            moduleC.setLayout((Layout)new GridLayout(2, false));
            ((GridLayout)moduleC.getLayout()).marginWidth = 0;
            moduleC.setLayoutData((Object)new GridData(4, 3, true, false));
            Label l = new Label(moduleC, 0);
            l.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            l.setText(Messages.MdModuleManagerWizard_4);
            l.setFont(font);
            final Text selectedModule = new Text(moduleC, 2048);
            selectedModule.setLayoutData((Object)new GridData(4, 1, true, false));
            selectedModule.setEnabled(false);
            Button createModule = new Button(moduleC, 8);
            createModule.setLayoutData((Object)new GridData(3, 1, false, false));
            createModule.setText("...");
            Label l2 = new Label(cFile, 0);
            l2.setLayoutData((Object)new GridData(1, 1, false, false));
            l2.setText(Messages.MdModuleManagerWizard_6);
            l2.setFont(font);
            ToolBar tb = new ToolBar(cFile, 0x800100);
            tb.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fileViewer = CheckboxTableViewer.newCheckList((Composite)cFile, (int)68096);
            this.fileViewer.getTable().setLinesVisible(true);
            this.fileViewer.getTable().setHeaderVisible(true);
            this.fileViewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    return ((IFile)e1).getFullPath().toString().compareTo(((IFile)e2).getFullPath().toString());
                }
            });
            this.fileViewer.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    IModuleRequirmentService.ModelModuleState state = ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.getState((IFile)element);
                    return MainPage.this.showError && (state == IModuleRequirmentService.ModelModuleState.UNSPECIFIED || state == IModuleRequirmentService.ModelModuleState.INEXISTANT) || MainPage.this.showWarning && state == IModuleRequirmentService.ModelModuleState.SPECIFIED || MainPage.this.showOk && state == IModuleRequirmentService.ModelModuleState.MATCH_BASE_MODULE;
                }
            });
            this.fileViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.fileViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fileViewer);
            this.createToolbar(tb, this.fileViewer);
            TableViewerColumn col = new TableViewerColumn((TableViewer)this.fileViewer, 16384);
            col.getColumn().setText(Messages.MdModuleManagerWizard_7);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public Image getImage(Object element) {
                    switch (((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.getState((IFile)element)) {
                        case MATCH_BASE_MODULE: {
                            return okIcon;
                        }
                        case SPECIFIED: {
                            return ModuleControler.warningIcon;
                        }
                        case UNSPECIFIED: 
                        case INEXISTANT: {
                            return ModuleControler.errorIcon;
                        }
                    }
                    return null;
                }

                public String getText(Object element) {
                    return ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.getModuleName((IFile)element);
                }

                public String getToolTipText(Object element) {
                    switch (((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.getState((IFile)element)) {
                        case INEXISTANT: {
                            return Messages.MdModuleManagerWizard_8;
                        }
                        case SPECIFIED: {
                            return Messages.MdModuleManagerWizard_9;
                        }
                        case UNSPECIFIED: {
                            return Messages.MdModuleManagerWizard_10;
                        }
                    }
                    return super.getToolTipText(element);
                }
            });
            col = new TableViewerColumn((TableViewer)this.fileViewer, 16384);
            col.getColumn().setText(Messages.MdModuleManagerWizard_11);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){
                private ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

                public void dispose() {
                    this.resourceManager.dispose();
                    super.dispose();
                }

                public Image getImage(Object element) {
                    IWorkbenchAdapter adapter = (IWorkbenchAdapter)Platform.getAdapterManager().getAdapter(element, IWorkbenchAdapter.class);
                    ImageDescriptor desc = adapter.getImageDescriptor(element);
                    return (Image)this.resourceManager.get((DeviceResourceDescriptor)desc);
                }

                public String getText(Object element) {
                    return ((IResource)element).getName();
                }
            });
            col = new TableViewerColumn((TableViewer)this.fileViewer, 16384);
            col.getColumn().setText(Messages.MdModuleManagerWizard_12);
            col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                public String getText(Object element) {
                    return ((IResource)element).getParent().getFullPath().toOSString();
                }
            });
            this.baseModuleList.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.options.mdModelsToUpdate.clear();
                    ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.options.moduleToApply = null;
                    selectedModule.setText("");
                    if (event.getSelection().isEmpty()) {
                        MainPage.this.fileViewer.setInput((Object)Collections.EMPTY_LIST);
                    } else {
                        MainPage.this.fileViewer.setInput(((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.getMdWithNoModulesPerBaseModuleId().get(event.getStructuredSelection().getFirstElement()));
                        MainPage.this.fileViewer.setAllChecked(false);
                        for (IModuleService.IModule m : ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.getModuleService().getModules()) {
                            if (!m.getDescriptor().getBaseModuleInfo().getId().equals(event.getStructuredSelection().getFirstElement())) continue;
                            ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.options.moduleToApply = m;
                            selectedModule.setText(m.getName());
                            break;
                        }
                    }
                    Table table = MainPage.this.fileViewer.getTable();
                    int i = 0;
                    while (i < table.getColumnCount()) {
                        table.getColumn(i).pack();
                        ++i;
                    }
                    MainPage.this.updateWizard();
                }
            });
            this.fileViewer.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    if (event.getChecked()) {
                        ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.options.mdModelsToUpdate.add((IFile)event.getElement());
                    } else {
                        ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.options.mdModelsToUpdate.remove(event.getElement());
                    }
                    MainPage.this.updateWizard();
                }
            });
            createModule.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    HashSet<String> baseModuleFilter = new HashSet<String>();
                    baseModuleFilter.add("com.indy.baseModule.default");
                    baseModuleFilter.add("com.indy.baseModule.generic");
                    baseModuleFilter.add((String)MainPage.this.baseModuleList.getSelection().getFirstElement());
                    ModuleWizard z = new ModuleWizard(baseModuleFilter, null, false, false);
                    WizardDialog d = new WizardDialog(MainPage.this.getShell(), (IWizard)z);
                    d.setPageSize(800, 600);
                    if (d.open() == 0) {
                        ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.options.moduleToApply = z.getResult();
                        selectedModule.setText(((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.options.moduleToApply.getName());
                        MainPage.this.updateWizard();
                    }
                }
            });
            ArrayList<String> ll = new ArrayList<String>(MdModuleManagerWizard.this.controler.getMdWithNoModulesPerBaseModuleId().keySet());
            Collections.sort(ll, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return textProvider.getMainText(o1).compareTo(textProvider.getMainText(o2));
                }
            });
            this.baseModuleList.setInput(ll);
        }

        public void fill() {
            this.fileViewer.setAllChecked(false);
            this.fileViewer.refresh(true, true);
        }

        private void createToolbar(ToolBar tb, final CheckboxTableViewer fileViewer) {
            ToolItem checkAll = new ToolItem(tb, 8);
            checkAll.setImage(MdModuleManagerWizard.checkAll);
            checkAll.setToolTipText(Messages.MdModuleManagerWizard_14);
            checkAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    fileViewer.setAllChecked(true);
                    TableItem[] tableItemArray = fileViewer.getTable().getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem i = tableItemArray[n2];
                        ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.options.mdModelsToUpdate.add((IFile)i.getData());
                        ++n2;
                    }
                    MainPage.this.updateWizard();
                }
            });
            ToolItem uncheckAll = new ToolItem(tb, 8);
            uncheckAll.setImage(MdModuleManagerWizard.uncheckAll);
            uncheckAll.setToolTipText(Messages.MdModuleManagerWizard_15);
            uncheckAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    fileViewer.setAllChecked(false);
                    ((MainPage)MainPage.this).MdModuleManagerWizard.this.controler.options.mdModelsToUpdate.clear();
                    MainPage.this.updateWizard();
                }
            });
            ToolItem filterOk = new ToolItem(tb, 32);
            filterOk.setImage(okIcon);
            filterOk.setToolTipText(Messages.MdModuleManagerWizard_16);
            filterOk.setSelection(true);
            filterOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MainPage.this.showOk = !MainPage.this.showOk;
                    fileViewer.refresh(true);
                }
            });
            ToolItem filterWarning = new ToolItem(tb, 32);
            filterWarning.setImage(ModuleControler.warningIcon);
            filterWarning.setToolTipText(Messages.MdModuleManagerWizard_17);
            filterWarning.setSelection(true);
            filterWarning.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MainPage.this.showWarning = !MainPage.this.showWarning;
                    fileViewer.refresh(true);
                }
            });
            ToolItem filterError = new ToolItem(tb, 32);
            filterError.setImage(ModuleControler.errorIcon);
            filterError.setToolTipText(Messages.MdModuleManagerWizard_18);
            filterError.setSelection(true);
            filterError.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MainPage.this.showError = !MainPage.this.showError;
                    fileViewer.refresh(true);
                }
            });
        }

        public boolean isPageComplete() {
            return MdModuleManagerWizard.this.controler.options != null && MdModuleManagerWizard.this.controler.options.moduleToApply != null && !MdModuleManagerWizard.this.controler.options.mdModelsToUpdate.isEmpty();
        }

        private void updateWizard() {
            String message = null;
            if (MdModuleManagerWizard.this.controler.options.moduleToApply == null) {
                message = Messages.MdModuleManagerWizard_19;
            } else if (MdModuleManagerWizard.this.controler.options.mdModelsToUpdate.isEmpty()) {
                message = Messages.MdModuleManagerWizard_20;
            }
            this.setErrorMessage(message);
            this.getContainer().updateButtons();
        }

        public void performHelp() {
            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("com.indy.ui.help.redirects/designer/modules");
        }
    }
}

