/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.editors.export;

import com.indy.ui.sql.IResultModel;
import com.indy.ui.sql.editors.export.ExportOptions;
import com.indy.ui.sql.editors.export.IExporter;
import com.indy.ui.sql.internal.IConstant;
import java.io.File;
import java.io.PrintStream;

public class ExporterCSV
implements IExporter {
    @Override
    public String[] getFileFilter() {
        return IConstant.CSV_EXPORT_DIALOG_FILE_EXTENSIONS;
    }

    @Override
    public void export(IResultModel data, ExportOptions options, File file) throws Exception {
        Throwable throwable = null;
        Object var5_6 = null;
        try (PrintStream writer = new PrintStream(file, options.getCharacterSet());){
            String val;
            String lineSeparator = System.getProperty("line.separator");
            String columnSeparator = options.getColumnSeparator();
            boolean includeColumnNames = options.isIncludeColumnNames();
            boolean quote = options.isQuote();
            String nullValue = options.getNullValue();
            StringBuilder sb = new StringBuilder();
            if (includeColumnNames) {
                int i = 0;
                while (i < data.getColumnNumber()) {
                    IResultModel.Column col = data.getColumn(i);
                    val = col.getCaption();
                    sb.append(val);
                    if (i < data.getColumnNumber() - 1) {
                        sb.append(columnSeparator);
                    }
                    ++i;
                }
                sb.append(lineSeparator);
            }
            IResultModel.Row[] rowArray = data.getRows();
            int n = rowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResultModel.Row r = rowArray[n2];
                int i = 0;
                while (i < data.getColumnNumber()) {
                    val = data.getColumn(i).getDisplayValue(r.getColumnValue(i));
                    String string = val = "<null>".equals(val) ? nullValue : val;
                    if (quote) {
                        sb.append(this.quote(val));
                    } else {
                        sb.append(val);
                    }
                    if (i < data.getColumnNumber() - 1) {
                        sb.append(columnSeparator);
                    }
                    ++i;
                }
                sb.append(lineSeparator);
                ++n2;
            }
            writer.print(sb.toString());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String quote(String input) {
        return "\"" + input.replaceAll("\"", "\"\"") + "\"";
    }
}

