/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.internal;

import com.indy.ui.sql.IResultModel;
import com.indy.ui.sql.internal.IConstant;
import java.math.RoundingMode;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.Format;

public class ColumnBuilder {
    ResultSetMetaData rsmd;

    public static ColumnBuilder of(ResultSetMetaData rsmd) {
        return new ColumnBuilder(rsmd);
    }

    private ColumnBuilder(ResultSetMetaData rsmd) {
        this.rsmd = rsmd;
    }

    private Format getDateFormat(int type) {
        switch (type) {
            case 91: {
                return IConstant.FORMAT_DATE;
            }
            case 92: 
            case 2013: {
                return IConstant.FORMAT_TIME;
            }
            case 93: 
            case 2014: {
                return IConstant.FORMAT_DATETIME;
            }
        }
        return null;
    }

    public IResultModel.Column[] buildColumns() throws SQLException {
        IResultModel.Column[] columns = new IResultModel.Column[this.rsmd.getColumnCount()];
        int i = 0;
        while (i < this.rsmd.getColumnCount()) {
            int colIndex = i + 1;
            int type = this.rsmd.getColumnType(colIndex);
            String columnName = this.rsmd.getColumnLabel(colIndex);
            IResultModel.Column column = null;
            switch (DataType.fromJDBCDataType(type)) {
                case DECIMAL: {
                    column = this.createDecimalColumn(colIndex, type, columnName, i);
                    break;
                }
                case DATE: {
                    column = this.createDateColumn(colIndex, type, columnName, i);
                    break;
                }
                case NATURAL: {
                    column = this.createNaturalColumn(colIndex, columnName, i);
                    break;
                }
                default: {
                    column = this.createDefaultColumn(colIndex, columnName, i);
                }
            }
            columns[i] = column;
            ++i;
        }
        return columns;
    }

    private IResultModel.Column createDefaultColumn(int colIndex, String label, int columnPosition) throws SQLException {
        return new IResultModel.Column(this.rsmd.getColumnDisplaySize(colIndex), label, columnPosition, false);
    }

    private IResultModel.Column createNaturalColumn(int colIndex, String label, int columnPosition) throws SQLException {
        return new IResultModel.Column(this.rsmd.getColumnDisplaySize(colIndex), label, columnPosition, true);
    }

    private IResultModel.Column createDateColumn(int colIndex, int type, String columnName, int columnPosition) throws SQLException {
        return new ColumnWithFormat(this.rsmd.getColumnDisplaySize(colIndex), columnName, columnPosition, true, this.getDateFormat(type));
    }

    private IResultModel.Column createDecimalColumn(int colIndex, int type, String columnName, int columnPosition) throws SQLException {
        DecimalFormat df;
        int scale;
        ColumnWithFormat column = null;
        int precision = this.rsmd.getPrecision(colIndex);
        int maxScale = 10;
        boolean shouldTrim = true;
        int n = scale = maxScale > this.rsmd.getScale(colIndex) || maxScale == 0 ? maxScale : this.rsmd.getScale(colIndex);
        if (precision < 1) {
            df = new DecimalFormat("#.#");
            df.setRoundingMode(RoundingMode.DOWN);
            column = new ColumnWithFormat(this.rsmd.getColumnDisplaySize(colIndex), columnName, columnPosition, true, df);
        }
        if (scale == 0 && (type == 8 || type == 6 || type == 7)) {
            df = new DecimalFormat("#.#");
            df.setRoundingMode(RoundingMode.DOWN);
            column = new ColumnWithFormat(this.rsmd.getColumnDisplaySize(colIndex), columnName, columnPosition, true, df);
        }
        char zeroWildcard = shouldTrim ? (char)'#' : '0';
        StringBuilder sb = new StringBuilder(precision + scale + 2);
        int j = 0;
        while (j <= precision) {
            sb.append(zeroWildcard);
            ++j;
        }
        if (scale > 0) {
            j = 0;
            while (j <= scale) {
                sb.append(zeroWildcard);
                ++j;
            }
        }
        if (scale > 0) {
            sb.insert(precision + 2, '.');
        } else if (scale <= 0) {
            sb.insert(1, '.');
        }
        DecimalFormat df2 = new DecimalFormat(sb.toString());
        df2.setRoundingMode(RoundingMode.DOWN);
        column = new ColumnWithFormat(this.rsmd.getColumnDisplaySize(colIndex), columnName, columnPosition, true, df2);
        return column;
    }

    private class ColumnWithFormat
    extends IResultModel.Column {
        private Format format;

        public ColumnWithFormat(int displaySize, String caption, int columnIndex, boolean justifyRight, Format format) {
            super(displaySize, caption, columnIndex, justifyRight);
            this.format = format;
        }

        @Override
        public String getDisplayValue(Object value) {
            if (value != null) {
                return this.format.format(value);
            }
            return super.getDisplayValue(value);
        }
    }

    static enum DataType {
        NATURAL,
        DECIMAL,
        DATE,
        BINARY,
        CHARACTER,
        OTHER;


        static DataType fromJDBCDataType(int jdbcDataType) {
            switch (jdbcDataType) {
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    return DECIMAL;
                }
                case 91: 
                case 92: 
                case 93: {
                    return DATE;
                }
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    return NATURAL;
                }
                case -4: 
                case 2004: {
                    return BINARY;
                }
                case -16: 
                case -1: 
                case 2005: {
                    return OTHER;
                }
            }
            return OTHER;
        }
    }
}

