/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.internal;

import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.ui.custom.out.services.IExternalValueResolver;
import com.indy.ui.sql.IConnectionProvider;
import com.indy.ui.sql.internal.Activator;
import com.indy.ui.sql.internal.Messages;
import com.semarchy.xdi.designer.core.services.IModuleClassLoaderProvider;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import com.stambia.md.Configuration;
import com.stambia.md.MdNode;
import com.stambia.md.custom.Util;
import com.stambia.md.util.MdAttributeNativeEvaluator;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={IConnectionProvider.class}, reference={@Reference(name="IExternalValueResolver", service=IExternalValueResolver.class, policy=ReferencePolicy.DYNAMIC)})
public class ConnectionManager
implements IConnectionProvider {
    private static Logger logger = LogManager.getLogger(ConnectionManager.class);
    public static final String REF_EXTERNALVALUERESOLVER = "IExternalValueResolver";
    private Map<String, ClassLoader> moduleCLmap = new HashMap<String, ClassLoader>();
    private Map<String, Map<String, Driver>> loadedDrivers = new HashMap<String, Map<String, Driver>>();
    @Reference
    private IModuleClassLoaderProvider clProvider;
    private ComponentContext context;

    @Activate
    public void activate(ComponentContext context) {
        this.context = context;
    }

    @Deactivate
    public void deactivate() {
        this.context = null;
    }

    /*
     * Unable to fully structure code
     */
    private ConnectionDescriptor createConnectionDescriptor(MdNode server) {
        block32: {
            block31: {
                block33: {
                    block30: {
                        r = new ConnectionDescriptor();
                        driver = ConnectionManager.getValue((Configuration)server, "INTERNAL_JDBC_DRIVER", "@driver");
                        isFileDriver = false;
                        if (driver == null) {
                            try {
                                if (server.getDefType().equals("com.stambia.file.server")) {
                                    driver = "com.stambia.jdbc.driver.file.FileDriver";
                                    isFileDriver = true;
                                } else {
                                    driver = server.evaluateMdString("ancestor::product/driver[@default='true']/@class");
                                }
                            }
                            catch (XPathExpressionException e) {
                                if (!ConnectionManager.logger.isDebugEnabled()) break block30;
                                ConnectionManager.logger.error("Failed to create connexion descriptor on {}", (Object)EcoreUtil.getURI((EObject)server), (Object)e);
                            }
                        }
                    }
                    r.driverClassName = driver;
                    r.module = ConnectionManager.getValue((Configuration)server, "INTERNAL_MODULE", "@module");
                    r.password = ConnectionManager.getValue((Configuration)server, "INTERNAL_JDBC_PASSWORD", "@password");
                    r.url = ConnectionManager.getValue((Configuration)server, "INTERNAL_JDBC_URL", "@url");
                    if (r.url == null && isFileDriver) {
                        r.url = "jdbc:semarchy:file";
                    }
                    r.userName = ConnectionManager.getValue((Configuration)server, "INTERNAL_JDBC_USER", "@user");
                    try {
                        if (r.password != null && !r.password.isEmpty()) {
                            semaphoreManager = new SemaphoreManagerI();
                            semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                            r.password = decrypt = semaphoreManager.getStringAsciiInfo(r.password);
                        }
                    }
                    catch (OtherExceptionI e) {
                        e.printStackTrace();
                    }
                    propertiesHandledByXpath = false;
                    try {
                        try {
                            expr = Util.findXpathExpressions((Configuration)server, (String)"INTERNAL_PROPERTIES_REF");
                            if (expr != null) {
                                o = server.evaluateXpathExpressionMdSet("INTERNAL_PROPERTIES_REF");
                                if (o instanceof Collection) {
                                    propertiesHandledByXpath = true;
                                    for (E i : (Collection)o) {
                                        if (!(i instanceof MdNode)) continue;
                                        value = MdAttributeNativeEvaluator.readAttribute((String)"value", (MdNode)((MdNode)i), null);
                                        r.properties.put(((MdNode)i).getName(), value);
                                    }
                                } else {
                                    this.log("xPathExpression INTERNAL_PROPERTIES_REF does not return a collection, the xPathExpression is ignored", null);
                                }
                            }
                            break block31;
                        }
                        catch (Throwable t) {
                            this.log(Messages.ConnectionManager_1, null);
                            if (propertiesHandledByXpath) break block32;
                            ** for (node : server.getNodeByCode((String)"com.stambia.rdbms.property"))
                        }
                    }
                    catch (Throwable var11_28) {
                        if (propertiesHandledByXpath) break block33;
                        ** for (node : server.getNodeByCode((String)"com.stambia.rdbms.property"))
                    }
lbl-1000:
                    // 1 sources

                    {
                        value = null;
                        try {
                            value = MdAttributeNativeEvaluator.readAttribute((String)"value", (MdNode)node, null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (value == null || value.isEmpty()) continue;
                        r.properties.put(node.getName(), value);
                        continue;
lbl63:
                        // 1 sources

                        break block32;
                    }
lbl-1000:
                    // 1 sources

                    {
                        value = null;
                        try {
                            value = MdAttributeNativeEvaluator.readAttribute((String)"value", (MdNode)node, null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (value == null || value.isEmpty()) continue;
                        r.properties.put(node.getName(), value);
                        continue;
                    }
                }
                throw var11_28;
            }
            if (!propertiesHandledByXpath) {
                for (MdNode node : server.getNodeByCode("com.stambia.rdbms.property")) {
                    value = null;
                    try {
                        value = MdAttributeNativeEvaluator.readAttribute((String)"value", (MdNode)node, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (value == null || value.isEmpty()) continue;
                    r.properties.put(node.getName(), value);
                }
            }
        }
        try {
            expr = Util.findXpathExpressions((Configuration)server, (String)"INTERNAL_EXTRA_PROPERTIES");
            if (expr != null && (s = server.evaluateXpathExpression("INTERNAL_EXTRA_PROPERTIES")) != null && !s.isEmpty()) {
                extra = new Properties();
                extra.load(new StringReader(s));
                r.properties.putAll((Map<?, ?>)extra);
            }
        }
        catch (Throwable t) {
            this.log("Failed to evaluate INTERNAL_EXTRA_PROPERTIES", t);
        }
        return r;
    }

    private static String getValue(Configuration node, String internalXpath, String xpath) {
        String value;
        block7: {
            try {
                value = null;
                try {
                    value = node.evaluate(xpath);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (internalXpath != null && !internalXpath.isEmpty() && (value == null || value.isEmpty())) {
                    value = node.evaluateXpathExpression(internalXpath);
                }
                if (value == null || !value.isEmpty()) break block7;
                return null;
            }
            catch (XPathExpressionException e) {
                if (logger.isDebugEnabled()) {
                    logger.error((Object)e);
                }
                return null;
            }
        }
        return value;
    }

    @Override
    public IConnectionProvider.IConnectionDescriptor getConnectionDescriptor(MdNode serverNode) {
        ConnectionDescriptor infos = this.createConnectionDescriptor(serverNode);
        return infos;
    }

    private Connection doConnect(Driver driver, String url, Properties props) throws Exception {
        return driver.connect(url, props);
    }

    @Override
    public Connection createJDBCConnection(final IConnectionProvider.IConnectionDescriptor infos) throws Exception {
        final IExternalValueResolver resolver = this.getResolver();
        boolean propsNeedResolution = this.needResolutionInfosProps(infos.getProperties(), resolver);
        if (resolver.needResolution(new String[]{infos.getModule(), infos.getDriverClassName(), infos.getUrl(), infos.getUsername(), infos.getPassword()}) || propsNeedResolution) {
            return (Connection)resolver.executeSecured((IExternalValueResolver.SecuredRunnerWithResut)new IExternalValueResolver.SecuredRunnerWithResut<Connection>(){

                public Connection runWithResult() throws Exception {
                    IConnectionProvider.IConnectionDescriptor resolvedInfos = ConnectionManager.this.getResolvedInfos(infos, resolver);
                    return ConnectionManager.this.createConnection(resolvedInfos);
                }

                public Exception getFailure() {
                    return new SQLException(Messages.ConnectionManager_4);
                }
            });
        }
        return this.createConnection(infos);
    }

    private boolean needResolutionInfosProps(Properties props, IExternalValueResolver resolver) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (!resolver.needResolution(new String[]{(String)entry.getValue()})) continue;
            return true;
        }
        return false;
    }

    protected IConnectionProvider.IConnectionDescriptor getResolvedInfos(IConnectionProvider.IConnectionDescriptor infos, IExternalValueResolver resolver) throws Exception {
        ConnectionDescriptor resolved = new ConnectionDescriptor();
        resolved.driverClassName = resolver.resolve(infos.getDriverClassName());
        resolved.module = resolver.resolve(infos.getModule());
        resolved.url = resolver.resolve(infos.getUrl());
        resolved.userName = resolver.resolve(infos.getUsername());
        resolved.password = resolver.resolve(infos.getPassword());
        resolved.properties = this.getResolvedInfosProperties(infos.getProperties(), resolver);
        return resolved;
    }

    private Properties getResolvedInfosProperties(Properties props, IExternalValueResolver resolver) throws Exception {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            if (!resolver.needResolution(new String[]{(String)entry.getValue()})) continue;
            props.replace(entry.getKey(), resolver.resolve((String)entry.getValue()));
        }
        return props;
    }

    private Connection createConnection(final IConnectionProvider.IConnectionDescriptor infos) throws Exception, IModuleClassLoaderProvider.ModuleServiceException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        AtomicReference<Driver> driverRef;
        ClassLoader cl = null;
        cl = this.clProvider.getClassLoader(((BundleWiring)Activator.getInstance().getBundle().adapt(BundleWiring.class)).getClassLoader(), infos.getModule(), new IModuleClassLoaderProvider.ClassLoaderValidator(){

            public void checkClassLoader(ClassLoader toValidate) throws Exception {
                toValidate.loadClass(infos.getDriverClassName());
            }
        });
        ClassLoader old = this.moduleCLmap.put(infos.getModule(), cl);
        boolean clModified = old != cl;
        Map<String, Driver> drivers = this.loadedDrivers.get(infos.getModule());
        if (drivers == null) {
            drivers = new HashMap<String, Driver>();
            this.loadedDrivers.put(infos.getModule(), drivers);
        }
        if (clModified) {
            drivers.clear();
        }
        if ((driverRef = new AtomicReference<Driver>(drivers.get(infos.getDriverClassName()))).get() == null) {
            Class<?> driverCls = cl.loadClass(infos.getDriverClassName());
            driverRef.set((Driver)driverCls.newInstance());
            drivers.put(infos.getDriverClassName(), driverRef.get());
        }
        Properties props = new Properties();
        if (infos.getUsername() != null && !infos.getUsername().isEmpty()) {
            props.setProperty("user", infos.getUsername());
        }
        if (infos.getPassword() != null && !infos.getPassword().isEmpty()) {
            props.setProperty("password", infos.getPassword());
        }
        props.putAll((Map<?, ?>)infos.getProperties());
        return this.doConnect(driverRef.get(), infos.getUrl(), props);
    }

    private void log(String message, Throwable t) {
        StatusManager.getManager().handle((IStatus)new Status(2, "com.indy.ui.sql", message, t), 1);
    }

    protected IExternalValueResolver getResolver() throws Exception {
        IExternalValueResolver r = (IExternalValueResolver)this.context.locateService(REF_EXTERNALVALUERESOLVER);
        return r;
    }

    class ConnectionDescriptor
    implements IConnectionProvider.IConnectionDescriptor {
        private String userName;
        private String password;
        private String url;
        private String driverClassName;
        private String module;
        private Properties properties = new Properties();

        ConnectionDescriptor() {
        }

        @Override
        public String getUsername() {
            return this.userName;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        @Override
        public String getUrl() {
            return this.url;
        }

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public String getDriverClassName() {
            return this.driverClassName;
        }

        @Override
        public String getModule() {
            return this.module;
        }
    }
}

