/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.sql.internal;

import com.indy.ui.sql.IResultModel;
import com.indy.ui.sql.internal.ColumnBuilder;
import com.indy.ui.sql.internal.RowBuilder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class QueryResult
implements IResultModel {
    private IResultModel.Column[] columns;
    private IResultModel.Row[] rows;
    private int maxRows;
    private int updateCount;
    private ErrorStatusImpl errorStatus = null;
    private long executionTime;

    public QueryResult(ResultSet rs, int maxRows) throws SQLException {
        this.maxRows = maxRows;
        this.createColumns(rs);
        this.creatContent(rs);
    }

    public QueryResult(int updateCount) throws SQLException {
        this.updateCount = updateCount;
        this.columns = null;
        this.rows = new IResultModel.Row[0];
    }

    public QueryResult(String executedSQL, Throwable err) {
        this.errorStatus = new ErrorStatusImpl();
        this.errorStatus.ex = err;
        this.errorStatus.sql = executedSQL;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    @Override
    public long getExecutionTime() {
        return this.executionTime;
    }

    private void createColumns(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        this.columns = ColumnBuilder.of(rsmd).buildColumns();
    }

    private void creatContent(ResultSet rs) throws SQLException {
        this.rows = RowBuilder.of(rs).buildRows(this.maxRows);
    }

    @Override
    public IResultModel.Column getColumn(int columnIndex) {
        return this.columns[columnIndex];
    }

    @Override
    public int getColumnNumber() {
        return this.columns == null ? 0 : this.columns.length;
    }

    @Override
    public int getRowNumber() {
        return this.rows == null ? 0 : this.rows.length;
    }

    @Override
    public IResultModel.Row[] getRows() {
        return this.rows;
    }

    @Override
    public int getUpdateCount() {
        return this.updateCount;
    }

    @Override
    public IResultModel.ErrorStatus getErrorStatus() {
        return this.errorStatus;
    }

    private class ErrorStatusImpl
    implements IResultModel.ErrorStatus {
        private String sql;
        private Throwable ex;

        private ErrorStatusImpl() {
        }

        @Override
        public String getSQL() {
            return this.sql;
        }

        @Override
        public String getMessage() {
            return this.ex.getMessage();
        }

        @Override
        public String getSQLState() {
            return this.ex instanceof SQLException ? ((SQLException)this.ex).getSQLState() : "";
        }

        @Override
        public int getSQLCode() {
            return this.ex instanceof SQLException ? ((SQLException)this.ex).getErrorCode() : -1;
        }

        @Override
        public Throwable getException() {
            return this.ex;
        }
    }
}

