/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.xml;

import com.indy.addons.Messages;
import com.indy.addons.xml.XmlTrimmDTDParser;
import com.indy.jdbc.editor.Activator;
import com.indy.runtime.json.JsonUtils;
import com.indy.runtime.json.JsonXmlEventReader;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdNode;
import com.stambia.md.MdRootNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.util.MdFactoryHelper;
import com.thaiopensource.relaxng.translate.Driver;
import com.thaiopensource.xml.sax.ErrorHandlerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXParseException;

public class XmlUtil {
    public static boolean forceOriginalType = true;
    private static final org.apache.logging.log4j.Logger LOGGER = LogManager.getLogger(XmlUtil.class);
    static XmlUtil INSTANCE = new XmlUtil();
    static Map<String, String> nameSpaceCache;
    static HashMap<String, XSDTypeDefinition> loadAllType;
    static Map<XSDTypeDefinition, String> soapArray;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int xmlToXsd(String xmlFilePath, String xsdFilePath, String encoding, boolean isJsonFormat, JsonXmlEventReader.ArrayMode mode) throws Exception {
        File temp = null;
        String inputFileName = xmlFilePath;
        try {
            block23: {
                if (isJsonFormat) {
                    temp = File.createTempFile("temp", "json.xml", new File(xmlFilePath).getParentFile());
                    Throwable throwable = null;
                    Object var8_9 = null;
                    try {
                        FileInputStream is = new FileInputStream(xmlFilePath);
                        try {
                            try (FileOutputStream os = new FileOutputStream(temp);){
                                JsonUtils.convertJsonToXml((InputStream)is, (OutputStream)os, (String)encoding, (String)encoding, (boolean)true);
                                temp.deleteOnExit();
                                inputFileName = temp.getAbsolutePath();
                            }
                            if (is == null) break block23;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (is == null) throw throwable;
                            ((InputStream)is).close();
                            throw throwable;
                        }
                        ((InputStream)is).close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
            }
            CustomErrorHandler eh = new CustomErrorHandler();
            String[] args = null;
            args = encoding == null || encoding.trim().isEmpty() ? new String[]{"-I", "xml", "-O", "xsd", inputFileName, xsdFilePath} : new String[]{"-I", "xml", "-O", "xsd", "-i", "encoding=" + encoding, inputFileName, xsdFilePath};
            int ret = new Driver((ErrorHandlerImpl)eh).run(args);
            if (ret != 0) {
                try {
                    eh.checkErrors();
                }
                catch (XmlTrimmDTDParser.AccessResourceException ex) {
                    if (isJsonFormat) throw (IOException)ex.getCause();
                    XmlTrimmDTDParser dtdTrimmer = new XmlTrimmDTDParser();
                    try {
                        ret = dtdTrimmer.handleAccessResourceException(ex, args, args.length == 6 ? 4 : 6, encoding);
                    }
                    catch (Exception ex2) {
                        throw (IOException)ex.getCause();
                    }
                }
            }
            int n = ret;
            return n;
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    private static Resource loadResource(URI uri, String extension, ResourceSet rs) throws IOException {
        Resource.Factory resourceFactory = rs.getResourceFactoryRegistry().getFactory(URI.createFileURI((String)("foo." + extension)), null);
        Resource r = resourceFactory.createResource(uri);
        rs.getResources().add((Object)r);
        r.load(rs.getLoadOptions());
        return r;
    }

    public static List<String> getRootElementName(String xsdPath) throws IOException, URISyntaxException {
        ArrayList<String> result = new ArrayList<String>();
        ResourceSetImpl rs = new ResourceSetImpl();
        URI uri = XmlUtil.getURI(xsdPath);
        Resource r = XmlUtil.loadResource(uri, "xsd", (ResourceSet)rs);
        EcoreUtil.resolveAll((ResourceSet)rs);
        XSDSchema schem = ((XSDResourceImpl)r).getSchema();
        XmlUtil.getRootElementName(schem, result, new HashSet<XSDSchema>());
        return result;
    }

    public static void getRootElementName(XSDSchema schem, List<String> list, Set<XSDSchema> set) {
        if (!set.contains(schem)) {
            set.add(schem);
            for (XSDSchemaContent o : schem.getContents()) {
                XSDImportImpl x;
                XSDSchema c1;
                if (o instanceof XSDElementDeclaration) {
                    XSDElementDeclaration xsdElt = (XSDElementDeclaration)o;
                    list.add(xsdElt.getName());
                    continue;
                }
                if (!(o instanceof XSDImportImpl) || (c1 = (x = (XSDImportImpl)o).importSchema()) == null) continue;
                XmlUtil.getRootElementName(c1, list, set);
            }
        }
    }

    public static String reverseNameSpace(XSDSchema xsdSchema, MdNode node) {
        XSDForm attributeForm;
        XSDForm elementForm;
        Map namespaces = xsdSchema.getQNamePrefixToNamespaceMap();
        XmlUtil.addNamespaces(node, namespaces, true);
        EList list = xsdSchema.getContents();
        if (list != null && !list.isEmpty() && list.get(0) instanceof XSDImport) {
            for (XSDSchemaContent xsdsc : list) {
                XSDImportImpl imp;
                XSDSchema o;
                if (!(xsdsc instanceof XSDImport) || (o = (imp = (XSDImportImpl)xsdSchema.getContents().get(0)).getResolvedSchema()) == null) continue;
                XmlUtil.addNamespaces(node, o.getQNamePrefixToNamespaceMap(), true);
            }
        }
        if ((elementForm = xsdSchema.getElementFormDefault()) != null) {
            if (elementForm == XSDForm.QUALIFIED_LITERAL) {
                node.setAttribute("prefixForElement", "qualified", false);
            } else if (elementForm == XSDForm.UNQUALIFIED_LITERAL) {
                node.setAttribute("prefixForElement", "unqualified", false);
            }
        }
        if ((attributeForm = xsdSchema.getAttributeFormDefault()) != null) {
            if (attributeForm == XSDForm.QUALIFIED_LITERAL) {
                node.setAttribute("prefixForAttribute", "qualified", false);
            } else if (attributeForm == XSDForm.UNQUALIFIED_LITERAL) {
                node.setAttribute("prefixForAttribute", "unqualified", false);
            }
        }
        return xsdSchema.getTargetNamespace();
    }

    public static MdNode reverse(InputStream xsdStream, MdNode root, int depth, boolean reverseFixedAttributes) throws IOException, XPathExpressionException {
        XmlUtil.initNamesapce(root);
        XSDSchema xsdSchema = null;
        MdNode result = null;
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource.Factory resourceFactory = resourceSet.getResourceFactoryRegistry().getFactory(URI.createFileURI((String)"foo.xsd"), null);
        XSDResourceImpl xsdMainResource = (XSDResourceImpl)resourceFactory.createResource(URI.createFileURI((String)"foo.xsd"));
        resourceSet.getResources().add((Object)xsdMainResource);
        xsdMainResource.load(xsdStream, resourceSet.getLoadOptions());
        xsdSchema = xsdMainResource.getSchema();
        if (xsdSchema.eContents().isEmpty()) {
            XmlUtil.end();
            return null;
        }
        XmlUtil.getRootElementName(xsdSchema, new ArrayList<String>(), new HashSet<XSDSchema>());
        for (Resource resource : resourceSet.getResources()) {
            if (!(resource instanceof XSDResourceImpl)) continue;
            XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
            xsdSchema = xsdResource.getSchema();
            for (XSDSchemaContent o : xsdSchema.getContents()) {
                if (!(o instanceof XSDElementDeclaration)) continue;
                XSDElementDeclaration xsdElt = (XSDElementDeclaration)o;
                result = root.copy(0);
                result.setSubstituteContainer(root.getSubstituteContainer());
                String targetNamespace = XmlUtil.reverseNameSpace(xsdSchema, result);
                result.setAttribute("targetNamespace", targetNamespace, false);
                XmlUtil.reverseConcreteElement(result, (XSDConcreteComponent)xsdElt, 0, targetNamespace, new HashMap<XSDComplexTypeDefinition, Integer>(), depth, reverseFixedAttributes, null);
            }
        }
        XmlUtil.end();
        return result;
    }

    public static MdNode reverse(String xsdPath, String rootName, MdNode root, int depth, boolean reverseFixedAttributes, boolean performIncrementalReverse) throws IOException, URISyntaxException, XPathExpressionException {
        XmlUtil.initNamesapce(root);
        XSDSchema xsdSchema = null;
        MdNode result = null;
        URI uri = XmlUtil.getURI(xsdPath);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        XSDResourceImpl xsdMainResource = (XSDResourceImpl)XmlUtil.loadResource(uri, "xsd", (ResourceSet)resourceSet);
        xsdSchema = xsdMainResource.getSchema();
        XmlUtil.getRootElementName(xsdSchema, new ArrayList<String>(), new HashSet<XSDSchema>());
        for (Resource resource : resourceSet.getResources()) {
            if (!(resource instanceof XSDResourceImpl)) continue;
            XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
            xsdSchema = xsdResource.getSchema();
            for (XSDSchemaContent o : xsdSchema.getContents()) {
                XSDElementDeclaration xsdElt;
                if (!(o instanceof XSDElementDeclaration) || !(xsdElt = (XSDElementDeclaration)o).getName().equals(rootName)) continue;
                result = root.copy(0);
                result.setSubstituteContainer(root.getSubstituteContainer());
                String targetNamespace = XmlUtil.reverseNameSpace(xsdSchema, result);
                result.setAttribute("targetNamespace", targetNamespace, false);
                XmlUtil.reverseConcreteElement(result, (XSDConcreteComponent)xsdElt, 0, targetNamespace, new HashMap<XSDComplexTypeDefinition, Integer>(), depth, reverseFixedAttributes, null);
            }
        }
        XmlUtil.end();
        return result;
    }

    public static XSDTypeDefinition getFirstXSDTypeDefinition1(XSDTypeDefinition type) {
        if (type.getTargetNamespace() == null || !type.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema")) {
            XSDTypeDefinition type2 = type.getBaseType();
            if (type2 != null && !type2.getName().equals("anySimpleType") && !type2.getName().equals("anyType")) {
                return XmlUtil.getFirstXSDTypeDefinition1(type.getBaseType());
            }
            return null;
        }
        return type;
    }

    public static XSDTypeDefinition getFirstXSDTypeDefinition2(XSDTypeDefinition type) {
        return XmlUtil.getFirstXSDTypeDefinition1(type);
    }

    private static void findAllContents(List list, XSDTypeDefinition type) {
        if (type != null) {
            list.removeAll((Collection<?>)type.eContents());
            list.addAll(type.eContents());
            if (type.getBaseType() != null && type.getBaseType() != type) {
                XmlUtil.findAllContents(list, type.getBaseType());
            }
        }
    }

    private static void findHierarchy(List list, XSDTypeDefinition type) {
        if (type != null) {
            list.add(type);
            if (type.getBaseType() != null && type.getBaseType() != type) {
                XmlUtil.findHierarchy(list, type.getBaseType());
            }
        }
    }

    public static MdNode reverseConcreteElement(MdNode parent, XSDConcreteComponent concrete, int position, String targetNamespace, Map<XSDComplexTypeDefinition, Integer> currentComplexDef, int depth, boolean reverseFixedAttributes, Map<String, XSDSchema> schemaPerNamespace) {
        MdNode result;
        Object children;
        block65: {
            XSDTypeDefinition type;
            XSDParticle particle;
            block63: {
                block64: {
                    String namespace;
                    children = new ArrayList();
                    result = null;
                    particle = null;
                    if (concrete instanceof XSDParticle) {
                        particle = (XSDParticle)concrete;
                        concrete = ((XSDParticle)concrete).getTerm();
                    }
                    String name = soapArray.get(concrete);
                    if (concrete != null && name != null) {
                        result = MdFactoryHelper.createMdNode((String)"com.stambia.xml.all");
                        if (parent != null) {
                            parent.getNode().add((Object)result);
                        }
                        parent = result;
                        result.setPosition(new BigInteger("-10"));
                        result.setAttribute("minOccurs", "0", false);
                        result.setAttribute("maxOccurs", "1", false);
                        result = MdFactoryHelper.createMdNode((String)"com.stambia.xml.element");
                        result.setName(name);
                        soapArray.remove(concrete);
                        if (parent != null) {
                            parent.getNode().add((Object)result);
                        }
                        result.setAttribute("minOccurs", "0", false);
                        result.setAttribute("maxOccurs", "-1", false);
                        XSDTypeDefinition type2 = XmlUtil.getFirstXSDTypeDefinition1((XSDTypeDefinition)concrete);
                        if (type2 != null) {
                            result.setAttribute("type", type2.getName(), false);
                        }
                        result.setAttribute("isNillable", "true", false);
                        if (forceOriginalType || concrete != type2) {
                            XmlUtil.setOriginalType(result, (XSDTypeDefinition)concrete);
                        }
                    }
                    Object additionalDefinition = null;
                    if (!(concrete instanceof XSDElementDeclaration)) break block63;
                    result = parent.getDefType().equals("com.stambia.xml.xsd") ? MdFactoryHelper.createMdNode((String)"com.stambia.xml.root") : MdFactoryHelper.createMdNode((String)"com.stambia.xml.element");
                    if (((XSDElementDeclaration)concrete).getName() != null) {
                        result.setName(((XSDElementDeclaration)concrete).getName());
                    }
                    XSDTypeDefinition o1 = ((XSDElementDeclaration)concrete).getTypeDefinition();
                    if (schemaPerNamespace != null && o1 instanceof XSDSimpleTypeDefinition) {
                        namespace = ((XSDSimpleTypeDefinition)o1).getTargetNamespace();
                        String string = ((XSDSimpleTypeDefinition)o1).getName();
                        XSDSchema schem = schemaPerNamespace.get(namespace);
                        if (schem != null && namespace != null && string != null) {
                            for (XSDTypeDefinition t : schem.getTypeDefinitions()) {
                                if (!t.getName().equals(string)) continue;
                                o1 = t;
                                break;
                            }
                        }
                    }
                    if (parent != null) {
                        parent.getNode().add((Object)result);
                        XmlUtil.reverseAnnotation(concrete, result);
                        if (((XSDElementDeclaration)concrete).isSetNillable()) {
                            result.setAttribute("isNillable", String.valueOf(((XSDElementDeclaration)concrete).isNillable()), false);
                        }
                        namespace = ((XSDElementDeclaration)concrete).getTargetNamespace();
                        if (targetNamespace != null && namespace != null && !targetNamespace.equals(namespace)) {
                            result.setAttribute("namespace", namespace, false);
                        }
                        if (particle != null) {
                            result.setAttribute("minOccurs", new Integer(particle.getMinOccurs()).toString(), false);
                            result.setAttribute("maxOccurs", new Integer(particle.getMaxOccurs()).toString(), false);
                        }
                    }
                    if (o1 instanceof XSDSimpleTypeDefinition) {
                        type = XmlUtil.getFirstXSDTypeDefinition1((XSDTypeDefinition)((XSDSimpleTypeDefinition)o1));
                        if (type != null) {
                            String string = type.getName();
                            result.setAttribute("type", string, false);
                        }
                        if (forceOriginalType || o1 != type) {
                            XmlUtil.setOriginalType(result, (XSDTypeDefinition)((XSDSimpleTypeDefinition)o1));
                        }
                    }
                    if (!((concrete = o1) instanceof XSDComplexTypeDefinition)) break block64;
                    type = XmlUtil.getFirstXSDTypeDefinition1((XSDTypeDefinition)((XSDComplexTypeDefinition)o1));
                    if (type != null && type != concrete && !(type instanceof XSDComplexTypeDefinition)) {
                        String string = type.getName();
                        result.setAttribute("type", string, false);
                    }
                    if (forceOriginalType || o1 != type) {
                        XmlUtil.setOriginalType(result, (XSDTypeDefinition)((XSDComplexTypeDefinition)o1));
                    }
                    children = new ArrayList();
                    switch (XmlUtil.getReverseVersion(parent)) {
                        case NONE: {
                            if (concrete instanceof XSDComplexTypeDefinition) {
                                XmlUtil.findAllContents((List)children, (XSDTypeDefinition)((XSDComplexTypeDefinition)concrete));
                                children.removeAll((Collection<?>)((XSDComplexTypeDefinition)concrete).getAttributeUses());
                                children.addAll(((XSDComplexTypeDefinition)concrete).getAttributeUses());
                                break;
                            }
                            break block65;
                        }
                        default: {
                            ArrayList arrayList = new ArrayList();
                            if (concrete instanceof XSDComplexTypeDefinition) {
                                XmlUtil.findHierarchy(arrayList, (XSDTypeDefinition)((XSDComplexTypeDefinition)concrete));
                                ArrayList attributes = new ArrayList();
                                int k = arrayList.size() - 1;
                                while (k >= 0) {
                                    XSDTypeDefinition _type = (XSDTypeDefinition)arrayList.get(k);
                                    children.addAll(_type.eContents());
                                    if (_type instanceof XSDComplexTypeDefinition) {
                                        children.removeAll((Collection<?>)((XSDComplexTypeDefinition)_type).getAttributeContents());
                                        attributes.addAll(((XSDComplexTypeDefinition)_type).getAttributeContents());
                                    }
                                    --k;
                                }
                                children.addAll(0, attributes);
                                break;
                            }
                            break block65;
                        }
                    }
                    break block65;
                }
                children = concrete == null ? new ArrayList() : concrete.eContents();
                break block65;
            }
            if (concrete instanceof XSDComplexTypeDefinition) {
                if (result == null) {
                    result = parent;
                }
                XmlUtil.findAllContents(children, (XSDTypeDefinition)((XSDComplexTypeDefinition)concrete));
                children.removeAll((Collection<?>)((XSDComplexTypeDefinition)concrete).getAttributeUses());
                children.addAll(((XSDComplexTypeDefinition)concrete).getAttributeUses());
            } else if (!(concrete instanceof XSDParticle)) {
                if (concrete instanceof XSDModelGroup && concrete.eContents().size() > 0 && (((EObject)concrete.eContents().get(0)).eContents().size() <= 0 || !(((EObject)concrete.eContents().get(0)).eContents().get(0) instanceof XSDWildcard))) {
                    if (((XSDModelGroup)concrete).getCompositor().equals((Object)XSDCompositor.SEQUENCE_LITERAL)) {
                        result = MdFactoryHelper.createMdNode((String)"com.stambia.xml.sequence");
                    } else if (((XSDModelGroup)concrete).getCompositor().equals((Object)XSDCompositor.CHOICE_LITERAL)) {
                        result = MdFactoryHelper.createMdNode((String)"com.stambia.xml.choice");
                    } else if (((XSDModelGroup)concrete).getCompositor().equals((Object)XSDCompositor.ALL_LITERAL)) {
                        result = MdFactoryHelper.createMdNode((String)"com.stambia.xml.all");
                    } else {
                        Logger.getLogger(XmlUtil.class.getName()).warning("Erreur de groupe");
                    }
                    if (parent != null) {
                        parent.getNode().add((Object)result);
                        if (particle != null) {
                            result.setAttribute("minOccurs", new Integer(particle.getMinOccurs()).toString(), false);
                            result.setAttribute("maxOccurs", new Integer(particle.getMaxOccurs()).toString(), false);
                        }
                    }
                    children = ((XSDModelGroup)concrete).getParticles();
                } else if (concrete instanceof XSDAttributeUse) {
                    String string;
                    result = MdFactoryHelper.createMdNode((String)"com.stambia.xml.attribute");
                    result.setName(((XSDAttributeUse)concrete).getContent().getName());
                    if (result.getName() == null) {
                        result.setName(((XSDAttributeUse)concrete).getAttributeDeclaration().getName());
                    }
                    parent.getNode().add((Object)result);
                    XmlUtil.reverseAnnotation(concrete, result);
                    String namespace = ((XSDAttributeUse)concrete).getAttributeDeclaration().getTargetNamespace();
                    if (targetNamespace != null && namespace != null && !targetNamespace.equals(namespace) || ((XSDAttributeUse)concrete).getAttributeDeclaration().isAttributeDeclarationReference()) {
                        result.setAttribute("namespace", namespace, false);
                    }
                    type = null;
                    if (((XSDAttributeUse)concrete).getAttributeDeclaration().getType() != null) {
                        type = XmlUtil.getFirstXSDTypeDefinition1(((XSDAttributeUse)concrete).getAttributeDeclaration().getType());
                    }
                    if (type != null) {
                        String string2 = type.getName();
                        result.setAttribute("type", string2, false);
                    }
                    if (forceOriginalType || ((XSDAttributeUse)concrete).getAttributeDeclaration().getType() != type) {
                        XmlUtil.setOriginalType(result, ((XSDAttributeUse)concrete).getAttributeDeclaration().getType());
                    }
                    if ((string = ((XSDAttributeUse)concrete).getUse().getName()) != null && !string.isEmpty()) {
                        result.setAttribute("use", string, false);
                    }
                    children = concrete.eContents();
                }
            }
        }
        int i = 0;
        ArrayList<Object> children2 = new ArrayList<Object>();
        Iterator iterator = children.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof XSDParticle) {
                if (((XSDParticle)e).getContent() instanceof XSDModelGroup && ((XSDModelGroup)((XSDParticle)e).getContent()).getContents().isEmpty()) {
                    for (Object o2 : ((XSDModelGroup)((XSDParticle)e).getContent()).getParticles()) {
                        if (children.contains(o2)) continue;
                        children2.add(o2);
                    }
                    continue;
                }
                children2.add(e);
                continue;
            }
            if (e instanceof XSDAttributeUse) {
                try {
                    Object o2;
                    o2 = XmlUtil.getArrayType((XSDAttributeUse)e);
                    if (o2 != null) {
                        soapArray.put((XSDTypeDefinition)o2, "item");
                    }
                    if (o2 != null) {
                        children2.add(o2);
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                children2.add(e);
                continue;
            }
            children2.add(e);
        }
        if (currentComplexDef.get(concrete) == null || !currentComplexDef.get(concrete).equals(depth)) {
            if (concrete instanceof XSDComplexTypeDefinition) {
                Integer n = currentComplexDef.get(concrete);
                if (n == null) {
                    currentComplexDef.put((XSDComplexTypeDefinition)concrete, 1);
                } else {
                    currentComplexDef.put((XSDComplexTypeDefinition)concrete, n + 1);
                }
            }
            for (Object e : children2) {
                if (!(e instanceof XSDConcreteComponent)) continue;
                XmlUtil.reverseConcreteElement(result, (XSDConcreteComponent)e, i++, targetNamespace, currentComplexDef, depth, reverseFixedAttributes, schemaPerNamespace);
            }
            if (concrete instanceof XSDComplexTypeDefinition) {
                Integer n = currentComplexDef.get(concrete);
                currentComplexDef.put((XSDComplexTypeDefinition)concrete, n - 1);
            }
        }
        if (result != null) {
            result.setPosition(new BigInteger(Integer.toString(position)));
        }
        return result;
    }

    private static ReverseVersion getReverseVersion(MdNode parent) {
        try {
            String value = parent.evaluateXpathExpressionCached("INTERNAL_XSD_REVERSE_VERSION", "");
            ReverseVersion[] reverseVersionArray = ReverseVersion.values();
            int n = reverseVersionArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReverseVersion v = reverseVersionArray[n2];
                if (value.equals(v.version)) {
                    return v;
                }
                ++n2;
            }
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("unexpected", (Throwable)e);
        }
        return ReverseVersion.NONE;
    }

    private static void reverseAnnotation(XSDConcreteComponent concrete, MdNode parent) {
        XSDAnnotation ann = null;
        if (concrete instanceof XSDElementDeclaration) {
            XSDElementDeclaration element = (XSDElementDeclaration)concrete;
            ann = element.getAnnotation();
        } else if (concrete instanceof XSDAttributeUse) {
            XSDAttributeUse attr = (XSDAttributeUse)concrete;
            ann = attr.getAttributeDeclaration().getAnnotation();
        }
        if (ann != null) {
            String source;
            EList elts = ann.getUserInformation();
            int i = 0;
            for (Element elt : elts) {
                String lang;
                if (!elt.getLocalName().equals("documentation") || elt.getTextContent() == null || elt.getTextContent().isEmpty()) continue;
                MdNode doc = MdFactoryHelper.createMdNode((String)"com.stambia.xml.documentation");
                doc.setName(String.valueOf(++i));
                parent.getNode().add((Object)doc);
                doc.setAttribute("text", elt.getTextContent(), false);
                source = elt.getAttribute("source");
                if (source != null && !source.isEmpty()) {
                    doc.setAttribute("source", source, false);
                }
                if ((lang = elt.getAttribute("xml:lang")) == null || lang.isEmpty()) continue;
                doc.setAttribute("lang", lang, false);
            }
            elts = ann.getApplicationInformation();
            i = 0;
            for (Element elt : elts) {
                if (!elt.getLocalName().equals("appinfo") || elt.getTextContent() == null || elt.getTextContent().isEmpty()) continue;
                MdNode appinfo = MdFactoryHelper.createMdNode((String)"com.stambia.xml.appinfo");
                appinfo.setName(String.valueOf(++i));
                parent.getNode().add((Object)appinfo);
                appinfo.setAttribute("text", elt.getTextContent(), false);
                source = elt.getAttribute("source");
                if (source == null || source.isEmpty()) continue;
                appinfo.setAttribute("source", source, false);
            }
        }
    }

    public static void setOriginalType(MdNode result, XSDTypeDefinition type) {
        if (type != null) {
            String str = type.getTargetNamespace();
            Object qname = type.getQName();
            if (qname != null) {
                String prefix = null;
                if (nameSpaceCache != null) {
                    prefix = nameSpaceCache.get(str);
                }
                if (prefix != null && !((String)qname).startsWith(prefix + ":")) {
                    qname = ((String)qname).contains(":") ? ((String)qname).replaceFirst("[^:]+:", prefix + ":") : prefix + ":" + (String)qname;
                }
                result.setAttribute("originalType", (String)qname, false);
            }
        }
    }

    private static XSDTypeDefinition getNamedType(String qname, ResourceSet rs) {
        XSDTypeDefinition o;
        if (loadAllType == null) {
            loadAllType = new HashMap();
            for (Resource re : rs.getResources()) {
                if (re instanceof WSDLResourceImpl) {
                    for (Object ooo : ((WSDLResourceImpl)re).getDefinition().getTypes().getExtensibilityElements()) {
                        if (!(ooo instanceof XSDSchemaExtensibilityElement)) continue;
                        for (XSDTypeDefinition oooo : ((XSDSchemaExtensibilityElement)ooo).getSchema().getTypeDefinitions()) {
                            loadAllType.put(oooo.getQName(), oooo);
                        }
                        for (XSDTypeDefinition oooo : ((XSDSchemaExtensibilityElement)ooo).getSchema().getSimpleTypeIdMap().values()) {
                            loadAllType.put(oooo.getQName(), oooo);
                        }
                    }
                }
                if (!(re instanceof XSDResourceImpl)) continue;
                for (XSDTypeDefinition oooo : ((XSDResourceImpl)re).getSchema().getTypeDefinitions()) {
                    loadAllType.put(oooo.getQName(), oooo);
                }
                for (XSDTypeDefinition oooo : ((XSDResourceImpl)re).getSchema().getSimpleTypeIdMap().values()) {
                    loadAllType.put(oooo.getQName(), oooo);
                }
            }
        }
        if ((o = loadAllType.get(qname)) == null) {
            for (Resource re : rs.getResources()) {
                if (!(re instanceof XSDResourceImpl)) continue;
                if (qname.indexOf(58) > -1) {
                    String prefix = qname.substring(0, qname.indexOf(58));
                    String local = qname.substring(qname.indexOf(58) + 1);
                    String namespaceUri = null;
                    for (String uri : nameSpaceCache.keySet()) {
                        String _prefix = nameSpaceCache.get(uri);
                        if (_prefix == null || !_prefix.equals(prefix)) continue;
                        namespaceUri = uri;
                        break;
                    }
                    o = namespaceUri != null ? ((XSDResourceImpl)re).getSchema().resolveTypeDefinition(namespaceUri, local) : ((XSDResourceImpl)re).getSchema().resolveTypeDefinition(local);
                } else {
                    o = ((XSDResourceImpl)re).getSchema().resolveTypeDefinition(qname);
                }
                if (o == null) break;
                loadAllType.put(qname, o);
                break;
            }
        }
        return o;
    }

    private static XSDTypeDefinition getArrayType(XSDAttributeUse attr) {
        Node o;
        String name = attr.getContent().getName();
        String uri = attr.getContent().getTargetNamespace();
        if (name == null) {
            name = attr.getAttributeDeclaration().getName();
            uri = attr.getAttributeDeclaration().getTargetNamespace();
        }
        if (name.equals("arrayType") && uri != null && uri.equals("http://schemas.xmlsoap.org/soap/encoding/") && (o = attr.getElement().getAttributes().getNamedItemNS("http://schemas.xmlsoap.org/wsdl/", "arrayType")) != null) {
            String val = o.getNodeValue();
            String qname = val.replace("[]", "");
            XSDTypeDefinition type = XmlUtil.getNamedType(qname, attr.eResource().getResourceSet());
            return type;
        }
        return null;
    }

    public static void initNamesapce(MdNode node) throws XPathExpressionException {
        nameSpaceCache = new HashMap<String, String>();
        loadAllType = null;
        soapArray = new HashMap<XSDTypeDefinition, String>();
        List namespaces = (List)node.evaluateMdSet("namespace");
        for (MdNode namespace : namespaces) {
            String uri = namespace.evaluate("@name");
            String prefix = namespace.evaluate("@prefix");
            XmlUtil.addNamespace(node, uri, prefix, false);
        }
    }

    public static void end() {
        nameSpaceCache.clear();
        if (loadAllType != null) {
            loadAllType.clear();
        }
        if (soapArray != null) {
            soapArray.clear();
        }
    }

    private static void addNamespaces(MdNode node, Map<String, String> map, boolean create) {
        if (map != null) {
            for (String prefix : map.keySet()) {
                XmlUtil.addNamespace(node, map.get(prefix), prefix, create);
            }
        }
    }

    private static void addNamespace(MdNode node, String uri, String prefix, boolean create) {
        if (uri != null) {
            HashSet<String> allPrefix = new HashSet<String>();
            for (String _uri : nameSpaceCache.keySet()) {
                if (_uri.equals(uri)) {
                    return;
                }
                allPrefix.add(nameSpaceCache.get(_uri));
            }
            if (prefix == null || prefix.isEmpty()) {
                prefix = uri.equals("http://www.w3.org/2001/XMLSchema") ? "xsd" : "ns";
            }
            Object newPrefix = prefix;
            int i = 2;
            while (allPrefix.contains(newPrefix)) {
                newPrefix = prefix + "_" + i++;
            }
            nameSpaceCache.put(uri, (String)newPrefix);
            if (create) {
                MdNode namespace = MdFactoryHelper.createMdNode((String)"com.stambia.xml.namespace");
                node.getNode().add((Object)namespace);
                namespace.setName(uri);
                namespace.setAttribute("prefix", (String)newPrefix, false);
            }
        }
    }

    public static URI getURI(String path) throws IOException, URISyntaxException {
        File file = new File(path);
        if (file.isFile()) {
            return URI.createFileURI((String)file.getCanonicalFile().toString());
        }
        URL url = new URL(path);
        java.net.URI uri = new java.net.URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
        return URI.createURI((String)uri.toASCIIString());
    }

    public static void incrementalReverse(final Shell shell, String filePath, final Reverser reverse, final DocumentRoot root, final boolean deleteUnexistantAttributeBoo, final boolean deleteUnexistantElementBoo, final List<String> excludeAttributeToUpdate, final boolean performIncrementalReverse) {
        try {
            new ProgressMonitorDialog(shell).run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block11: {
                        try {
                            MdNode node = reverse.reverse(monitor);
                            if (!performIncrementalReverse) {
                                return;
                            }
                            try {
                                ArrayList<MdNode> tmp = new ArrayList<MdNode>();
                                tmp.add(node);
                                monitor.beginTask(Messages.XmlUtil_102, -1);
                                monitor.subTask(null);
                                HashMap<String, Boolean> incrementalDelete = null;
                                if (deleteUnexistantAttributeBoo || deleteUnexistantElementBoo) {
                                    incrementalDelete = new HashMap<String, Boolean>();
                                    if (deleteUnexistantElementBoo) {
                                        incrementalDelete.put("com.stambia.xml.element", true);
                                        incrementalDelete.put("com.stambia.xml.sequence", true);
                                        incrementalDelete.put("com.stambia.xml.choice", true);
                                        incrementalDelete.put("com.stambia.xml.all", true);
                                    }
                                    if (deleteUnexistantAttributeBoo) {
                                        incrementalDelete.put("com.stambia.xml.attribute", true);
                                    }
                                }
                                HashMap<MdNode, MdRootNode> reversedMap = new HashMap<MdNode, MdRootNode>();
                                reversedMap.put(node, root.getNode());
                                IncrementalReverser ir = new IncrementalReverser((EObject)root, reversedMap, excludeAttributeToUpdate, true, null, incrementalDelete, (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
                                monitor.subTask("count element to reverse");
                                ir.reverse();
                            }
                            catch (Exception e) {
                                if (e.getMessage() != null) {
                                    MessageDialog.openError((Shell)shell, (String)Messages.XmlUtil_2, (String)e.getMessage());
                                    Activator.error(Messages.XmlUtil_0, e);
                                    e.printStackTrace();
                                    break block11;
                                }
                                MessageDialog.openError((Shell)shell, (String)Messages.XmlUtil_115, (String)Messages.XmlUtil_116);
                                Activator.error(Messages.XmlUtil_117, e);
                                e.printStackTrace();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            MessageDialog.openError((Shell)shell, (String)Messages.XmlUtil_118, (String)e.getMessage());
            Activator.error(Messages.XmlUtil_119, e);
        }
    }

    public static class CustomErrorHandler
    extends ErrorHandlerImpl {
        List<Throwable> errors = new ArrayList<Throwable>();

        public void error(SAXParseException paramSAXParseException) {
            super.error(paramSAXParseException);
            this.errors.add(paramSAXParseException);
        }

        public void fatalError(SAXParseException paramSAXParseException) throws SAXParseException {
            super.fatalError(paramSAXParseException);
            this.errors.add(paramSAXParseException);
        }

        public void printException(Throwable paramThrowable) {
            super.printException(paramThrowable);
            this.errors.add(paramThrowable);
        }

        public void checkErrors() throws Exception {
            StringBuilder b = new StringBuilder();
            for (Throwable ex : this.errors) {
                b.append(ex.getMessage() + "\\n");
                if (!(ex instanceof FileNotFoundException) && !(ex instanceof IOException)) continue;
                throw new XmlTrimmDTDParser.AccessResourceException((IOException)ex);
            }
            if (b.length() > 0) {
                throw new Exception(b.toString());
            }
        }
    }

    private static enum ReverseVersion {
        NONE(null),
        V1("1");

        String version;

        private ReverseVersion(String version) {
            this.version = version;
        }
    }

    public static interface Reverser {
        public MdNode reverse(IProgressMonitor var1) throws Exception;
    }
}

