/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file;

import com.indy.addons.Messages;
import com.indy.file.FieldDescriptor;
import com.indy.file.ReaderWrapper;
import com.indy.libraries.build.utils.StringUtils;
import com.indy.ui.custom.out.Util;
import com.stambia.jdbc.driver.file.fileManagment.IReadContext;
import com.stambia.jdbc.driver.file.fileManagment.StambiaBufferedReaderI;
import com.stambia.jdbc.driver.file.fileManagment.TransformInputStreamWithScript;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFilter;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFilterSet;
import com.stambia.jdbc.driver.file.tools.DelimitedLineParser;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.Property;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class FileUtil {
    private static final String DATE_REGEX = "((19|20)(\\d\\d)([- /.])(0[1-9]|1[012])([- /.])(0[1-9]|[12][0-9]|3[01]))(([- /.T])([01][0-9]|2[0-3])([:.])([0-5][0-9])(([:.])([0-5][0-9]))?(([:. ])([0-9])([0-9])?([0-9])?)?)?";
    private static final Pattern DATE_PATTER = Pattern.compile("((19|20)(\\d\\d)([- /.])(0[1-9]|1[012])([- /.])(0[1-9]|[12][0-9]|3[01]))(([- /.T])([01][0-9]|2[0-3])([:.])([0-5][0-9])(([:.])([0-5][0-9]))?(([:. ])([0-9])([0-9])?([0-9])?)?)?");
    public static final String XPATH_EXPRESSION_PATH = "INTERNAL_PATH";
    private static final Logger LOGGER = LogManager.getLogger(FileUtil.class);
    private static final String IS_ENCLOSE_BY_DELIMITER = "\u00a4\u00a3str\u00a3\u00a4";
    static final FileUtil INSTANCE = new FileUtil();

    private FileUtil() {
    }

    private static MdNode getMdFile(MdNode node) throws XPathExpressionException {
        return (MdNode)node.evaluateMdNode("ancestor-or-self::file[1]");
    }

    private static String getFieldSeparator(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            return file.evaluateMdString("@fieldSeparator");
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static String getDecimalSeparator(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            return file.evaluateMdString("@decimalSeparator");
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String formatFields(List<String> fields, List<FieldDescriptor> list) {
        int i = 0;
        StringBuilder result = new StringBuilder();
        for (String string : fields) {
            void var4_5;
            FieldDescriptor fd;
            if (list.size() <= i) continue;
            if ((fd = list.get(i++)) != null) {
                String string2 = Util.rightPad((String)string, (int)fd.size);
            }
            result.append((String)var4_5);
        }
        return result.toString();
    }

    private static String getFieldDelimiter(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            return file.evaluateMdString("@stringDelimiter");
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static int getLineToSkip(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            String str = file.evaluateMdString("@lineToSkip");
            return str != null && !str.equals("") && str.matches("\\d*") ? Integer.valueOf(str) : 0;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return 0;
        }
    }

    private static String getEscapeChar(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            return file.evaluateMdString("@escapeChar");
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static String getFieldFormat(MdNode node) {
        try {
            return node.evaluateMdString("@format");
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static int getFieldDecimal(MdNode node) {
        try {
            String str = node.evaluateMdString("@decimal");
            return str != null && !str.equals("") && str.matches("\\d*") ? Integer.valueOf(str) : 0;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return 0;
        }
    }

    public static void synchronizeFieldDescriptor(FieldDescriptor fd, MdNode node) {
        fd.name = node.getName();
        fd.position = node.getPosition().intValue();
        fd.format = FileUtil.getFieldFormat(node);
        fd.decimal = FileUtil.getFieldDecimal(node);
        fd.size = FileUtil.getFieldSize(node);
        fd.type = FileUtil.getFieldType(node);
    }

    public static String getType(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            String result = file.evaluateMdString("@type");
            return result == null ? "" : result;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static String getFieldType(MdNode node) {
        try {
            String result = node.evaluateMdString("@type");
            return result == null ? "" : result;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return "";
        }
    }

    private static int getFieldSize(MdNode node) {
        try {
            String str = node.evaluateMdString("@size");
            return str != null && !str.equals("") && str.matches("\\d*") ? Integer.valueOf(str) : 0;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return 0;
        }
    }

    private static List<String> parseDelimitedLine(String line, String fieldSeparator, String fieldDelimiter) {
        try {
            DelimitedLineParser dlp = new DelimitedLineParser(fieldSeparator, fieldDelimiter, null);
            dlp.parse(line);
            ArrayList<String> list = new ArrayList<String>();
            while (dlp.hasNext()) {
                list.add(dlp.next().getData());
            }
            return list;
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static List<FieldDescriptor> getDelimitedFieldDescriptor(MdNode node, int limit, int stringMinSize, int stringSafetyMargin, boolean determineDataType, int numericMinSize, int numericSafetyMargin) throws XPathExpressionException, IOException {
        Throwable throwable = null;
        Object var8_9 = null;
        try (ReaderWrapper reader = new ReaderWrapper(FileUtil.getReader2(node, false), FileUtil.getHeaderPosition(node), FileUtil.getHeaderPosition(node), limit);){
            ArrayList<FieldDescriptor> result = null;
            int headerPosition = FileUtil.getHeaderPosition(node);
            String fieldSeparator = StringUtils.decodeHexString((String)FileUtil.getFieldSeparator(node), (boolean)false);
            String fieldDelimiter = StringUtils.decodeHexString((String)FileUtil.getFieldDelimiter(node), (boolean)false);
            String decimalSeparator = FileUtil.getDecimalSeparator(node);
            if (fieldSeparator != null) {
                String headerLine = reader.headerLine;
                String line = reader.readLine();
                String string = headerLine = headerLine == null ? line : headerLine;
                if (headerLine != null) {
                    List<String> split = FileUtil.parseDelimitedLine(headerLine, fieldSeparator, fieldDelimiter);
                    int index = 0;
                    result = new ArrayList<FieldDescriptor>(split.size());
                    while (line != null && (index < limit || limit == -1)) {
                        ++index;
                        if (!line.isEmpty()) {
                            List<String> split2 = FileUtil.parseDelimitedLine(line, fieldSeparator, fieldDelimiter);
                            int j = 0;
                            for (String name : split) {
                                if (j >= result.size()) {
                                    result.add(new FieldDescriptor());
                                }
                                FieldDescriptor fd = (FieldDescriptor)result.get(j);
                                if (fd.position == -1) {
                                    fd.position = j + 1;
                                }
                                if (fd.name == null || fd.name.isEmpty()) {
                                    if (headerPosition > 0 && split.size() > j && name != null && !name.isEmpty()) {
                                        Object tmp = name;
                                        if (((String)tmp).startsWith(IS_ENCLOSE_BY_DELIMITER)) {
                                            tmp = ((String)tmp).substring(IS_ENCLOSE_BY_DELIMITER.length());
                                        }
                                        tmp = ((String)tmp).replace(".", "_");
                                        tmp = ((String)tmp).replace("'", "_");
                                        if (!((String)(tmp = FileUtil.deAccent((String)tmp))).substring(0, 1).matches("[A-Za-z]")) {
                                            tmp = "A" + (String)tmp;
                                        }
                                        fd.name = ((String)tmp).trim();
                                        fd.noName = false;
                                    } else {
                                        fd.name = "F" + (j + 1);
                                    }
                                }
                                if (split2.size() > j) {
                                    String data = split2.get(j);
                                    data = data == null ? "" : data;
                                    String forceType = null;
                                    if (data != null && data.startsWith(IS_ENCLOSE_BY_DELIMITER)) {
                                        data = data.substring(IS_ENCLOSE_BY_DELIMITER.length());
                                        forceType = "String";
                                    }
                                    FileUtil.updateFieldDescriptor(fd, data, decimalSeparator, forceType, stringMinSize, stringSafetyMargin, determineDataType, numericMinSize, numericSafetyMargin);
                                } else {
                                    FileUtil.updateFieldDescriptor(fd, "", decimalSeparator, null, stringMinSize, stringSafetyMargin, determineDataType, numericMinSize, numericSafetyMargin);
                                }
                                ++j;
                            }
                        }
                        line = reader.readLine();
                    }
                    for (FieldDescriptor fd : result) {
                        if (fd.type.equals("Empty")) {
                            fd.type = "String";
                        }
                        if (fd.size != 0 || !fd.type.equals("String")) continue;
                        fd.size = stringMinSize > 0 ? Integer.valueOf(stringMinSize) : Integer.valueOf(50);
                    }
                }
            }
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String deAccent(String str) {
        String nfdNormalizedString = Normalizer.normalize(str, Normalizer.Form.NFD);
        Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
        return pattern.matcher(nfdNormalizedString).replaceAll("");
    }

    static int getHeaderPosition(MdNode node) {
        try {
            MdNode file = FileUtil.getMdFile(node);
            String str = file.evaluateMdString("@header");
            return str != null && !str.equals("") && str.matches("[0-9]*") ? Integer.valueOf(str) : 0;
        }
        catch (XPathExpressionException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
            return 0;
        }
    }

    public static void updateFieldDescriptor(FieldDescriptor fd, String str2, String decimalSeparator, String forceType, int stringMinSize, int stringSafetyMargin, boolean determineDataType, int numericMinSize, int numericSafetyMargin) {
        String trim = str2.trim();
        String localDecimalSeparator = StringUtils.decodeHexString((String)decimalSeparator, (boolean)true);
        localDecimalSeparator = localDecimalSeparator.replace("\\.", "\\\\\\\\.");
        if (!determineDataType) {
            fd.type = "String";
        } else if (forceType == null) {
            String tmpFormat = null;
            String tmpType = "Empty";
            if (fd.type == null || !fd.type.equals("String")) {
                if (trim.isEmpty()) {
                    tmpType = "Empty";
                } else if (trim.matches("[-]?[0-9]*[" + localDecimalSeparator + "]?[0-9]*")) {
                    tmpType = "Numeric";
                } else if (trim.matches(DATE_REGEX)) {
                    tmpType = "Date";
                    Matcher m = DATE_PATTER.matcher(trim);
                    m.matches();
                    tmpFormat = String.format("yyyy%sMM%sdd", m.group(4), m.group(6));
                    if (m.group(8) != null) {
                        tmpType = "Timestamp";
                        tmpFormat = String.format("%s%sHH%smm", tmpFormat, m.group(9), m.group(11));
                        if (m.group(13) != null) {
                            tmpFormat = String.format("%s%sss", tmpFormat, m.group(14));
                            if (m.group(16) != null) {
                                tmpFormat = String.format("%s%s", tmpFormat, m.group(17));
                                if (m.group(18) != null) {
                                    tmpFormat = String.format("%s%s", tmpFormat, "S");
                                }
                                if (m.group(19) != null) {
                                    tmpFormat = String.format("%s%s", tmpFormat, "S");
                                }
                                if (m.group(20) != null) {
                                    tmpFormat = String.format("%s%s", tmpFormat, "S");
                                }
                            }
                        }
                    }
                } else {
                    tmpType = "String";
                }
            }
            if (fd.type == null) {
                fd.type = tmpType;
                fd.format = tmpFormat;
            } else if (!tmpType.equals("Empty") && !fd.type.equals(tmpType)) {
                fd.type = "String";
            }
        } else {
            fd.type = forceType;
        }
        Integer currentSize = fd.size == null ? 0 : fd.size;
        Integer tmpSize = str2.length();
        if (fd.type.equals("Numeric")) {
            tmpSize = tmpSize + numericSafetyMargin;
            if (numericMinSize > 0 && numericMinSize > tmpSize) {
                tmpSize = numericMinSize;
            }
        } else if (fd.type.equals("String")) {
            tmpSize = tmpSize + stringSafetyMargin;
            if (stringMinSize > 0 && stringMinSize > tmpSize) {
                tmpSize = stringMinSize;
            }
        }
        Integer n = fd.size = currentSize > tmpSize ? currentSize : tmpSize;
        if (fd.type.equals("Numeric")) {
            if (trim.matches("[-]?[0-9]*[" + localDecimalSeparator + "][0-9]+")) {
                int currentDecimal = trim.substring(trim.indexOf(localDecimalSeparator) + 1).length();
                if (fd.decimal == null || currentDecimal > fd.decimal) {
                    fd.decimal = currentDecimal;
                }
            }
        } else {
            fd.decimal = null;
        }
    }

    public static List<FieldDescriptor> getPositionalFieldDescriptor(MdNode node, int limit, boolean determineDataType) throws XPathExpressionException, IOException {
        int j;
        ReaderWrapper reader;
        ArrayList<FieldDescriptor> result = null;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int header = FileUtil.getHeaderPosition(node);
        String decimalSeparator = FileUtil.getDecimalSeparator(node);
        Throwable throwable = null;
        Object var8_10 = null;
        try {
            reader = new ReaderWrapper(FileUtil.getReader2(node, false), header, FileUtil.getLineToSkip(node), limit);
            try {
                String line = reader.readLine();
                if (line == null) {
                    return result;
                }
                int index = 1;
                while (line != null) {
                    j = 0;
                    int precChar = 32;
                    while (j < line.length()) {
                        char c = line.charAt(j);
                        if (index == 1) {
                            if (c != ' ' && precChar == 32) {
                                positions.add(j);
                            }
                        } else if (c == ' ' || precChar != 32) {
                            positions.remove((Object)j);
                        }
                        ++j;
                        precChar = c;
                    }
                    line = reader.readLine();
                    ++index;
                }
                if (!positions.contains(0)) {
                    positions.add(0);
                }
                Collections.sort(positions);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var8_10 = null;
        try {
            reader = new ReaderWrapper(FileUtil.getReader2(node, false), header, FileUtil.getLineToSkip(node), limit);
            try {
                String headerLine = reader.headerLine;
                String line = reader.readLine();
                headerLine = headerLine == null ? line : headerLine;
                result = new ArrayList<FieldDescriptor>(positions.size());
                while (line != null) {
                    j = 0;
                    for (Integer position : positions) {
                        int start = position;
                        if (line.length() > start) {
                            String str = "";
                            str = j + 1 < positions.size() ? line.substring(start, (Integer)positions.get(j + 1)) : line.substring(start);
                            if (j >= result.size()) {
                                result.add(new FieldDescriptor());
                            }
                            FieldDescriptor fd = (FieldDescriptor)result.get(j);
                            if (fd.position == -1) {
                                fd.position = j + 1;
                            }
                            if (fd.name == null) {
                                if (header > 0) {
                                    String name = null;
                                    name = j + 1 < positions.size() ? headerLine.substring(start, (Integer)positions.get(j + 1)) : headerLine.substring(start);
                                    String tmp = name.replace(".", "_");
                                    tmp = tmp.replace("'", "_");
                                    fd.name = tmp = FileUtil.deAccent(tmp);
                                    fd.noName = false;
                                } else {
                                    fd.name = "F" + (j + 1);
                                }
                            }
                            FileUtil.updateFieldDescriptor(fd, str, decimalSeparator, null, 0, 0, determineDataType, 0, 0);
                        } else {
                            LOGGER.warn("erreur de taille de ligne");
                        }
                        ++j;
                    }
                    line = reader.readLine();
                }
                for (FieldDescriptor fd : result) {
                    if (!fd.type.equals("Empty")) continue;
                    fd.type = "String";
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        return result;
    }

    public static void reverseWithFileDescriptor(List<FieldDescriptor> fieldDescriptorList, MdNode file, boolean updateName, boolean updateSize, boolean updateType, boolean updatePhysicalName, boolean positionMode) {
        ArrayList<MdNode> newNode = new ArrayList<MdNode>();
        HashMap<Object, Integer> alreadeyNamed = new HashMap<Object, Integer>();
        HashMap<Object, Integer> alreadeyNamed2 = new HashMap<Object, Integer>();
        boolean noName = false;
        if (fieldDescriptorList != null) {
            int precPosition = 1;
            for (FieldDescriptor fd : fieldDescriptorList) {
                Integer already;
                Object formattedName = fd.name.trim();
                noName = fd.noName;
                if (((String)formattedName).startsWith("\"")) {
                    formattedName = ((String)formattedName).substring(1);
                }
                if (((String)formattedName).endsWith("\"")) {
                    formattedName = ((String)formattedName).substring(0, ((String)formattedName).length() - 1);
                }
                if ((already = (Integer)alreadeyNamed.get(formattedName = ((String)formattedName).trim())) != null) {
                    int i = already;
                    alreadeyNamed.put(formattedName, ++i);
                    formattedName = (String)formattedName + "_" + i;
                    alreadeyNamed.put(formattedName, 1);
                } else {
                    alreadeyNamed.put(formattedName, 1);
                }
                MdNode newField = MdFactoryHelper.createMdNode((String)"com.stambia.file.field");
                newField.setName((String)formattedName);
                newField.setSubstituteContainer((EObject)file);
                for (Property prop : newField.getLevel().getAttribute()) {
                    String value = prop.getDefaultValue();
                    if (prop.getCode().equals("size")) {
                        value = fd.size.toString();
                    } else if (prop.getCode().equals("type")) {
                        value = fd.type;
                    } else if (prop.getCode().equals("decimal")) {
                        value = fd.decimal != null ? fd.decimal.toString() : null;
                    } else if (prop.getCode().equals("format")) {
                        value = fd.format;
                    }
                    if (value == null || value.equals("")) continue;
                    Attribute attr = MdFactoryHelper.createAttribute((String)prop.getFullCode());
                    attr.setValue(value);
                    newField.getAttribute().add((Object)attr);
                }
                if (positionMode) {
                    newField.setPosition(BigInteger.valueOf(precPosition));
                } else {
                    newField.setPosition(BigInteger.valueOf(fd.position));
                }
                precPosition += fd.size.intValue();
                Attribute attr = MdFactoryHelper.createAttribute((String)"com.stambia.file.field.physicalName");
                newField.getAttribute().add((Object)attr);
                String temp = FileUtil.deAccent((String)formattedName);
                Object pname = temp.replaceAll("[\\W]", "_");
                pname = ((String)pname).toUpperCase();
                already = (Integer)alreadeyNamed2.get(pname);
                if (already != null) {
                    int i = already;
                    alreadeyNamed2.put(pname, ++i);
                    pname = (String)pname + "_" + i;
                    alreadeyNamed2.put(pname, 1);
                } else {
                    alreadeyNamed2.put(pname, 1);
                }
                attr.setValue((String)pname);
                newNode.add(newField);
            }
        }
        try {
            ArrayList<String> excludeAttributeToUpdate = new ArrayList<String>();
            if (!updatePhysicalName) {
                excludeAttributeToUpdate.add("com.stambia.file.field.physicalName");
            }
            if (!updateSize) {
                excludeAttributeToUpdate.add("com.stambia.file.field.size");
                excludeAttributeToUpdate.add("com.stambia.file.field.decimal");
            }
            if (!updateType) {
                excludeAttributeToUpdate.add("com.stambia.file.field.type");
            }
            HashMap<MdNode, MdNode> reversedMap = new HashMap<MdNode, MdNode>();
            for (MdNode n : newNode) {
                reversedMap.put(n, noName ? file.getNodeByPosition(n.getDefType(), newNode.indexOf(n)) : file.getNodeByName(n.getDefType(), n.getName()));
            }
            IncrementalReverser reverser = new IncrementalReverser((EObject)file, reversedMap, excludeAttributeToUpdate, updateName, null, null, (IncrementalReverser.IReverseMatchingStrategy)(noName ? IncrementalReverser.DefaulteverseMatchingStrategy.ByPosition : IncrementalReverser.DefaulteverseMatchingStrategy.ByName), null, true);
            reverser.reverse();
        }
        catch (ReverseException e) {
            LOGGER.warn("Unexpected", (Throwable)e);
        }
    }

    private static MetadataFilterSet getFilterSet2(MdNode node, MetadataFilterSet parent) throws XPathExpressionException {
        List mdChildren;
        Object o;
        MetadataFilterSet filterSet = new MetadataFilterSet(new IReadContext(){

            public int position() {
                return 0;
            }

            public long startTimeStamp() {
                return 0L;
            }
        });
        filterSet.setName(node.getName());
        try {
            filterSet.setAncestorLevel(Integer.valueOf(node.evaluateMdString("@ancestorLevel")).intValue());
        }
        catch (Exception e) {
            filterSet.setAncestorLevel(0);
        }
        try {
            filterSet.setOccurenceNumber(Integer.valueOf(node.evaluateMdString("@occurenceNumber")).intValue());
        }
        catch (Exception e) {
            filterSet.setOccurenceNumber(-1);
        }
        try {
            filterSet.setOccurenceSize(Integer.valueOf(node.evaluateMdString("@occurenceSize")).intValue());
        }
        catch (Exception e) {
            filterSet.setOccurenceSize(-1);
        }
        try {
            filterSet.setOccurenceStart(Integer.valueOf(node.evaluateMdString("@occurenceStart")).intValue());
        }
        catch (Exception e) {
            filterSet.setOccurenceStart(-1);
        }
        if (parent != null) {
            filterSet.setParent(parent);
            parent.addChildren(node.getName(), filterSet);
        }
        if ((o = node.evaluateMdSet("filter")) instanceof List) {
            ArrayList<MetadataFilter> filters = new ArrayList<MetadataFilter>();
            for (Object _filter : (List)o) {
                MdNode filter = (MdNode)_filter;
                String value = filter.evaluateMdString("@value");
                MetadataFilter mdFilter = new MetadataFilter();
                mdFilter.setTest(value);
                try {
                    MetadataFilter.Operator op = MetadataFilter.Operator.valueOf((String)filter.evaluateMdString("@operator"));
                    mdFilter.setOperator(op);
                }
                catch (Exception e) {
                    mdFilter.setOperator(MetadataFilter.Operator.StartsWith);
                }
                try {
                    mdFilter.setStartsAt(Integer.valueOf(filter.evaluateMdString("@start")).intValue());
                }
                catch (Exception e) {
                    mdFilter.setStartsAt(1);
                }
                try {
                    mdFilter.setLength(Integer.valueOf(filter.evaluateMdString("@length")).intValue());
                }
                catch (Exception e) {
                    mdFilter.setLength(-1);
                }
                try {
                    mdFilter.setNot(Boolean.valueOf(filter.evaluateMdString("@not")).booleanValue());
                }
                catch (Exception e) {
                    mdFilter.setNot(false);
                }
                try {
                    mdFilter.setAncestorLevel(Integer.valueOf(filter.evaluateMdString("@ancestorLevel")).intValue());
                }
                catch (Exception e) {
                    mdFilter.setAncestorLevel(0);
                }
                filters.add(mdFilter);
            }
            filterSet.addFilter(filters);
        }
        if ((mdChildren = (List)node.evaluateMdSet("*[name()='record' or name()='file']")) != null) {
            for (MdNode child : mdChildren) {
                FileUtil.getFilterSet2(child, filterSet);
            }
        }
        return filterSet;
    }

    private static StambiaBufferedReaderI getReader2(MdNode node, boolean disableFilter) throws XPathExpressionException, IOException {
        MdNode fileMdNode = FileUtil.getMdFile(node);
        String path = fileMdNode.evaluateXpathExpression(XPATH_EXPRESSION_PATH);
        String lineSeparator = fileMdNode.evaluateMdString("@lineSeparator");
        String stringDelimiter = fileMdNode.evaluateMdString("@stringDelimiter");
        String lineSize = fileMdNode.evaluateMdString("@lineSize");
        stringDelimiter = stringDelimiter != null ? StringUtils.decodeHexString((String)stringDelimiter, (boolean)true) : null;
        String charsetName = fileMdNode.evaluateMdString("@charsetName");
        String script = fileMdNode.evaluateMdString("@transformScript");
        String scriptLanguage = fileMdNode.evaluateMdString("@transformScriptLanguage");
        String escapeChar = fileMdNode.evaluateMdString("@escapeChar");
        String lastLineToSkip = fileMdNode.evaluateMdString("@lastLineToSkip");
        charsetName = charsetName == null || charsetName.isEmpty() ? Charset.defaultCharset().displayName() : charsetName;
        lineSeparator = lineSeparator != null ? StringUtils.decodeHexString((String)lineSeparator, (boolean)false) : null;
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException(NLS.bind((String)Messages.FileUtil_2, (Object)path));
        }
        int readerBufferSize = 8192;
        InputStream is = null;
        if (!(script == null || script.isEmpty() || scriptLanguage != null && scriptLanguage.equals("disable"))) {
            try {
                is = TransformInputStreamWithScript.transform((InputStream)new FileInputStream(file), (String)script, (String)scriptLanguage);
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected", (Throwable)e);
            }
        }
        StambiaBufferedReaderI reader = new StambiaBufferedReaderI((Reader)new InputStreamReader((InputStream)(is == null ? new FileInputStream(file) : is), charsetName), readerBufferSize);
        try {
            String lineScript = fileMdNode.evaluateMdString("@transformLineScript");
            String lineScriptLanguage = fileMdNode.evaluateMdString("@transformLineScriptLanguage");
            reader.setLineTransformLanguage(lineScriptLanguage);
            reader.setLineTransformScript(lineScript);
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected", (Throwable)e);
        }
        try {
            reader.setLastLinePosition(Integer.parseInt(lastLineToSkip));
            reader.setMaxLasLineToBuffer(Integer.parseInt(lastLineToSkip));
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected", (Throwable)e);
        }
        reader.setLineSeparator(lineSeparator);
        try {
            reader.setLineSize(Integer.parseInt(lineSize));
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected", (Throwable)e);
        }
        try {
            reader.setLineSize(lineSize);
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected", (Throwable)e);
        }
        if (!disableFilter) {
            try {
                reader.setFilterSet(FileUtil.getFilterSet2(fileMdNode, null));
            }
            catch (Exception e) {
                LOGGER.warn("Unexpected", (Throwable)e);
            }
        }
        try {
            reader.setMonoSourceName(node.getName());
        }
        catch (Exception e) {
            LOGGER.warn("Unexpected", (Throwable)e);
        }
        reader.setStringDelimiter(stringDelimiter);
        reader.setEscapeChar(escapeChar);
        return reader;
    }

    public static String getPreviewData(MdNode node, int limit, boolean disableFilter) throws XPathExpressionException, IOException {
        StringBuilder result = new StringBuilder();
        Throwable throwable = null;
        Object var5_6 = null;
        try (ReaderWrapper reader = new ReaderWrapper(FileUtil.getReader2(node, disableFilter), FileUtil.getHeaderPosition(node), FileUtil.getLineToSkip(node), limit);){
            String escapeChar = FileUtil.getEscapeChar(node);
            escapeChar = escapeChar.replace("\\\\", "\\\\\\\\");
            String line = reader.readLine();
            while (line != null) {
                String replacer = "\u0000";
                Object curr = line.replaceAll("\\p{C}", replacer).replace("\t", replacer).replace("\n", replacer).replace("\r", replacer) + "\n";
                if (!escapeChar.isEmpty()) {
                    curr = ((String)curr).replaceAll(escapeChar, replacer);
                }
                result.append((String)curr);
                line = reader.readLine();
            }
            return result.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getFormatedData(MdNode node, int limit, List<FieldDescriptor> list) throws XPathExpressionException, IOException {
        StringBuilder result = new StringBuilder();
        Throwable throwable = null;
        Object var5_6 = null;
        try (ReaderWrapper reader = new ReaderWrapper(FileUtil.getReader2(node, false), FileUtil.getHeaderPosition(node), FileUtil.getHeaderPosition(node), limit);){
            String fieldSeparator = StringUtils.decodeHexString((String)FileUtil.getFieldSeparator(node), (boolean)false);
            String sringDelimiter = StringUtils.decodeHexString((String)FileUtil.getFieldDelimiter(node), (boolean)false);
            String line = reader.readLine();
            while (line != null) {
                List<String> fields = FileUtil.parseDelimitedLine(line, fieldSeparator, sringDelimiter);
                String line2 = FileUtil.formatFields(fields, list);
                result.append(line2);
                result.append("\n");
                line = reader.readLine();
            }
            return result.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

