/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file;

import com.stambia.jdbc.driver.file.fileManagment.StambiaBufferedReaderI;
import java.io.IOException;

class ReaderWrapper
implements AutoCloseable {
    StambiaBufferedReaderI reader;
    String headerLine;
    String[] lines;
    int limit = -1;
    int index = 0;

    public ReaderWrapper(StambiaBufferedReaderI reader, int headerPosition, int lineToSkip, int limit) throws IOException {
        this.reader = reader;
        if (lineToSkip < headerPosition) {
            lineToSkip = headerPosition;
        }
        try {
            reader.setRowsLimit(limit);
        }
        catch (Exception e) {
            this.limit = limit;
        }
        boolean setLineToSkipBeforeUnexist = false;
        if (headerPosition > 0) {
            try {
                reader.setLineToSkipBefore(headerPosition - 1);
                this.headerLine = reader.readLine();
            }
            catch (Exception e) {
                setLineToSkipBeforeUnexist = true;
                String line = null;
                int i = 0;
                do {
                    line = reader.readLine();
                    if (++i != headerPosition) continue;
                    this.headerLine = line;
                } while (line != null && i < lineToSkip);
            }
        }
        if (!setLineToSkipBeforeUnexist && lineToSkip > 0) {
            reader.setLineToSkipBefore(lineToSkip);
        }
    }

    public String readLine() throws IOException {
        if (this.limit > -1 && this.index >= this.limit) {
            return null;
        }
        String line = this.reader.readLine();
        if (line != null) {
            ++this.index;
        }
        return line;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

