/*
 * Decompiled with CFR 0.152.
 */
package com.indy.jdbc.wizard;

import com.indy.addons.Messages;
import com.indy.jdbc.MdReverserNode;
import com.indy.jdbc.composite.SchemaDatastoreReverserComposite;
import com.indy.jdbc.wizard.MessageConsoleReverseListener;
import com.indy.md.ui.editor.reverse.MdDiffBuilder;
import com.indy.md.ui.editor.reverse.MdDiffNode;
import com.indy.md.ui.editor.reverse.MdDiffNodeUI;
import com.indy.md.ui.editor.ui.MdWizardPage;
import com.indy.ui.custom.out.Util;
import com.stambia.md.MdNode;
import com.stambia.md.custom.AttributeRefResolver;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.custom.ReverseEvent;
import com.stambia.md.custom.ReverseListener;
import com.stambia.md.custom.exception.ReverseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class SelectiveWizardPage
extends MdWizardPage {
    private MdDiffNodeUI diffNodeUI;
    private AttributeRefResolver attributeRefResolver;
    private SchemaDatastoreReverserComposite compositeDataStore;
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

    public SelectiveWizardPage(String pageName, MdNode node) {
        super(pageName, node);
    }

    public IWizardPage getNextPage() {
        this.loadSelectiveTree();
        return super.getNextPage();
    }

    private void loadSelectiveTree() {
        try {
            MdNode newroot = this.getNode().copy(1);
            newroot.setSubstituteContainer(this.getNode().eContainer());
            MessageConsole console = Util.findConsole((String)"Reverse");
            console.activate();
            ReverseListener listener = this.getReverseListener(console);
            MdReverserNode reverser = this.compositeDataStore.reverse(listener);
            this.getContainer().run(true, true, monitor -> {
                monitor.beginTask("start task", -1);
                try {
                    List<MdNode> newNodes = reverser.doReverse(monitor);
                    newroot.getNode().addAll(newNodes);
                    this.attributeRefResolver = reverser.getReverse().getAttributeRefResolver();
                    MdDiffNode diffNode = new MdDiffNode(null, this.getNode(), newroot, null, true);
                    HashMap nodeMatchingMap = new HashMap();
                    MdDiffBuilder.buildTree((IncrementalReverser.DefaulteverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, (MdDiffNode)diffNode, Collections.emptySet(), null, nodeMatchingMap);
                    Display.getDefault().syncExec(() -> this.diffNodeUI.getViewerHelper().setInput((Object)diffNode));
                }
                catch (ReverseException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            this.logger.warn("Unexpected", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SchemaWizard_14, (String)e.getMessage());
        }
    }

    public void createControl(Composite parent) {
        TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
        this.diffNodeUI = new MdDiffNodeUI(widgetFactory);
        Composite main = widgetFactory.createComposite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        ((GridLayout)main.getLayout()).verticalSpacing = 0;
        this.diffNodeUI.createSearchBar(main).setLayoutData((Object)new GridData(4, 1, true, false));
        this.diffNodeUI.createOptionComposite(main).setLayoutData((Object)new GridData(4, 1, true, false));
        this.diffNodeUI.createToolbar(main).setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridLayout)main.getLayout()).verticalSpacing = 0;
        main.setLayoutData((Object)new GridData(1808));
        CheckboxTreeViewer diffViewer = this.diffNodeUI.createViewer(main);
        diffViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.setControl((Control)main);
    }

    private ReverseListener getReverseListener(MessageConsole console) {
        return new MessageConsoleReverseListener(console){

            @Override
            public String getMessage(ReverseEvent event) {
                return "Selective reverse  " + event.objectType + " : " + String.valueOf(event.data);
            }
        };
    }

    public MdDiffNodeUI.DiffState computeDiffState(MdDiffNodeUI.IVisitorHandler handler, List<String> defTypeToDelete) throws Exception {
        return this.diffNodeUI.computeDiffState(handler, defTypeToDelete);
    }

    public int getCheckedElementsCount() {
        return this.diffNodeUI.getViewerHelper().getCheckedElements().length;
    }

    public AttributeRefResolver getAttributeRefResolver() {
        return this.attributeRefResolver;
    }

    public void setCompositeDataStore(SchemaDatastoreReverserComposite compositeDataStore) {
        this.compositeDataStore = compositeDataStore;
    }
}

