/*
 * Decompiled with CFR 0.152.
 */
package com.indy.md.rdbms;

import com.indy.jdbc.editor.Activator;
import com.indy.md.rdbms.Messages;
import com.indy.md.rdbms.PatternUtil;
import com.indy.md.rdbms.ResultSetWrapper;
import com.indy.md.rdbms.ScriptEngineReverseAPI;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.services.IXPathEvaluationService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.ParameterBuilder;
import com.stambia.md.Attribute;
import com.stambia.md.Configuration;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.custom.AttributeRefResolver;
import com.stambia.md.custom.MdReverse;
import com.stambia.md.custom.Util;
import com.stambia.md.custom.exception.ReverseException;
import com.stambia.md.impl.custom.CustomMdNode;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.md.util.XPathExpressionHelper;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import com.stambia.tech.XpathExpression;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.jdom.Element;

public class JdbcReverse
extends MdReverse {
    MdNode node;
    private Connection jdbcConnection;
    protected String schemaName;
    protected String catalogName;
    private boolean hasCatalog = false;
    private boolean hasSchema;
    private Configuration product;
    private Configuration schema;
    private HashMap<String, List<MdNode>> queryMap;
    private Map<Attribute, List<ReferenceResolver>> referenceResolver;
    private List<MdNode> reversedNode;
    private final Logger logger = LogManager.getLogger((String)"com.indy.reverse");
    static final String RDBMS_TYPE = "com.stambia.rdbms";
    public static final String RDBMS_SERVER_TYPE = "com.stambia.rdbms.server";
    static final String RDBMS_SERVER_SCHEMA_FILTER = "com.stambia.rdbms.server.schemaFilter";
    public static final String RDBMS_SCHEMA_TYPE = "com.stambia.rdbms.schema";
    public static final String RDBMS_CATALOG_TYPE = "com.stambia.rdbms.catalog";
    static final String RDBMS_SCHEMA_DATASTORE_FILTER = "com.stambia.rdbms.schema.dataStoreFilter";
    public static final String RDBMS_SCHEMA_NAME = "com.stambia.rdbms.schema.name";
    public static final String RDBMS_CATALOG_NAME = "com.stambia.rdbms.schema.catalog.name";
    public static final String RDBMS_LINKED_SERVER = "com.stambia.rdbms.schema.linkedServer";
    static final String RDBMS_DATASTORE_TYPE = "com.stambia.rdbms.datastore";
    static final String RDBMS_DATAVIEW_TYPE = "com.stambia.rdbms.dataview";
    static final String RDBMS_QUERY_TYPE = "com.stambia.rdbms.query";
    static final String RDBMS_COLUMN_TYPE = "com.stambia.rdbms.column";
    static final String RDBMS_COLUMN_PK = "com.stambia.rdbms.column.pk";
    static final String RDBMS_PK_TYPE = "com.stambia.rdbms.pk";
    static final String RDBMS_FK_TYPE = "com.stambia.rdbms.fk";
    static final String RDBMS_RELATION_TYPE = "com.stambia.rdbms.relation";
    static final String RDBMS_RELATION_FK_TYPE = "com.stambia.rdbms.relation.fk";
    static final String RDBMS_RELATION_PK_TYPE = "com.stambia.rdbms.relation.pk";
    static final String RDBMS_COL_REF_TYPE = "com.stambia.rdbms.colref";
    static final String RDBMS_COL_REF_REF_TYPE = "com.stambia.rdbms.colref.ref";
    static final String RDBMS_OWNER = "jdbc.owner";
    static final int ADD_ATTRIBUTE_REVERSE_MODE = 1;
    static final int ADD_ATTRIBUTE_CODE_MODE = 2;
    static final int ADD_ATTRIBUTE_DISPLAY_MODE = 3;
    public static final String RDBMS_DATASTORETYPE_TYPE = "getDataStoreTypes";
    private static final int REVERSE_COLUMN_RESULTSET_MODE = 0;
    private static final int REVERSE_COLUMN_SELECT_MODE = 1;
    private static final int REVERSE_COLUMN_QUERY_MODE = 2;
    public static final String RDBMS_FUNCTION_FOLDER_TYPE = "com.stambia.rdbms.functionFolder";
    private static final String RDBMS_FUNCTION_TYPE = "com.stambia.rdbms.function";
    ResultSetWrapper.InfoMode dbdmInfoMode = ResultSetWrapper.InfoMode.columnLabel;
    List<Statement> listStatements = new ArrayList<Statement>();
    private int reverseColumnMode;
    Map<String, _Statement> cacheStatement = new HashMap<String, _Statement>();
    Map<MdNode, Map<String, String>> properties = new HashMap<MdNode, Map<String, String>>();
    private List<MdNode> referenceAlreadyReversed = new ArrayList<MdNode>();

    DatabaseMetaData getDatabaseMetaData() throws SQLException {
        return this.jdbcConnection.getMetaData();
    }

    private boolean connect() {
        return this.isConnected();
    }

    public List<String> getChildren(String type, String parentName, String nameFilter, String ... typesFilter) throws ReverseException {
        if (this.connect()) {
            try {
                ArrayList<String> children = new ArrayList<String>();
                boolean override = false;
                try {
                    List currentList = (List)this.node.evaluateMdSet("ancestor-or-self::product[1]/reverseQuery[level='" + type + "' and @selectionQuery!='']");
                    for (MdNode elt : currentList) {
                        boolean enable = false;
                        String condition = elt.evaluate("@xpathSelectionCondition");
                        enable = condition != null && !condition.isEmpty() ? this.node.evaluateMdBoolean(condition) : true;
                        if (!enable) continue;
                        if (elt.evaluateMdBoolean("@overrideStandardSelection='true'")) {
                            override = true;
                        }
                        String query = elt.evaluateMdString("@selectionQuery");
                        query = query.replaceAll("\\{reverse:filter\\(\\)\\}", nameFilter);
                        query = PatternUtil.pattern((Configuration)this.node, query);
                        Throwable throwable = null;
                        Object var14_22 = null;
                        try (Statement st = this.jdbcConnection.createStatement();){
                            Throwable throwable2 = null;
                            Object var17_27 = null;
                            try (ResultSet rs = st.executeQuery(query);){
                                while (rs.next()) {
                                    children.add(rs.getString(1));
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                }
                catch (Exception e) {
                    Activator.error(Messages.JdbcReverse_reverseError, e);
                    throw new ReverseException((Throwable)e);
                }
                if (!override) {
                    if (type.equals(RDBMS_DATASTORETYPE_TYPE)) {
                        this.debug("getTableTypes start");
                        ResultSetWrapper rs = ResultSetWrapper.createWrapper(this.getDatabaseMetaData().getTableTypes(), this.dbdmInfoMode, ResultSetWrapper.Type.TABLE_TYPE);
                        this.debug("getTableTypes end");
                        this.debug("getTableTypes read resultset: start");
                        int i = 1;
                        while (rs.next()) {
                            this.debug("read line[" + i++ + "]");
                            Map<String, String> map = this.getProperties(rs);
                            String _type = map.get("TABLE_TYPE");
                            String string = _type = _type == null ? map.get("TYPE") : _type;
                            if (_type == null || children.contains(_type)) continue;
                            children.add(_type);
                        }
                        this.debug("getTableTypes read resultset: end");
                    }
                    if ((type.equals(RDBMS_SCHEMA_TYPE) || type.equals(RDBMS_SCHEMA_NAME)) && this.hasSchema) {
                        children.addAll(this.getSchemaList(parentName, nameFilter));
                    } else if ((type.equals(RDBMS_CATALOG_TYPE) || type.equals(RDBMS_CATALOG_NAME)) && this.hasCatalog) {
                        children.addAll(this.getCatalogList());
                    } else if (type.equals(RDBMS_DATASTORE_TYPE)) {
                        children.addAll(this.getDataStoreList(nameFilter, typesFilter));
                    } else if (type.equals(RDBMS_FUNCTION_FOLDER_TYPE)) {
                        try {
                            children.addAll(this.getFunctionList(nameFilter));
                        }
                        catch (Exception ex) {
                            this.logger.warn("unexpected", (Throwable)ex);
                        }
                    }
                }
                return children;
            }
            catch (SQLException e) {
                Activator.error(Messages.JdbcReverse_reverseError, e);
                throw new ReverseException(Messages.JdbcReverse_41, (Exception)e);
            }
        }
        ReverseException e = new ReverseException(Messages.JdbcReverse_42);
        Activator.error(Messages.JdbcReverse_reverseError, (Throwable)e);
        throw e;
    }

    private boolean addReferenceResolver(Attribute attr, ReferenceResolver rr) {
        if (attr != null && attr.getTechProperty().getReverseUpdateXpathQuery() != null && !attr.getTechProperty().getReverseUpdateXpathQuery().isEmpty()) {
            List<ReferenceResolver> list = this.referenceResolver.get(attr);
            if (list == null) {
                list = new ArrayList<ReferenceResolver>();
                this.referenceResolver.put(attr, list);
            }
            list.add(rr);
            return true;
        }
        return false;
    }

    public List<MdNode> doReverse(Object[] selectedChildren) throws ReverseException {
        this.referenceResolver = new HashMap<Attribute, List<ReferenceResolver>>();
        if (this.connect()) {
            try {
                ArrayList<MdNode> result = new ArrayList<MdNode>();
                HashMap<String, ArrayList<String>> objectToReverse = new HashMap<String, ArrayList<String>>();
                if (selectedChildren.length > 0 && selectedChildren[0] instanceof MdNode) {
                    Object[] objectArray = selectedChildren;
                    int n = selectedChildren.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object ob = objectArray[n2];
                        List<String> list = (List)objectToReverse.get(((MdNode)ob).getDefType());
                        if (list == null) {
                            list = new ArrayList<String>();
                            objectToReverse.put(((MdNode)ob).getDefType(), (ArrayList<String>)list);
                        }
                        list.add(((MdNode)ob).getName());
                        ++n2;
                    }
                }
                boolean reverseFk = this.getProperties().getProperty("reverseFk") == null || !this.getProperties().getProperty("reverseFk").equals("false");
                boolean reverseUserFunctions = this.getProperties().getProperty("reverseUserFunctions") != null && this.getProperties().getProperty("reverseUserFunctions").equals("true");
                boolean reverseDBFunctions = this.getProperties().getProperty("reverseRdbmsFunctions") != null && this.getProperties().getProperty("reverseRdbmsFunctions").equals("true");
                for (Map.Entry entry : objectToReverse.entrySet()) {
                    if (((String)entry.getKey()).equals(RDBMS_DATASTORE_TYPE)) {
                        this.reversedNode = new ArrayList<MdNode>();
                        ArrayList<String> unresolvedTable = new ArrayList<String>();
                        ArrayList<MdNode> list = new ArrayList<MdNode>();
                        List<Object> precList = new ArrayList();
                        Object[] tempSelectedChildren = ((List)entry.getValue()).toArray();
                        this.referenceAlreadyReversed.clear();
                        while (tempSelectedChildren.length > 0) {
                            List<MdNode> tmpList = this.reverseDataStores(tempSelectedChildren);
                            if (reverseFk) {
                                for (MdNode node : tmpList) {
                                    unresolvedTable.addAll(this.addFKs(node));
                                }
                            }
                            tempSelectedChildren = unresolvedTable.toArray();
                            unresolvedTable = new ArrayList();
                            if (reverseFk) {
                                for (MdNode node : precList) {
                                    this.addFKs(node);
                                }
                            }
                            list.addAll(tmpList);
                            precList = tmpList;
                        }
                        this.referenceAlreadyReversed.clear();
                        result.addAll(list);
                        continue;
                    }
                    if (((String)entry.getKey()).equals(RDBMS_QUERY_TYPE)) {
                        this.reversedNode = new ArrayList<MdNode>();
                        ArrayList<MdNode> list = new ArrayList<MdNode>();
                        Object[] tempSelectedChildren = ((List)entry.getValue()).toArray();
                        this.referenceAlreadyReversed.clear();
                        List<MdNode> tmpList = this.reverseQueries(tempSelectedChildren);
                        list.addAll(tmpList);
                        this.referenceAlreadyReversed.clear();
                        result.addAll(list);
                        continue;
                    }
                    if (((String)entry.getKey()).equals(RDBMS_SCHEMA_TYPE)) {
                        Object[] tempSelectedChildren = ((List)entry.getValue()).toArray();
                        this.reversedNode = new ArrayList<MdNode>();
                        result.addAll(this.reverseSchema(tempSelectedChildren));
                        continue;
                    }
                    if (((String)entry.getKey()).equals(RDBMS_FUNCTION_FOLDER_TYPE)) {
                        this.reversedNode = new ArrayList<MdNode>();
                        if (reverseUserFunctions) {
                            folderNode = MdFactory.eINSTANCE.createMdNode();
                            folderNode.setDefType(RDBMS_FUNCTION_FOLDER_TYPE);
                            folderNode.setName("User");
                            att = MdFactory.eINSTANCE.createAttribute();
                            att.setDefType(folderNode.getDefType() + ".type");
                            att.setValue("User");
                            folderNode.getAttribute().add((Object)att);
                            folderNode.setSubstituteContainer((EObject)this.node);
                            folderNode.getNode().addAll(this.reverseFunctions());
                            this.reversedNode.add(folderNode);
                        } else if (reverseDBFunctions) {
                            folderNode = MdFactory.eINSTANCE.createMdNode();
                            folderNode.setDefType(RDBMS_FUNCTION_FOLDER_TYPE);
                            att = MdFactory.eINSTANCE.createAttribute();
                            att.setDefType(folderNode.getDefType() + ".type");
                            att.setValue("Standard");
                            folderNode.setName("Standard");
                            folderNode.getAttribute().add((Object)att);
                            folderNode.setSubstituteContainer((EObject)this.node);
                            try {
                                folderNode.getNode().addAll(this.reverseStandardFunctions());
                            }
                            catch (Exception ex) {
                                this.logger.warn("unexpected", (Throwable)ex);
                            }
                            this.reversedNode.add(folderNode);
                        }
                        result.addAll(this.reversedNode);
                        continue;
                    }
                    for (String name : (List)entry.getValue()) {
                        MdNode newNode = MdFactoryHelper.createMdNode((String)((String)entry.getKey()));
                        newNode.setName(name);
                        newNode.setSubstituteContainer(this.node.eContainer());
                        this.reverseSpe(newNode, name, null);
                        result.add(newNode);
                    }
                }
                List<ScriptEngineReverseAPI.ReverseScript> list = this.searchReverseScript(result);
                if (!list.isEmpty()) {
                    ScriptEngineReverseAPI serh = new ScriptEngineReverseAPI();
                    serh.reverseWithScript(list, result);
                }
                return result;
            }
            catch (XPathExpressionException e) {
                this.logger.error(Messages.JdbcReverse_reverseError, (Throwable)e);
                throw new ReverseException(Messages.JdbcReverse_reverseError + e.getMessage(), (Exception)e);
            }
            catch (Exception e) {
                this.logger.error(Messages.JdbcReverse_reverseError, (Throwable)e);
                throw new ReverseException(Messages.JdbcReverse_reverseError + e.getMessage(), e);
            }
        }
        return null;
    }

    public List<ScriptEngineReverseAPI.ReverseScript> searchReverseScript(List<MdNode> result) throws XPathExpressionException {
        ArrayList<ScriptEngineReverseAPI.ReverseScript> queryScript = new ArrayList<ScriptEngineReverseAPI.ReverseScript>();
        List _list2 = (List)this.node.evaluateMdSet("ancestor-or-self::product[1]/reverseScript");
        Iterator iterator = _list2.iterator();
        while (iterator.hasNext()) {
            MdNode elt;
            MdNode _node = elt = (MdNode)iterator.next();
            List list3 = (List)_node.evaluateMdSet("level");
            ScriptEngineReverseAPI.ReverseScript rs = new ScriptEngineReverseAPI.ReverseScript(this.node, this.jdbcConnection);
            for (Element elt3 : list3) {
                String code = elt3.getText();
                rs.levels.add(code);
            }
            rs.language = elt.evaluate("@language");
            rs.script = elt.evaluate("@script");
            queryScript.add(rs);
        }
        return queryScript;
    }

    private Collection<? extends MdNode> reverseStandardFunctions() throws ReverseException {
        ArrayList<MdNode> l = new ArrayList<MdNode>();
        try {
            Attribute attr;
            MdNode n;
            String s;
            DatabaseMetaData dbmd = this.getDatabaseMetaData();
            String[] stringArray = dbmd.getStringFunctions().split(",");
            if (stringArray.length != 0) {
                s = stringArray[0];
                MdNode n2 = MdFactory.eINSTANCE.createMdNode();
                n2.setDefType(RDBMS_FUNCTION_TYPE);
                n2.setName(s);
                l.add(n2);
                Attribute attr2 = MdFactory.eINSTANCE.createAttribute();
                attr2.setDefType("com.stambia.rdbms.function.categoryType");
                attr2.setValue("String");
                n2.getAttribute().add((Object)attr2);
            }
            String[] stringArray2 = dbmd.getNumericFunctions().split(",");
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                s = stringArray2[n4];
                n = MdFactory.eINSTANCE.createMdNode();
                n.setDefType(RDBMS_FUNCTION_TYPE);
                n.setName(s);
                l.add(n);
                attr = MdFactory.eINSTANCE.createAttribute();
                attr.setDefType("com.stambia.rdbms.function.categoryType");
                attr.setValue("Numeric");
                n.getAttribute().add((Object)attr);
                ++n4;
            }
            stringArray2 = dbmd.getTimeDateFunctions().split(",");
            n3 = stringArray2.length;
            n4 = 0;
            while (n4 < n3) {
                s = stringArray2[n4];
                n = MdFactory.eINSTANCE.createMdNode();
                n.setDefType(RDBMS_FUNCTION_TYPE);
                n.setDefType(RDBMS_FUNCTION_TYPE);
                n.setName(s);
                l.add(n);
                attr = MdFactory.eINSTANCE.createAttribute();
                attr.setDefType("com.stambia.rdbms.function.categoryType");
                attr.setValue("TimeDate");
                n.getAttribute().add((Object)attr);
                ++n4;
            }
            stringArray2 = dbmd.getSystemFunctions().split(",");
            n3 = stringArray2.length;
            n4 = 0;
            while (n4 < n3) {
                s = stringArray2[n4];
                n = MdFactory.eINSTANCE.createMdNode();
                n.setDefType(RDBMS_FUNCTION_TYPE);
                n.setDefType(RDBMS_FUNCTION_TYPE);
                n.setName(s);
                l.add(n);
                attr = MdFactory.eINSTANCE.createAttribute();
                attr.setDefType("com.stambia.rdbms.function.categoryType");
                attr.setValue("System");
                n.getAttribute().add((Object)attr);
                ++n4;
            }
        }
        catch (Exception ex) {
            throw new ReverseException(Messages.JdbcReverse_89, ex);
        }
        return l;
    }

    private List<MdNode> reverseFunctions() {
        ArrayList<MdNode> result;
        block19: {
            result = new ArrayList<MdNode>();
            Level fnLvl = null;
            ResultSet rs = null;
            try {
                try {
                    HashMap<String, MdNode> functions = new HashMap<String, MdNode>();
                    rs = ResultSetWrapper.createWrapper(this.getDatabaseMetaData().getFunctions(this.catalogName, this.schemaName, "%"), this.dbdmInfoMode, ResultSetWrapper.Type.FUNCTION);
                    if (rs != null) {
                        while (rs.next()) {
                            String schName = rs.getString("FUNCTION_SCHEM");
                            if (schName == null ? this.schemaName != null && !this.schemaName.isEmpty() : !schName.equals(this.schemaName)) continue;
                            String name = rs.getString("FUNCTION_NAME");
                            MdNode functionNode = MdFactory.eINSTANCE.createMdNode();
                            functionNode.setName(name);
                            functionNode.setDefType(RDBMS_FUNCTION_TYPE);
                            functions.put(functionNode.getName(), functionNode);
                        }
                        rs.close();
                    }
                    if (!functions.isEmpty()) {
                        rs = ResultSetWrapper.createWrapper(this.getDatabaseMetaData().getFunctionColumns(this.catalogName, this.schemaName, "%", "%"), this.dbdmInfoMode, ResultSetWrapper.Type.FUNCTION);
                        if (rs != null) {
                            while (rs.next()) {
                                MdNode functionNode = (MdNode)functions.get(rs.getString("FUNCTION_NAME"));
                                if (fnLvl == null) {
                                    fnLvl = functionNode.getLevel(this.node.eResource());
                                }
                                MdNode param = MdFactory.eINSTANCE.createMdNode();
                                param.setName(rs.getString("COLUMN_NAME"));
                                param.setDefType("com.stambia.rdbms.function.parameter");
                                functionNode.getNode().add((Object)param);
                                Level lvl = param.getLevel(this.node.eResource());
                                for (Property p : lvl.getAttribute()) {
                                    if (p.getReverseCode() == null || p.getReverseCode().isEmpty()) continue;
                                    Attribute a = MdFactory.eINSTANCE.createAttribute();
                                    a.setDefType("com.stambia.rdbms.function.parameter." + p.getCode());
                                    a.setValue(rs.getString(p.getReverseCode()));
                                    param.getAttribute().add((Object)a);
                                }
                            }
                        }
                        result.addAll(functions.values());
                    }
                }
                catch (SQLException ex) {
                    this.warn("close", ex);
                    if (rs == null) break block19;
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        this.warn("close", e);
                    }
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e) {
                        this.warn("close", e);
                    }
                }
            }
        }
        return result;
    }

    private void refreshQueryMap() {
        try {
            this.queryMap = new HashMap();
            List internalList2 = (List)this.node.evaluateMdSet("ancestor-or-self::product[1]/reverseQuery");
            Iterator iterator = internalList2.iterator();
            while (iterator.hasNext()) {
                MdNode elt;
                MdNode internalNode = elt = (MdNode)iterator.next();
                List list3 = (List)internalNode.evaluateMdSet("level");
                for (Element elt3 : list3) {
                    String code = elt3.getText();
                    List<MdNode> list = this.queryMap.get(code);
                    if (list == null) {
                        list = new ArrayList<MdNode>();
                        this.queryMap.put(code, list);
                    }
                    list.add(internalNode);
                }
            }
        }
        catch (XPathExpressionException e) {
            Activator.warning(Messages.JdbcReverse_reverseWarning, e);
        }
    }

    private List<String> getQuery(String code) {
        ArrayList<String> queryList = new ArrayList<String>();
        try {
            this.queryMap = new HashMap();
            List _list = (List)this.node.evaluateMdSet("ancestor-or-self::product[1]/reverseQuery[level='" + code + "']");
            List _list2 = (List)this.node.evaluateMdSet("ancestor-or-self::product[1]/reverseQuery");
            Iterator iterator = _list2.iterator();
            while (iterator.hasNext()) {
                MdNode elt;
                MdNode _node = elt = (MdNode)iterator.next();
                String _code = _node.getDefType();
                List<MdNode> list = this.queryMap.get(elt.getDefType());
                if (list == null) {
                    list = new ArrayList<MdNode>();
                    this.queryMap.put(elt.getDefType(), list);
                }
                list.add(_node);
            }
        }
        catch (XPathExpressionException e) {
            Activator.warning(Messages.JdbcReverse_reverseWarning, e);
        }
        return queryList;
    }

    private ResultSet getQueryResultSet(Configuration node, String query) throws SQLException, XPathExpressionException {
        _Statement _st = this.cacheStatement.get(query);
        boolean bind = query.contains(":{");
        if (bind) {
            if (_st == null && bind) {
                String query3;
                _st = new _Statement();
                String query2 = PatternUtil.pattern2(query, _st.expressions);
                _st.query = query3 = PatternUtil.pattern(node, query2);
                _st.st = this.jdbcConnection.prepareStatement(query3);
                this.cacheStatement.put(query, _st);
                this.listStatements.add(_st.st);
            }
            this.debug("Executing query: " + _st.query);
            ResultSet rsSpe = _st.executeQuery(node);
            this.debug("Executing query end");
            return rsSpe;
        }
        String query2 = PatternUtil.pattern(node, query);
        Statement st = this.jdbcConnection.createStatement();
        this.listStatements.add(st);
        this.debug("Executing query: " + query2);
        ResultSet rsSpe = st.executeQuery(query2);
        this.debug("Executing query end");
        return rsSpe;
    }

    private List<MdNode> reverseSchema(Object[] selectedChildren) throws SQLException, ReverseException {
        String debugMessage;
        ResultSetWrapper.Type type;
        ResultSet metadataResultset;
        List<MdNode> retour = this.reversedNode;
        boolean mode = false;
        if (this.hasCatalog) {
            mode = true;
        }
        if (mode) {
            this.debug("getCatalogs start");
            metadataResultset = this.getDatabaseMetaData().getCatalogs();
            type = ResultSetWrapper.Type.CATALOG;
            debugMessage = "getCatalogs end";
        } else {
            this.debug("getSchemas start");
            metadataResultset = this.getDatabaseMetaData().getSchemas();
            type = ResultSetWrapper.Type.SCHEMA;
            debugMessage = "getSchemas end";
        }
        int i = 1;
        Throwable throwable = null;
        Object var9_10 = null;
        try (ResultSetWrapper rs = ResultSetWrapper.createWrapper(metadataResultset, this.dbdmInfoMode, type);){
            this.debug(debugMessage);
            while (rs.next()) {
                String catalogName;
                MdNode schemaNode;
                String schemaName;
                this.debug("read line[" + i++ + "]");
                Map<String, String> map = this.getProperties(rs);
                if (!mode && this.contains(selectedChildren, schemaName = map.get("TABLE_SCHEM"))) {
                    this.fireObjectReverseStarted(schemaName, "schema");
                    schemaNode = MdFactory.eINSTANCE.createMdNode();
                    schemaNode.setSubstituteContainer((EObject)this.node);
                    schemaNode.setName(schemaName);
                    schemaNode.setDefType(RDBMS_SCHEMA_TYPE);
                    retour.add(schemaNode);
                    this.addAttributes(schemaNode, map);
                    this.reverseSpe(schemaNode, schemaName, map);
                }
                if (!mode || !this.contains(selectedChildren, catalogName = map.get("TABLE_CAT"))) continue;
                this.fireObjectReverseStarted(catalogName, "schema");
                schemaNode = MdFactory.eINSTANCE.createMdNode();
                schemaNode.setName(catalogName);
                schemaNode.setDefType(RDBMS_SCHEMA_TYPE);
                retour.add(schemaNode);
                this.addAttributes(schemaNode, map);
                this.reverseSpe(schemaNode, catalogName, map);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return retour;
    }

    private boolean nodeAlreadyReversed(String name, String type) {
        return this.getReversedNode(name, type) != null;
    }

    private MdNode getReversedNode(String name, String type) {
        if (this.reversedNode != null) {
            for (MdNode _node : this.reversedNode) {
                if (_node.getName() == null || _node.getDefType() == null || !_node.getName().equals(name) || !_node.getDefType().equals(type)) continue;
                return _node;
            }
        }
        return null;
    }

    protected MdNode createMdNode(String defType) {
        return MdFactoryHelper.createMdNode((String)defType);
    }

    private List<MdNode> reverseDataStores(Object[] selectedChildren) throws SQLException, ReverseException {
        if (selectedChildren != null && selectedChildren.length > 0) {
            HashSet<String> datastoreToReverse = new HashSet<String>();
            Object[] objectArray = selectedChildren;
            int n = selectedChildren.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                datastoreToReverse.add((String)o);
                ++n2;
            }
            selectedChildren = new String[datastoreToReverse.size()];
            datastoreToReverse.toArray(selectedChildren);
            this.fireReverseStarted(selectedChildren, "datastores");
            List<MdNode> retour = this.reversedNode;
            this.info("Datastores to reverse:");
            int i = 0;
            while (i < selectedChildren.length) {
                this.info("\t" + String.valueOf(selectedChildren[i]));
                ++i;
            }
            i = 0;
            while (i < selectedChildren.length) {
                if (this.isCanceled()) {
                    return Collections.emptyList();
                }
                this.info("Reverse datastore: " + String.valueOf(selectedChildren[i]));
                this.fireObjectReverseStarted((String)selectedChildren[i], "dataStore");
                if (!this.nodeAlreadyReversed((String)selectedChildren[i], RDBMS_DATASTORE_TYPE)) {
                    Map<ResultSet, Map<String, String>> mapResultSets = this.initMapResultSet(this.schema, RDBMS_DATASTORE_TYPE, (String)selectedChildren[i], true);
                    ArrayList<MdNode> list = new ArrayList<MdNode>();
                    MdNode internalTableNode = this.createMdNode(RDBMS_DATASTORE_TYPE);
                    Level internalLevel = internalTableNode.getLevel(this.node.eResource());
                    String reverseCode = null;
                    if (internalLevel.getReverseCode() != null && !internalLevel.getReverseCode().isEmpty()) {
                        reverseCode = internalLevel.getReverseCode();
                    }
                    int j = 1;
                    if (reverseCode != null) {
                        if (!mapResultSets.isEmpty()) {
                            this.debug("getTables start: use specific query");
                        } else {
                            this.debug("getTables start: catalog: " + this.catalogName + " schema:" + this.schemaName + " table: " + String.valueOf(selectedChildren[i]));
                        }
                        Throwable throwable = null;
                        Iterator iterator = null;
                        try (ResultSet rs = mapResultSets.isEmpty() ? ResultSetWrapper.createWrapper(this.getDatabaseMetaData().getTables(this.catalogName, this.schemaName, (String)selectedChildren[i], null), this.dbdmInfoMode, ResultSetWrapper.Type.TABLE) : mapResultSets.keySet().iterator().next();){
                            this.debug("getTables end");
                            while (rs.next()) {
                                this.debug("read line[" + j++ + "]");
                                Map<String, String> map = this.getProperties(rs);
                                String tableName = map.get(reverseCode);
                                this.info("Reverse datastore: " + tableName);
                                if (tableName == null || !tableName.equals(selectedChildren[i])) continue;
                                this.info("Reverse datastore: " + String.valueOf(selectedChildren[i]) + " found");
                                MdNode tableNode = this.createMdNode(RDBMS_DATASTORE_TYPE);
                                for (Map.Entry<String, String> entry : map.entrySet()) {
                                    this.info("property: " + entry.getKey() + " = " + entry.getValue());
                                }
                                this.properties.put(tableNode, map);
                                this.addAttributes(tableNode, map);
                                tableNode.setSubstituteContainer((EObject)this.node);
                                tableNode.setName(tableName);
                                this.reverseSpe(tableNode, tableName, map);
                                list.add(tableNode);
                                break;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    for (MdNode tableNode : list) {
                        this.addColumns(tableNode);
                        this.addPKs(tableNode);
                    }
                    retour.addAll(list);
                }
                this.fireObjectReverseEnded((String)selectedChildren[i], "dataStore");
                ++i;
            }
            return retour;
        }
        return null;
    }

    private List<MdNode> reverseQueries(Object[] selectedChildren) throws SQLException, ReverseException {
        if (selectedChildren != null && selectedChildren.length > 0) {
            this.fireReverseStarted(selectedChildren, "queries");
            List<MdNode> retour = this.reversedNode;
            this.info("Queries to reverse:");
            int i = 0;
            while (i < selectedChildren.length) {
                this.info("\t" + String.valueOf(selectedChildren[i]));
                ++i;
            }
            i = 0;
            while (i < selectedChildren.length) {
                if (this.isCanceled()) {
                    return Collections.EMPTY_LIST;
                }
                this.info("Reverse Query: " + String.valueOf(selectedChildren[i]));
                this.fireObjectReverseStarted((String)selectedChildren[i], "query");
                ArrayList<MdNode> list = new ArrayList<MdNode>();
                if (!this.nodeAlreadyReversed((String)selectedChildren[i], RDBMS_QUERY_TYPE)) {
                    MdNode tableNode = MdFactoryHelper.createMdNode((String)RDBMS_QUERY_TYPE);
                    tableNode.setName((String)selectedChildren[i]);
                    tableNode.setSubstituteContainer(this.node.getSubstituteContainer());
                    Attribute a = MdFactoryHelper.createAttribute((String)"com.stambia.rdbms.query.expression");
                    Attribute a2 = this.node.getAttributeByCode(a.getDefType());
                    a.setValue(a2.getValue());
                    tableNode.getAttribute().add((Object)a);
                    list.add(tableNode);
                }
                this.reverseColumnMode = 2;
                for (MdNode tableNode : list) {
                    this.addColumns(tableNode);
                }
                retour.addAll(list);
                this.fireObjectReverseEnded((String)selectedChildren[i], "query");
                ++i;
            }
            return retour;
        }
        return null;
    }

    private Map<ResultSet, Map<String, String>> initMapResultSet(Configuration context, String defType, String name, boolean override) {
        HashMap<ResultSet, Map<String, String>> resultSets = new HashMap<ResultSet, Map<String, String>>();
        List<MdNode> queryList = this.queryMap.get(defType);
        if (queryList != null) {
            this.debug("find query for defType: " + defType + " override: " + override);
            for (MdNode query : queryList) {
                boolean enable = false;
                String query2 = null;
                HashMap<String, String> breaks = new HashMap<String, String>();
                try {
                    enable = query.evaluateMdBoolean("@overrideStandard='true'") == override;
                    this.debug("Enable: " + enable);
                    query2 = query.evaluate("@query");
                    if (query2 == null || query2.isEmpty()) {
                        enable = false;
                    } else {
                        this.debug("Query: " + query2);
                        for (MdNode _break : (List)query.evaluateMdSet("break")) {
                            String level = _break.evaluate("@level");
                            this.debug("Level: " + level);
                            String alias = _break.evaluate("@name");
                            this.debug("Alias: " + alias);
                            breaks.put(level, alias);
                        }
                        if (enable) {
                            String condition = query.evaluate("@xpathCondition");
                            this.debug("Condition: " + condition);
                            if (condition != null && !condition.isEmpty()) {
                                this.debug("Evaluaute condition: " + condition);
                                enable = context.evaluateMdBoolean(condition);
                                this.debug("Evaluaute condition result: " + enable);
                            }
                        }
                    }
                }
                catch (XPathExpressionException e) {
                    this.warn("during initMapResultSet", e);
                    Activator.warning(" during reverse", e);
                }
                if (!enable) continue;
                name = name.replace("\\$", "\u00a4\u00a3\u00a4");
                if (query2 == null) continue;
                query2 = query2.replaceAll("\\{reverse:filter\\(\\)\\}", name);
                query2 = query2.replace("\u00a4\u00a3\u00a4", "\\$");
                this.debug("Query after filter replacment: " + query2);
                ResultSet rsSpe = null;
                try {
                    this.debug("Execute specific query: start");
                    rsSpe = this.getQueryResultSet(context, query2);
                    this.debug("Execute specific query: end");
                }
                catch (Exception e) {
                    this.warn("Error during executing query: " + query2, e);
                    Activator.warning("Warning during reverse", e);
                }
                if (rsSpe == null) continue;
                resultSets.put(rsSpe, breaks);
            }
        }
        return resultSets;
    }

    private void reverseSpe(MdNode newNode, String name, Map<String, String> _map) throws SQLException, ReverseException {
        try {
            Map<ResultSet, Map<String, String>> resultSets = this.initMapResultSet((Configuration)newNode, newNode.getDefType(), name, false);
            for (Map.Entry<ResultSet, Map<String, String>> rsSpe : resultSets.entrySet()) {
                this.boucle(rsSpe.getKey(), newNode, _map, rsSpe.getValue());
            }
        }
        catch (Exception e) {
            Activator.error("Error during reverse", e);
            throw new ReverseException((Throwable)e);
        }
    }

    private boolean boucle(ResultSet rs, MdNode node, Map<String, String> _map, Map<String, String> breaks) throws SQLException, ReverseException {
        boolean next = false;
        while (rs.next()) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (_map != null) {
                map.putAll(_map);
            }
            map.putAll(this.getProperties(rs));
            this.recursiveReverse(node, map, breaks);
        }
        rs.close();
        return true;
    }

    private void recursiveReverse(MdNode node, Map<String, String> map, Map<String, String> breaks) throws ReverseException, SQLException {
        this.addAttributes(node, map);
        List possibleChildren = node.getChildrenLevel();
        HashMap<String, Level> reverseChildrenCodes = new HashMap<String, Level>();
        MdNode childNode = null;
        for (Level level : possibleChildren) {
            String tmp1 = breaks.get(level.getCode());
            if (tmp1 == null || tmp1.isEmpty()) continue;
            reverseChildrenCodes.put(tmp1, level);
        }
        for (String reveseCode : reverseChildrenCodes.keySet()) {
            if (map.get(reveseCode) == null) continue;
            String tmp = map.get(reveseCode);
            Level level = (Level)reverseChildrenCodes.get(reveseCode);
            childNode = node.getNodeByName(level.getCode(), tmp);
            if (childNode == null) {
                String str;
                childNode = MdFactoryHelper.createMdNode((String)level.getCode());
                childNode.setName(tmp);
                if (level.getPositionReverseCode() != null && !level.getPositionReverseCode().isEmpty() && (str = map.get(level.getPositionReverseCode())) != null) {
                    try {
                        childNode.setPosition(BigInteger.valueOf(Integer.valueOf(str).intValue()));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                node.getNode().add((Object)childNode);
            }
            this.recursiveReverse(childNode, map, breaks);
        }
    }

    private Map<String, String> getProperties(ResultSet rs) throws SQLException {
        return this.getProperties(rs, Collections.EMPTY_SET);
    }

    Map<String, String> getProperties(ResultSet rs, Set<String> integers) throws SQLException {
        HashMap<String, String> map = new HashMap<String, String>();
        ResultSetMetaData resultSetMetaData = rs.getMetaData();
        int j = 1;
        while (j <= resultSetMetaData.getColumnCount()) {
            String label = resultSetMetaData.getColumnLabel(j);
            String type = label = label == null ? resultSetMetaData.getColumnName(j) : label;
            type = type != null ? type.toUpperCase() : type;
            String value = null;
            try {
                value = type != null && integers.contains(type) ? String.valueOf(rs.getInt(j)) : rs.getString(j);
            }
            catch (SQLException e) {
                String message = "Error impossible to get \"" + type + "\n Cause : " + e.getMessage();
                ReverseException r = new ReverseException(message, (Exception)e);
                Activator.warning("Warning during reverse", (Throwable)r);
            }
            if (value != null) {
                map.put(type, value);
            }
            ++j;
        }
        return map;
    }

    private void addAttributes(MdNode parameterNode, Map<String, String> map) throws ReverseException, SQLException {
        Level level = parameterNode.getLevel(this.node.eResource());
        String schema = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String type = entry.getKey();
            String value = map.get(type);
            String string = schema = type.equals("TABLE_SCHEM") ? value : null;
            if (value == null || level == null) continue;
            for (Property prop : Util.getPropertyByReverseCode((Level)level, (String)type)) {
                Attribute attr = parameterNode.getAttributeByFullCode(prop.getFullCode());
                if (attr == null) {
                    attr = MdFactory.eINSTANCE.createAttribute();
                    attr.setDefType(prop.getFullCode());
                    parameterNode.getAttribute().add((Object)attr);
                }
                if ("remarks".equals(prop.getCode())) {
                    String XML_0_INVALID_CHAR_PATTERN = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";
                    value = value.replaceAll(XML_0_INVALID_CHAR_PATTERN, "");
                }
                if (this.addReferenceResolver(attr, new ReferenceResolver(value, parameterNode, prop, map))) continue;
                attr.setValue(value);
            }
        }
        if (schema == null && this.schemaName != null) {
            this.addStringAttribute(parameterNode, this.schemaName, "TABLE_SCHEM", 1);
        }
    }

    private void addStringAttribute(MdNode InternalNode, String value, String type, int mode) {
        if (InternalNode != null) {
            Level currentLevel = InternalNode.getLevel(this.node.eResource());
            if (value != null && type != null) {
                List props = null;
                Property prop = null;
                if (currentLevel != null) {
                    switch (mode) {
                        case 1: {
                            props = Util.getPropertyByReverseCode((Level)currentLevel, (String)type);
                            break;
                        }
                        case 2: {
                            prop = Util.getPropertyByCode((Level)currentLevel, (String)type);
                            break;
                        }
                        case 3: {
                            prop = Util.getPropertyByDisplayName((Level)currentLevel, (String)type);
                        }
                    }
                }
                if (prop != null) {
                    Attribute attr = MdFactory.eINSTANCE.createAttribute();
                    attr.setValue(value);
                    attr.setDefType(prop.getFullCode());
                    if (!prop.isUnbounded()) {
                        InternalNode.getAttribute().clear();
                    }
                    InternalNode.getAttribute().add((Object)attr);
                } else if (props != null) {
                    for (Property prop2 : props) {
                        Attribute attr = MdFactory.eINSTANCE.createAttribute();
                        attr.setValue(value);
                        attr.setDefType(prop2.getFullCode());
                        if (!prop2.isUnbounded()) {
                            InternalNode.getAttribute().clear();
                        }
                        InternalNode.getAttribute().add((Object)attr);
                    }
                }
            }
        }
    }

    private void addRefAttribute(MdNode _node, MdNode ref, String type, int mode) {
        if (_node != null) {
            Level _level = _node.getLevel(this.node.eResource());
            if (ref != null && _node != null && type != null) {
                List props = null;
                Property prop = null;
                if (_level != null) {
                    switch (mode) {
                        case 1: {
                            props = Util.getPropertyByReverseCode((Level)_level, (String)type);
                            break;
                        }
                        case 2: {
                            prop = Util.getPropertyByCode((Level)_level, (String)type);
                            break;
                        }
                        case 3: {
                            prop = Util.getPropertyByDisplayName((Level)_level, (String)type);
                        }
                    }
                }
                if (prop != null) {
                    Attribute attr = MdFactory.eINSTANCE.createAttribute();
                    attr.setRef((EObject)ref);
                    attr.setDefType(prop.getFullCode());
                    _node.getAttribute().add((Object)attr);
                } else if (props != null) {
                    for (Property prop2 : props) {
                        Attribute attr = MdFactory.eINSTANCE.createAttribute();
                        attr.setRef((EObject)ref);
                        attr.setDefType(prop2.getFullCode());
                        _node.getAttribute().add((Object)attr);
                    }
                }
            }
        }
    }

    private void info(String msg) {
        this.logger.info(msg);
    }

    private void warn(String msg, Throwable t) {
        this.logger.warn(msg, t);
    }

    private void debug(String msg) {
        this.logger.debug(msg);
    }

    private List<String> addFKs(MdNode _node) throws SQLException {
        ArrayList<String> unresolvedTable = new ArrayList<String>();
        ResultSet rs = null;
        try {
            this.info("Reverse FK for: " + _node.getName());
            Map<ResultSet, Map<String, String>> mapResultSets = this.initMapResultSet((Configuration)_node, RDBMS_FK_TYPE, _node.getName(), true);
            if (mapResultSets.size() > 0) {
                this.debug("getImportedKeys start: use specific query");
                rs = mapResultSets.keySet().iterator().next();
            } else {
                this.debug("getImportedKeys start: catalog: " + this.catalogName + " schema:" + this.schemaName + " table: " + _node.getName());
                rs = ResultSetWrapper.createWrapper(this.getDatabaseMetaData().getImportedKeys(this.catalogName, this.schemaName, _node.getName()), this.dbdmInfoMode, ResultSetWrapper.Type.FK);
            }
            this.debug("getImportedKeys end");
        }
        catch (Exception e) {
            this.warn("Reverse FK Error for: " + _node.getName(), e);
            Activator.warning(Messages.JdbcReverse_reverseWarning, e);
            return Collections.EMPTY_LIST;
        }
        if (rs != null) {
            ArrayList<MdNode> currentref = new ArrayList<MdNode>();
            int i = 1;
            while (rs.next()) {
                this.debug("read line[" + i++ + "]");
                Map<String, String> map = this.getProperties(rs);
                String fkColumn = map.get("FKCOLUMN_NAME");
                String fkName = map.get("FK_NAME");
                String fkSeq = map.get("KEY_SEQ");
                String pkColumn = map.get("PKCOLUMN_NAME");
                String pkTableName = map.get("PKTABLE_NAME");
                String pkSchem = map.get("PKTABLE_SCHEM");
                String fkSchem = map.get("FKTABLE_SCHEM");
                String pkCatalog = map.get("PKTABLE_CAT");
                String fkCatalog = map.get("FKTABLE_CAT");
                fkSchem = fkSchem == null ? "" : fkSchem;
                pkSchem = pkSchem == null ? "" : pkSchem;
                fkCatalog = fkCatalog == null ? "" : fkCatalog;
                pkCatalog = pkCatalog == null ? "" : pkCatalog;
                this.debug(map.toString());
                if (pkSchem.equals(fkSchem) && pkCatalog.equals(fkCatalog) && fkSchem.equals(this.schemaName)) {
                    MdNode server;
                    MdNode schema;
                    EObject parent;
                    MdNode pkTableNode = this.node.getNodeByName(RDBMS_DATASTORE_TYPE, pkTableName);
                    if (pkTableNode == null && (parent = this.node.eContainer()) instanceof MdNode && (schema = this.findSchema(server = (MdNode)parent, pkCatalog, pkSchem)) != null && (pkTableNode = schema.getNodeByName(RDBMS_DATASTORE_TYPE, pkTableName)) != null) {
                        map.put("PKSCHEMA_ID", schema.getId());
                    }
                    if (pkTableNode == null) {
                        pkTableNode = this.getReversedNode(pkTableName, RDBMS_DATASTORE_TYPE);
                    }
                    if (pkTableName.equals(_node.getName())) {
                        pkTableNode = _node;
                    }
                    if (pkTableNode != null) {
                        MdNode fkNode = this.createOrUpdateFKNode(_node, fkName, fkSeq, fkColumn, map);
                        _node.getNodeByName(RDBMS_FK_TYPE, fkName);
                        if (fkNode == null) continue;
                        currentref.add(fkNode);
                        continue;
                    }
                    unresolvedTable.add(pkTableName);
                    continue;
                }
                if (!pkCatalog.equals(fkCatalog)) continue;
                try {
                    MdNode datastoreNode;
                    MdNode schemaNode;
                    Collection schemaNames = (Collection)_node.evaluateMdSet("../../schema/@TABLE_SCHEM/string()");
                    schemaNames.remove(this.schemaName);
                    if (!schemaNames.contains(pkSchem) || pkSchem.equals(fkSchem) || !pkCatalog.equals(fkCatalog) || (schemaNode = this.findSchema((MdNode)this.node.eContainer(), pkCatalog, pkSchem)) == null || (datastoreNode = schemaNode.getNodeByName(RDBMS_DATASTORE_TYPE, pkTableName)) == null) continue;
                    MdNode fkNode = this.createOrUpdateFKNode(_node, fkName, fkSeq, fkColumn, map);
                    map.put("PKSCHEMA_ID", schemaNode.getId());
                    if (fkNode == null) continue;
                    currentref.add(fkNode);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.referenceAlreadyReversed.addAll(currentref);
            rs.close();
        }
        return unresolvedTable;
    }

    private MdNode findSchema(MdNode server, String catalog, String schem) {
        List schemas = server.getNodeByCode(RDBMS_SCHEMA_TYPE);
        for (MdNode schema : schemas) {
            Attribute schemAttr = schema.getAttributeByCode(RDBMS_SCHEMA_NAME);
            String schemStr = schemAttr != null ? schemAttr.getStringValue() : null;
            schemStr = schemStr == null ? "" : schemStr;
            Attribute catAttr = schema.getAttributeByCode(RDBMS_CATALOG_NAME);
            String catStr = catAttr != null ? catAttr.getStringValue() : null;
            String string = catStr = catStr == null ? "" : catStr;
            if (!schemStr.equals(schem) || !catStr.equals(catalog)) continue;
            return schema;
        }
        return null;
    }

    private MdNode createOrUpdateFKNode(MdNode datastore, String fkName, String fkSeq, String fkColumn, Map<String, String> resultSetPropertyMap) {
        MdNode relation;
        MdNode fkNode = datastore.getNodeByName(RDBMS_FK_TYPE, fkName);
        if (!this.referenceAlreadyReversed.contains(fkNode)) {
            this.debug("create FK Node: " + fkName);
            if (fkNode == null) {
                fkNode = MdFactoryHelper.createMdNode((String)RDBMS_FK_TYPE);
                fkNode.setName(fkName);
                datastore.getNode().add((Object)fkNode);
            }
            relation = MdFactoryHelper.createMdNode((String)RDBMS_RELATION_TYPE);
            MdNode baseFkNode = this.node.getNodeByName(RDBMS_FK_TYPE, datastore.getName());
            if (baseFkNode == null) {
                baseFkNode = datastore;
            }
            try {
                relation.setPosition(BigInteger.valueOf(Integer.valueOf(fkSeq).intValue()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        } else {
            return null;
        }
        fkNode.getNode().add((Object)relation);
        Attribute fkAttr = MdFactory.eINSTANCE.createAttribute();
        fkAttr.setDefType(RDBMS_RELATION_FK_TYPE);
        relation.getAttribute().add((Object)fkAttr);
        this.addReferenceResolver(fkAttr, new ReferenceResolver(null, relation, null, resultSetPropertyMap));
        Attribute pkAttr = MdFactory.eINSTANCE.createAttribute();
        pkAttr.setDefType(RDBMS_RELATION_PK_TYPE);
        relation.getAttribute().add((Object)pkAttr);
        this.addReferenceResolver(pkAttr, new ReferenceResolver(null, relation, null, resultSetPropertyMap));
        return fkNode;
    }

    private List<String> addPKs(MdNode _node) throws SQLException {
        ArrayList<String> unresolvedTable = new ArrayList<String>();
        ResultSet rs = null;
        try {
            this.info("Reverse PK for: " + _node.getName());
            Map<ResultSet, Map<String, String>> mapResultSets = this.initMapResultSet((Configuration)_node, RDBMS_PK_TYPE, _node.getName(), true);
            if (mapResultSets.size() > 0) {
                this.debug("getPrimaryKeys2 start: use specific query");
                rs = mapResultSets.keySet().iterator().next();
            } else {
                this.debug("getPrimaryKeys2 start: catalog: " + this.catalogName + " schema:" + this.schemaName + " table: " + _node.getName());
                rs = ResultSetWrapper.createWrapper(this.getDatabaseMetaData().getPrimaryKeys(this.catalogName, this.schemaName, _node.getName()), this.dbdmInfoMode, ResultSetWrapper.Type.PK);
            }
            this.debug("getPrimaryKeys2 end");
        }
        catch (Exception e) {
            this.warn("Reverse PK Error for: " + _node.getName(), e);
            Activator.warning(Messages.JdbcReverse_reverseWarning, e);
            return Collections.EMPTY_LIST;
        }
        if (rs != null) {
            Object schema = null;
            String precPkName = null;
            int i = 1;
            while (rs.next()) {
                MdNode pkNode;
                this.debug("read line[" + i++ + "]");
                HashSet<String> integers = new HashSet<String>();
                integers.add("KEY_SEQ");
                Map<String, String> properties = this.getProperties(rs, integers);
                String tmp = properties.get("KEY_SEQ");
                int seq = 1;
                if (tmp != null) {
                    seq = Integer.valueOf(tmp);
                }
                String pkColumn = properties.get("COLUMN_NAME");
                Object pkName = properties.get("PK_NAME");
                if (precPkName != null && !precPkName.equals(pkName)) {
                    pkName = "PK_" + _node.getName();
                }
                precPkName = pkName;
                List list = _node.getNodeByCode(RDBMS_PK_TYPE);
                MdNode mdNode = pkNode = list != null && list.size() > 0 ? (MdNode)list.get(0) : null;
                if (pkNode == null) {
                    pkNode = MdFactoryHelper.createMdNode((String)RDBMS_PK_TYPE);
                    pkNode.setName((String)pkName);
                    _node.getNode().add((Object)pkNode);
                }
                pkNode.setName((String)pkName);
                MdNode colRef = MdFactoryHelper.createMdNode((String)RDBMS_COL_REF_TYPE);
                colRef.setPosition(BigInteger.valueOf(seq));
                MdNode baseNode = this.node.getNodeByName(RDBMS_PK_TYPE, _node.getName());
                if (baseNode == null) {
                    baseNode = _node;
                }
                pkNode.getNode().add((Object)colRef);
                _node.getNode().add((Object)pkNode);
                Attribute refAttr = MdFactory.eINSTANCE.createAttribute();
                Property prop = colRef.getPropertyByShortCode("ref");
                refAttr.setDefType(prop.getFullCode());
                colRef.getAttribute().add((Object)refAttr);
                this.addReferenceResolver(refAttr, new ReferenceResolver(pkColumn, colRef, prop, properties));
            }
            rs.close();
        }
        return unresolvedTable;
    }

    private List<Map<String, String>> gatherColumnMetadataFromQuery(String query, QueryReverseMode mode) throws SQLException, ReverseException {
        if (mode == QueryReverseMode.EXECUTE_QUERY) {
            return this.gatherColumnMetadataFromQuery(query);
        }
        if (mode == QueryReverseMode.PREPARED_QUERY) {
            return this.gatherColumnMetadataFromQueryPreparedStatement(query);
        }
        throw new ReverseException(String.format(Messages.JdbcReverse_0, new Object[]{mode}));
    }

    private List<Map<String, String>> gatherColumnMetadataFromQueryPreparedStatement(String query) throws SQLException {
        ArrayList<Map<String, String>> list1 = new ArrayList<Map<String, String>>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (PreparedStatement pStmt = this.jdbcConnection.prepareStatement(query);){
            ResultSetMetaData mdt = pStmt.getMetaData();
            int i = 1;
            while (i <= mdt.getColumnCount()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("CATALOG_NAME", mdt.getCatalogName(i));
                map.put("TYPE_NAME", mdt.getColumnTypeName(i));
                map.put("TABLE_NAME", mdt.getTableName(i));
                String colName = mdt.getColumnName(i);
                String displayName = mdt.getColumnLabel(i);
                String str = null;
                str = colName == null || colName.isEmpty() ? displayName : (displayName == null || displayName.isEmpty() ? colName : displayName);
                map.put("COLUMN_NAME", str);
                map.put("TABLE_SCHEM", mdt.getSchemaName(i));
                map.put("IS_NULLABLE", Integer.toString(mdt.isNullable(i)));
                map.put("NULLABLE", Integer.toString(mdt.isNullable(i)));
                map.put("DECIMAL_DIGITS", Integer.toString(mdt.getScale(i)));
                map.put("COLUMN_SIZE", Integer.toString(mdt.getPrecision(i)));
                map.put("IS_AUTOINCREMENT", Boolean.toString(mdt.isAutoIncrement(i)));
                map.put("ORDINAL_POSITION", Integer.toString(i));
                list1.add(map);
                ++i;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return list1;
    }

    private List<Map<String, String>> gatherColumnMetadataFromQuery(String query) throws SQLException, ReverseException {
        ArrayList<Map<String, String>> list1 = new ArrayList<Map<String, String>>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Statement st = this.jdbcConnection.createStatement();){
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (ResultSet rsTemp = st.executeQuery(query);){
                ResultSetMetaData rsmd = rsTemp.getMetaData();
                int i = 1;
                while (i <= rsmd.getColumnCount()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("CATALOG_NAME", rsmd.getCatalogName(i));
                    map.put("TYPE_NAME", rsmd.getColumnTypeName(i));
                    map.put("TABLE_NAME", rsmd.getTableName(i));
                    String colName = rsmd.getColumnName(i);
                    String displayName = rsmd.getColumnLabel(i);
                    String str = null;
                    str = colName == null || colName.isEmpty() ? displayName : (displayName == null || displayName.isEmpty() ? colName : displayName);
                    map.put("COLUMN_NAME", str);
                    map.put("TABLE_SCHEM", rsmd.getSchemaName(i));
                    map.put("IS_NULLABLE", Integer.toString(rsmd.isNullable(i)));
                    map.put("NULLABLE", Integer.toString(rsmd.isNullable(i)));
                    map.put("DECIMAL_DIGITS", Integer.toString(rsmd.getScale(i)));
                    map.put("COLUMN_SIZE", Integer.toString(rsmd.getPrecision(i)));
                    map.put("IS_AUTOINCREMENT", Boolean.toString(rsmd.isAutoIncrement(i)));
                    map.put("ORDINAL_POSITION", Integer.toString(i));
                    list1.add(map);
                    ++i;
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            return list1;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addColumns(MdNode parameterNode) throws SQLException, ReverseException {
        ArrayList<Map<String, String>> list1 = new ArrayList<Map<String, String>>();
        if (this.reverseColumnMode == 1) {
            Object tablePath;
            Object object = tablePath = this.catalogName != null && this.schemaName != null ? this.catalogName + "." + this.schemaName : null;
            tablePath = this.schemaName == null ? this.catalogName : (this.catalogName == null ? this.schemaName : tablePath);
            tablePath = tablePath != null ? (String)tablePath + Messages.JdbcReverse_1 + parameterNode.getName() : parameterNode.getName();
            String string = "select * from " + (String)tablePath + " where 1=2";
            list1.addAll(this.gatherColumnMetadataFromQuery(string));
        } else if (this.reverseColumnMode == 2) {
            String string;
            XpathExpression xpe = this.node.getXPathExpression("EXPRESSION");
            Object var4_5 = null;
            try {
                string = ((IXPathEvaluationService)E4InjectorHelper.getService(IXPathEvaluationService.class)).evaluate(this.node.eResource().getURI(), XPathExpressionHelper.INSTANCE.getXPathScript(this.node, xpe), ParameterBuilder.create(IXPathEvaluationService.Option.class, String.class).set((Object)IXPathEvaluationService.Option.VARIABLE_EVALUATE_DEFAULT_VALUE, (Object)Boolean.toString(true)));
            }
            catch (IGenerationService.SynchronizerBusyException ex) {
                throw new ReverseException(Messages.JdbcReverse_275);
            }
            QueryReverseMode mode = QueryReverseMode.EXECUTE_QUERY;
            try {
                MdNode n = (MdNode)this.node.evaluateMdNode("ancestor-or-self::product[1]");
                String s = n.evaluateXpathExpressionCached("INTERNAL_QUERY_REVERSE_METHOD", null);
                mode = "ResultSet.getMetaData".equals(s) ? QueryReverseMode.EXECUTE_QUERY : ("PreparedStatement.getMetadata".equals(s) ? QueryReverseMode.PREPARED_QUERY : QueryReverseMode.EXECUTE_QUERY);
            }
            catch (Exception e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.JdbcReverse_279, (Throwable)e));
                mode = QueryReverseMode.EXECUTE_QUERY;
            }
            try {
                list1.addAll(this.gatherColumnMetadataFromQuery(string, mode));
            }
            catch (Exception ex) {
                if (mode == QueryReverseMode.PREPARED_QUERY) {
                    Activator.getDefault().getLog().log((IStatus)new Status(2, "com.indy.jdbc.editor", Messages.JdbcReverse_280, (Throwable)ex));
                    list1.addAll(this.gatherColumnMetadataFromQuery(string, QueryReverseMode.EXECUTE_QUERY));
                }
                throw new ReverseException(ex.getMessage(), ex);
            }
        } else {
            void var4_10;
            Map<ResultSet, Map<String, String>> mapResultSets = this.initMapResultSet((Configuration)parameterNode, RDBMS_COLUMN_TYPE, parameterNode.getName(), true);
            Object var4_7 = null;
            if (mapResultSets.size() > 0) {
                this.debug("getColumns start: use specific query");
                ResultSet resultSet = mapResultSets.keySet().iterator().next();
            } else {
                String escapeChar = this.getDatabaseMetaData().getSearchStringEscape();
                String schemaNamePattern = this.schemaName;
                String tableNamePattern = parameterNode.getName();
                if (escapeChar != null) {
                    tableNamePattern = tableNamePattern.replace("_", escapeChar + "_").replace("%", escapeChar + "%");
                    if (schemaNamePattern != null) {
                        schemaNamePattern = schemaNamePattern.replace("_", escapeChar + "_").replace("%", escapeChar + "%");
                    }
                }
                this.debug("getColumns start: catalog: " + this.catalogName + " schema:" + schemaNamePattern + " table: " + tableNamePattern);
                try {
                    ResultSetWrapper resultSetWrapper = ResultSetWrapper.createWrapper(this.getDatabaseMetaData().getColumns(this.catalogName, schemaNamePattern, tableNamePattern, "%"), this.dbdmInfoMode, ResultSetWrapper.Type.COLUMN);
                }
                catch (Exception e) {
                    this.warn("unexpected", e);
                }
            }
            this.debug("getColumns end");
            int i = 1;
            if (var4_10 != null) {
                while (var4_10.next()) {
                    this.debug("read line[" + i++ + "]");
                    list1.add(this.getProperties((ResultSet)var4_10));
                }
                var4_10.close();
            }
        }
        Collections.sort(list1, (o1, o2) -> {
            String pos1 = (String)o1.get("ORDINAL_POSITION");
            String pos2 = (String)o2.get("ORDINAL_POSITION");
            if (pos1 == null && pos2 == null) {
                return 0;
            }
            if (pos1 == null) {
                return -1;
            }
            if (pos2 == null) {
                return 1;
            }
            try {
                return Integer.valueOf(pos1).compareTo(Integer.valueOf(pos2));
            }
            catch (Exception exception) {
                return 0;
            }
        });
        ArrayList<MdNode> list = new ArrayList<MdNode>();
        for (Map map : list1) {
            String position;
            MdNode columnNode = MdFactory.eINSTANCE.createMdNode();
            columnNode.setDefType(RDBMS_COLUMN_TYPE);
            this.addAttributes(columnNode, map);
            Level level = columnNode.getLevel(this.node.eResource());
            if (level.getReverseCode() != null && !level.getReverseCode().isEmpty()) {
                String columnName = (String)map.get(level.getReverseCode());
                columnNode.setName(columnName);
                columnNode.setSubstituteContainer((EObject)parameterNode);
                this.reverseSpe(columnNode, columnName, map);
            }
            if (level.getPositionReverseCode() != null && !level.getPositionReverseCode().isEmpty() && (position = (String)map.get(level.getPositionReverseCode())) != null) {
                columnNode.setPosition(new BigInteger(position));
            }
            list.add(columnNode);
        }
        parameterNode.getNode().addAll(list);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<String> getSchemaList(String catalog, String filter) throws SQLException {
        ArrayList<String> retour = new ArrayList<String>();
        ResultSet metadataResultSet = catalog == null && (filter == null || filter.equals("")) ? this.getDatabaseMetaData().getSchemas() : this.getDatabaseMetaData().getSchemas(catalog, filter);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ResultSetWrapper rs = ResultSetWrapper.createWrapper(metadataResultSet, this.dbdmInfoMode, ResultSetWrapper.Type.SCHEMA);){
            while (true) {
                if (!rs.next()) {
                    return retour;
                }
                try {
                    retour.add(rs.getString("TABLE_SCHEM"));
                }
                catch (Exception ex) {
                    retour.add(rs.getString(1));
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private ArrayList<String> getCatalogList() throws SQLException {
        ArrayList<String> retour = new ArrayList<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ResultSetWrapper rs = ResultSetWrapper.createWrapper(this.getDatabaseMetaData().getCatalogs(), this.dbdmInfoMode, ResultSetWrapper.Type.CATALOG);){
            while (rs.next()) {
                retour.add(rs.getString("TABLE_CAT"));
            }
            return retour;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ArrayList<String> getDataStoreList(String nameFilter, String ... typesFilter) throws SQLException {
        ArrayList<String> retour = new ArrayList<String>();
        String _filter = nameFilter != null ? (nameFilter.equals("") ? "%" : nameFilter) : "%";
        Throwable throwable = null;
        Object var6_7 = null;
        try (ResultSetWrapper rs = ResultSetWrapper.createWrapper(this.getDatabaseMetaData().getTables(this.catalogName, this.schemaName, _filter, typesFilter), this.dbdmInfoMode, ResultSetWrapper.Type.TABLE);){
            while (rs.next()) {
                Map<String, String> map = this.getProperties(rs);
                retour.add(map.get("TABLE_NAME"));
            }
            return retour;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ArrayList<String> getFunctionList(String nameFilter) throws SQLException {
        ArrayList<String> retour = new ArrayList<String>();
        String _filter = nameFilter != null ? (nameFilter.equals("") ? "%" : nameFilter) : "%";
        Throwable throwable = null;
        Object var5_6 = null;
        try (ResultSetWrapper rs = ResultSetWrapper.createWrapper(this.getDatabaseMetaData().getFunctions(this.catalogName, this.schemaName, _filter), this.dbdmInfoMode, ResultSetWrapper.Type.FUNCTION);){
            while (rs.next()) {
                Map<String, String> map = this.getProperties(rs);
                retour.add(map.get("FUNCTION_NAME"));
            }
            return retour;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean contains(Object[] selectedChildren, String compareName) {
        int i = 0;
        while (selectedChildren.length > i) {
            String name = (String)selectedChildren[i];
            if (name.equals(compareName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isConnected() {
        if (this.jdbcConnection != null) {
            try {
                if (!this.jdbcConnection.isClosed()) {
                    return true;
                }
            }
            catch (SQLException e) {
                Activator.warning(Messages.JdbcReverse_reverseWarning, e);
                this.warn("Close connection", e);
            }
        }
        return false;
    }

    public void setNode(MdNode node) {
        this.node = node;
        this.refreshQueryMap();
        try {
            String s = node.evaluateXpathExpressionCached("INTERNAL_REVERSE_DBMD_COLUMN_ACCESS_MODE", ResultSetWrapper.InfoMode.columnLabel.name());
            this.dbdmInfoMode = ResultSetWrapper.InfoMode.valueOf(s);
        }
        catch (Exception s) {
            // empty catch block
        }
        try {
            this.schema = node.evaluateMdNode("ancestor-or-self::schema[1]");
            this.schemaName = this.schema != null ? this.schema.evaluate("@TABLE_SCHEM") : null;
            this.schemaName = this.schemaName != null && this.schemaName.equals("") ? null : this.schemaName;
            this.catalogName = this.schema != null ? this.schema.evaluate("@TABLE_CAT") : null;
            this.catalogName = this.catalogName != null && this.catalogName.equals("") ? null : this.catalogName;
            Configuration server = node.evaluateMdNode("ancestor-or-self::server[1]");
            this.product = server.evaluateMdNode("ancestor::product[1]");
            this.reverseColumnMode = 0;
            try {
                if (server.evaluateMdBoolean("exists(property[@name='jdbc.reverse.column.mode' and @value='select'])")) {
                    this.reverseColumnMode = 1;
                }
                if (this.product.evaluateMdBoolean("exists(property[@name='jdbc.reverse.column.mode' and @value='select'])")) {
                    this.reverseColumnMode = 1;
                }
            }
            catch (XPathExpressionException e) {
                Activator.warning(Messages.JdbcReverse_reverseWarning, e);
            }
            this.hasCatalog = this.product.evaluateMdBoolean("contains(@schemaType,'catalog')");
            this.hasSchema = this.product.evaluateMdBoolean("contains(@schemaType,'schema')");
        }
        catch (XPathExpressionException e) {
            Activator.warning(Messages.JdbcReverse_reverseWarning, e);
        }
    }

    public void close() {
        try {
            for (Statement st : this.listStatements) {
                st.close();
            }
            this.listStatements.clear();
            this.cacheStatement.clear();
            if (this.jdbcConnection != null && !this.jdbcConnection.isClosed()) {
                this.jdbcConnection.close();
            }
        }
        catch (SQLException e) {
            Activator.warning(Messages.JdbcReverse_reverseWarning, e);
        }
    }

    public void setConf(String conf) {
    }

    public List<Attribute> getMandatoryField() {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        if (this.node.getDefType().equals(RDBMS_SCHEMA_TYPE)) {
            result.add(this.node.getAttributeByCode("com.stambia.rdbms.schema.control"));
        }
        return null;
    }

    public List<MdNode> getMdNodeChildren(String type, String parentName, String nameFilter, String ... typesFilter) throws ReverseException {
        List<String> list = this.getChildren(type, parentName, nameFilter, typesFilter);
        String str = "";
        ArrayList<MdNode> result = new ArrayList<MdNode>();
        for (String tmp : list) {
            MdNode _node = MdFactory.eINSTANCE.createMdNode();
            _node.setName(tmp);
            String _type = type.equals(RDBMS_CATALOG_TYPE) ? RDBMS_SCHEMA_TYPE : type;
            _node.setDefType(_type);
            _node.setSubstituteContainer((EObject)this.node);
            result.add(_node);
        }
        return result;
    }

    public void setConnection(Object connection) throws ReverseException {
        try {
            this.jdbcConnection = (Connection)connection;
        }
        catch (ClassCastException exeption) {
            Activator.error(Messages.JdbcReverse_connectionError, exeption);
            throw new ReverseException(exeption.getCause());
        }
    }

    public AttributeRefResolver getAttributeRefResolver() {
        return new AttributeRefResolver(){
            Map<Attribute, String> paths = new HashMap<Attribute, String>();

            String getAttributePath(Attribute a) {
                Object res = this.paths.get(a);
                if (res == null) {
                    String path = ((MdNode)a.eContainer()).getFullPath(true);
                    res = path + "/" + a.getDefType();
                    this.paths.put(a, (String)res);
                }
                return res;
            }

            public Attribute adapt(Attribute att) {
                String key = this.getAttributePath(att);
                Optional<Attribute> res = JdbcReverse.this.referenceResolver.keySet().stream().filter(a -> key.equals(this.getAttributePath((Attribute)a))).findFirst();
                return res.orElse(att);
            }

            public List<Object> resolve(MdNode context, Attribute attribute) {
                Property prop = attribute.getTechProperty();
                ArrayList<Object> result = new ArrayList<Object>();
                Attribute att = this.adapt(attribute);
                List<ReferenceResolver> rrs = JdbcReverse.this.referenceResolver.get(att);
                if (rrs == null) {
                    for (Attribute a : JdbcReverse.this.referenceResolver.keySet()) {
                        if (!attribute.getDefType().equals(a.getDefType())) continue;
                        CustomMdNode customMdNode = (CustomMdNode)attribute.eContainer();
                        CustomMdNode customMdNode2 = (CustomMdNode)a.eContainer();
                        if (customMdNode == null || customMdNode.compare((Configuration)customMdNode2) != 0) continue;
                        rrs = JdbcReverse.this.referenceResolver.get(a);
                        break;
                    }
                }
                if (rrs != null) {
                    for (ReferenceResolver rr : rrs) {
                        if (rr == null) continue;
                        String query = prop.getReverseUpdateXpathQuery();
                        Pattern pDeb = Pattern.compile("\\{reverse:([A-Za-z0-9_]*)\\(\\)\\}");
                        Matcher mDeb = pDeb.matcher(query);
                        if (rr.properties != null) {
                            while (mDeb.find()) {
                                String grp1 = mDeb.group(1);
                                String replaceBy = rr.properties.get(grp1);
                                replaceBy = replaceBy == null ? "" : replaceBy;
                                query = query.replaceAll("\\{reverse:" + grp1 + "\\(\\)\\}", replaceBy);
                            }
                        }
                        query = query.replaceAll("\\{reverse:filter\\(\\)\\}", rr.filter);
                        try {
                            List list;
                            if (prop.getType().equals((Object)PropertyType.REFERENCE)) {
                                list = (List)context.evaluateMdSet(query);
                                for (Object elt : list) {
                                    result.add(elt);
                                }
                                continue;
                            }
                            list = (List)context.evaluateMdStringList(query);
                            for (Object elt : list) {
                                result.add(elt);
                            }
                        }
                        catch (XPathExpressionException e) {
                            Activator.warning(Messages.JdbcReverse_reverseWarning, e);
                        }
                    }
                }
                return result;
            }
        };
    }

    private static enum QueryReverseMode {
        EXECUTE_QUERY,
        PREPARED_QUERY;

    }

    class RecursiveReverse {
        List<String> reverseCodes = new ArrayList<String>();
        List<String> revereseValues = new ArrayList<String>();
        ResultSet rs;
        Map<String, String> map;
        MdNode root;
        MdNode currentNode;

        public RecursiveReverse(ResultSet rs, MdNode root) {
            this.rs = rs;
            this.root = root;
        }

        public void doReverse(MdNode node) throws ReverseException, SQLException {
            this.currentNode = node;
            boolean stop = true;
            do {
                JdbcReverse.this.addAttributes(node, this.map);
            } while (!stop);
        }

        public boolean next() throws SQLException {
            boolean next = this.rs.next();
            this.map = next ? JdbcReverse.this.getProperties(this.rs) : null;
            return next;
        }
    }

    private class ReferenceResolver {
        MdNode parent;
        Property property;
        String filter;
        Map<String, String> properties;

        public ReferenceResolver(String filter, MdNode parent, Property property, Map properties) {
            this.filter = filter;
            this.parent = parent;
            this.property = property;
            this.properties = properties;
        }
    }

    static class _Statement {
        PreparedStatement st;
        List<String> expressions = new ArrayList<String>();
        String query;

        _Statement() {
        }

        ResultSet executeQuery(Configuration node) throws XPathExpressionException, SQLException {
            int i = 1;
            this.st.clearParameters();
            for (String expression : this.expressions) {
                String value = node.evaluateMdString(expression);
                this.st.setString(i, value);
                ++i;
            }
            return this.st.executeQuery();
        }
    }
}

