/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.action.ant.taskdefs;

import com.indy.engine.action.ant.taskdefs.Messages;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.resources.FileResourceIterator;
import org.apache.tools.ant.types.resources.Resources;
import org.apache.tools.ant.types.resources.Restrict;
import org.apache.tools.ant.types.resources.Sort;
import org.apache.tools.ant.types.resources.comparators.FileSystem;
import org.apache.tools.ant.types.resources.comparators.ResourceComparator;
import org.apache.tools.ant.types.resources.comparators.Reverse;
import org.apache.tools.ant.types.resources.selectors.Exists;
import org.apache.tools.ant.types.resources.selectors.ResourceSelector;
import org.apache.tools.ant.types.selectors.AndSelector;
import org.apache.tools.ant.types.selectors.ContainsRegexpSelector;
import org.apache.tools.ant.types.selectors.ContainsSelector;
import org.apache.tools.ant.types.selectors.DateSelector;
import org.apache.tools.ant.types.selectors.DependSelector;
import org.apache.tools.ant.types.selectors.DepthSelector;
import org.apache.tools.ant.types.selectors.ExtendSelector;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.FilenameSelector;
import org.apache.tools.ant.types.selectors.MajoritySelector;
import org.apache.tools.ant.types.selectors.NoneSelector;
import org.apache.tools.ant.types.selectors.NotSelector;
import org.apache.tools.ant.types.selectors.OrSelector;
import org.apache.tools.ant.types.selectors.PresentSelector;
import org.apache.tools.ant.types.selectors.SelectSelector;
import org.apache.tools.ant.types.selectors.SizeSelector;
import org.apache.tools.ant.types.selectors.modifiedselector.ModifiedSelector;

public class Delete
extends MatchingTask {
    private static final int DELETE_RETRY_SLEEP_MILLIS = 10;
    private static final ResourceComparator REVERSE_FILESYSTEM = new Reverse((ResourceComparator)new FileSystem());
    private static final ResourceSelector EXISTS = new Exists();
    private final Logger logger = LogManager.getLogger(Delete.class);
    protected File file = null;
    protected File dir = null;
    protected Vector filesets = new Vector();
    protected boolean usedMatchingTask = false;
    protected boolean includeEmpty = false;
    private int verbosity = 3;
    private boolean quiet = false;
    private boolean failonerror = true;
    private boolean deleteOnExit = false;
    private Resources rcs = null;
    Listener listener;
    int numFile;

    public void setFile(File file) {
        this.file = file;
    }

    public void setDir(File dir) {
        this.dir = dir;
        this.getImplicitFileSet().setDir(dir);
    }

    public void setVerbose(boolean verbose) {
        this.verbosity = verbose ? 2 : 3;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
        if (quiet) {
            this.failonerror = false;
        }
    }

    public void setFailOnError(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setDeleteOnExit(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    public void setIncludeEmptyDirs(boolean includeEmpty) {
        this.includeEmpty = includeEmpty;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void add(ResourceCollection rc) {
        if (rc == null) {
            return;
        }
        this.rcs = this.rcs == null ? new Resources() : this.rcs;
        this.rcs.add(rc);
    }

    public PatternSet.NameEntry createInclude() {
        this.usedMatchingTask = true;
        return super.createInclude();
    }

    public PatternSet.NameEntry createIncludesFile() {
        this.usedMatchingTask = true;
        return super.createIncludesFile();
    }

    public PatternSet.NameEntry createExclude() {
        this.usedMatchingTask = true;
        return super.createExclude();
    }

    public PatternSet.NameEntry createExcludesFile() {
        this.usedMatchingTask = true;
        return super.createExcludesFile();
    }

    public PatternSet createPatternSet() {
        this.usedMatchingTask = true;
        return super.createPatternSet();
    }

    public void setIncludes(String includes) {
        this.usedMatchingTask = true;
        super.setIncludes(includes);
    }

    public void setExcludes(String excludes) {
        this.usedMatchingTask = true;
        super.setExcludes(excludes);
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.usedMatchingTask = true;
        super.setDefaultexcludes(useDefaultExcludes);
    }

    public void setIncludesfile(File includesfile) {
        this.usedMatchingTask = true;
        super.setIncludesfile(includesfile);
    }

    public void setExcludesfile(File excludesfile) {
        this.usedMatchingTask = true;
        super.setExcludesfile(excludesfile);
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.usedMatchingTask = true;
        super.setCaseSensitive(isCaseSensitive);
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.usedMatchingTask = true;
        super.setFollowSymlinks(followSymlinks);
    }

    public void addSelector(SelectSelector selector) {
        this.usedMatchingTask = true;
        super.addSelector(selector);
    }

    public void addAnd(AndSelector selector) {
        this.usedMatchingTask = true;
        super.addAnd(selector);
    }

    public void addOr(OrSelector selector) {
        this.usedMatchingTask = true;
        super.addOr(selector);
    }

    public void addNot(NotSelector selector) {
        this.usedMatchingTask = true;
        super.addNot(selector);
    }

    public void addNone(NoneSelector selector) {
        this.usedMatchingTask = true;
        super.addNone(selector);
    }

    public void addMajority(MajoritySelector selector) {
        this.usedMatchingTask = true;
        super.addMajority(selector);
    }

    public void addDate(DateSelector selector) {
        this.usedMatchingTask = true;
        super.addDate(selector);
    }

    public void addSize(SizeSelector selector) {
        this.usedMatchingTask = true;
        super.addSize(selector);
    }

    public void addFilename(FilenameSelector selector) {
        this.usedMatchingTask = true;
        super.addFilename(selector);
    }

    public void addCustom(ExtendSelector selector) {
        this.usedMatchingTask = true;
        super.addCustom(selector);
    }

    public void addContains(ContainsSelector selector) {
        this.usedMatchingTask = true;
        super.addContains(selector);
    }

    public void addPresent(PresentSelector selector) {
        this.usedMatchingTask = true;
        super.addPresent(selector);
    }

    public void addDepth(DepthSelector selector) {
        this.usedMatchingTask = true;
        super.addDepth(selector);
    }

    public void addDepend(DependSelector selector) {
        this.usedMatchingTask = true;
        super.addDepend(selector);
    }

    public void addContainsRegexp(ContainsRegexpSelector selector) {
        this.usedMatchingTask = true;
        super.addContainsRegexp(selector);
    }

    public void addModified(ModifiedSelector selector) {
        this.usedMatchingTask = true;
        super.addModified(selector);
    }

    public void add(FileSelector selector) {
        this.usedMatchingTask = true;
        super.add(selector);
    }

    public void execute() throws BuildException {
        if (this.usedMatchingTask) {
            this.log(Messages.getString("Delete.0") + Messages.getString("Delete.1"), this.quiet ? 3 : this.verbosity);
        }
        if (this.file == null && this.dir == null && this.filesets.isEmpty() && this.rcs == null) {
            throw new BuildException(Messages.getString("Delete.2") + Messages.getString("Delete.3") + Messages.getString("Delete.4"));
        }
        if (this.quiet && this.failonerror) {
            throw new BuildException(Messages.getString("Delete.5") + Messages.getString("Delete.6"), this.getLocation());
        }
        if (this.file != null) {
            if (this.file.exists()) {
                if (this.file.isDirectory()) {
                    this.log(Messages.getString("Delete.7") + this.file.getAbsolutePath() + Messages.getString("Delete.8") + Messages.getString("Delete.9"), this.quiet ? 3 : this.verbosity);
                } else {
                    this.log(Messages.getString("Delete.10") + this.file.getAbsolutePath());
                    if (!this.delete(this.file)) {
                        this.handle(Messages.getString("Delete.11") + this.file.getAbsolutePath());
                    }
                }
            } else if (!this.failonerror) {
                this.log(Messages.getString("Delete.12") + this.file.getAbsolutePath() + Messages.getString("Delete.13"), this.quiet ? 3 : this.verbosity);
            } else {
                throw new BuildException(Messages.getString("Delete.14") + this.file.getAbsolutePath() + Messages.getString("Delete.15"));
            }
        }
        if (this.dir != null && this.dir.exists() && this.dir.isDirectory() && !this.usedMatchingTask) {
            if (this.verbosity == 3) {
                this.log(Messages.getString("Delete.16") + this.dir.getAbsolutePath());
            }
            this.removeDir(this.dir);
        }
        Resources resourcesToDelete = new Resources();
        resourcesToDelete.setProject(this.getProject());
        Resources filesetDirs = new Resources();
        filesetDirs.setProject(this.getProject());
        FileSet implicit = null;
        if (this.usedMatchingTask && this.dir != null && this.dir.isDirectory()) {
            implicit = this.getImplicitFileSet();
            implicit.setProject(this.getProject());
            this.filesets.add(implicit);
        }
        for (Object fileset2 : this.filesets) {
            File fsDir;
            FileSet fs = (FileSet)fileset2;
            if (fs.getProject() == null) {
                this.log(Messages.getString("Delete.17") + Messages.getString("Delete.18"), 3);
                fs = (FileSet)fs.clone();
                fs.setProject(this.getProject());
            }
            if ((fsDir = fs.getDir()) == null) {
                throw new BuildException(Messages.getString("Delete.19"));
            }
            if (!fsDir.isDirectory()) {
                this.handle(Messages.getString("Delete.20") + String.valueOf(fsDir));
                continue;
            }
            resourcesToDelete.add((ResourceCollection)fs);
            if (!this.includeEmpty) continue;
            filesetDirs.add((ResourceCollection)new ReverseDirs(fsDir, fs.getDirectoryScanner().getIncludedDirectories()));
        }
        resourcesToDelete.add((ResourceCollection)filesetDirs);
        if (this.rcs != null) {
            Restrict exists = new Restrict();
            exists.add(EXISTS);
            exists.add((ResourceCollection)this.rcs);
            Sort s = new Sort();
            s.add(REVERSE_FILESYSTEM);
            s.add((ResourceCollection)exists);
            resourcesToDelete.add((ResourceCollection)s);
        }
        try {
            try {
                if (resourcesToDelete.isFilesystemOnly()) {
                    for (FileResource r : resourcesToDelete) {
                        if (!r.isExists() || r.isDirectory() && r.getFile().list().length != 0) continue;
                        this.log(Messages.getString("Delete.21") + String.valueOf(r), this.verbosity);
                        if (this.delete(r.getFile()) || !this.failonerror) continue;
                        this.handle(Messages.getString("Delete.22") + (r.isDirectory() ? Messages.getString("Delete.23") : Messages.getString("Delete.24")) + String.valueOf(r));
                    }
                } else {
                    this.handle(this.getTaskName() + Messages.getString("Delete.25"));
                }
            }
            catch (Exception e) {
                this.handle(e);
                if (implicit != null) {
                    this.filesets.remove(implicit);
                }
            }
        }
        finally {
            if (implicit != null) {
                this.filesets.remove(implicit);
            }
        }
    }

    private void handle(String msg) {
        this.handle((Exception)((Object)new BuildException(msg)));
    }

    private void handle(Exception e) {
        if (this.failonerror) {
            throw e instanceof BuildException ? (BuildException)((Object)e) : new BuildException((Throwable)e);
        }
        this.log(e, this.quiet ? 3 : this.verbosity);
    }

    private boolean delete(File f) {
        long length = f.length();
        long lastModified = f.lastModified();
        boolean canExecute = f.canExecute();
        boolean canRead = f.canRead();
        boolean canWrite = f.canWrite();
        boolean isHidden = f.isHidden();
        boolean isDirectory = f.isDirectory();
        if (!f.delete()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                this.logger.debug("Interrupted", (Throwable)ex);
            }
            if (!f.delete()) {
                if (this.deleteOnExit) {
                    int level = this.quiet ? 3 : 2;
                    this.log(Messages.getString("Delete.26") + String.valueOf(f) + Messages.getString("Delete.27") + Messages.getString("Delete.28") + Messages.getString("Delete.29"), level);
                    f.deleteOnExit();
                    return true;
                }
                return false;
            }
        }
        if (this.listener != null) {
            String sDir = null;
            String sFile = null;
            try {
                if (f.isDirectory()) {
                    sDir = f.getCanonicalPath();
                } else {
                    sFile = f.getCanonicalFile().getName();
                    if (f.getParentFile() != null) {
                        sDir = f.getParentFile().getCanonicalPath();
                    }
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to get canonical path for {}", (Object)f, (Object)e);
            }
            this.listener.deleteFile(++this.numFile, sDir, sFile, length, lastModified, canExecute, canRead, canWrite, isHidden, isDirectory);
        } else {
            ++this.numFile;
        }
        return true;
    }

    protected void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            File f = new File(d, s);
            if (f.isDirectory()) {
                this.removeDir(f);
            } else {
                this.log(Messages.getString("Delete.30") + f.getAbsolutePath(), this.quiet ? 3 : this.verbosity);
                if (!this.delete(f)) {
                    this.handle(Messages.getString("Delete.31") + f.getAbsolutePath());
                }
            }
            ++n2;
        }
        this.log(Messages.getString("Delete.32") + d.getAbsolutePath(), this.verbosity);
        if (!this.delete(d)) {
            this.handle(Messages.getString("Delete.33") + this.dir.getAbsolutePath());
        }
    }

    protected void removeFiles(File d, String[] files, String[] dirs) {
        if (files.length > 0) {
            this.log(Messages.getString("Delete.34") + files.length + Messages.getString("Delete.35") + d.getAbsolutePath(), this.quiet ? 3 : this.verbosity);
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file2 = stringArray[n2];
                File f = new File(d, file2);
                this.log(Messages.getString("Delete.36") + f.getAbsolutePath(), this.quiet ? 3 : this.verbosity);
                if (!this.delete(f)) {
                    this.handle(Messages.getString("Delete.37") + f.getAbsolutePath());
                }
                ++n2;
            }
        }
        if (dirs.length > 0 && this.includeEmpty) {
            int dirCount = 0;
            int j = dirs.length - 1;
            while (j >= 0) {
                File currDir = new File(d, dirs[j]);
                String[] dirFiles = currDir.list();
                if (dirFiles == null || dirFiles.length == 0) {
                    this.log(Messages.getString("Delete.38") + currDir.getAbsolutePath(), this.quiet ? 3 : this.verbosity);
                    if (!this.delete(currDir)) {
                        this.handle(Messages.getString("Delete.39") + currDir.getAbsolutePath());
                    } else {
                        ++dirCount;
                    }
                }
                --j;
            }
            if (dirCount > 0) {
                this.log(Messages.getString("Delete.40") + dirCount + Messages.getString("Delete.41") + (dirCount == 1 ? "y" : "ies") + Messages.getString("Delete.42") + d.getAbsolutePath(), this.quiet ? 3 : this.verbosity);
            }
        }
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public int getNumFile() {
        return this.numFile;
    }

    public void setNumFile(int numFile) {
        this.numFile = numFile;
    }

    public static interface Listener {
        public void deleteFile(int var1, String var2, String var3, long var4, long var6, boolean var8, boolean var9, boolean var10, boolean var11, boolean var12);
    }

    private static class ReverseDirs
    implements ResourceCollection {
        static final Comparator REVERSE = new Comparator(){

            public int compare(Object foo, Object bar) {
                return ((Comparable)foo).compareTo(bar) * -1;
            }
        };
        private File basedir;
        private String[] dirs;

        ReverseDirs(File basedir, String[] dirs) {
            this.basedir = basedir;
            this.dirs = dirs;
            Arrays.sort(this.dirs, REVERSE);
        }

        public Iterator iterator() {
            return new FileResourceIterator(this.basedir, this.dirs);
        }

        public boolean isFilesystemOnly() {
            return true;
        }

        public int size() {
            return this.dirs.length;
        }
    }
}

