/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.actionCodes.XmlToJdbcActionCodeI;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

class IResourceFactory {
    private IResourceFactory() {
    }

    static XmlToJdbcActionCodeI.IResource of(File f) {
        return new FileResource(f);
    }

    static XmlToJdbcActionCodeI.IResource of(String content) {
        return new StringResource(content);
    }

    static class FileResource
    implements XmlToJdbcActionCodeI.IResource {
        File file;

        private FileResource(File file) {
            this.file = file;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public long getLength() {
            return this.file.length();
        }
    }

    static class StringResource
    implements XmlToJdbcActionCodeI.IResource {
        String inputContent;

        private StringResource(String inputContent) {
            this.inputContent = inputContent;
        }

        @Override
        public File getFile() {
            return null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream(this.inputContent.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public long getLength() {
            return this.inputContent.length();
        }
    }
}

