/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.file.jdbc.FileWriter;
import com.indy.engine.actionCodes.file.jdbc.FixedWriter;
import com.indy.engine.actionCodes.file.jdbc.VariableWriter;
import com.indy.engine.actionCodes.utils.Tools;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;

public class SqlFileExportActionCodeI
extends ActionCodeTypeI {
    String fileName = null;
    String driver = null;
    String url = null;
    String user = null;
    String password = null;
    String sMaxFileSize = "";
    long maxFileSize = -1L;
    Connection localJdbcConnection;
    int fileBufferSize = 8192;
    String fileEncoding = null;
    boolean fileAppend = false;
    int fileFormat = -1;
    static final int FORMAT_VARIABLE = 0;
    static final int FORMAT_POSITIONNAL = 1;
    private static final int ZIP_MODE_NONE = 0;
    private static final int ZIP_MODE_GZIP = 1;
    String fieldSep = null;
    String xFieldSep = null;
    String rowSep = null;
    String xRowSep = null;
    boolean copyHeaderWhenAppend = false;
    boolean addRecordNumber = false;
    boolean generateIfEmpty = false;
    String generateHeader = "false";
    boolean isGenerateHeader;
    int fetchSize;
    String query = null;
    String queryFile = null;
    String queryFileEncoding = null;
    boolean closeLastRowWithRowSep = false;
    boolean beginWithRowSepWhenAppendMode = true;
    int numRecord = 0;
    int previousNumRecord = 0;
    private int columnCount;
    private int zipMode;
    private String nullValueSubstitution;
    private String resultSetName;
    private String sourceNamedObject;
    FileWriter fileWriter;
    long currentFileSize = 0L;
    long previousCurrentFileSize = 0L;
    int nbFiles = 0;
    int previousNbFiles = 0;
    private OutputStream fileOutputStream;
    private BufferedOutputStream bufferedOutputStream;
    private GZIPOutputStream gzipOutputStream;
    private OutputStreamWriter outputStreamWriter;
    private BufferedWriter bufferedWriter;
    JdbcPreparedStatementToResultSet jpstr;

    public SqlFileExportActionCodeI() {
        this.actionCodeName = "Sql File Export Class";
        this.bNullCodeAllowed = true;
    }

    int closeConnection() throws EngineExceptionI {
        int ret = 0;
        if (this.connectionName == null && this.localJdbcConnection != null) {
            try {
                this.localJdbcConnection.close();
            }
            catch (SQLException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        return ret;
    }

    public int prepareSetConnection(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.setTransactionAndCommit(this.getLocalStringParameter("SQL_TRANSACTION_TYPE", null), true);
        try {
            this.sqlTransactionIsolation = -1;
            String pTransIsolation = this.getLocalStringBindedParameter(rSet, "SQL_TRANSACTION_ISOLATION");
            if (pTransIsolation != null) {
                if (pTransIsolation.equals("TRANSACTION_NONE")) {
                    this.sqlTransactionIsolation = 0;
                } else if (pTransIsolation.equals("TRANSACTION_READ_COMMITTED")) {
                    this.sqlTransactionIsolation = 2;
                } else if (pTransIsolation.equals("TRANSACTION_READ_UNCOMMITTED")) {
                    this.sqlTransactionIsolation = 1;
                } else if (pTransIsolation.equals("TRANSACTION_REPEATABLE_READ")) {
                    this.sqlTransactionIsolation = 4;
                } else if (pTransIsolation.equals("TRANSACTION_SERIALIZABLE")) {
                    this.sqlTransactionIsolation = 8;
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("error while reading parameter", (Throwable)e);
        }
        try {
            this.sqlTransName = this.getLocalStringBindedParameter(rSet, "SQL_TRANSACTION_NAME");
        }
        catch (Exception e) {
            this.sqlTransName = "T1";
        }
        return ret;
    }

    int generateFixedHeader(BufferedWriter out, ResultSetMetaData sourceRSMD) throws EngineExceptionI {
        return this.generateVariableHeader(out, sourceRSMD);
    }

    int generateVariableHeader(BufferedWriter out, ResultSetMetaData sourceRSMD) throws EngineExceptionI {
        int ret = 0;
        try {
            if (this.addRecordNumber) {
                out.write("0" + this.fieldSep);
                ret += 1 + this.fieldSep.length();
            }
            int i = 1;
            while (i <= sourceRSMD.getColumnCount()) {
                ret += sourceRSMD.getColumnLabel(i).length();
                out.write(sourceRSMD.getColumnLabel(i));
                if (i != sourceRSMD.getColumnCount()) {
                    out.write(this.fieldSep);
                    ret += this.fieldSep.length();
                } else {
                    out.write(this.rowSep);
                    ret += this.rowSep.length();
                }
                ++i;
            }
        }
        catch (IOException e) {
            this.debugLog("generateVariableHeader", "IOException : " + e.getMessage(), 1, "ERROR");
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), "IOException : " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        catch (SQLException e) {
            this.debugLog("generateVariableHeader", "SQLException : " + e.getMessage(), 1, "ERROR");
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), "SQLException : " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        DecimalFormat decimalFormat;
        String numericGroupingChar;
        DecimalFormatSymbols dfs;
        String stringDelimiter;
        String stringPadChar;
        String numericPadChar;
        String txt;
        int ret = 0;
        this.sourceNamedObject = this.getLocalStringBindedParameter(rSet, "SQL_EXP_NAMED_OBJECT", null);
        this.fileName = this.getLocalStringBindedParameter(rSet, "SQL_EXP_FILENAME", null);
        if (this.fileName == null) {
            this.debugLog("prepare", Messages.getString("SqlFileExportActionCodeI.0"), 1, "ERROR");
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("SqlFileExportActionCodeI.1"), "String", false);
            throw new EngineExceptionI(Messages.getString("SqlFileExportActionCodeI.2"));
        }
        if (this.sourceNamedObject == null) {
            try {
                this.prepareSetConnection(rSet);
                this.connectionName = this.getLocalStringBindedParameter(rSet, "SQL_CONNECTION");
            }
            catch (EngineExceptionI e1) {
                try {
                    this.driver = this.getLocalStringBindedParameter(rSet, "SQL_EXP_JAVA_DRIVER");
                    this.url = this.getLocalStringBindedParameter(rSet, "SQL_EXP_JAVA_URL");
                    this.user = this.getLocalStringBindedParameter(rSet, "SQL_EXP_JAVA_USER");
                    this.password = this.getLocalPasswordParameter(rSet, "SQL_EXP_JAVA_PASSWORD", "SQL_EXP_UNCRYPTED_JAVA_PASSWORD");
                }
                catch (EngineExceptionI e) {
                    this.debugLog("prepare", Messages.getString("SqlFileExportActionCodeI.3") + e.getMessage(), 1, "ERROR");
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("SqlFileExportActionCodeI.4") + e.getMessage(), "String", false);
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
        String string = txt = this.actionTxtCode != null && !this.actionTxtCode.equals("") ? this.actionTxtCode : null;
        if (txt == null) {
            this.queryFile = this.getLocalStringBindedParameter(rSet, "SQL_EXP_SQL_QUERY_FILE", null);
            this.queryFileEncoding = this.getLocalStringBindedParameter(rSet, "SQL_EXP_SQL_QUERY_FILE_ENCODING", Charset.defaultCharset().displayName());
            if (this.queryFile != null) {
                File file = new File(this.queryFile);
                if (!file.exists()) {
                    this.debugLog("prepare", Messages.getString("SqlFileExportActionCodeI.5") + this.queryFile, 1, "ERROR");
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("SqlFileExportActionCodeI.6"), "String", false);
                    throw new EngineExceptionI(Messages.getString("SqlFileExportActionCodeI.7"));
                }
                try {
                    txt = this.queryFileEncoding != null ? Tools.readFileAsString((String)this.queryFile, (String)this.queryFileEncoding) : Tools.readFileAsString((String)this.queryFile, null);
                }
                catch (IOException e) {
                    String msg = Messages.getString("SqlFileExportActionCodeI.8") + this.queryFile;
                    this.debugLog("prepare", msg, 1, "ERROR");
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), msg, "String", false);
                    throw new EngineExceptionI(msg);
                }
            }
        }
        if (txt != null && !txt.isEmpty()) {
            if (rSet != null) {
                try {
                    this.query = this.getFinalBindedCode(rSet, txt);
                }
                catch (Exception e) {
                    this.debugLog("prepare", "Exception : " + e.getMessage(), 1, "ERROR");
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), "Exception : " + e.getMessage(), "String", false);
                    throw new EngineExceptionI((Throwable)e);
                }
            } else {
                this.query = txt;
            }
        } else {
            this.query = this.getLocalStringBindedParameter(rSet, "SQL_EXP_SQL_QUERY", null);
        }
        if (this.query == null && this.sourceNamedObject == null) {
            this.debugLog("prepare", Messages.getString("SqlFileExportActionCodeI.9"), 1, "ERROR");
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("SqlFileExportActionCodeI.10"), "String", false);
            throw new EngineExceptionI(Messages.getString("SqlFileExportActionCodeI.11"));
        }
        String tempFileFormat = this.getLocalStringBindedParameter(rSet, "SQL_EXP_FILE_FORMAT", "variable");
        this.fileFormat = tempFileFormat.equals("fixed") || tempFileFormat.equals("positional") ? 1 : 0;
        String tempZipMode = this.getLocalStringBindedParameter(rSet, "SQL_EXP_FILE_ZIP_MODE", "zip");
        this.zipMode = tempZipMode.equalsIgnoreCase("gzip") ? 1 : 0;
        this.fileAppend = this.getLocalBooleanBindedParameter(rSet, "SQL_EXP_FILE_APPEND", false);
        this.fileEncoding = this.getLocalStringBindedParameter(rSet, "SQL_EXP_FILE_ENCODING", Charset.defaultCharset().displayName());
        this.nullValueSubstitution = this.getLocalStringBindedParameter(rSet, "SQL_EXP_NULL_VALUE_REPLACEMENT", null);
        String stringDelimiterReplacment = this.getLocalStringBindedParameter(rSet, "SQL_EXP_STRING_DELIMITER_REPLACEMENT", null);
        try {
            this.fieldSep = this.getLocalStringBindedParameter(rSet, "SQL_EXP_FIELD_SEP");
            this.fieldSep = SqlFileExportActionCodeI.decodeSpecialChar(this.fieldSep);
        }
        catch (EngineExceptionI e) {
            try {
                this.xFieldSep = this.getLocalStringBindedParameter(rSet, "SQL_EXP_XFIELD_SEP");
                if (this.xFieldSep != null) {
                    this.fieldSep = new String(StringOperations.hexStringToArrayByte((String)this.xFieldSep));
                }
            }
            catch (EngineExceptionI e2) {
                this.fieldSep = ";";
                this.xFieldSep = null;
            }
        }
        try {
            this.rowSep = this.getLocalStringBindedParameter(rSet, "SQL_EXP_ROW_SEP");
            this.rowSep = SqlFileExportActionCodeI.decodeSpecialChar(this.rowSep);
        }
        catch (EngineExceptionI e) {
            try {
                this.xRowSep = this.getLocalStringBindedParameter(rSet, "SQL_EXP_XROW_SEP");
                if (this.xRowSep != null) {
                    this.rowSep = new String(StringOperations.hexStringToArrayByte((String)this.xRowSep));
                }
            }
            catch (EngineExceptionI e2) {
                this.rowSep = System.getProperty("line.separator");
                this.xRowSep = null;
            }
        }
        try {
            this.beginWithRowSepWhenAppendMode = this.getLocalBooleanBindedParameter(rSet, "SQL_EXP_ROW_SEP_ON_FIRST_ROW_WHEN_APPEND");
        }
        catch (EngineExceptionI e) {
            this.beginWithRowSepWhenAppendMode = true;
        }
        try {
            this.closeLastRowWithRowSep = this.getLocalBooleanBindedParameter(rSet, "SQL_EXP_ROW_SEP_ON_LAST_ROW");
        }
        catch (EngineExceptionI e) {
            this.closeLastRowWithRowSep = false;
        }
        Boolean booleanAsNumeric = true;
        try {
            booleanAsNumeric = this.getLocalBooleanBindedParameter(rSet, "SQL_EXP_BOOLEAN_AS_NUMERIC");
        }
        catch (EngineExceptionI e) {
            booleanAsNumeric = true;
        }
        try {
            this.addRecordNumber = this.getLocalBooleanBindedParameter(rSet, "SQL_EXP_ADD_RECORD_NUMBER");
        }
        catch (EngineExceptionI e) {
            this.addRecordNumber = false;
        }
        try {
            this.generateHeader = this.getLocalStringBindedParameter(rSet, "SQL_EXP_GENERATE_HEADER");
            if (this.generateHeader != null) {
                this.generateHeader = this.generateHeader.replace("\n", "");
            }
            this.isGenerateHeader = this.generateHeader != null && ("always".equals(this.generateHeader) || "true".equals(this.generateHeader));
        }
        catch (EngineExceptionI e) {
            this.isGenerateHeader = false;
        }
        try {
            this.generateIfEmpty = this.getLocalBooleanBindedParameter(rSet, "SQL_EXP_GENERATE_IF_EMPTY");
        }
        catch (EngineExceptionI e) {
            this.generateIfEmpty = false;
        }
        try {
            this.fetchSize = this.getLocalIntegerBindedParameter(rSet, "SQL_EXP_FETCH_SIZE");
        }
        catch (EngineExceptionI e) {
            this.fetchSize = this.runtimeContext.DEFAULT_FETCH_SIZE;
        }
        String strTimeStampFormat = null;
        try {
            strTimeStampFormat = this.getLocalStringBindedParameter(rSet, "SQL_EXP_TIMESTAMP_FORMAT", null);
            if (strTimeStampFormat == null) {
                strTimeStampFormat = this.getLocalStringBindedParameter(rSet, "SQL_EXP_DATE_FORMAT", this.runtimeContext.GLOBAL_DATE_FORMAT);
            }
            DateTimeFormatter.ofPattern(strTimeStampFormat);
        }
        catch (Exception e) {
            throw new EngineExceptionI(Messages.getString("SqlFileExportActionCodeI.12") + strTimeStampFormat, (Throwable)e);
        }
        String strDateFormat = null;
        try {
            strDateFormat = this.getLocalStringBindedParameter(rSet, "SQL_EXP_SHORT_DATE_FORMAT", strTimeStampFormat);
            DateTimeFormatter.ofPattern(strDateFormat);
        }
        catch (Exception e) {
            throw new EngineExceptionI(Messages.getString("SqlFileExportActionCodeI.13") + strDateFormat, (Throwable)e);
        }
        String strTimeFormat = null;
        try {
            strTimeFormat = this.getLocalStringBindedParameter(rSet, "SQL_EXP_TIME_FORMAT", null);
            if (strTimeFormat != null && strTimeFormat.isEmpty()) {
                strTimeFormat = null;
            }
            if (strTimeFormat != null) {
                DateTimeFormatter.ofPattern(strTimeFormat);
            }
        }
        catch (Exception e) {
            throw new EngineExceptionI(Messages.getString("SqlFileExportActionCodeI.14") + strTimeFormat, (Throwable)e);
        }
        try {
            numericPadChar = this.getLocalStringBindedParameter(rSet, "SQL_EXP_NUMERIC_PAD_CHAR");
        }
        catch (EngineExceptionI e) {
            numericPadChar = " ";
        }
        try {
            stringPadChar = this.getLocalStringBindedParameter(rSet, "SQL_EXP_STRING_PAD_CHAR");
        }
        catch (EngineExceptionI e) {
            stringPadChar = " ";
        }
        try {
            stringDelimiter = this.getLocalStringBindedParameter(rSet, "SQL_EXP_STRING_DELIMITER");
        }
        catch (EngineExceptionI e) {
            String xStringDelimiter = null;
            try {
                xStringDelimiter = this.getLocalStringBindedParameter(rSet, "SQL_EXP_XSTRING_DELIMITER");
                stringDelimiter = xStringDelimiter != null ? new String(StringOperations.hexStringToArrayByte((String)xStringDelimiter)) : "";
            }
            catch (EngineExceptionI e2) {
                stringDelimiter = "";
            }
        }
        try {
            this.fileBufferSize = this.getLocalIntegerBindedParameter(rSet, "SQL_EXP_FILE_BUFFER_SIZE");
        }
        catch (EngineExceptionI e) {
            this.fileBufferSize = 8192;
        }
        try {
            this.fileBufferSize = this.getLocalIntegerBindedParameter(rSet, "FILE_BUFFER_SIZE");
        }
        catch (EngineExceptionI e) {
            this.fileBufferSize = 8192;
        }
        try {
            this.sMaxFileSize = this.getLocalStringBindedParameter(rSet, "SQL_EXP_MAX_FILE_SIZE");
        }
        catch (EngineExceptionI e) {
            this.sMaxFileSize = "";
        }
        String numericFormat = this.getLocalStringBindedParameter(rSet, "SQL_EXP_NUMERIC_FORMAT", "");
        String localeLanguage = null;
        try {
            localeLanguage = this.getLocalStringBindedParameter(rSet, "SQL_EXP_LOCALE_LANGUAGE");
        }
        catch (EngineExceptionI e) {
            this.logger.debug("Error while reading parameter", (Throwable)e);
        }
        if (localeLanguage != null) {
            try {
                dfs = new DecimalFormatSymbols(new Locale(localeLanguage));
            }
            catch (Exception e) {
                dfs = new DecimalFormatSymbols();
            }
        } else {
            dfs = new DecimalFormatSymbols();
        }
        try {
            numericGroupingChar = this.getLocalStringBindedParameter(rSet, "SQL_EXP_NUMERIC_GROUPING_CHAR");
        }
        catch (EngineExceptionI e) {
            numericGroupingChar = "";
        }
        String numericSeparatorChar = null;
        try {
            numericSeparatorChar = this.getLocalStringBindedParameter(rSet, "SQL_EXP_NUMERIC_SEPARATOR_CHAR");
        }
        catch (EngineExceptionI e) {
            this.logger.debug("Error while reading parameter", (Throwable)e);
        }
        boolean useGroupingChar = false;
        try {
            useGroupingChar = this.getLocalBooleanBindedParameter(rSet, "SQL_EXP_USE_NUMERIC_GROUPING_CHAR");
        }
        catch (EngineExceptionI e) {
            this.logger.debug("Error while reading parameter", (Throwable)e);
        }
        if (numericSeparatorChar != null) {
            dfs.setDecimalSeparator(numericSeparatorChar.toCharArray()[0]);
        }
        if (useGroupingChar) {
            if (numericGroupingChar.length() > 0) {
                dfs.setGroupingSeparator(numericGroupingChar.toCharArray()[0]);
            }
            decimalFormat = new DecimalFormat(numericFormat, dfs);
            decimalFormat.setGroupingUsed(true);
        } else {
            decimalFormat = new DecimalFormat(numericFormat, dfs);
            decimalFormat.setGroupingUsed(false);
        }
        decimalFormat.setParseBigDecimal(true);
        if (numericFormat.isEmpty()) {
            decimalFormat.setMinimumIntegerDigits(1);
        }
        boolean addStringDelimiterOnAllField = this.getLocalBooleanBindedParameter(rSet, "SQL_EXP_ENCLOSE_ALL_FIELDS", false);
        try {
            this.sMaxFileSize = this.sMaxFileSize.trim();
            if (this.sMaxFileSize.equals("")) {
                this.maxFileSize = -1L;
                this.sMaxFileSize = "";
            } else {
                String sPattern = "([0-9]*)([OMKGomkg]?)";
                Pattern pattern = Pattern.compile(sPattern);
                Matcher match = pattern.matcher(this.sMaxFileSize);
                if (match.matches()) {
                    long fSize = Long.parseLong(match.group(1));
                    this.maxFileSize = match.group(2) != null && match.group(2).equalsIgnoreCase("O") ? fSize : (match.group(2) != null && match.group(2).equalsIgnoreCase("K") ? fSize * 1024L : (match.group(2) != null && match.group(2).equalsIgnoreCase("M") ? fSize * 1024L * 1024L : (match.group(2) != null && match.group(2).equalsIgnoreCase("G") ? fSize * 1024L * 1024L * 1024L : fSize)));
                } else {
                    this.maxFileSize = -1L;
                    this.sMaxFileSize = "";
                }
            }
        }
        catch (Exception e) {
            this.sMaxFileSize = "";
            this.maxFileSize = -1L;
        }
        if (this.fileFormat == 1) {
            this.fileWriter = new FixedWriter(this.runtimeContext, decimalFormat, numericPadChar, stringPadChar, strTimeStampFormat, strDateFormat, strTimeFormat, booleanAsNumeric, this.addRecordNumber);
        } else if (this.fileFormat == 0) {
            this.fileWriter = new VariableWriter(this.runtimeContext, booleanAsNumeric, strTimeStampFormat, strDateFormat, strTimeFormat, decimalFormat, stringDelimiter, this.addRecordNumber, this.fieldSep, this.nullValueSubstitution, stringDelimiterReplacment, this.rowSep, addStringDelimiterOnAllField, null, null);
        }
        this.resultSetName = this.getLocalStringBindedParameter(rSet, "OUT_NAMED_RESULTSET", null);
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        int currentFileId = 1;
        this.numRecord = 0;
        this.debugLog("executeSimpleCode", "starting", 1, "DEBUG");
        if (ret == 0) {
            block94: {
                try {
                    if (this.connectionName == null || this.connectionName.equals("")) break block94;
                    this.debugLog("executeSimpleCode", Messages.getString("SqlFileExportActionCodeI.15") + this.connectionName, 3, "DEBUG");
                    this.localJdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
                    try {
                        ActionCodeTypeI.setAutoCommit((Connection)this.localJdbcConnection, (boolean)this.isAutoCommit());
                    }
                    catch (Exception e) {
                        this.logger.warn("unexpected", (Throwable)e);
                    }
                    this.isRdbmsLinked = true;
                }
                catch (EngineExceptionI e) {
                    this.debugLog("executeSimpleCode", Messages.getString("SqlFileExportActionCodeI.16") + e.getMessage(), 1, "ERROR");
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            this.fileWriter.setGetDateAsTimeStamp(this.getDateAsTimestamp);
            this.debugLog("executeSimpleCode", Messages.getString("SqlFileExportActionCodeI.17"), 1, "DEBUG");
            try {
                boolean fileCreated = false;
                Statement stmtSelect = null;
                EngineExceptionI exceptionToTrow = null;
                try {
                    ResultSet sourceRSet;
                    if (this.sourceNamedObject == null) {
                        stmtSelect = SqlFileExportActionCodeI.createResultSetStatement((Connection)this.localJdbcConnection);
                        try {
                            stmtSelect.setFetchSize(this.fetchSize);
                        }
                        catch (SQLException e) {
                            this.write(this.sessionName, "SqlFileExportActionCodeI=>executesimpleCode", this.actionName + Messages.getString("SqlFileExportActionCodeI.18") + e.getMessage(), 3, this.actionLevel, "WARNING");
                            this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_WARNING.getName(), Messages.getString("SqlFileExportActionCodeI.19") + e.getMessage(), "String", false);
                        }
                    }
                    this.debugLog("executeSimpleCode", "Statement Created", 1, "DEBUG");
                    if (this.query == null && this.sourceNamedObject == null) {
                        return -1;
                    }
                    if (this.sourceNamedObject != null) {
                        Object namedObject = this.getActionContext().getNamedObjectManager().waitObject(this.sourceNamedObject);
                        if (namedObject instanceof JdbcPreparedStatementToResultSet) {
                            JdbcPreparedStatementToResultSet jpstrs = (JdbcPreparedStatementToResultSet)namedObject;
                            if (jpstrs.isClosed()) {
                                throw new EngineExceptionI(String.format(Messages.getString("SqlFileExportActionCodeI.20"), this.sourceNamedObject));
                            }
                            jpstrs.setConsumers(false, new String[]{this.getActionContext().getActionId()});
                            this.getActionContext().getNamedObjectManager().setReady(this.sourceNamedObject);
                            sourceRSet = jpstrs.getResultSet(this.getActionContext().getActionId());
                        } else {
                            ResultSet rSet;
                            if (!(namedObject instanceof ResultSet)) {
                                throw new UnsupportedOperationException("Unsupported NamedObject:" + String.valueOf(namedObject));
                            }
                            sourceRSet = rSet = (ResultSet)namedObject;
                            this.getActionContext().getNamedObjectManager().setReady(this.sourceNamedObject);
                        }
                    } else {
                        sourceRSet = stmtSelect.executeQuery(this.query);
                    }
                    try {
                        ResultSetMetaData sourceRSMD = sourceRSet.getMetaData();
                        this.debugLog("executeSimpleCode", Messages.getString("SqlFileExportActionCodeI.21"), 1, "DEBUG");
                        this.currentFileSize = 0L;
                        currentFileId = 1;
                        Object currentFileName = this.fileName;
                        boolean debFile = true;
                        boolean addRowToDeb = false;
                        File f = null;
                        this.columnCount = sourceRSMD.getColumnCount();
                        FieldInfo[] fieldInfos = new FieldInfo[this.columnCount];
                        int i = 0;
                        while (i < this.columnCount) {
                            fieldInfos[i] = new FieldInfo(sourceRSMD.getColumnName(i + 1), sourceRSMD.getColumnType(i + 1), i + 1, sourceRSMD.getPrecision(i + 1), sourceRSMD.getColumnDisplaySize(i + 1), sourceRSMD.getScale(i + 1));
                            if (this.fileFormat == 1 && fieldInfos[i].precision == Integer.MAX_VALUE && fieldInfos[i].columnDisplaySize == Integer.MAX_VALUE) {
                                throw new EngineExceptionI("Column " + fieldInfos[i].precision + Messages.getString("SqlFileExportActionCodeI.22") + "2147483647)");
                            }
                            ++i;
                        }
                        while (sourceRSet.next() && ret == 0) {
                            if (Thread.interrupted()) {
                                this.debugLog("executeSimpleCode", Messages.getString("SqlFileExportActionCodeI.23"), 3, "DEBUG");
                                throw new InterruptedException();
                            }
                            ++this.numRecord;
                            if (this.numRecord == 1 || debFile) {
                                if (this.maxFileSize != -1L) {
                                    currentFileName = this.fileName + StringOperations.leftPad((String)String.valueOf(currentFileId), (String)"0", (int)3);
                                }
                                f = new File((String)currentFileName);
                                if (this.resultSetName == null) {
                                    addRowToDeb = f.exists() && this.fileAppend;
                                    this.newOutputStreamWriter((String)currentFileName);
                                } else {
                                    this.newOutputStreamWriter(this.newOutputResultSetOutputStream(currentFileId, f.getName()));
                                }
                                if (addRowToDeb && this.beginWithRowSepWhenAppendMode) {
                                    this.bufferedWriter.write(this.rowSep);
                                    this.currentFileSize += (long)this.rowSep.length();
                                }
                                ++this.nbFiles;
                                this.handleNbFiles(false);
                                fileCreated = true;
                                if (this.shouldGenerateHeader(addRowToDeb)) {
                                    if (this.fileFormat == 0) {
                                        this.currentFileSize += (long)this.generateVariableHeader(this.bufferedWriter, sourceRSMD);
                                    } else if (this.fileFormat == 1) {
                                        this.currentFileSize += (long)this.generateFixedHeader(this.bufferedWriter, sourceRSMD);
                                    }
                                }
                                debFile = false;
                            } else {
                                this.bufferedWriter.write(this.rowSep);
                                this.currentFileSize += (long)this.rowSep.length();
                                debFile = false;
                            }
                            this.fileWriter.writeLine(this.bufferedWriter, sourceRSet, fieldInfos);
                            this.currentFileSize += this.fileWriter.getCurrentLineSize();
                            if (this.numRecord % this.fetchSize == 0) {
                                this.handleNbRows(false);
                                this.handleOutFileSize(false);
                                this.bufferedWriter.flush();
                            }
                            if (this.maxFileSize == -1L || this.currentFileSize < this.maxFileSize || !fileCreated) continue;
                            if (this.closeLastRowWithRowSep) {
                                this.bufferedWriter.write(this.rowSep);
                                this.currentFileSize += (long)this.rowSep.length();
                            }
                            this.closeOutputStreamWriter();
                            this.currentFileSize = 0L;
                            currentFileName = this.fileName + StringOperations.leftPad((String)String.valueOf(++currentFileId), (String)"0", (int)3);
                            f = new File((String)currentFileName);
                            addRowToDeb = f.exists() && this.fileAppend;
                            if (this.resultSetName == null) {
                                addRowToDeb = f.exists() && this.fileAppend;
                                this.newOutputStreamWriter((String)currentFileName);
                            } else {
                                this.newOutputStreamWriter(this.newOutputResultSetOutputStream(currentFileId, f.getName()));
                            }
                            if (addRowToDeb && this.beginWithRowSepWhenAppendMode) {
                                this.bufferedWriter.write(this.rowSep);
                                this.currentFileSize += (long)this.rowSep.length();
                            }
                            fileCreated = true;
                            ++this.nbFiles;
                            this.handleNbFiles(false);
                            debFile = true;
                        }
                        if (fileCreated) {
                            if (this.closeLastRowWithRowSep) {
                                this.bufferedWriter.write(this.rowSep);
                                this.currentFileSize += (long)this.rowSep.length();
                            }
                            this.closeOutputStreamWriter();
                        } else if (this.currentFileSize == 0L && this.generateIfEmpty) {
                            f = new File(this.fileName);
                            addRowToDeb = f.exists() && this.fileAppend;
                            this.newOutputStreamWriter(this.fileName);
                            ++this.nbFiles;
                            this.handleNbFiles(false);
                            if (addRowToDeb && this.beginWithRowSepWhenAppendMode) {
                                this.bufferedWriter.write(this.rowSep);
                                this.currentFileSize += (long)this.rowSep.length();
                            }
                            if (this.isGenerateHeader) {
                                if (this.fileFormat == 0) {
                                    this.currentFileSize += (long)this.generateVariableHeader(this.bufferedWriter, sourceRSMD);
                                } else if (this.fileFormat == 1) {
                                    this.currentFileSize += (long)this.generateFixedHeader(this.bufferedWriter, sourceRSMD);
                                }
                            }
                            this.closeOutputStreamWriter();
                        }
                        if (this.jpstr != null) {
                            this.jpstr.end();
                        }
                        this.handleNbRows(false);
                        this.handleOutFileSize(false);
                    }
                    finally {
                        sourceRSet.close();
                    }
                }
                catch (SQLException e) {
                    this.debugLog("executeSimpleCode", "SQLException : " + e.getMessage(), 1, "ERROR");
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), "SQLException : " + e.getMessage(), "String", false);
                    exceptionToTrow = new EngineExceptionI((Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    this.debugLog("executeSimpleCode", Messages.getString("SqlFileExportActionCodeI.26") + e.getMessage(), 1, "ERROR");
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("SqlFileExportActionCodeI.24") + e.getMessage(), "String", false);
                    exceptionToTrow = new EngineExceptionI((Throwable)e);
                }
                catch (EngineExceptionI e) {
                    this.debugLog("executeSimpleCode", "EngineExceptionI : " + e.getMessage(), 1, "ERROR");
                    this.publishVariable(VariableType.CORE_RET_MESS.getName(), "EngineExceptionI : " + e.getMessage(), "String", false);
                    exceptionToTrow = e;
                }
                catch (Exception e) {
                    exceptionToTrow = new EngineExceptionI((Throwable)e);
                }
                finally {
                    block97: {
                        if (this.sourceNamedObject != null) {
                            try {
                                this.getActionContext().getNamedObjectManager().setCompleted(this.sourceNamedObject);
                            }
                            catch (Exception e) {
                                if (exceptionToTrow == null) break block97;
                                exceptionToTrow = new EngineExceptionI((Throwable)e);
                            }
                        }
                    }
                    if (stmtSelect != null) {
                        try {
                            stmtSelect.close();
                        }
                        catch (SQLException e) {
                            this.logger.warn("unexpected", (Throwable)e);
                        }
                    }
                    this.closeConnection();
                    this.closeOutputStreamWriter();
                }
                if (exceptionToTrow != null) {
                    throw exceptionToTrow;
                }
            }
            catch (FileNotFoundException e) {
                this.debugLog("executeSimpleCode", Messages.getString("SqlFileExportActionCodeI.25") + e.getMessage(), 1, "ERROR");
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), Messages.getString("SqlFileExportActionCodeI.27") + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
            catch (UnsupportedEncodingException e) {
                this.debugLog("executeSimpleCode", "UnsupportedEncodingException : " + e.getMessage(), 1, "ERROR");
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), "UnsupportedEncodingException : " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
            catch (IOException e) {
                this.debugLog("executeSimpleCode", "IOException : " + e.getMessage(), 1, "ERROR");
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), "IOException : " + e.getMessage(), "String", false);
                throw new EngineExceptionI((Throwable)e);
            }
            catch (EngineExceptionI e) {
                this.debugLog("executeSimpleCode", "EngineExceptionI : " + e.getMessage(), 1, "ERROR");
                this.publishVariable(VariableType.CORE_RET_MESS.getName(), "EngineExceptionI : " + e.getMessage(), "String", false);
                throw e;
            }
        }
        this.handleOutFileSize(true);
        this.handleNbFiles(true);
        this.handleNbRows(true);
        return ret;
    }

    private boolean shouldGenerateHeader(boolean addRowToDeb) {
        if (!this.isGenerateHeader) {
            return false;
        }
        if (this.fileAppend && this.copyHeaderWhenAppend && addRowToDeb) {
            return true;
        }
        if (this.fileAppend && !addRowToDeb) {
            return true;
        }
        if ("true".equals(this.generateHeader) && !this.fileAppend) {
            return true;
        }
        return "always".equals(this.generateHeader);
    }

    private void handleNbRows(boolean last) {
        this.publishStatistic("SQL_NB_ROWS", this.numRecord, last);
    }

    private void handleNbFiles(boolean last) {
        this.publishStatistic("SQL_EXP_NB_FILES", this.nbFiles, last);
    }

    private void handleOutFileSize(boolean last) {
        this.publishStatistic("OUT_FILE_SIZE", this.currentFileSize, last);
    }

    void newOutputStreamWriter(String fileName) throws IOException {
        this.newOutputStreamWriter(new FileOutputStream(fileName, this.fileAppend));
    }

    void newOutputStreamWriter(OutputStream os) throws IOException {
        this.closeOutputStreamWriter();
        this.fileOutputStream = os;
        this.bufferedOutputStream = new BufferedOutputStream(this.fileOutputStream, this.fileBufferSize);
        if (this.zipMode == 1) {
            this.gzipOutputStream = new GZIPOutputStream(this.bufferedOutputStream);
            this.outputStreamWriter = new OutputStreamWriter((OutputStream)this.gzipOutputStream, this.fileEncoding);
        } else {
            this.outputStreamWriter = new OutputStreamWriter((OutputStream)this.bufferedOutputStream, this.fileEncoding);
        }
        this.bufferedWriter = new BufferedWriter(this.outputStreamWriter);
    }

    void closeOutputStreamWriter() throws IOException {
        if (this.bufferedWriter != null) {
            this.bufferedWriter.close();
            this.bufferedWriter = null;
        }
        if (this.outputStreamWriter != null) {
            this.outputStreamWriter.close();
            this.outputStreamWriter = null;
        }
        if (this.zipMode == 1 && this.gzipOutputStream != null) {
            this.gzipOutputStream.close();
            this.gzipOutputStream = null;
        }
        if (this.bufferedOutputStream != null) {
            this.bufferedOutputStream.close();
            this.bufferedOutputStream = null;
        }
        if (this.fileOutputStream != null) {
            this.fileOutputStream.close();
            this.fileOutputStream = null;
        }
    }

    public static String decodeSpecialChar(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("\\n", "\n").replace("\\t", "\t").replace("\\r", "\r").replace("\\f", "\f");
    }

    private OutputStream newOutputResultSetOutputStream(int num, String fileName) throws Exception {
        Object o = this.getActionContext().getNamedObjectManager().waitObject(this.resultSetName);
        this.jpstr = (JdbcPreparedStatementToResultSet)o;
        if (this.jpstr.getParameterMetaData().getParameterCount() == 0) {
            this.jpstr.setColumnsName("FILE_NUM,FILE_STREAM,FILE_NAME", ",");
            this.jpstr.setColumnType(1, 4);
            this.jpstr.setColumnType(2, -4);
            this.jpstr.setColumnType(3, 12);
        }
        this.getActionContext().getNamedObjectManager().setReady(this.resultSetName);
        this.jpstr.setInt(1, num);
        PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream pis = new PipedInputStream(pos);
        this.jpstr.setBinaryStream(2, (InputStream)pis);
        this.jpstr.setString(3, fileName);
        this.jpstr.executeUpdate();
        return pos;
    }

    public static final class FieldInfo {
        public int index;
        public int colType;
        public String name;
        public int precision;
        public int columnDisplaySize;
        public int scale;

        public FieldInfo(String string, int colType, int index, int precision, int columnDisplaySize, int scale) {
            this.index = index;
            this.name = string;
            this.colType = colType;
            this.precision = precision;
            this.columnDisplaySize = columnDisplaySize;
            this.scale = scale;
        }
    }
}

