/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.JdbcToXmlActionCodeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.actionCodes.utils.BidiMap;
import com.indy.engine.actionCodes.utils.Constant;
import com.indy.engine.actionCodes.utils.IndyContentHandler;
import com.indy.engine.actionCodes.wsdl.HttpOperation;
import com.indy.engine.actionCodes.wsdl.HttpPort;
import com.indy.engine.actionCodes.wsdl.Operation;
import com.indy.engine.actionCodes.wsdl.Part;
import com.indy.engine.actionCodes.wsdl.Port;
import com.indy.engine.actionCodes.wsdl.SoapOperation;
import com.indy.engine.actionCodes.wsdl.SoapPort;
import com.indy.engine.actionCodes.wsdl.Wsdl;
import com.indy.engine.actionCodes.xml.unload.AbstractXmlWriterAPI;
import com.indy.engine.actionCodes.xml.unload.XmlWriterAPI;
import com.indy.engine.common.ntlm.NtlmMetadata;
import com.indy.engine.common.scripting.StbScriptEngineManager;
import com.indy.engine.core.UtilsService;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.indy.engine.secret.ISecretValue;
import com.indy.runtime.utils.SSLUtils;
import com.semarchy.xdi.base.core.auth.OAuth2;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import com.semarchy.xdi.base.core.auth.OAuth2Utils;
import com.semarchy.xdi.base.core.auth.OAuthMetadata;
import com.semarchy.xdi.engine.common.BypassedX509TrustManager;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import jakarta.xml.bind.DatatypeConverter;
import jakarta.xml.soap.Node;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Base64;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.function.Consumer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.xml.namespace.QName;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlToWsdlActionCodeI
extends ActionCodeTypeI {
    static String xsiUri = "http://www.w3.org/2001/XMLSchema-instance";
    private static String mdPrefix = "md";
    private static String mdURI = "http://www.stambia.com/md";
    private String inputFile;
    private AbstractXmlWriterAPI xwa;
    private int retryNumber;
    private int readTimeout;
    private int connectionTimeout;
    private int retryDelay;
    private int delayBetweenInvocation;
    private String encoding;
    private String urlEncoding;
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private ISecretValue proxyPassword;
    private Integer errorAcceptanceNumber;
    private File sentMessagesFolder;
    private File receivedMessagesFolder;
    private String soapStartMessageScript;
    private boolean activeScripting;
    private ScriptEngine engine;
    private Bindings bindings;
    private Map<String, String> headerParameters;
    private String wsseUsernname;
    private String wssePassword;
    private String wssePasswordType;
    private String wsseRawContent;
    private Integer technicalErrorAcceptanceNumber;
    private Integer technicalErrorRetryNumber;
    private Integer technicalErrorRetryDelay;
    private NtlmMetadata ntlmMetadata = null;
    private boolean wsseAddsANonce;
    private boolean wsseAddsACreated;
    private Boolean encloseActionWithQuote = false;
    private Long wsseTimeToLive;
    private String tempFolder;
    private String attachmentsFolder;
    private String xmlVersion;
    private Operation currentOperation;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private boolean wsse;
    private BidiMap<String, String> namespaces = new BidiMap();
    private String xsiPrefix = "xsi";
    public static final String WSSE_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String WSU_URI = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    public static final String DEFAULT_WSSE_PREFIX = "wsse";
    public static final String DEFAULT_WSU_PREFIX = "wsu";
    private MessageDigest digest;
    private String wssePrefix = "wsse";
    private String wsuPrefix = "wsu";
    private Map<String, CompiledScript> compiledScripts;
    private String user;
    private ISecretValue password;
    private SecureRandom random;
    OAuth2Metadata oAuth2 = null;
    OAuthMetadata oAuth = null;

    public XmlToWsdlActionCodeI() {
        super("Xml To Wsdl Action Code", true);
    }

    public Proxy getProxy() {
        if (this.proxyHost != null) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
        }
        return null;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        try {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (FileInputStream is = new FileInputStream(this.inputFile);){
                    SAXParserFactory parserFactory = SAXParserFactory.newInstance();
                    parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
                    parserFactory.setFeature("http://xml.org/sax/features/validation", false);
                    parserFactory.setNamespaceAware(true);
                    SAXParser parser = parserFactory.newSAXParser();
                    XMLReader saxReader = parser.getXMLReader();
                    SimpleContentHandler sch = new SimpleContentHandler();
                    saxReader.setContentHandler((ContentHandler)((Object)sch));
                    saxReader.parse(new InputSource(is));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        finally {
            if (this.xwa != null) {
                this.xwa.close();
            }
        }
        return 0;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws EngineExceptionI {
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return 0;
    }

    public int prepare(ResultSet rs) throws EngineExceptionI {
        String oauth1Token;
        this.attachmentsFolder = this.getLocalStringBindedParameter(rs, "RECEIVED_ATTACHMENTS_FOLDER", null);
        this.proxyHost = this.getLocalStringBindedParameter(rs, "PROXY_HOST", null);
        this.proxyPort = this.getLocalIntegerBindedParameter(rs, "PROXY_PORT", -1);
        this.proxyUser = this.getLocalStringBindedParameter(rs, "PROXY_USER", null);
        this.proxyPassword = this.getLocalSecretBindedParameter(rs, "PROXY_PASSWORD", null);
        this.tempFolder = this.getStringParameter(this.runtimeContext.VAR_PREFIXE + Constant.VAR_CORE_TEMPORARY_FOLDER);
        this.inputFile = this.getLocalStringBindedParameter(rs, "IN_FILE_NAME");
        if (this.inputFile.startsWith("<tempDir>")) {
            File localTempFolder = new File(this.tempFolder);
            if (!localTempFolder.exists()) {
                localTempFolder.mkdirs();
            }
            this.inputFile = String.valueOf(localTempFolder) + File.separator + this.inputFile.substring(9);
        }
        File outFile = new File(this.inputFile);
        this.readTimeout = this.getLocalIntegerBindedParameter(rs, "READ_TIMEOUT", 0);
        this.connectionTimeout = this.getLocalIntegerBindedParameter(rs, "CONNECTION_TIMEOUT", 0);
        this.retryNumber = this.getLocalIntegerBindedParameter(rs, "RETRY_NUMBER", 0);
        this.retryDelay = this.getLocalIntegerBindedParameter(rs, "RETRY_DELAY", 0);
        this.delayBetweenInvocation = this.getLocalIntegerBindedParameter(rs, "DELAY_BETWEEN_INVOCATIONS", 0);
        String xmlOutPutFactoryClassName = this.getLocalStringBindedParameter(rs, "XML_OUTPUT_FACTORY", null);
        this.xmlVersion = this.getLocalStringBindedParameter(rs, "WRITE_XML_VERSION", "1.1");
        this.encoding = this.getLocalStringBindedParameter(rs, "OUT_FILE_ENCODING", null);
        this.urlEncoding = this.getLocalStringBindedParameter(rs, "URL_ENCODED_CHARSET", null);
        boolean writeXmlDeclaration = this.getLocalBooleanBindedParameter(rs, "WRITE_XML_DECLARATION", true);
        this.errorAcceptanceNumber = this.getLocalIntegerBindedParameter(rs, "ERROR_ACCEPTANCE_NUMBER", -1);
        this.technicalErrorAcceptanceNumber = this.getLocalIntegerBindedParameter(rs, "TECHNICAL_ERROR_ACCEPTANCE_NUMBER", 0);
        this.technicalErrorRetryNumber = this.getLocalIntegerBindedParameter(rs, "TECHNICAL_ERROR_RETRY_NUMBER", 0);
        this.technicalErrorRetryDelay = this.getLocalIntegerBindedParameter(rs, "TECHNICAL_ERROR_RETRY_DELAY", 0);
        String currentParam = this.getLocalStringBindedParameter(rs, "SENT_MESSAGES_FOLDER", null);
        if (currentParam != null && !currentParam.isEmpty()) {
            this.sentMessagesFolder = new File(currentParam);
            this.sentMessagesFolder.mkdirs();
            if (!this.sentMessagesFolder.isDirectory()) {
                throw new EngineExceptionI(Messages.getString("XmlToWsdlActionCodeI.0") + currentParam + Messages.getString("XmlToWsdlActionCodeI.1"));
            }
        }
        if ((currentParam = this.getLocalStringBindedParameter(rs, "RECEIVED_MESSAGES_FOLDER", null)) != null && !currentParam.isEmpty()) {
            this.receivedMessagesFolder = new File(currentParam);
            this.receivedMessagesFolder.mkdirs();
            if (!this.receivedMessagesFolder.isDirectory()) {
                throw new EngineExceptionI(Messages.getString("XmlToWsdlActionCodeI.2") + currentParam + Messages.getString("XmlToWsdlActionCodeI.3"));
            }
        }
        this.xwa = new XmlWriterAPI(true, this.getEncoding(), writeXmlDeclaration, this.xmlVersion, null, xmlOutPutFactoryClassName, outFile, this, AbstractXmlWriterAPI.NoDataBehaviour.deleteExistingFile, AbstractXmlWriterAPI.FileAlreadyExistsBehaviour.replace, null, null){

            @Override
            public JdbcToXmlActionCodeI.IndyElement getRoot() {
                return null;
            }
        };
        this.soapStartMessageScript = this.getLocalStringBindedParameter(rs, "SOAP_START_MESSAGE_SCRIPT", null);
        this.activeScripting = this.getLocalBooleanBindedParameter(rs, "ACTIVE_SCRIPTING", false);
        if (this.isActiveScripting()) {
            StbScriptEngineManager mgr = null;
            try {
                mgr = new StbScriptEngineManager(ClassLoaderServiceProvider.instance().getClassLoader("internal"));
            }
            catch (ClassLoaderServiceProvider.ClassLoaderServiceException ex) {
                throw new EngineExceptionI((Throwable)ex);
            }
            this.engine = mgr.getEngineByName("rhino");
            this.bindings = this.getEngine().getBindings(100);
        }
        TrustManager[] trustManagers = null;
        if (Boolean.TRUE.equals(this.getLocalBooleanBindedParameter(rs, "IGNORE_TRUST_STORE", false))) {
            trustManagers = new TrustManager[]{new BypassedX509TrustManager()};
        } else {
            final String trustStore = this.getLocalStringBindedParameter(rs, "TRUST_STORE", null);
            if (trustStore != null) {
                final String keyStoreType = this.getLocalStringBindedParameter(rs, "TRUST_STORE_TYPE", "JKS");
                final ISecretValue keyStorePassword = this.getLocalSecretBindedParameter(rs, "TRUST_STORE_PASSWORD", "changeit");
                try {
                    trustManagers = (TrustManager[])this.secret((ISecretStatement)new ISecretStatement<TrustManager[]>(){

                        public TrustManager[] execute(ISecretContext context) throws Exception {
                            return SSLUtils.loadTrustStore((String)trustStore, (String)keyStoreType, (String)keyStorePassword.decryptString(context));
                        }
                    });
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
            }
        }
        if (Boolean.TRUE.equals(this.getLocalBooleanBindedParameter(rs, "IGNORE_HOSTNAME_VERIFIER", false))) {
            this.hostnameVerifier = (hostname, sslSession) -> true;
        }
        final String keyStore = this.getLocalStringBindedParameter(rs, "KEY_STORE", null);
        KeyManager[] keyManagers = null;
        if (keyStore != null) {
            final String keyStoreType = this.getLocalStringBindedParameter(rs, "KEY_STORE_TYPE", "JKS");
            final ISecretValue keyStorePassword = this.getLocalSecretBindedParameter(rs, "KEY_STORE_PASSWORD", "changeit");
            try {
                keyManagers = (KeyManager[])this.secret((ISecretStatement)new ISecretStatement<KeyManager[]>(){

                    public KeyManager[] execute(ISecretContext context) throws Exception {
                        return SSLUtils.loadKeyStore((String)keyStore, (String)keyStoreType, (String)keyStorePassword.decryptString(context));
                    }
                });
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        if (System.getProperty("javax.net.ssl.keyStore") != null) {
            try {
                keyManagers = SSLUtils.loadKeyStore((String)System.getProperty("javax.net.ssl.keyStore"), (String)System.getProperty("javax.net.ssl.keyStoreType"), (String)System.getProperty("javax.net.ssl.keyStorePassword"));
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        if (keyManagers != null || trustManagers != null) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagers, trustManagers, null);
                this.sslSocketFactory = sslContext.getSocketFactory();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        this.user = this.getLocalStringBindedParameter(rs, "USER", null);
        this.password = this.getLocalSecretBindedParameter(rs, "PASSWORD", null);
        String httpHeaderParameterSeprator = this.getLocalStringBindedParameter(rs, "HTTP_HEADER_PARAMETER_SEPARATOR", "\n");
        String httpHeaderValueSeprator = this.getLocalStringBindedParameter(rs, "HTTP_HEADER_VALUE_SEPARATOR", ":");
        String httpHeaders = this.getLocalStringBindedParameter(rs, "HTTP_HEADER_PARAMETERS", null);
        this.headerParameters = new HashMap<String, String>();
        if (httpHeaders != null) {
            String[] strs;
            String[] stringArray = strs = httpHeaders.split(httpHeaderParameterSeprator);
            int n = strs.length;
            int n2 = 0;
            while (n2 < n) {
                String param = stringArray[n2];
                int index = (param = param.trim()).indexOf(httpHeaderValueSeprator);
                if (index > -1) {
                    this.headerParameters.put(param.substring(0, index), param.substring(index + 1));
                }
                ++n2;
            }
        }
        final String ntlmUser = this.getLocalStringBindedParameter(rs, "NTLM_USER", null);
        final String ntlmDomain = this.getLocalStringBindedParameter(rs, "NTLM_DOMAIN", null);
        final ISecretValue ntlmEncPassword = this.getLocalSecretBindedParameter(rs, "NTLM_PASSWORD", null);
        if (ntlmUser != null) {
            try {
                this.ntlmMetadata = (NtlmMetadata)this.secret((ISecretStatement)new ISecretStatement<NtlmMetadata>(){

                    public NtlmMetadata execute(ISecretContext context) throws Exception {
                        return new NtlmMetadata(ntlmUser, ntlmEncPassword.decryptString(context), ntlmDomain);
                    }
                });
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        this.wsseUsernname = this.getLocalStringBindedParameter(rs, "WSSE_USERNAME", null);
        this.wssePassword = this.getLocalPasswordParameter(rs, "WSSE_PASSWORD", "WSSE_UNCRYPTED_PASSWORD", null);
        this.wssePasswordType = this.getLocalStringBindedParameter(rs, "WSSE_PASSWORD_TYPE", "PasswordDigest");
        this.wsseTimeToLive = this.getLocalLongBindedParameter(rs, "WSSE_TIME_TO_LIVE", null);
        this.wsseAddsACreated = this.getLocalBooleanBindedParameter(rs, "WSSE_ADDS_CREATED", false);
        this.wsseAddsANonce = this.getLocalBooleanBindedParameter(rs, "WSSE_ADDS_NONCE", false);
        this.wsseRawContent = this.getLocalStringBindedParameter(rs, "WSSE_RAW_CONTENT", null);
        this.wsse = this.wsseUsernname != null && !this.wsseUsernname.isEmpty() || this.wsseTimeToLive != null && this.wsseTimeToLive > 0L || this.wsseRawContent != null && !this.wsseRawContent.isEmpty();
        this.encloseActionWithQuote = this.getLocalBooleanBindedParameter(rs, "SOAP_ENCLOSE_ACTION_URI", false);
        String oauth2AccessToken = this.getLocalStringBindedParameter(rs, "OAUTH2_ACCESS_TOKEN", null);
        String oauth2RefreshToken = this.getLocalStringBindedParameter(rs, "OAUTH2_REFRESH_TOKEN", null);
        String oauth2FlowType = this.getLocalStringBindedParameter(rs, "OAUTH2_FLOW_TYPE", null);
        if (oauth2AccessToken != null || oauth2RefreshToken != null || oauth2FlowType != null) {
            this.oAuth2 = new OAuth2Metadata();
            OAuth2Utils.setLog4JLogger((OAuth2Metadata)this.oAuth2, (Logger)LogManager.getLogger((String)this.runtimeContext.comIndyEngineActionCodes));
            this.oAuth2.accessToken = oauth2AccessToken;
            this.oAuth2.proxyHost = this.proxyHost;
            this.oAuth2.proxyPort = this.proxyPort;
            this.oAuth2.proxyUser = this.getProxyUser();
            try {
                this.oAuth2.proxyPassword = (String)this.secret((ISecretStatement)new ISecretStatement<String>(){

                    public String execute(ISecretContext context) throws Exception {
                        return XmlToWsdlActionCodeI.this.getProxyPassword().decryptString(context);
                    }
                });
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
            if (oauth2RefreshToken != null || oauth2FlowType != null) {
                this.oAuth2.refreshToken = oauth2RefreshToken;
                this.oAuth2.flowType = oauth2FlowType;
                this.oAuth2.tokenEndpoint = this.getLocalStringBindedParameter(rs, "OAUTH2_TOKEN_ENDPOINT", null);
                final ISecretValue secretClientId = this.getLocalSecretBindedParameter(rs, "OAUTH2_CLIENT_ID", null);
                final ISecretValue secretClientSecret = this.getLocalSecretBindedParameter(rs, "OAUTH2_CLIENT_SECRET", this.getLocalStringBindedParameter(rs, "OAUTH2_UNCRYPTED_CLIENT_SECRET", null));
                this.oAuth2.expiresIn = this.getLocalLongBindedParameter(rs, "OAUTH2_EXPIRES_IN", 0L);
                this.oAuth2.numberOfAttempts = this.getLocalIntegerBindedParameter(rs, "OAUTH2_NUMBER_OF_ATTEMPTS", 1);
                this.oAuth2.connectionTimeout = this.getLocalIntegerBindedParameter(rs, "OAUTH2_CONNECTION_TIMEOUT", -1);
                boolean sendClientId = this.getLocalBooleanBindedParameter(rs, "OAUTH2_SEND_CLIENT_ID", false);
                boolean sendClientSecret = this.getLocalBooleanBindedParameter(rs, "OAUTH2_SEND_CLIENT_SECRET", false);
                String credentialPolicyName = this.getLocalStringBindedParameter(rs, "OAUTH2_SEND_CLIENT_CREDENTIALS_POLICY", null);
                OAuth2.CredentialMode credentialPolicy = OAuth2.CredentialMode.NONE;
                if (credentialPolicyName == null) {
                    if (sendClientId) {
                        credentialPolicy = sendClientSecret ? OAuth2.CredentialMode.PARAMETER_CLIENT_ID_AND_SECRET : OAuth2.CredentialMode.PARAMETER_CLIENT_ID;
                    }
                } else {
                    credentialPolicy = OAuth2.CredentialMode.fromLabel((String)credentialPolicyName);
                    if (credentialPolicy == null) {
                        throw new EngineExceptionI(String.format(Messages.getString("XmlToWsdlActionCodeI.4"), credentialPolicyName));
                    }
                }
                this.oAuth2.clientCredentialPolicy = credentialPolicy;
                this.oAuth2.tokenEndpointHttpMethod = this.getLocalStringBindedParameter(rs, "OAUTH2_TOKEN_ENDPOINT_HTTP_METHOD", "POST");
                final ISecretValue secretLogin = this.getLocalSecretBindedParameter(rs, "OAUTH2_USERNAME", null);
                this.oAuth2.scope = this.getLocalStringBindedParameter(rs, "OAUTH2_SCOPE", null);
                final ISecretValue secretPassword = this.getLocalSecretBindedParameter(rs, "OAUTH2_PASSWORD", null);
                this.secret((ISecretStatement)new ISecretStatement<Object>(){

                    public Object execute(ISecretContext context) throws Throwable {
                        XmlToWsdlActionCodeI.this.oAuth2.clientId = secretClientId.getString(context);
                        XmlToWsdlActionCodeI.this.oAuth2.clientSecret = secretClientSecret.decryptString(context);
                        XmlToWsdlActionCodeI.this.oAuth2.login = secretLogin.getString(context);
                        XmlToWsdlActionCodeI.this.oAuth2.password = secretPassword.decryptString(context);
                        return null;
                    }
                });
                String additionnalParameters = this.getLocalStringBindedParameter(rs, "OAUTH2_ADDITIONAL_PARAMETERS", null);
                if (additionnalParameters != null) {
                    Properties p = new Properties();
                    StringReader sr = new StringReader(additionnalParameters);
                    try {
                        p.load(sr);
                        this.oAuth2.additionnalParameters = p;
                    }
                    catch (IOException e) {
                        throw new EngineExceptionI((Throwable)e);
                    }
                }
            }
        }
        if ((oauth1Token = this.getLocalStringBindedParameter(rs, "OAUTH_TOKEN", null)) != null) {
            this.oAuth = new OAuthMetadata();
            this.oAuth.token = oauth1Token;
            this.oAuth.consumerKey = this.getLocalStringBindedParameter(rs, "OAUTH_CONSUMER_KEY");
            this.oAuth.consumerSecret = this.getLocalPasswordParameter(rs, "OAUTH_CONSUMER_SECRET", "OAUTH_UNCRYPTED_CONSUMER_SECRET");
            this.oAuth.signatureMethod = this.getLocalStringBindedParameter(rs, "OAUTH_SIGNATURE_METHOD");
            this.oAuth.tokenSecret = this.getLocalPasswordParameter(rs, "OAUTH_TOKEN_SECRET", "OAUTH_UNCRYPTED_TOKEN_SECRET");
            this.oAuth.version = "1.0";
        }
        return 0;
    }

    public String digest(String nonce, String created, byte[] password) throws NoSuchAlgorithmException {
        String passwdDigest = null;
        byte[] b1 = nonce != null ? Base64.getDecoder().decode(nonce) : new byte[]{};
        byte[] b2 = created != null ? created.getBytes(StandardCharsets.UTF_8) : new byte[]{};
        byte[] b3 = password;
        byte[] b4 = new byte[b1.length + b2.length + b3.length];
        int offset = 0;
        System.arraycopy(b1, 0, b4, offset, b1.length);
        System.arraycopy(b2, 0, b4, offset += b1.length, b2.length);
        System.arraycopy(b3, 0, b4, offset += b2.length, b3.length);
        byte[] digestBytes = null;
        if (this.digest == null) {
            this.digest = MessageDigest.getInstance("SHA-1");
        }
        digestBytes = this.digest.digest(b4);
        passwdDigest = Base64.getEncoder().encodeToString(digestBytes);
        return passwdDigest;
    }

    public byte[] nonce(int length) throws NoSuchAlgorithmException {
        if (this.random == null) {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        byte[] temp = new byte[length];
        this.random.nextBytes(temp);
        return temp;
    }

    public void stopAction(Thread th) {
        super.stopAction(th);
        if (this.currentOperation != null) {
            this.currentOperation.killOpenedConnections();
        }
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public ISecretValue getProxyPassword() {
        return this.proxyPassword;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int getDelayBetweenInvocation() {
        return this.delayBetweenInvocation;
    }

    public Integer getTechnicalErrorRetryNumber() {
        return this.technicalErrorRetryNumber;
    }

    public int getRetryNumber() {
        return this.retryNumber;
    }

    public Integer getTechnicalErrorRetryDelay() {
        return this.technicalErrorRetryDelay;
    }

    public int getRetryDelay() {
        return this.retryDelay;
    }

    public Integer getTechnicalErrorAcceptanceNumber() {
        return this.technicalErrorAcceptanceNumber;
    }

    public boolean isActiveScripting() {
        return this.activeScripting;
    }

    public String getSoapStartMessageScript() {
        return this.soapStartMessageScript;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }

    public String getUser() {
        return this.user;
    }

    public ISecretValue getPassword() {
        return this.password;
    }

    public Map<String, CompiledScript> getCompiledScripts() {
        return this.compiledScripts;
    }

    public class SimpleContentHandler
    extends IndyContentHandler {
        private static final String WSDL_NB_DONE = "WSDL_NB_DONE";
        private static final String WSDL_NB_ERROR = "WSDL_NB_ERROR";
        int skipedElement = 0;
        int nbInvocation = 0;
        int nbInvocationError = 0;
        String currentPath = "";
        Part currentPart;
        Port currentPort;
        Wsdl currentWsdl;
        Operation currentOperation;
        String currentStyle;
        private boolean isRoot = true;

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (this.currentWsdl != null) {
                this.currentWsdl.namespaces.put((Object)prefix, (Object)uri);
            } else {
                XmlToWsdlActionCodeI.this.namespaces.put((Object)prefix, (Object)uri);
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            if (this.currentWsdl != null) {
                this.currentWsdl.namespaces.remove((Object)prefix);
            } else {
                XmlToWsdlActionCodeI.this.namespaces.remove((Object)prefix);
            }
        }

        public void endDocument() throws SAXException {
            try {
                XmlToWsdlActionCodeI.this.xwa.endCurrentDocument(new File(XmlToWsdlActionCodeI.this.inputFile));
                XmlToWsdlActionCodeI.this.publishStatistic(WSDL_NB_ERROR, this.nbInvocationError, true);
                XmlToWsdlActionCodeI.this.publishStatistic(WSDL_NB_DONE, this.nbInvocation, true);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            super.endDocument();
        }

        public void startDocument() throws SAXException {
            try {
                XmlToWsdlActionCodeI.this.xwa.startNewDocument(false);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
            super.startDocument();
        }

        public void characters(char[] ch, int start, int end) throws SAXException {
            try {
                if (this.currentOperation != null && this.currentOperation.inputPartState == Operation.PartState.OPEN) {
                    if (this.currentOperation instanceof SoapOperation) {
                        this.currentOperation.addText(new String(ch, start, end));
                    } else if (this.currentOperation instanceof HttpOperation) {
                        if (((HttpOperation)this.currentOperation).getInputMode() == HttpOperation.InputMode.PARAM) {
                            ((HttpOperation)this.currentOperation).addParameterValue(new String(ch, start, end));
                        } else if (((HttpOperation)this.currentOperation).getInputMode() == HttpOperation.InputMode.XML) {
                            this.currentOperation.addText(new String(ch, start, end));
                        } else if (((HttpOperation)this.currentOperation).getInputMode() == HttpOperation.InputMode.RAW) {
                            this.currentOperation.addText(new String(ch, start, end));
                        }
                    }
                }
                XmlToWsdlActionCodeI.this.xwa.getXMLStreamWriter().writeCharacters(ch, start, end);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        private void debug(String message) {
            XmlToWsdlActionCodeI.this.getActionCodeLogger().debug("{} {}", (Object)this.currentPath, (Object)message);
        }

        private void closeHttpParameter() {
            ((HttpOperation)this.currentOperation).closeParameter();
        }

        public void endElement(String nameSpaceURI, String localName, String rawName) throws SAXException {
            this.debug("endElement");
            try {
                XmlToWsdlActionCodeI.this.interruptedException();
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                throw new SAXException(e1);
            }
            try {
                if (this.currentOperation != null && this.currentOperation.inputPartState == Operation.PartState.OPEN && !this.currentPart.path.equals(this.currentPath)) {
                    this.closeInputPartElement();
                }
                if (this.currentPort != null && this.currentPort.path.equals(this.currentPath)) {
                    this.closePort();
                } else if (this.currentOperation != null && this.currentOperation.path.equals(this.currentPath)) {
                    this.closeOperation();
                } else if (this.currentPart != null && this.currentPart.path.equals(this.currentPath) && this.currentOperation != null) {
                    this.currentOperationStateAction(localName);
                    this.currentPart = null;
                    this.debug("Current Part is Reset");
                } else if (this.currentOperation != null && this.currentOperation.inputPath.equals(this.currentPath)) {
                    this.closeInput();
                } else if (this.currentOperation != null && this.currentOperation.outputPath.equals(this.currentPath)) {
                    this.closeOutput();
                }
                this.closeCurrent();
                if (this.currentPath.contains("/")) {
                    this.currentPath = this.currentPath.substring(0, this.currentPath.lastIndexOf("/"));
                }
            }
            catch (Exception e) {
                throw new SAXException(Messages.getString("XmlToWsdlActionCodeI.5") + this.currentPath, e);
            }
        }

        private void currentOperationStateAction(String localName) throws SOAPException {
            if (this.currentOperation.inputPartState == Operation.PartState.OPEN) {
                this.closeInputPart();
            } else if (this.currentOperation.state == Operation.OperationState.OUTPUT) {
                this.closeOutputPart(localName);
            } else if (this.currentOperation.state == Operation.OperationState.FAULT) {
                this.closeFaultPart();
            }
        }

        private void closeOutput() throws Exception {
            this.invoke();
            this.currentOperation.intoOutput = false;
            this.currentOperation.clear();
        }

        private void closeInput() {
            this.currentOperation.inputPartState = Operation.PartState.CLOSE;
        }

        private void closeInputPart() throws SOAPException {
            this.currentOperation.inputPartState = Operation.PartState.CLOSE;
            if (this.currentOperation instanceof HttpOperation) {
                if (((HttpOperation)this.currentOperation).getInputMode() == HttpOperation.InputMode.PARAM) {
                    this.closeHttpParameter();
                    ((HttpOperation)this.currentOperation).setInputMode(null);
                }
            } else {
                Operation operation = this.currentOperation;
                if (operation instanceof SoapOperation) {
                    SoapOperation op = (SoapOperation)operation;
                    if (this.currentPart.hasType) {
                        op.endElement();
                    }
                }
            }
        }

        private void closePort() {
            this.currentPort = null;
        }

        private void closeInputPartElement() throws Exception {
            this.currentOperation.endElement();
        }

        private void closeCurrent() throws XMLStreamException {
            if (this.skipedElement == 0) {
                XmlToWsdlActionCodeI.this.xwa.getXMLStreamWriter().writeEndElement();
            } else {
                --this.skipedElement;
            }
        }

        private void closeOperation() {
            this.currentOperation = null;
            XmlToWsdlActionCodeI.this.currentOperation = null;
        }

        private void closeFaultPart() {
            this.currentOperation.faultPartState = Operation.PartState.CLOSE;
            try {
                this.invoke();
                this.currentOperation.writeFault(XmlToWsdlActionCodeI.this.xwa);
            }
            catch (Exception e) {
                XmlToWsdlActionCodeI.this.log.warn((Object)e);
            }
            this.currentOperation.state = Operation.OperationState.NONE;
        }

        private void invoke() throws Exception {
            if (this.currentOperation.isAlreadyInvokated) {
                return;
            }
            Operation operation = this.currentOperation;
            if (operation instanceof SoapOperation) {
                SoapOperation so = (SoapOperation)operation;
                if (XmlToWsdlActionCodeI.this.ntlmMetadata != null) {
                    so.setNtlmMetadata(XmlToWsdlActionCodeI.this.ntlmMetadata);
                }
                so.setAttachmentsFolder(XmlToWsdlActionCodeI.this.attachmentsFolder);
            } else {
                Operation operation2 = this.currentOperation;
                if (operation2 instanceof HttpOperation) {
                    HttpOperation ho = (HttpOperation)operation2;
                    ho.setOauth(XmlToWsdlActionCodeI.this.oAuth);
                    if (XmlToWsdlActionCodeI.this.ntlmMetadata != null) {
                        ho.setNtlmMetadata(XmlToWsdlActionCodeI.this.ntlmMetadata);
                    }
                }
            }
            if (this.currentOperation.inputPartState == Operation.PartState.CLOSE) {
                int ret = this.currentOperation.invoke();
                this.currentOperation.isAlreadyInvokated = true;
                if (ret == 1) {
                    XmlToWsdlActionCodeI.this.publishStatistic(WSDL_NB_DONE, ++this.nbInvocation, false);
                } else if (ret == -1) {
                    XmlToWsdlActionCodeI.this.publishStatistic(WSDL_NB_ERROR, ++this.nbInvocationError, false);
                }
            }
        }

        private void closeOutputPart(String localName) throws SOAPException {
            this.currentOperation.outputPartState = Operation.PartState.CLOSE;
            try {
                this.invoke();
                this.currentOperation.writeMessage(XmlToWsdlActionCodeI.this.xwa, localName, this.currentPart.firstOutputElementName);
            }
            catch (Exception e) {
                XmlToWsdlActionCodeI.this.log.warn((Object)e);
                throw new SOAPException((Throwable)e);
            }
            this.currentOperation.state = Operation.OperationState.FIRST_OUTPUT_DONE;
        }

        private void openPort(Attributes attributs) throws SAXException {
            this.currentPort = null;
            String protocol = attributs.getValue("md:protocol");
            this.currentStyle = attributs.getValue("md:style");
            if (protocol != null) {
                if (protocol.equals("HTTP")) {
                    HttpPort hp = new HttpPort();
                    this.currentPort = hp;
                    hp.mainAdress = attributs.getValue("md:address");
                    String verb = attributs.getValue("md:verb");
                    if (verb != null) {
                        hp.verb = HttpOperation.HttpVerb.valueOf(verb);
                        if (hp.verb == null) {
                            throw new SAXException("unknown HTTP Verb: " + verb);
                        }
                    }
                } else if (protocol.equals("SOAP")) {
                    SoapPort sp = new SoapPort();
                    this.currentPort = sp;
                    sp.address = attributs.getValue("md:address");
                    sp.transportURI = attributs.getValue("md:transportURI");
                }
            }
            if (this.currentPort != null) {
                this.currentPort.path = this.currentPath;
                this.currentPort.wsdl = this.currentWsdl;
            }
        }

        public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attributs) throws SAXException {
            try {
                String typeNode;
                XmlToWsdlActionCodeI.this.interruptedException();
                this.currentPath = String.valueOf(this.currentPath) + "/" + localName;
                this.debug("startElement");
                this.openCurrent(localName, attributs);
                if (this.isRoot) {
                    this.isRoot = false;
                    XmlToWsdlActionCodeI.this.xwa.getXMLStreamWriter().writeNamespace(XmlToWsdlActionCodeI.this.xsiPrefix, xsiUri);
                    XmlToWsdlActionCodeI.this.xwa.getXMLStreamWriter().writeNamespace(mdPrefix, mdURI);
                }
                if (this.currentPart != null) {
                    if (this.currentOperation.inputPartState == Operation.PartState.OPEN) {
                        this.openInputPartElement(nameSpaceURI, localName, attributs);
                    } else if (this.currentOperation.outputPartState == Operation.PartState.OPEN) {
                        this.openOutputPartElement(localName, attributs);
                    } else if (this.currentOperation.faultPartState == Operation.PartState.OPEN) {
                        this.openFaultPartElement(attributs);
                    }
                }
                String string = typeNode = (typeNode = attributs.getValue("md:defType")) == null ? attributs.getValue("defType") : typeNode;
                if (typeNode == null) {
                    return;
                }
                if (typeNode.equals("com.stambia.xml.namespace")) {
                    this.parseNamespace(attributs);
                } else if (typeNode.equals("com.stambia.wsdl.wsdl")) {
                    this.openWsdl(attributs);
                } else if (typeNode.equals("com.stambia.wsdl.port")) {
                    this.openPort(attributs);
                } else if (typeNode.equals("com.stambia.wsdl.operation")) {
                    this.openOperation(attributs);
                } else if (typeNode.equals("com.stambia.wsdl.input")) {
                    this.openInput();
                } else if (typeNode.equals("com.stambia.wsdl.output")) {
                    this.openOutput();
                } else if (typeNode.equals("com.stambia.wsdl.fault")) {
                    if (this.currentOperation != null) {
                        this.currentOperation.state = Operation.OperationState.FAULT;
                    }
                } else if (typeNode.equals("com.stambia.wsdl.part")) {
                    if (this.currentOperation != null) {
                        if (this.currentOperation.state == Operation.OperationState.FIRST_OUTPUT_DONE) {
                            this.currentOperation.state = Operation.OperationState.OUTPUT;
                        }
                        if (this.currentOperation.state == Operation.OperationState.INPUT) {
                            this.openInputPart(localName, attributs, false);
                        } else if (this.currentOperation.state == Operation.OperationState.OUTPUT) {
                            this.openOutputPart(localName, attributs);
                        } else if (this.currentOperation.state == Operation.OperationState.FAULT) {
                            this.openFaultPart(attributs);
                        }
                    }
                } else if (typeNode.equals("com.stambia.wsdl.headerPart") && this.currentOperation != null && this.currentOperation.state == Operation.OperationState.INPUT) {
                    this.openInputPart(localName, attributs, true);
                }
            }
            catch (SAXException e) {
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SAXException(e);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }

        private void openFaultPartElement(Attributes attributs) {
            String typeNode = attributs.getValue("md:defType");
            if (typeNode != null && typeNode.startsWith("com.stambia.json.root")) {
                String readEncoding = attributs.getValue("md:encoding");
                if (readEncoding == null || readEncoding.isEmpty()) {
                    readEncoding = StandardCharsets.UTF_8.name();
                }
                ((HttpOperation)this.currentOperation).setFaultEncoding(readEncoding);
                ((HttpOperation)this.currentOperation).setFaultType(HttpOperation.PartType.JSON);
            }
        }

        private void openOutputPartElement(String localName, Attributes attributs) {
            String typeNode;
            if (this.currentPart.firstOutputElementName == null) {
                this.currentPart.firstOutputElementName = localName;
            }
            if ((typeNode = attributs.getValue("md:defType")) != null && typeNode.startsWith("com.stambia.json.root")) {
                String readEncoding = attributs.getValue("md:encoding");
                if (readEncoding == null || readEncoding.isEmpty()) {
                    readEncoding = StandardCharsets.UTF_8.name();
                }
                ((HttpOperation)this.currentOperation).setOutputEncoding(readEncoding);
                ((HttpOperation)this.currentOperation).setOutputPartType(HttpOperation.PartType.JSON);
            }
        }

        private void openInputPartElement(String nameSpaceURI, String localName, Attributes attributs) throws Exception {
            String name = localName;
            String typeNode = attributs.getValue("md:defType");
            if (typeNode != null && typeNode.equals("com.stambia.wsdl.simpleType")) {
                name = this.currentPart.getName();
            } else if (typeNode != null && typeNode.startsWith("com.stambia.json.root")) {
                ((HttpOperation)this.currentOperation).setInputPartType(HttpOperation.PartType.JSON);
                String readEncoding = attributs.getValue("md:encoding");
                if (readEncoding == null || readEncoding.isEmpty()) {
                    readEncoding = StandardCharsets.UTF_8.name();
                }
                ((HttpOperation)this.currentOperation).setInputEncoding(readEncoding);
            }
            if (this.currentPart.use != null && this.currentPart.use.equals("encoded")) {
                String type = attributs.getValue("md:originalType");
                Element elt = this.currentOperation.openElement(name, null);
                elt.setAttribute(((SoapOperation)this.currentOperation).getXsiPrefix() + ":type", type);
            } else {
                this.currentOperation.openElement(name, nameSpaceURI);
            }
            int i = 0;
            while (i < attributs.getLength()) {
                String attName = attributs.getQName(i);
                String attValue = attributs.getValue(i);
                if (attValue != null && attName != null && !attName.startsWith("md:")) {
                    this.currentOperation.setAttribute(attName, attValue);
                }
                ++i;
            }
        }

        private void openCurrent(String localName, Attributes attributs) throws XMLStreamException {
            if (this.currentOperation == null || !this.currentOperation.stopOpenOrClose()) {
                XmlToWsdlActionCodeI.this.xwa.writeStartElement(localName);
                int i = 0;
                while (i < attributs.getLength()) {
                    String attName = attributs.getLocalName(i);
                    String attNamespace = attributs.getURI(i);
                    String value = attributs.getValue(i);
                    if (attName != null && (attName.equals("nil") || attName.equals("type")) && attNamespace != null && attNamespace.equals(xsiUri)) {
                        XmlToWsdlActionCodeI.this.xwa.getXMLStreamWriter().writeAttribute(XmlToWsdlActionCodeI.this.xsiPrefix, attNamespace, attName, value);
                    } else if (attNamespace != null && attNamespace.equals(mdURI)) {
                        XmlToWsdlActionCodeI.this.xwa.getXMLStreamWriter().writeAttribute(mdPrefix, mdURI, attName, value);
                    } else {
                        XmlToWsdlActionCodeI.this.xwa.getXMLStreamWriter().writeAttribute(attName, value);
                    }
                    ++i;
                }
            } else {
                ++this.skipedElement;
            }
        }

        private void openOutput() {
            if (this.currentOperation == null) {
                return;
            }
            this.currentOperation.state = Operation.OperationState.OUTPUT;
            this.currentOperation.outputPath = this.currentPath;
            this.currentOperation.intoOutput = true;
        }

        private void openInput() throws Exception {
            if (this.currentOperation != null) {
                this.currentOperation.state = Operation.OperationState.INPUT;
                this.currentOperation.inputPath = this.currentPath;
                if (this.currentOperation instanceof SoapOperation) {
                    ((SoapOperation)this.currentOperation).startMessage();
                    ((SoapOperation)this.currentOperation).setCurrentElementToBody();
                    if (XmlToWsdlActionCodeI.this.wsse) {
                        ((SoapOperation)this.currentOperation).setCurrentElementToHeader();
                        this.addWSSE();
                        ((SoapOperation)this.currentOperation).endElement();
                        ((SoapOperation)this.currentOperation).endElement();
                        ((SoapOperation)this.currentOperation).setCurrentElementToBody();
                    }
                } else if (this.currentOperation instanceof HttpOperation && XmlToWsdlActionCodeI.this.oAuth2 != null) {
                    ((HttpOperation)this.currentOperation).openParameter("Authorization", 3);
                    ((HttpOperation)this.currentOperation).addParameterValue("Bearer " + OAuth2.getToken((OAuth2Metadata)XmlToWsdlActionCodeI.this.oAuth2));
                    ((HttpOperation)this.currentOperation).closeParameter();
                }
            }
        }

        private void parseNamespace(Attributes attributs) {
            if (this.currentWsdl != null) {
                String uri = attributs.getValue("md:name");
                String prefix = attributs.getValue("md:prefix");
                this.currentWsdl.namespaces.put((Object)prefix, (Object)uri);
            }
        }

        private void computeWSSENamespaces(String defaultPrefix, String prefix, String namespace, Consumer<String> prefixConsumer) {
            int i = 1;
            StringBuilder currentPrefix = new StringBuilder(defaultPrefix);
            String currentNamespace = null;
            do {
                if ((currentNamespace = (String)XmlToWsdlActionCodeI.this.namespaces.getFrom((Object)currentPrefix.toString())) != null && !currentNamespace.equals(namespace)) {
                    currentPrefix.append(prefix + "_" + i++);
                    continue;
                }
                currentNamespace = null;
            } while (currentNamespace != null);
            prefixConsumer.accept(namespace);
            XmlToWsdlActionCodeI.this.namespaces.put((Object)currentPrefix.toString(), (Object)namespace);
        }

        private void openWsdl(Attributes attributs) {
            String targetNamespace;
            Wsdl wsdl = new Wsdl();
            wsdl.targetNamespace = targetNamespace = attributs.getValue("md:targetNamespace");
            String elementForm = attributs.getValue("md:prefixForElement");
            String attributeForm = attributs.getValue("md:prefixForAttribute");
            if (elementForm != null && elementForm.equals("qualified")) {
                wsdl.prefixElement = true;
            }
            if (attributeForm != null && attributeForm.equals("qualified")) {
                wsdl.prefixAttribute = true;
            }
            if (XmlToWsdlActionCodeI.this.wsse) {
                this.computeWSSENamespaces(XmlToWsdlActionCodeI.DEFAULT_WSSE_PREFIX, XmlToWsdlActionCodeI.this.wssePrefix, XmlToWsdlActionCodeI.WSSE_URI, s -> {
                    String string = XmlToWsdlActionCodeI.this.wssePrefix = s;
                });
                this.computeWSSENamespaces(XmlToWsdlActionCodeI.DEFAULT_WSU_PREFIX, XmlToWsdlActionCodeI.this.wsuPrefix, XmlToWsdlActionCodeI.WSU_URI, s -> {
                    String string = XmlToWsdlActionCodeI.this.wsuPrefix = s;
                });
            }
            wsdl.globalNamespaces = XmlToWsdlActionCodeI.this.namespaces;
            wsdl.errorAcceptanceNumber = XmlToWsdlActionCodeI.this.errorAcceptanceNumber;
            wsdl.sentMessagesFolder = XmlToWsdlActionCodeI.this.sentMessagesFolder;
            wsdl.receivedMessagesFolder = XmlToWsdlActionCodeI.this.receivedMessagesFolder;
            wsdl.headerParameters = XmlToWsdlActionCodeI.this.headerParameters;
            this.currentWsdl = wsdl;
        }

        private void openInputPart4Soap(String localName, Attributes attributs, boolean headerPart, SoapOperation op) throws Exception {
            String typeOrElement;
            if (headerPart) {
                op.setCurrentElementToHeader();
            }
            this.currentPart.use = attributs.getValue("md:use");
            if (op.getStyle() == SoapOperation.SoapStyle.RPC && !op.isRPCOperationISOpen()) {
                op.openElement(this.currentOperation.getName(), null);
                if (this.currentPart.use != null && this.currentPart.use.equals("encoded")) {
                    String encodingStyle = "http://schemas.xmlsoap.org/soap/encoding/";
                    op.setAttribute("SOAP-ENV:encoding-style", encodingStyle);
                }
                op.setRPCOperationISOpen(true);
            }
            boolean bl = this.currentPart.hasType = (typeOrElement = attributs.getValue("md:typeOrElement")) != null && typeOrElement.equals("type");
            if (this.currentPart.hasType) {
                Element elt = ((SoapOperation)this.currentOperation).openElement(localName, null);
                if (op.getStyle() == SoapOperation.SoapStyle.RPC && this.currentPart.use != null && this.currentPart.use.equals("encoded")) {
                    String type = attributs.getValue("md:originalType");
                    elt.setAttribute(((SoapOperation)this.currentOperation).getXsiPrefix() + ":type", type);
                }
            }
        }

        private void openInputPart4Http(String localName, Attributes attributs, HttpOperation op) throws Exception {
            String type;
            String contentType = attributs.getValue("md:contentType");
            String bindingType = attributs.getValue("md:bindingType");
            HttpOperation.HttpVerb verb = ((HttpPort)((HttpOperation)this.currentOperation).port).verb;
            if (bindingType == null && verb != null) {
                bindingType = verb == HttpOperation.HttpVerb.GET || verb == HttpOperation.HttpVerb.DELETE ? "http:urlEncoded" : "mime:content";
            }
            if (contentType == null) {
                if (verb != null && verb != HttpOperation.HttpVerb.GET && verb != HttpOperation.HttpVerb.DELETE) {
                    if (bindingType.equals("mime:content")) {
                        contentType = "application/x-www-form-urlencoded";
                    } else if (bindingType.equals("mime:mimeXml")) {
                        contentType = "text/xml; charset=UTF-8";
                    }
                }
            } else if (bindingType != null && bindingType.startsWith("http:")) {
                contentType = null;
            }
            if (contentType != null) {
                op.setInputContentType(contentType);
            } else {
                contentType = "";
            }
            String contentTypeLC = contentType.toLowerCase();
            if (contentTypeLC.contains(";")) {
                contentTypeLC = contentTypeLC.substring(0, contentTypeLC.indexOf(";"));
            }
            if (bindingType.equals("http:urlEncoded")) {
                op.setInputMode(HttpOperation.InputMode.PARAM);
                op.openParameter(localName, 1);
            } else if (bindingType.equals("mime:content") && contentType.equals("application/x-www-form-urlencoded")) {
                op.setInputMode(HttpOperation.InputMode.PARAM);
                op.openParameter(localName, 2);
            } else if (bindingType.equals("http:urlReplacement")) {
                op.setInputMode(HttpOperation.InputMode.PARAM);
                op.openParameter(localName, 4);
            } else if (bindingType.equals("http:urlReplacementNotEncoded")) {
                op.setInputMode(HttpOperation.InputMode.PARAM);
                op.openParameter(localName, 9);
            } else if (bindingType.equals("mime:content") && (contentTypeLC.endsWith("/json") || contentTypeLC.endsWith("/xml") || contentTypeLC.endsWith("+json") || contentTypeLC.endsWith("+xml")) || bindingType.equals("mime:mimeXml")) {
                op.setInputMode(HttpOperation.InputMode.XML);
                op.inputPartState = Operation.PartState.OPEN;
            } else if (bindingType.equals("http:header")) {
                op.setInputMode(HttpOperation.InputMode.PARAM);
                op.openParameter(localName, 3);
            } else if (bindingType.equals("http:method")) {
                op.setInputMode(HttpOperation.InputMode.PARAM);
                op.openParameter(localName, 8);
            } else if (bindingType.equals("mime:content") && (type = attributs.getValue("md:type")) != null) {
                if (type.equals("string")) {
                    ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.RAW);
                    ((HttpOperation)this.currentOperation).setInputPartType(HttpOperation.PartType.STRING);
                } else if (type.equals("base64Binary")) {
                    ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.RAW);
                    ((HttpOperation)this.currentOperation).setInputPartType(HttpOperation.PartType.BINARY);
                } else if (type.equals("anyURI")) {
                    ((HttpOperation)this.currentOperation).setInputMode(HttpOperation.InputMode.RAW);
                    ((HttpOperation)this.currentOperation).setInputPartType(HttpOperation.PartType.URI);
                }
            }
        }

        private void openInputPart(String localName, Attributes attributs, boolean headerPart) throws Exception {
            this.initPart();
            this.currentOperation.inputPartState = Operation.PartState.OPEN;
            Operation operation = this.currentOperation;
            if (operation instanceof SoapOperation) {
                SoapOperation op = (SoapOperation)operation;
                this.openInputPart4Soap(localName, attributs, headerPart, op);
            } else {
                Operation operation2 = this.currentOperation;
                if (operation2 instanceof HttpOperation) {
                    HttpOperation op = (HttpOperation)operation2;
                    this.openInputPart4Http(localName, attributs, op);
                }
            }
        }

        private String formatDateTime(long timeInMilli) {
            Calendar currentCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            currentCalendar.setTimeInMillis(timeInMilli);
            return DatatypeConverter.printDateTime((Calendar)currentCalendar);
        }

        private void addWSSE() throws Exception {
            if (XmlToWsdlActionCodeI.this.wsse) {
                ((SoapOperation)this.currentOperation).openElement("Security", XmlToWsdlActionCodeI.WSSE_URI);
                if (XmlToWsdlActionCodeI.this.wsseRawContent != null && !XmlToWsdlActionCodeI.this.wsseRawContent.isEmpty()) {
                    Document doc = UtilsService.getXmlUtils().stringToDOMDocument(XmlToWsdlActionCodeI.this.wsseRawContent);
                    ((SoapOperation)this.currentOperation).appendChild((Node)doc.getChildNodes().item(0));
                } else {
                    String nonce;
                    long currentTime = System.currentTimeMillis();
                    Calendar currentCalendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                    currentCalendar.setTimeInMillis(currentTime);
                    String formatedCurrentDateTime = this.formatDateTime(currentTime);
                    try {
                        nonce = Base64.getEncoder().encodeToString(XmlToWsdlActionCodeI.this.nonce(16));
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new SOAPException((Throwable)e);
                    }
                    int id = 1;
                    if (XmlToWsdlActionCodeI.this.wsseTimeToLive != null && XmlToWsdlActionCodeI.this.wsseTimeToLive > 0L) {
                        String expires = this.formatDateTime(currentTime + XmlToWsdlActionCodeI.this.wsseTimeToLive);
                        SOAPElement timpestamp = (SOAPElement)((SoapOperation)this.currentOperation).openElement("Timestamp", XmlToWsdlActionCodeI.WSU_URI);
                        timpestamp.addAttribute(new QName(XmlToWsdlActionCodeI.WSU_URI, "Id", XmlToWsdlActionCodeI.this.wsuPrefix), "id-" + id++);
                        ((SOAPElement)((SoapOperation)this.currentOperation).openElement("Created", XmlToWsdlActionCodeI.WSU_URI)).addTextNode(formatedCurrentDateTime);
                        ((SoapOperation)this.currentOperation).endElement();
                        ((SoapOperation)this.currentOperation).openElement("Expires", XmlToWsdlActionCodeI.WSU_URI, XmlToWsdlActionCodeI.this.wsuPrefix).addTextNode(expires);
                        ((SoapOperation)this.currentOperation).endElement();
                        ((SoapOperation)this.currentOperation).endElement();
                    }
                    if (XmlToWsdlActionCodeI.this.wsseUsernname != null && !XmlToWsdlActionCodeI.this.wsseUsernname.isEmpty()) {
                        SOAPElement usernameToken = (SOAPElement)((SoapOperation)this.currentOperation).openElement("UsernameToken", XmlToWsdlActionCodeI.WSSE_URI);
                        usernameToken.addAttribute(new QName(XmlToWsdlActionCodeI.WSU_URI, "Id", XmlToWsdlActionCodeI.this.wsuPrefix), "id-" + id);
                        SOAPElement username = (SOAPElement)((SoapOperation)this.currentOperation).openElement("Username", XmlToWsdlActionCodeI.WSSE_URI);
                        username.addTextNode(XmlToWsdlActionCodeI.this.wsseUsernname);
                        ((SoapOperation)this.currentOperation).endElement();
                        String curPassord = XmlToWsdlActionCodeI.this.wssePassword;
                        if (curPassord != null) {
                            if (XmlToWsdlActionCodeI.this.wssePasswordType.equals("PasswordDigest")) {
                                try {
                                    curPassord = XmlToWsdlActionCodeI.this.digest(XmlToWsdlActionCodeI.this.wsseAddsANonce ? nonce : null, XmlToWsdlActionCodeI.this.wsseAddsACreated ? formatedCurrentDateTime : null, curPassord.getBytes(StandardCharsets.UTF_8));
                                }
                                catch (NoSuchAlgorithmException e) {
                                    throw new SOAPException((Throwable)e);
                                }
                            }
                            SOAPElement passwordElt = (SOAPElement)((SoapOperation)this.currentOperation).openElement("Password", XmlToWsdlActionCodeI.WSSE_URI);
                            passwordElt.addAttribute(new QName("Type"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#" + XmlToWsdlActionCodeI.this.wssePasswordType);
                            passwordElt.addTextNode(curPassord);
                            ((SoapOperation)this.currentOperation).endElement();
                        }
                        if (XmlToWsdlActionCodeI.this.wsseAddsANonce) {
                            SOAPElement nonceElt = (SOAPElement)((SoapOperation)this.currentOperation).openElement("Nonce", XmlToWsdlActionCodeI.WSSE_URI);
                            nonceElt.addAttribute(new QName("EncodingType"), "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
                            nonceElt.addTextNode(nonce);
                            ((SoapOperation)this.currentOperation).endElement();
                        }
                        if (XmlToWsdlActionCodeI.this.wsseAddsACreated) {
                            SOAPElement created = (SOAPElement)((SoapOperation)this.currentOperation).openElement("Created", XmlToWsdlActionCodeI.WSU_URI);
                            created.addTextNode(formatedCurrentDateTime);
                            ((SoapOperation)this.currentOperation).endElement();
                        }
                    }
                }
                ((SoapOperation)this.currentOperation).endElement();
            }
        }

        private void openOutputPart(String localName, Attributes attributs) throws Exception {
            this.initPart();
            String outputContentType = attributs.getValue("md:contentType");
            if (outputContentType != null) {
                ((HttpOperation)this.currentOperation).setOutputContentType(outputContentType);
            }
            this.currentOperation.outputPartState = Operation.PartState.OPEN;
            String bindingType = attributs.getValue("md:bindingType");
            if (bindingType == null) {
                return;
            }
            Operation operation = this.currentOperation;
            if (operation instanceof HttpOperation) {
                HttpOperation op = (HttpOperation)operation;
                String type = attributs.getValue("md:type");
                if (type != null) {
                    op.setOutputPartType(HttpOperation.PartType.fromMdType(type));
                }
                if (bindingType.equals("http:responseCode")) {
                    op.openParameter(localName, 5);
                    op.closeParameter();
                } else if (bindingType.equals("http:header")) {
                    op.openParameter(localName, 6);
                    op.closeParameter();
                } else if (bindingType.equals("http:responseMessage")) {
                    op.openParameter(localName, 7);
                    op.closeParameter();
                } else if (bindingType.equals("error:technicalErrorMessage")) {
                    op.openParameter(localName, 10);
                    op.closeParameter();
                } else if (bindingType.equals("error:technicalErrorException")) {
                    op.openParameter(localName, 11);
                    op.closeParameter();
                }
            } else {
                Operation operation2 = this.currentOperation;
                if (operation2 instanceof SoapOperation) {
                    SoapOperation op = (SoapOperation)operation2;
                    if (bindingType.equals("error:technicalErrorMessage")) {
                        op.setErrorMessageName(localName);
                    } else if (bindingType.equals("error:technicalErrorException")) {
                        op.setErrorExceptionName(localName);
                    }
                }
            }
        }

        private void openFaultPart(Attributes attributs) {
            Operation operation;
            String bindingType;
            this.initPart();
            if (this.currentOperation != null) {
                this.currentOperation.faultPartState = Operation.PartState.OPEN;
                this.currentOperation.faultPath = this.currentPath;
            }
            if ((bindingType = attributs.getValue("md:bindingType")) != null && (operation = this.currentOperation) instanceof HttpOperation) {
                HttpOperation op = (HttpOperation)operation;
                String type = attributs.getValue("md:type");
                if (type != null) {
                    if (type.equals("base64Binary")) {
                        op.setFaultType(HttpOperation.PartType.BINARY);
                    } else if (type.equals("string")) {
                        op.setFaultType(HttpOperation.PartType.STRING);
                    } else if (type.equals("anyURI")) {
                        op.setFaultType(HttpOperation.PartType.URI);
                    }
                }
            }
        }

        private void initPart() {
            this.currentPart = new Part();
            this.currentPart.path = this.currentPath;
            this.currentPart.operation = this.currentOperation;
            this.debug("Current Part is Set");
        }

        private void openOperation(Attributes attributs) {
            if (this.currentPort instanceof SoapPort) {
                String actionURI;
                SoapOperation so = new SoapOperation();
                so.setEnloseActionByQUote(XmlToWsdlActionCodeI.this.encloseActionWithQuote);
                this.currentOperation = so;
                if (this.currentStyle != null) {
                    if (this.currentStyle.equals("document")) {
                        so.setStyle(SoapOperation.SoapStyle.DOCUMENT);
                    } else if (this.currentStyle.equals("rpc")) {
                        so.setStyle(SoapOperation.SoapStyle.RPC);
                    }
                }
                if ((actionURI = attributs.getValue("md:actionURI")) != null) {
                    so.setActionURI(actionURI);
                }
            } else if (this.currentPort instanceof HttpPort) {
                HttpOperation ho = new HttpOperation(XmlToWsdlActionCodeI.this.runtimeContext);
                ho.setTemporaryFolder(XmlToWsdlActionCodeI.this.tempFolder);
                ho.setXmlVersion(XmlToWsdlActionCodeI.this.xmlVersion);
                XmlToWsdlActionCodeI.this.currentOperation = this.currentOperation = ho;
                ho.setMethodAddress(attributs.getValue("md:address"));
            }
            if (this.currentOperation != null) {
                this.currentOperation.ctx = XmlToWsdlActionCodeI.this;
                this.currentOperation.path = this.currentPath;
                this.currentOperation.port = this.currentPort;
                if (this.currentOperation instanceof HttpOperation) {
                    ((HttpOperation)this.currentOperation).setUrlEncoding(XmlToWsdlActionCodeI.this.urlEncoding);
                }
            }
        }
    }
}

