/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes;

import com.indy.engine.action.ant.AntActionCodeTypeI;
import com.indy.engine.actionCodes.Messages;
import com.indy.engine.core.common.VariableType;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Zip;
import org.apache.tools.ant.types.FileSet;

public class ZipActionCodeI
extends AntActionCodeTypeI {
    Zip antZipManager;
    String sToFile = null;
    String sFromDir = null;
    String sExcludes = null;
    String sIncludes = null;
    String encoding = null;
    String whatIfEmpty = null;
    String whatIfDuplicated = null;
    Boolean compressZip = null;
    Boolean updateZip = null;
    String comment = null;
    int compressionLevel = -1;
    private Boolean casesensitive;
    private Boolean defaultExcludes;

    public ZipActionCodeI() {
        this.actionCodeName = "Zip File Class";
        this.actionClassName = "ZipActionCodeI";
        this.bNullCodeAllowed = true;
    }

    public int prepare(ResultSet rSet) throws EngineExceptionI {
        int ret = 0;
        this.debugLog("prepare", Messages.getString("ZipActionCodeI.0"), 3, "DEBUG");
        this.setStandardConnectionParameters(rSet);
        this.sToFile = this.getLocalStringBindedParameter(rSet, "ZIP_TO_FILE", null);
        this.sFromDir = this.getLocalStringBindedParameter(rSet, "ZIP_FROM_DIR", null);
        if (this.sToFile == null || this.sFromDir == null) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + Messages.getString("ZipActionCodeI.1"), "String", false);
            throw new EngineExceptionI(Messages.getString("ZipActionCodeI.2"));
        }
        this.sIncludes = this.getLocalStringBindedParameter(rSet, "ZIP_INCLUDES", null);
        this.sExcludes = this.getLocalStringBindedParameter(rSet, "ZIP_EXCLUDES", null);
        this.encoding = this.getLocalStringBindedParameter(rSet, "ZIP_ENCODING", null);
        this.whatIfEmpty = this.getLocalStringBindedParameter(rSet, "ZIP_ACTION_IF_EMPTY", null);
        this.whatIfDuplicated = this.getLocalStringBindedParameter(rSet, "ZIP_ACTION_IF_DUPLICATED_FILES", null);
        this.compressZip = this.getLocalBooleanBindedParameter(rSet, "ZIP_COMPRESS", null);
        this.updateZip = this.getLocalBooleanBindedParameter(rSet, "ZIP_UPDATE", null);
        this.comment = this.getLocalStringBindedParameter(rSet, "ZIP_COMMENT", null);
        this.compressionLevel = this.getLocalIntegerBindedParameter(rSet, "ZIP_COMPRESSION_LEVEL", -1);
        this.casesensitive = this.getLocalBooleanBindedParameter(rSet, "ZIP_CASE_SENSITIVE", true);
        this.defaultExcludes = this.getLocalBooleanBindedParameter(rSet, "ZIP_DEFAULT_EXLUDES", true);
        this.debugLog("prepare", Messages.getString("ZipActionCodeI.3"), 3, "DEBUG");
        return ret;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return this.prepare(null);
    }

    public int executeSimpleCode() throws EngineExceptionI {
        int ret = 0;
        this.antZipManager = new Zip();
        this.antZipManager.setCaseSensitive(this.casesensitive.booleanValue());
        this.antZipManager.setDefaultexcludes(this.defaultExcludes.booleanValue());
        this.antZipManager.setProject((Project)this.project);
        if (this.connectionName != null && !this.connectionName.equals("")) {
            this.debugLog("executeSimpleCode", Messages.getString("ZipActionCodeI.4") + this.connectionName, 3, "DEBUG");
            this.jdbcConnection = this.setConnection(this.connectionName, this.sqlTransName, this.sqlTransType);
            if (!this.existsFileTable()) {
                this.debugLog("executeSimpleCode", Messages.getString("ZipActionCodeI.5"), 3, "DEBUG");
                this.createFileTable();
            }
            this.isRdbmsLinked = true;
        }
        try {
            String[] lstExcludes;
            String[] lstIncludes;
            File fromDir = new File(this.sFromDir);
            if (this.sIncludes == null && this.sExcludes == null) {
                this.antZipManager.setBasedir(fromDir);
            }
            if (!this.sToFile.isEmpty()) {
                this.antZipManager.setDestFile(new File(this.sToFile));
            }
            FileSet fileSet = new FileSet();
            fileSet.setDir(fromDir);
            if (this.sIncludes != null && !this.sIncludes.isEmpty() && (lstIncludes = this.sIncludes.split(";")) != null && lstIncludes.length > 0) {
                fileSet.appendIncludes(lstIncludes);
                this.antZipManager.addFileset(fileSet);
            }
            if (this.sExcludes != null && !this.sExcludes.isEmpty() && (lstExcludes = this.sExcludes.split(";")) != null && lstExcludes.length > 0) {
                if (!fileSet.hasPatterns()) {
                    this.antZipManager.addFileset(fileSet);
                }
                fileSet.appendExcludes(lstExcludes);
            }
            if (this.compressZip != null) {
                this.antZipManager.setCompress(this.compressZip.booleanValue());
            }
            if (this.updateZip != null) {
                this.antZipManager.setUpdate(this.updateZip.booleanValue());
            }
            if (this.encoding != null) {
                this.antZipManager.setEncoding(this.encoding);
            }
            if (this.whatIfEmpty != null) {
                Zip.WhenEmpty we = new Zip.WhenEmpty();
                we.setValue(this.whatIfEmpty);
                this.antZipManager.setWhenempty(we);
            }
            if (this.whatIfDuplicated != null) {
                Zip.Duplicate df = new Zip.Duplicate();
                df.setValue(this.whatIfDuplicated);
                this.antZipManager.setDuplicate(df);
            }
            if (this.comment != null) {
                this.antZipManager.setComment(this.comment);
            }
            if (this.compressionLevel != -1) {
                this.antZipManager.setLevel(this.compressionLevel);
            }
            this.antZipManager.execute();
        }
        catch (BuildException e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.actionClassName + "=>executeSimpleCode : " + e.getMessage(), "String", false);
            throw new EngineExceptionI((Throwable)e);
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws InterruptedException, EngineExceptionI, SQLException {
        int ret = 0;
        this.prepare(sourceRSet);
        this.executeSimpleCode();
        return ret;
    }
}

