/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.jms;

import com.indy.engine.actionCodes.jms.JMSConnection;
import com.indy.engine.actionCodes.jms.JMSMessageListener;
import com.indy.engine.actionCodes.jms.JMSMessageReceiver;
import com.indy.engine.actionCodes.jms.JMSUtils;
import com.indy.engine.actionCodes.jms.Messages;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;

public class JMSFileReceiver
extends JMSMessageReceiver
implements JMSMessageListener {
    String receiveDirectory;
    String fileMask = "[JMSMessageId].data";

    public void setReceiveDirectory(String receiveDirectory) {
        this.receiveDirectory = receiveDirectory;
    }

    public void setFileMask(String fileMask) {
        this.fileMask = fileMask;
    }

    @Override
    public void receive(JMSConnection connection) throws JMSException, NamingException, InterruptedException {
        if (this.receiveDirectory != null) {
            File directory = new File(this.receiveDirectory);
            if (!directory.exists()) {
                throw new JMSException(Messages.getString("JMSFileReceiver.0") + this.receiveDirectory + Messages.getString("JMSFileReceiver.1"));
            }
            if (directory.isFile()) {
                throw new JMSException(Messages.getString("JMSFileReceiver.2") + this.receiveDirectory + Messages.getString("JMSFileReceiver.3"));
            }
        }
        super.receive(connection);
    }

    private static String replaceWord(Message message, String word, int count) throws JMSException {
        String currentWord = word.substring(1, word.length() - 1);
        if (message != null) {
            if (currentWord.equalsIgnoreCase("JMSNORMALIZEDMESSAGEID")) {
                return JMSUtils.getJMSNormalizedMessageId(message);
            }
            if (currentWord.equalsIgnoreCase("JMSTYPE")) {
                return message.getJMSType();
            }
            if (currentWord.equalsIgnoreCase("JMSMESSAGEID")) {
                return message.getJMSMessageID();
            }
            if (currentWord.equalsIgnoreCase("JMSTIMESTAMP")) {
                return String.valueOf(message.getJMSTimestamp());
            }
            if (currentWord.equalsIgnoreCase("JMSDELIVERYMODE")) {
                return String.valueOf(message.getJMSDeliveryMode());
            }
            if (currentWord.equalsIgnoreCase("JMSDESTINATION")) {
                Destination dest = message.getJMSDestination();
                if (dest != null) {
                    return dest.toString();
                }
            } else {
                if (currentWord.equalsIgnoreCase("JMSMESSAGECOUNT")) {
                    return String.valueOf(count);
                }
                return message.getStringProperty(currentWord);
            }
        }
        return null;
    }

    private static String getFileName(Message message, String fileMask, int count) throws JMSException {
        Pattern pattern = Pattern.compile("(\\[[A-Za-z0-9]+\\])");
        Matcher matcher = pattern.matcher(fileMask);
        int last = 0;
        Object ret = "";
        while (matcher.find()) {
            String word = matcher.group(1);
            if (word == null) continue;
            if (matcher.start(1) > last) {
                ret = (String)ret + fileMask.substring(last, matcher.start(1));
            }
            ret = (String)ret + JMSFileReceiver.replaceWord(message, word, count);
            last = matcher.end(1);
        }
        if (last < fileMask.length()) {
            ret = (String)ret + fileMask.substring(last);
        }
        return ret;
    }

    @Override
    public void onMessage(Message message, int count) throws JMSException {
        File directory = new File(this.receiveDirectory);
        String fileName = JMSFileReceiver.getFileName(message, this.fileMask, count);
        File file = new File(directory, fileName);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (FileOutputStream fos = new FileOutputStream(file);){
                JMSUtils.messageToOutputStream(message, fos, false);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JMSException(e.getMessage());
        }
    }
}

