/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.loader;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.action.common.BindExpressionReplacer;
import com.indy.engine.core.actionCodes.convert.JdbcConverter;
import com.indy.engine.core.api.impl.CellMapProperties;
import com.indy.engine.core.api.impl.jdbc.JdbcReaderProperties;
import com.indy.engine.core.api.impl.jdbc.JdbcWriterProperties;
import com.indy.engine.core.common.objects2.IVariable;
import com.indy.runtime.api.ICellReader;
import com.indy.runtime.api.ICellWriter;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class JdbcBinder {
    private ParameterMetaData parameterMetadata;
    JdbcWriterProperties converter;
    CellReaderWriter[] readersWriters;
    Map<Integer, CellMapProperties> properties;
    JdbcReaderProperties sourceProperties;
    private ActionCodeTypeI actionCode;
    private ResultSetMetaData sourceMetadata;
    boolean parameterMetadataIsSet = false;
    Map<Integer, Integer> map = new HashMap<Integer, Integer>();

    public void setParameterMetadata(ParameterMetaData parameterMetadata) {
        this.parameterMetadata = parameterMetadata;
    }

    public void setSetDateAsTimestamp(boolean setDateAsTimestamp) {
        this.converter.setDateAsTimestamp(setDateAsTimestamp);
    }

    public void setSetNVarcharAsNVarchar(boolean useVarcharInsteadOfNVarchar) {
        this.converter.setNVarcharAsVarchar(useVarcharInsteadOfNVarchar);
    }

    public void setDisableImplicitConversion(boolean setDisableImplicitConversion) {
        this.converter.setDisableImplicitConversion(setDisableImplicitConversion);
    }

    public JdbcBinder(ActionCodeTypeI actionCode) {
        this.actionCode = actionCode;
        this.properties = new HashMap<Integer, CellMapProperties>();
        this.readersWriters = new CellReaderWriter[0];
        this.converter = new JdbcWriterProperties();
        this.sourceProperties = new JdbcReaderProperties();
    }

    public void clear() {
        this.sourceMetadata = null;
        this.parameterMetadata = null;
        this.properties.clear();
        this.readersWriters = null;
        this.map = null;
    }

    private void resize(int newSize) {
        this.readersWriters = Arrays.copyOf(this.readersWriters, newSize);
    }

    private CellReaderWriter getReaderWriter(int index) {
        if (this.readersWriters.length < index) {
            this.resize(index);
            return null;
        }
        return this.readersWriters[index - 1];
    }

    private void putReaderWriter(int index, CellReaderWriter readerWriter) {
        if (this.readersWriters.length < index) {
            this.resize(index);
        }
        this.readersWriters[index - 1] = readerWriter;
    }

    public void write(int targetIndex, ResultSet rSet, int sourceIndex, PreparedStatement stmt, Integer sourceType, BindExpressionReplacer.BindedExpressionPlaceHolder variablePlaceHolder) throws Exception {
        BindExpressionReplacer.SessionVariablePlaceHolder placeHolder = null;
        if (variablePlaceHolder != null) {
            placeHolder = variablePlaceHolder.getVariablePlaceHolder(targetIndex);
        }
        this.getReaderWriter(targetIndex, rSet, sourceIndex, stmt, sourceType, placeHolder).write(rSet, stmt);
    }

    private CellMapProperties createProperties(int targetIndex, int sourceIndex, int sourceType) {
        CellMapProperties property = new CellMapProperties();
        property.targetIndex = targetIndex;
        property.sourceIndex = sourceIndex;
        property.sourceType = sourceType;
        if (this.parameterMetadata != null) {
            try {
                property.targetType = this.parameterMetadata.getParameterType(targetIndex);
            }
            catch (Exception e) {
                this.parameterMetadata = null;
                property.targetType = property.sourceType;
            }
        } else {
            property.targetType = property.sourceType;
        }
        return property;
    }

    private CellReaderWriter getReaderWriter(int targetIndex, ResultSet rSet, int sourceIndex, PreparedStatement stmt, Integer sourceType, BindExpressionReplacer.SessionVariablePlaceHolder variablePlaceHolder) throws Exception {
        CellReaderWriter readerWriter = this.getReaderWriter(targetIndex);
        if (readerWriter == null) {
            if (sourceType == null || sourceIndex != -1) {
                this.sourceMetadata = rSet.getMetaData();
                sourceType = this.sourceMetadata.getColumnType(sourceIndex);
            } else {
                sourceType = -1;
            }
            if (this.parameterMetadata == null && !this.parameterMetadataIsSet) {
                try {
                    this.parameterMetadataIsSet = true;
                    this.parameterMetadata = stmt.getParameterMetaData();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CellMapProperties property = this.createProperties(targetIndex, sourceIndex, sourceType);
            ICellReader reader = null;
            reader = variablePlaceHolder != null ? this.createSessionVariableReader(variablePlaceHolder, property) : JdbcConverter.getResultSetCellReader((CellMapProperties)property, (JdbcReaderProperties)this.sourceProperties);
            ICellWriter writer = JdbcConverter.getPreparedStatementCellWriter((CellMapProperties)property, (JdbcWriterProperties)this.converter);
            readerWriter = new CellReaderWriter();
            readerWriter.reader = reader;
            readerWriter.writer = writer;
            this.putReaderWriter(targetIndex, readerWriter);
            return readerWriter;
        }
        return readerWriter;
    }

    private ICellReader<? extends Object> createSessionVariableReader(BindExpressionReplacer.SessionVariablePlaceHolder variablePlaceHolder, CellMapProperties property) throws JdbcBinderException {
        int sourceType;
        String variableFullPath = this.actionCode.engineContext.resolveVariableName(variablePlaceHolder.getVariablePath(), this.actionCode.actionName);
        IVariable var = this.actionCode.engineContext.getVariable(variableFullPath);
        ICellReader res = null;
        if ("string".equalsIgnoreCase(var.getType())) {
            sourceType = -1;
            res = o -> this.actionCode.getStringParameter(variableFullPath);
        } else if ("integer".equalsIgnoreCase(var.getType())) {
            sourceType = 4;
            res = o -> this.actionCode.getIntegerParameter(variableFullPath);
        } else if ("boolean".equalsIgnoreCase(var.getType())) {
            sourceType = 16;
            res = o -> this.actionCode.getBooleanParameter(variableFullPath);
        } else {
            throw new JdbcBinderException(String.format("The session variable %s has not a supported type(String, Integer, Boolean)", variableFullPath));
        }
        property.sourceType = sourceType;
        return res;
    }

    public void setGetDateAsTimestamp(boolean getDateAsTimestamp) {
        this.sourceProperties.setDateAsTimestamp(getDateAsTimestamp);
    }

    public class CellReaderWriter {
        ICellReader reader;
        ICellWriter writer;

        public void write(ResultSet resultSet, PreparedStatement statement) throws Exception {
            this.writer.write((Object)statement, this.reader.read((Object)resultSet));
        }
    }

    private class JdbcBinderException
    extends Exception {
        JdbcBinderException(String message) {
            super(message);
        }
    }
}

