/*
 * Decompiled with CFR 0.152.
 */
package com.indy.model.navigation.ui.view;

import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.diagram.non_rcp.navigator.ProcDomainNavigatorItem;
import com.indy.gmf.proc.diagram.non_rcp.part.ProcDiagramEditorPlugin;
import com.indy.ui.custom.out.IMetaDataModelProvider;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.models.IndyXMLResource;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.cache.CacheSourceEvent;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.EMFResourceUtil;
import com.stambia.md.MdNode;
import com.stambia.md.diagram.custom.properties.CustomizedAdapterFactoryContentProvider;
import com.stambia.md.diagram.navigator.MdDomainNavigatorItem;
import com.stambia.md.diagram.part.MdDiagramEditorPlugin;
import com.stambia.tech.MappingType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class NavigatorContentProvider
implements ITreeContentProvider {
    private List input;
    private AdapterFactoryContentProvider myAdapterFctoryContentProvier;
    private AdapterFactoryEditingDomain myEditingDomain;
    private Viewer myViewer;
    private boolean filterContentBecauseOfMode = false;
    private ITreeViewerListener treeListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
            if (event.getElement() instanceof IFile) {
                URI uri = Util.convertIFileToEMFURI((IFile)((IFile)event.getElement()));
                Resource r = NavigatorContentProvider.this.myEditingDomain.getResourceSet().getResource(uri, false);
                if (r != null) {
                    r.unload();
                    NavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources().remove((Object)r);
                    NavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).NavigatorContentProvider.this.myViewer != null && !(this).NavigatorContentProvider.this.myViewer.getControl().isDisposed()) {
                                (this).NavigatorContentProvider.this.myViewer.refresh();
                            }
                        }
                    });
                }
            }
        }

        public void treeExpanded(TreeExpansionEvent event) {
        }
    };
    private CacheEventTracker eventTracker;
    private static List<MappingType> mappingTypeFilters = Arrays.asList(MappingType.SOURCE, MappingType.TARGET, MappingType.STAGING, MappingType.MAPPING, MappingType.SOURCE_MAPPING, MappingType.TARGET_MAPPING, MappingType.VARIABLE);

    public NavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        editingDomain.getResourceSet().setURIConverter((URIConverter)new InternalResourceURIConverter());
        editingDomain.getResourceSet().getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        editingDomain.setID("com.indy.model.navigation.ui.view.NavigatorContentProvider");
        ComposedAdapterFactory composedFactory = new ComposedAdapterFactory(Arrays.asList(MdDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory(), ProcDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory()));
        this.myAdapterFctoryContentProvier = new CustomizedAdapterFactoryContentProvider((AdapterFactory)composedFactory, (EditingDomain)editingDomain);
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            @Override
            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.eventTracker = new CacheEventTracker();
        ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).addEventListener((ICacheService.ICacheSourceEventListener)this.eventTracker);
    }

    public void dispose() {
        if (this.myViewer instanceof AbstractTreeViewer) {
            ((AbstractTreeViewer)this.myViewer).removeTreeListener(this.treeListener);
        }
        ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).removeEventListener((ICacheService.ICacheSourceEventListener)this.eventTracker);
        for (Resource r : this.myEditingDomain.getResourceSet().getResources()) {
            r.unload();
        }
        this.myEditingDomain.getResourceSet().getResources().clear();
        this.myViewer = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.myViewer instanceof AbstractTreeViewer) {
            ((AbstractTreeViewer)this.myViewer).removeTreeListener(this.treeListener);
        }
        if (this.myViewer != null) {
            for (Resource r : this.myEditingDomain.getResourceSet().getResources()) {
                r.unload();
            }
            this.myEditingDomain.getResourceSet().getResources().clear();
        }
        this.myViewer = viewer;
        boolean bl = this.filterContentBecauseOfMode = this.myViewer.getData("com.indy.model.navigation.ui.view.MdNavigationViewPart.viewerMode") == IMetaDataModelProvider.Mode.MAPPING;
        if (this.myViewer instanceof AbstractTreeViewer) {
            ((AbstractTreeViewer)this.myViewer).addTreeListener(this.treeListener);
        }
        this.input = (List)newInput;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (parentElement == this.input) {
            for (Object o : this.input) {
                if (o == null) continue;
                Resource resource = this.myEditingDomain.getResourceSet().getResource(Util.convertIFileToEMFURI((IFile)((IFile)o)), true);
                EObject eo = EMFResourceUtil.getRootElement((Resource)resource);
                boolean replaced = false;
                if (eo instanceof MdNode && ((MdNode)eo).isSubMetaDataChildFile()) {
                    children.add(new MdDomainNavigatorItem(eo, null, (IPropertySourceProvider)this.myAdapterFctoryContentProvier));
                    replaced = true;
                }
                if (replaced) continue;
                children.add(o);
            }
            return children.toArray(new Object[children.size()]);
        }
        if (parentElement instanceof IFile) {
            try {
                Resource resource = this.myEditingDomain.getResourceSet().getResource(Util.convertIFileToEMFURI((IFile)((IFile)parentElement)), true);
                TreeIterator it = resource.getURI().fileExtension().equals("md") ? ((EObject)((EObject)resource.getContents().get(0)).eContents().get(0)).eAllContents() : ((EObject)resource.getContents().get(0)).eAllContents();
                while (it.hasNext()) {
                    EObject cur = (EObject)it.next();
                    if (cur instanceof MdNode) {
                        MdNode n = (MdNode)cur;
                        if (n.getLevel() == null || this.filterContentBecauseOfMode && Collections.disjoint(mappingTypeFilters, n.getLevel().getMappingType())) continue;
                        children.add(n);
                        it.prune();
                        continue;
                    }
                    if (cur instanceof ActionProcess) {
                        children.add(cur);
                        it.prune();
                        continue;
                    }
                    it.prune();
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        } else if (parentElement instanceof MdDomainNavigatorItem) {
            it = ((MdDomainNavigatorItem)parentElement).getEObject().eAllContents();
            while (it.hasNext()) {
                cur = (EObject)it.next();
                if (cur instanceof MdNode) {
                    MdNode n = (MdNode)cur;
                    if (n.getLevel() == null || this.filterContentBecauseOfMode && Collections.disjoint(mappingTypeFilters, n.getLevel().getMappingType())) continue;
                    children.add(n);
                    it.prune();
                    continue;
                }
                it.prune();
            }
        } else if (parentElement instanceof ProcDomainNavigatorItem) {
            it = ((ProcDomainNavigatorItem)parentElement).getEObject().eAllContents();
            while (it.hasNext()) {
                cur = (EObject)it.next();
                if (cur instanceof ActionProcess) {
                    children.add(cur);
                    it.prune();
                    continue;
                }
                it.prune();
            }
        }
        Object[] res = new Object[children.size()];
        int i = 0;
        while (i < children.size()) {
            if (children.get(i) instanceof MdNode) {
                res[i] = new MdDomainNavigatorItem((EObject)((MdNode)children.get(i)), parentElement, (IPropertySourceProvider)this.myAdapterFctoryContentProvier);
            } else if (children.get(i) instanceof ActionProcess) {
                res[i] = new ProcDomainNavigatorItem((EObject)children.get(i), parentElement, (IPropertySourceProvider)this.myAdapterFctoryContentProvier);
            }
            ++i;
        }
        return res;
    }

    public Object getParent(Object element) {
        if (this.input.contains(element)) {
            return this.input;
        }
        if (element instanceof MdDomainNavigatorItem) {
            return ((MdDomainNavigatorItem)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == this.input) {
            return !this.input.isEmpty();
        }
        this.filterContentBecauseOfMode = this.myViewer.getData("com.indy.model.navigation.ui.view.MdNavigationViewPart.viewerMode") == IMetaDataModelProvider.Mode.MAPPING;
        Object[] o = this.getChildren(element);
        return o != null && o.length > 0;
    }

    private class CacheEventTracker
    implements ICacheService.IBatchedListener {
        Set<String> changed = new HashSet<String>();

        private CacheEventTracker() {
        }

        public void handleEvent(CacheSourceEvent event) {
            this.changed.add(event.getSourceId());
        }

        public void handBatchedEvents() {
            ArrayList<String> toUnload = new ArrayList<String>(this.changed);
            this.changed.clear();
            ArrayList<Resource> unloaded = new ArrayList<Resource>();
            for (Resource r : NavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                if (!(r instanceof IndyXMLResource) || !toUnload.contains(((IndyXMLResource)r).getId())) continue;
                r.unload();
                unloaded.add(r);
            }
            if (!unloaded.isEmpty()) {
                NavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources().removeAll(unloaded);
                NavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (((CacheEventTracker)CacheEventTracker.this).NavigatorContentProvider.this.myViewer != null && !((CacheEventTracker)CacheEventTracker.this).NavigatorContentProvider.this.myViewer.getControl().isDisposed()) {
                            ((CacheEventTracker)CacheEventTracker.this).NavigatorContentProvider.this.myViewer.refresh();
                        }
                    }
                });
            }
        }
    }
}

