/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.build.parser.sql;

import com.indy.libraries.build.parser.sql.Messages;
import com.indy.libraries.build.parser.sql.OuterFilterVisitorModificator;
import com.indy.libraries.build.parser.sql.OuterJoinVisitorModificator;
import com.indy.libraries.build.parser.sql.RemoveAndRestoreVarTags;
import com.indy.libraries.build.parser.sql.StandardVisitor;
import com.indy.libraries.build.utils.XSLException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;

public class OuterModificator {
    private static final String HEADER = "select * from table_qui_nexiste_pas where (1=1) and ";
    String where;
    String outerExpression;
    int mode;
    private RemoveAndRestoreVarTags rarsc;
    private Statement parsedStm;

    public OuterModificator(String outerExpression, String where) {
        this.outerExpression = outerExpression;
        this.where = where;
    }

    private boolean prepareVisit() throws JSQLParserException {
        if (this.where != null && !this.where.trim().isEmpty()) {
            Object statement = HEADER;
            statement = (String)statement + this.where;
            this.rarsc = new RemoveAndRestoreVarTags((String)statement);
            statement = this.rarsc.remove();
            try {
                this.parsedStm = CCJSqlParserUtil.parse((Reader)new StringReader((String)statement));
                return this.parsedStm instanceof Select;
            }
            catch (JSQLParserException e) {
                return false;
            }
        }
        return false;
    }

    private String visit(StandardVisitor sv) {
        ((Select)this.parsedStm).getSelectBody().accept((SelectVisitor)sv);
        return this.parsedStm.toString();
    }

    private String afterVisit(String str) {
        String retour = str.substring(HEADER.length() + 2);
        retour = this.rarsc.restore(retour);
        return retour;
    }

    public static String addJoinOuterWord(String where, String outerExpression, String innerAlias, String outerAlias) throws XSLException {
        List<CallSite> alias = Collections.singletonList(innerAlias + "," + outerAlias);
        int side = 0;
        if (outerExpression.equals("(+)")) {
            side = 1;
        } else if (outerExpression.equals("*")) {
            side = 2;
        }
        try {
            OuterModificator om = new OuterModificator(outerExpression, where);
            if (om.prepareVisit()) {
                String result = null;
                result = side == 1 ? om.visit(new OuterFilterVisitorModificator(outerExpression, alias, side)) : om.visit(new OuterJoinVisitorModificator(outerExpression, alias, side));
                return om.afterVisit(result);
            }
            return where;
        }
        catch (JSQLParserException e) {
            String message = String.format(Messages.OuterModificator_0, outerExpression, where);
            throw new XSLException(message, e);
        }
    }

    public static String addFilterOuterWord(String where, String outerExpression, List<String> alias) throws JSQLParserException {
        if (outerExpression.equals("(+)")) {
            OuterModificator om = new OuterModificator(outerExpression, where);
            if (om.prepareVisit()) {
                String result = om.visit(new OuterFilterVisitorModificator(outerExpression, alias, 1));
                return om.afterVisit(result);
            }
            return where;
        }
        return null;
    }
}

