/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.egc.presentation;

import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.indy.ui.conf.editor.Messages;
import com.indy.ui.custom.out.GlobalPropertySection;
import com.indy.ui.custom.out.fixes.MacOsTextHelper;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import com.stambia.egc.EgcPackage;
import com.stambia.egc.Engine;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EgcPropertySection
extends GlobalPropertySection {
    private Text name;
    private Text description;
    private Text port;
    private Text server;
    private Text user;
    private Text password;

    protected void initializeControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        parent.setLayoutData((Object)gridData);
        Composite topComposite = this.getWidgetFactory().createComposite(parent);
        topComposite.setLayoutData((Object)gridData);
        topComposite.setLayout((Layout)new GridLayout(2, false));
        MacOsTextHelper.handle((Composite)topComposite, (Composite)parent.getParent());
        this.getWidgetFactory().createLabel(topComposite, Messages.EgcPropertySection_0);
        this.name = this.getWidgetFactory().createText(topComposite, "");
        gridData = new GridData(768);
        this.name.setLayoutData((Object)gridData);
        this.connectText(this.name, false, (EStructuralFeature)EgcPackage.eINSTANCE.getEngine_Name(), true);
        this.getWidgetFactory().createLabel(topComposite, Messages.EgcPropertySection_2, 0);
        this.server = this.getWidgetFactory().createText(topComposite, "");
        gridData = new GridData(768);
        this.server.setLayoutData((Object)gridData);
        this.connectText(this.server, false, (EStructuralFeature)EgcPackage.eINSTANCE.getEngine_Server(), true);
        this.getWidgetFactory().createLabel(topComposite, Messages.EgcPropertySection_4, 0);
        this.port = this.getWidgetFactory().createText(topComposite, "");
        gridData = new GridData(768);
        this.port.setLayoutData((Object)gridData);
        this.connectText(this.port, false, (EStructuralFeature)EgcPackage.eINSTANCE.getEngine_Port(), true);
        this.getWidgetFactory().createLabel(topComposite, Messages.EgcPropertySection_6, 0);
        this.user = this.getWidgetFactory().createText(topComposite, "");
        gridData = new GridData(768);
        this.user.setLayoutData((Object)gridData);
        this.connectText(this.user, false, (EStructuralFeature)EgcPackage.eINSTANCE.getEngine_User(), true);
        this.getWidgetFactory().createLabel(topComposite, Messages.EgcPropertySection_8, 0);
        this.password = this.getWidgetFactory().createText(topComposite, "", 0x400000);
        gridData = new GridData(768);
        this.password.setLayoutData((Object)gridData);
        this.connectText(this.password, false, (EStructuralFeature)EgcPackage.eINSTANCE.getEngine_Password(), true);
        this.createDescriptionGroup(topComposite, 2);
    }

    protected void createDescriptionGroup(Composite composite, int horizontalSpan) {
        GridData gridData = new GridData(1808);
        gridData.minimumHeight = 100;
        Group descriptionGroup = this.getWidgetFactory().createGroup(composite, Messages.EgcPropertySection_10);
        gridData.horizontalSpan = horizontalSpan;
        descriptionGroup.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(1, false);
        descriptionGroup.setLayout((Layout)gridLayout);
        this.description = this.getWidgetFactory().createText((Composite)descriptionGroup, "", 578);
        gridData = new GridData(1808);
        gridData.widthHint = 0;
        this.description.setLayoutData((Object)gridData);
        this.description.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
            }
        });
        this.description.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                EObject eObject = EgcPropertySection.this.getEObject();
                if (eObject instanceof Engine) {
                    String currDesc = ((Engine)eObject).getDescription();
                    if (currDesc == null || currDesc.isEmpty()) {
                        if (!EgcPropertySection.this.description.getText().isEmpty()) {
                            EgcPropertySection.this.setValue(EgcPropertySection.this.description.getText(), (EStructuralFeature)EgcPackage.eINSTANCE.getEngine_Description());
                        }
                    } else {
                        EgcPropertySection.this.setValue(EgcPropertySection.this.description.getText(), (EStructuralFeature)EgcPackage.eINSTANCE.getEngine_Description());
                    }
                }
            }
        });
    }

    public void refresh() {
        super.refresh();
        if (!this.isDisposed()) {
            this.executeAsReadAction(new Runnable(){

                @Override
                public void run() {
                    EObject eObject = EgcPropertySection.this.getEObject();
                    if (eObject instanceof Engine) {
                        Engine engine = (Engine)eObject;
                        boolean isReadOnly = EgcPropertySection.this.isReadOnly();
                        EgcPropertySection.this.name.setText((String)(engine.getName() != null ? engine.getName() : ""));
                        EgcPropertySection.this.description.setText(engine.getDescription() != null ? engine.getDescription() : "");
                        EgcPropertySection.this.server.setText(engine.getServer() != null ? engine.getServer() : "");
                        EgcPropertySection.this.port.setText(engine.getPort() != null ? engine.getPort() : "");
                        EgcPropertySection.this.user.setText(engine.getUser() != null ? engine.getUser() : "");
                        if (engine.getPassword() == null) {
                            EgcPropertySection.this.password.setText("");
                        } else {
                            try {
                                SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                                String decrypt = semaphoreManager.getStringAsciiInfo(engine.getPassword());
                                EgcPropertySection.this.password.setText(decrypt);
                            }
                            catch (OtherExceptionI e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
    }

    protected void setValue(Object value, EStructuralFeature feature) {
        if (feature == EgcPackage.eINSTANCE.getEngine_Password()) {
            try {
                SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
                semaphoreManager.getIsSemaphore("Incorrect Semaphore");
                String encrypt = semaphoreManager.setSemaphore(true, (String)value);
                super.setValue((Object)encrypt, feature);
            }
            catch (OtherExceptionI e1) {
                e1.printStackTrace();
            }
        } else {
            super.setValue(value, feature);
        }
    }
}

