/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.text.editor.views.parsing;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;

public class EnclosingAutoEditStrategy
implements IAutoEditStrategy {
    private ISourceViewer viewer;

    public EnclosingAutoEditStrategy(ISourceViewer viewer) {
        this.viewer = viewer;
    }

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (command.text.equals("{")) {
            String s = null;
            String prev = null;
            boolean handled = false;
            try {
                if (command.offset >= 1 && document.getLength() - 1 >= 0) {
                    prev = s = document.get(command.offset - 1, 1);
                    if (s.equals(":") || s.equals("$") || s.equals("%")) {
                        command.text = String.valueOf(command.text) + "}" + s;
                        command.shiftsCaret = false;
                        command.caretOffset = command.offset + 1;
                        handled = true;
                    }
                }
                if (!handled && command.offset >= 2 && document.getLength() - 2 >= 0) {
                    s = document.get(command.offset - 2, 2);
                    if (s.equals("%x")) {
                        command.text = String.valueOf(command.text) + "}x%";
                        command.shiftsCaret = false;
                        command.caretOffset = command.offset + 1;
                        handled = true;
                    }
                    if (!handled && command.offset >= 4 && document.getLength() - 4 >= 0 && (s = document.get(command.offset - 4, 4)).equals("%xsl")) {
                        command.text = String.valueOf(command.text) + "}xsl%";
                        command.shiftsCaret = false;
                        command.caretOffset = command.offset + 1;
                        handled = true;
                    }
                    if (!handled && command.offset >= 8 && document.getLength() - 8 >= 0 && (s = document.get(command.offset - 8, 8)).equals("%comment")) {
                        command.text = String.valueOf(command.text) + "}comment%";
                        command.shiftsCaret = false;
                        command.caretOffset = command.offset + 1;
                        handled = true;
                    }
                    if (!handled && prev.endsWith(")")) {
                        char type;
                        String opening;
                        int pos = command.offset - 1;
                        boolean match = false;
                        StringBuffer buf = new StringBuffer();
                        int count = 0;
                        while (pos > 0 && count < 15 && !match) {
                            char c = document.getChar(pos);
                            buf.append(c);
                            if (c == '(') {
                                if (pos >= 2) {
                                    buf.append(document.getChar(pos - 1));
                                    buf.append(document.getChar(pos - 2));
                                    match = true;
                                } else {
                                    match = false;
                                    break;
                                }
                            }
                            --pos;
                            ++count;
                        }
                        if (match && (opening = buf.reverse().toString()).startsWith("%") && ((type = buf.charAt(1)) == 'e' || type == 's' || type == 'b')) {
                            String language = buf.substring(2);
                            command.text = String.valueOf(command.text) + "}" + type + language + "%";
                            command.shiftsCaret = false;
                            command.caretOffset = command.offset + 1;
                            handled = true;
                        }
                    }
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            if (!handled) {
                command.text = String.valueOf(command.text) + "}";
                command.shiftsCaret = false;
                command.caretOffset = command.offset + 1;
            }
        }
    }
}

