/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.text.editor.views.parsing;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;

public class EnsemblistCompletionProcessor
implements IContentAssistProcessor {
    private final IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private final char[] PROPOSAL_ACTIVATION_CHARS = new char[]{'u', 'U', 'm', 'M', 'I', 'i', '['};
    private ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private Collection<String> keyWords;

    public EnsemblistCompletionProcessor(Collection<String> keyWords) {
        this.keyWords = keyWords;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        if (this.keyWords == null) {
            return null;
        }
        String text = viewer.getDocument().get();
        String string = text.substring(0, offset);
        if (string.equals("")) {
            return this.NO_COMPLETIONS;
        }
        ArrayList<CompletionProposal> propList = new ArrayList<CompletionProposal>();
        int length = string.length();
        if (length < 1) {
            return this.NO_COMPLETIONS;
        }
        if (string.charAt(length - 1) == ' ' || string.charAt(length - 1) == '(' || string.charAt(length - 1) == ')' || string.charAt(length - 1) == '\n') {
            for (String s : this.keyWords) {
                CompletionProposal cmp = new CompletionProposal(s, offset, 0, s.length());
                propList.add(cmp);
            }
        } else {
            int lastEscapeIndex = string.lastIndexOf(32);
            if (lastEscapeIndex == -1) {
                lastEscapeIndex = Math.max(string.lastIndexOf(41), string.lastIndexOf(40));
            }
            String copy = new String(string);
            if (lastEscapeIndex != 1) {
                copy = string.substring(lastEscapeIndex + 1);
            }
            for (String s : this.keyWords) {
                if (!s.toLowerCase().startsWith(copy.toLowerCase())) continue;
                CompletionProposal cmp = new CompletionProposal(s, offset - copy.length(), copy.length(), s.length());
                propList.add(cmp);
            }
        }
        return propList.toArray(new ICompletionProposal[propList.size()]);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return this.NO_CONTEXTS;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.PROPOSAL_ACTIVATION_CHARS;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

