/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.text.editor.views.parsing;

import com.indy.ui.text.editor.views.parsing.ColorHelper;
import com.indy.ui.text.editor.views.parsing.StateRuleBasedScanner;
import com.indy.ui.text.editor.views.parsing.XPathViewerConfiguration;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class XPathRule
implements IRule,
StateRuleBasedScanner.IRuleWithState {
    Token BLOCK_TOKEN = new Token((Object)new TextAttribute(ColorHelper.getColor("com.indy.ui.text.editor.preferences.color.xpathDelimiter")));
    Token STRING_TOKEN = XPathViewerConfiguration.STRING_TOKEN;
    Token VARIABLE_TOKEN = new Token((Object)new TextAttribute(ColorHelper.getColor("com.indy.ui.text.editor.preferences.color.variable")));
    Token DEFAULT_TOKEN = new Token(null);
    boolean openedBlock = false;
    boolean openedString = false;

    public IToken evaluate(ICharacterScanner scanner) {
        if (this.openedBlock) {
            return this.readContent(scanner);
        }
        int c = scanner.read();
        int k = 1;
        if (c == 37) {
            c = scanner.read();
            ++k;
            if (c == 120) {
                c = scanner.read();
                ++k;
                if (c == 123) {
                    this.openedBlock = true;
                    return this.BLOCK_TOKEN;
                }
            }
        } else if (c == -1) {
            return Token.EOF;
        }
        int i = 0;
        while (i < k) {
            scanner.unread();
            ++i;
        }
        return Token.UNDEFINED;
    }

    private IToken readContent(ICharacterScanner scanner) {
        int c = scanner.read();
        if (c == -1) {
            return Token.EOF;
        }
        if (c == 39) {
            if (!this.openedString) {
                this.openedString = true;
                boolean canRead = true;
                while (canRead) {
                    while ((c = scanner.read()) != 39 && c != -1) {
                    }
                    if (c != -1) {
                        c = scanner.read();
                        if (c == 39) continue;
                        this.openedString = false;
                        scanner.unread();
                        return this.STRING_TOKEN;
                    }
                    return this.STRING_TOKEN;
                }
            }
        } else {
            if (c == 36) {
                while (Character.isJavaIdentifierPart(c = scanner.read()) && c != 36) {
                }
                scanner.unread();
                return this.VARIABLE_TOKEN;
            }
            if (c == 125) {
                c = scanner.read();
                if (c == 120) {
                    c = scanner.read();
                    if (c == 37) {
                        this.openedBlock = false;
                        return this.BLOCK_TOKEN;
                    }
                    scanner.unread();
                    scanner.unread();
                } else {
                    scanner.unread();
                }
            }
        }
        return this.DEFAULT_TOKEN;
    }

    @Override
    public void cleanupState() {
        this.openedBlock = false;
        this.openedString = false;
    }
}

