/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.engine;

import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.security.PrivilegeAnnotation;
import com.indy.engine.core.security.Role;
import com.indy.engine.log.engine.Messages;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.xml.sax.SAXException;

public class AnalyticsEngineWrapper
implements IEngineClient {
    private IEngineClient engine;
    private static boolean debug = false;
    public static final String MAP_SCHEDULE_NAME = "scheduleName";
    public static final String MAP_SCHEDULE_TRIGGER_NAME = "triggerName";
    public static final String MAP_SCHEDULE_JOB_NAME = "jobName";
    public static final String MAP_SCHEDULE_DELIVERY_NAME = "deliveryName";

    public AnalyticsEngineWrapper(IEngineClient engine) {
        this.engine = engine;
    }

    private static void printExecutionTime(String method, long startTime) {
        if (debug) {
            long endTime = System.nanoTime();
            long time_ns = endTime - startTime;
            long time_ms = TimeUnit.NANOSECONDS.toMillis(time_ns);
            long time_sec = TimeUnit.NANOSECONDS.toSeconds(time_ns);
            long time_min = TimeUnit.NANOSECONDS.toMinutes(time_ns);
            long time_hour = TimeUnit.NANOSECONDS.toHours(time_ns);
            System.out.print("\n" + method + Messages.AnalyticsEngineWrapper_1);
            if (time_hour > 0L) {
                System.out.print(String.valueOf(time_hour) + Messages.AnalyticsEngineWrapper_2);
            }
            if (time_min > 0L) {
                System.out.print(String.valueOf(time_min % 60L) + Messages.AnalyticsEngineWrapper_3);
            }
            if (time_sec > 0L) {
                System.out.print(String.valueOf(time_sec % 60L) + Messages.AnalyticsEngineWrapper_4);
            }
            if (time_ms > 0L) {
                System.out.print(String.valueOf((double)time_ms % 1000.0) + Messages.AnalyticsEngineWrapper_5);
            }
            if (time_ns > 0L) {
                System.out.print(String.valueOf((double)time_ns % 1000000.0) + Messages.AnalyticsEngineWrapper_6);
            }
            System.out.print("\n");
        }
    }

    public Map<String, Object> aggregateVariable(String arg0, String arg1, String arg2, int arg3, String arg4) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.aggregateVariable(arg0, arg1, arg2, arg3, arg4);
        AnalyticsEngineWrapper.printExecutionTime("aggregateVariable", startTime);
        return result;
    }

    public Map<String, Map<String, Object>> aggregateVariables(String arg0, String arg1, List<String> arg2, int arg3, String arg4) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.aggregateVariables(arg0, arg1, arg2, arg3, arg4);
        AnalyticsEngineWrapper.printExecutionTime("aggregateVariables", startTime);
        return result;
    }

    public Map<String, Map<String, Object>> aggregateVariables(String arg0, String arg1, List<String> arg2, int arg3, String arg4, String arg5) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.aggregateVariables(arg0, arg1, arg2, arg3, arg4, arg5);
        AnalyticsEngineWrapper.printExecutionTime("aggregateVariables", startTime);
        return result;
    }

    public int deleteSession(String arg0) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.deleteSession(arg0);
        AnalyticsEngineWrapper.printExecutionTime("deleteSession", startTime);
        return result;
    }

    public String executeDelivery(String arg0, Map<String, Object> arg1) throws Exception {
        long startTime = System.nanoTime();
        String result = this.engine.executeDelivery(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("executeDelivery", startTime);
        return result;
    }

    public int executeSession(String arg0) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.executeSession(arg0);
        AnalyticsEngineWrapper.printExecutionTime("executeSession", startTime);
        return result;
    }

    public boolean existDelivery(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        boolean result = this.engine.existDelivery(arg0);
        AnalyticsEngineWrapper.printExecutionTime("existDelivery", startTime);
        return result;
    }

    public Map<String, Object> get(Map<String, Object> arg0) throws Exception, UnknownHostException, SAXException, IOException {
        long startTime = System.nanoTime();
        Map result = this.engine.get(arg0);
        AnalyticsEngineWrapper.printExecutionTime("get", startTime);
        return result;
    }

    public String getActionCode(String arg0, String arg1) throws Exception {
        long startTime = System.nanoTime();
        String result = this.engine.getActionCode(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("getActionCode", startTime);
        return result;
    }

    public String getActionExecutedCode(String arg0, String arg1) throws Exception {
        long startTime = System.nanoTime();
        String result = this.engine.getActionExecutedCode(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("getActionExecutedCode", startTime);
        return result;
    }

    public Map<String, Object> getActionExtInfo(String arg0, String arg1) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getActionExtInfo(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("getActionExtInfo", startTime);
        return result;
    }

    public String getActionId(String arg0, String arg1) throws Exception {
        long startTime = System.nanoTime();
        String result = this.engine.getActionId(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("getActionId", startTime);
        return result;
    }

    public Map<String, Object> getActionInfo(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getActionInfo(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getActionInfo", startTime);
        return result;
    }

    public Map<String, Object> getActionInfo(String arg0, String arg1) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getActionInfo(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("getActionInfo", startTime);
        return result;
    }

    public Map<String, Map<String, Object>> getActionLstVariables(String arg0, String arg1) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getActionLstVariables(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("getActionLstVariables", startTime);
        return result;
    }

    public int getActionStatus(String arg0, String arg1) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.getActionStatus(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("getActionStatus", startTime);
        return result;
    }

    public Map<String, Object> getActionVariable(String arg0, String arg1, String arg2) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getActionVariable(arg0, arg1, arg2);
        AnalyticsEngineWrapper.printExecutionTime("getActionVariable", startTime);
        return result;
    }

    public String getApiVersion() throws Exception {
        long startTime = System.nanoTime();
        String result = this.engine.getApiVersion();
        AnalyticsEngineWrapper.printExecutionTime("getApiVersion", startTime);
        return result;
    }

    public Map<String, Map<String, Object>> getDeliveries(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getDeliveries(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getDeliveries", startTime);
        return result;
    }

    public String getEngineName(String arg0) throws Exception {
        long startTime = System.nanoTime();
        String result = this.engine.getEngineName(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getEngineName", startTime);
        return result;
    }

    public String getEngineVersion() throws Exception {
        long startTime = System.nanoTime();
        String result = this.engine.getEngineVersion();
        AnalyticsEngineWrapper.printExecutionTime("getEngineVersion", startTime);
        return result;
    }

    public boolean getIsSemaphore(String arg0) throws Exception {
        long startTime = System.nanoTime();
        boolean result = this.engine.getIsSemaphore(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getIsSemaphore", startTime);
        return result;
    }

    public Map<String, Object> getLogProperties(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getLogProperties(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getLogProperties", startTime);
        return result;
    }

    public List<String> getLstChildIds(String arg0, String arg1) throws Exception {
        long startTime = System.nanoTime();
        List result = this.engine.getLstChildIds(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("getLstChildIds", startTime);
        return result;
    }

    public List<String> getLstDeliveries(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        List result = this.engine.getLstDeliveries(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getLstDeliveries", startTime);
        return result;
    }

    public Map<String, Map<String, Object>> getLstInstanciatedIds(String arg0, String arg1) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getLstInstanciatedIds(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("getLstInstanciatedIds", startTime);
        return result;
    }

    public Map<String, Map<String, Object>> getLstRootSessionVariables(String arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getLstRootSessionVariables(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getLstRootSessionVariables", startTime);
        return result;
    }

    public List<Map<String, Object>> getLstSchedules(String arg0) throws Exception {
        long startTime = System.nanoTime();
        List result = this.engine.getLstSchedules(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getLstSchedules", startTime);
        return result;
    }

    public Map<String, Map<String, Object>> getLstSession(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getLstSession(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getLstSession", startTime);
        return result;
    }

    public Map<String, Map<String, Object>> getLstSessionVariables(String arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getLstSessionVariables(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getLstSessionVariables", startTime);
        return result;
    }

    public Map<String, Map<String, Object>> getLstSessionErrors(String arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getLstSessionErrors(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getLstSessionErrors", startTime);
        return result;
    }

    public Map<String, Map<String, Object>> getLstSessionWarnings(String arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getLstSessionWarnings(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getLstSessionWarnings", startTime);
        return result;
    }

    public List<String> getLstTriggers() throws Exception {
        long startTime = System.nanoTime();
        List result = this.engine.getLstTriggers();
        AnalyticsEngineWrapper.printExecutionTime("getLstTriggers", startTime);
        return result;
    }

    public Map<String, Object> getRemoteSessions(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getRemoteSessions(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getRemoteSessions", startTime);
        return result;
    }

    public Map<String, Map<String, Object>> getRepositories(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getRepositories(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getRepositories", startTime);
        return result;
    }

    public Map<String, Object> getSessionInfo(String arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getSessionInfo(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getSessionInfo", startTime);
        return result;
    }

    public Map<String, Object> getTriggerDetail(String arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getTriggerDetail(arg0);
        AnalyticsEngineWrapper.printExecutionTime("getTriggerDetail", startTime);
        return result;
    }

    public Map<String, Object> getVersion() throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.getVersion();
        AnalyticsEngineWrapper.printExecutionTime("getVersion", startTime);
        return result;
    }

    public String getVersions() throws Exception {
        long startTime = System.nanoTime();
        String result = this.engine.getVersions();
        AnalyticsEngineWrapper.printExecutionTime("getVersions", startTime);
        return result;
    }

    public String initSession(String arg0, Map<String, Object> arg1) throws Exception {
        long startTime = System.nanoTime();
        String result = this.engine.initSession(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("initSession", startTime);
        return result;
    }

    public String initSessionWithStream(Object arg0, Map<String, Object> arg1) throws Exception {
        long startTime = System.nanoTime();
        String result = this.engine.initSessionWithStream(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("initSessionWithStream", startTime);
        return result;
    }

    public Map<String, Object> invokeCommand(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.invokeCommand(arg0);
        AnalyticsEngineWrapper.printExecutionTime("invokeCommand", startTime);
        return result;
    }

    public boolean isConnected() throws Exception {
        long startTime = System.nanoTime();
        boolean result = this.engine.isConnected();
        AnalyticsEngineWrapper.printExecutionTime("isConnected", startTime);
        return result;
    }

    public boolean isRunningSession(String arg0) throws Exception {
        long startTime = System.nanoTime();
        boolean result = this.engine.isRunningSession(arg0);
        AnalyticsEngineWrapper.printExecutionTime("isRunningSession", startTime);
        return result;
    }

    public void pauseTrigger(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        this.engine.pauseTrigger(arg0);
        AnalyticsEngineWrapper.printExecutionTime("startTime", startTime);
    }

    public int purgeLogs(Date arg0) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.purgeLogs(arg0);
        AnalyticsEngineWrapper.printExecutionTime("purgeLogs", startTime);
        return result;
    }

    public int purgeLogs(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.purgeLogs(arg0);
        AnalyticsEngineWrapper.printExecutionTime("purgeLogs", startTime);
        return result;
    }

    public void putDelivery(Object arg0, Map<String, Object> arg1) throws Exception {
        long startTime = System.nanoTime();
        this.engine.putDelivery(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("putDelivery", startTime);
    }

    public void removeDelivery(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        this.engine.removeDelivery(arg0);
        AnalyticsEngineWrapper.printExecutionTime("removeDelivery", startTime);
    }

    public int removeJobTrigger(String arg0) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.removeJobTrigger(arg0);
        AnalyticsEngineWrapper.printExecutionTime("removeJobTrigger", startTime);
        return result;
    }

    public int restartSession(String arg0) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.restartSession(arg0);
        AnalyticsEngineWrapper.printExecutionTime("restartSession", startTime);
        return result;
    }

    public int restartSession(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.restartSession(arg0);
        AnalyticsEngineWrapper.printExecutionTime("restartSession", startTime);
        return result;
    }

    public void resumeTrigger(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        this.engine.resumeTrigger(arg0);
        AnalyticsEngineWrapper.printExecutionTime("resumeTrigger", startTime);
    }

    public Map<String, Object> scheduleDeliv(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.scheduleDeliv(arg0);
        AnalyticsEngineWrapper.printExecutionTime("scheduleDeliv", startTime);
        return result;
    }

    public int scheduleDelivery(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.scheduleDelivery(arg0);
        AnalyticsEngineWrapper.printExecutionTime("scheduleDelivery", startTime);
        return result;
    }

    public int scheduleDelivery(String arg0, String arg1, int arg2, List<Map<String, Object>> arg3) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.scheduleDelivery(arg0, arg1, arg2, arg3);
        AnalyticsEngineWrapper.printExecutionTime("scheduleDelivery", startTime);
        return result;
    }

    public int scheduleDelivery(String arg0, String arg1, int arg2, String arg3, int arg4, List<Map<String, Object>> arg5) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.scheduleDelivery(arg0, arg1, arg2, arg3, arg4, arg5);
        AnalyticsEngineWrapper.printExecutionTime("scheduleDelivery", startTime);
        return result;
    }

    public Map<String, Object> scheduleLogsPurge(String arg0, List<Map<String, Object>> arg1, Map<String, Object> arg2) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.scheduleLogsPurge(arg0, arg1, arg2);
        AnalyticsEngineWrapper.printExecutionTime("scheduleLogsPurge", startTime);
        return result;
    }

    public int schedulePurgeLog(String arg0, List<Map<String, Object>> arg1, Map<String, Object> arg2) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.schedulePurgeLog(arg0, arg1, arg2);
        AnalyticsEngineWrapper.printExecutionTime("schedulePurgeLog", startTime);
        return result;
    }

    public void setActionVariableByName(String arg0, String arg1, Map<String, Object> arg2) throws Exception {
        long startTime = System.nanoTime();
        this.engine.setActionVariableByName(arg0, arg1, arg2);
        AnalyticsEngineWrapper.printExecutionTime("setActionVariableByName", startTime);
    }

    public String setSemaphore(boolean arg0, String arg1) throws Exception, OtherExceptionI {
        long startTime = System.nanoTime();
        String result = this.engine.setSemaphore(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("setSemaphore", startTime);
        return result;
    }

    public void soapServerAction(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        this.engine.soapServerAction(arg0);
        AnalyticsEngineWrapper.printExecutionTime("soapServerAction", startTime);
    }

    public void stopEngine(boolean arg0) throws Exception {
        long startTime = System.nanoTime();
        this.engine.stopEngine(arg0);
        AnalyticsEngineWrapper.printExecutionTime("stopEngine", startTime);
    }

    public void stopEngine(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        this.engine.stopEngine(arg0);
        AnalyticsEngineWrapper.printExecutionTime("stopEngine", startTime);
    }

    public int stopSession(String arg0, boolean arg1) throws Exception {
        long startTime = System.nanoTime();
        int result = this.engine.stopSession(arg0, arg1);
        AnalyticsEngineWrapper.printExecutionTime("stopSession", startTime);
        return result;
    }

    public Map<String, Object> waitSession(Map<String, Object> arg0) throws Exception {
        long startTime = System.nanoTime();
        Map result = this.engine.waitSession(arg0);
        AnalyticsEngineWrapper.printExecutionTime("waitSession", startTime);
        return result;
    }

    public void reloadModules() throws Exception {
        throw new Exception(Messages.AnalyticsEngineWrapper_unsupportedOperation);
    }

    @PrivilegeAnnotation(role=Role.Admin)
    public int markInactiveSessionsAsDead() throws Exception {
        return this.engine.markInactiveSessionsAsDead();
    }
}

