/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.engine;

import com.indy.engine.core.common.LocalSession;
import com.indy.engine.log.engine.HttpEngine;
import com.indy.engine.log.engine.IEngineFactory;
import com.indy.engine.log.engine.RmiEngine;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum EngineFactory implements IEngineFactory
{
    INSTANCE;

    private static final Logger LOGGER;

    static {
        LOGGER = Logger.getLogger(EngineFactory.class.getName());
    }

    @Override
    public LocalSession create(String host, int port, Map<String, String> credentials) throws Exception {
        Protocol protocol = null;
        protocol = host.startsWith("https://") ? Protocol.https : (host.startsWith("http://") ? Protocol.http : (host.startsWith("rmis://") ? Protocol.rmis : (host.startsWith("rmi://") ? Protocol.rmi : Protocol.auto)));
        LOGGER.log(Level.INFO, "Create connection to Runtime with " + (Object)((Object)protocol) + " protocol");
        if (protocol == Protocol.rmi || protocol == Protocol.rmis) {
            LOGGER.log(Level.INFO, "Create RMI Connection");
            return new RmiEngine(host, port, credentials, protocol).getEngine();
        }
        if (protocol == Protocol.http || protocol == Protocol.https) {
            LOGGER.log(Level.INFO, "Create HTTP Connection");
            return new HttpEngine(host, port, credentials).getEngine();
        }
        if (protocol == Protocol.auto) {
            LOGGER.log(Level.INFO, "Create RMI Connection (no protocol)");
            return new RmiEngine(host, port, credentials, protocol).getEngine();
        }
        return null;
    }

    public static enum Protocol {
        http,
        https,
        rmi,
        rmis,
        auto;

    }
}

