/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.actioncodes.connection;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.common.actioncodes.connection.Messages;
import com.indy.engine.core.main.connections.ConnectionManagerI;
import com.indy.engine.core.main.connections.RuntimeDatasource;
import com.indy.engine.core.manager.IActionContext;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.Logger;

public class JdbcConnectionManager {
    private String finalConnectionName;
    private String actionName;
    private String sessionName;
    private boolean setDateAsTimestamp;
    private boolean setNVarcharAsVarchar;
    private boolean disableImplicitConversion = false;
    private int sqlServerFetchSize;
    private int sqlServerBatchSize;
    private String objectStartDelimiter;
    private String objectEndDelimiter;
    private String sqlActionType;
    private String connectionName;
    private String sqlTransType;
    private int sqlTransactionIsolation;
    private String sqlTransName;
    private int sqlTransCommitNb;
    private Connection jdbcConnection;
    private String prefix;
    private PreparedStatement batchPreparedStatement;
    private String transactionIsolationParamName;
    private String transactionNameParamName;
    private String transactionTypeParamName;
    private String transactionCommitNbParamName;
    private String fetchSizeParamName;
    private String connectionNameParamName;
    private String batchSizeParamName;
    private String varSaveSchemaNameParamName;
    private IActionContext actionContext;
    private Logger logger;
    private boolean isSelect;
    private int sqlReadAutocommitMode;
    TransactionType type;
    private String sqlSchemaName;

    public boolean isSetDateAsTimestamp() {
        return this.setDateAsTimestamp;
    }

    public boolean isSetNVarcharAsVarchar() {
        return this.setNVarcharAsVarchar;
    }

    public boolean hasDisableImplicitConversion() {
        return this.disableImplicitConversion;
    }

    public int getSqlServerFetchSize() {
        return this.sqlServerFetchSize;
    }

    public int getSqlServerBatchSize() {
        return this.sqlServerBatchSize;
    }

    public String getObjectStartDelimiter() {
        return this.objectStartDelimiter;
    }

    public String getObjectEndDelimiter() {
        return this.objectEndDelimiter;
    }

    public int getSqlTransCommitNb() {
        return this.sqlTransCommitNb;
    }

    public Connection getJdbcConnection() {
        return this.jdbcConnection;
    }

    public void setTransactionIsolationParamName(String transactionIsolationParamName) {
        this.transactionIsolationParamName = transactionIsolationParamName;
    }

    public void setTransactionNameParamName(String transactionNameParamName) {
        this.transactionNameParamName = transactionNameParamName;
    }

    public void setTransactionTypeParamName(String transactionTypeParamName) {
        this.transactionTypeParamName = transactionTypeParamName;
    }

    public void setTransactionCommitNbParamName(String transactionCommitNbParamName) {
        this.transactionCommitNbParamName = transactionCommitNbParamName;
    }

    public void setFetchSizeParamName(String fetchSizeParamName) {
        this.fetchSizeParamName = fetchSizeParamName;
    }

    public void setConnectionNameParamName(String connectionNameParamName) {
        this.connectionNameParamName = connectionNameParamName;
    }

    public void setBatchSizeParamName(String batchSizeParamName) {
        this.batchSizeParamName = batchSizeParamName;
    }

    public JdbcConnectionManager(String sqlActionType, String prefix, IActionContext actionContext, Logger logger, boolean isSelect) {
        this.sqlActionType = sqlActionType;
        this.actionName = actionContext.getActionName();
        this.actionContext = actionContext;
        this.logger = logger;
        this.prefix = prefix == null ? "" : prefix;
        this.transactionIsolationParamName = prefix + "TRANSACTION_ISOLATION";
        this.transactionNameParamName = prefix + "TRANSACTION_NAME";
        this.connectionNameParamName = prefix + "CONNECTION";
        this.transactionTypeParamName = prefix + "TRANSACTION_TYPE";
        this.transactionCommitNbParamName = prefix + "TRANSACTION_COMMIT_NB";
        this.fetchSizeParamName = prefix + "FETCH_SIZE";
        this.batchSizeParamName = prefix + "BATCH_SIZE";
        this.varSaveSchemaNameParamName = prefix + "SCHEMA_NAME";
        this.isSelect = isSelect;
    }

    public String getVarSaveSchemaNameParamName() {
        return this.varSaveSchemaNameParamName;
    }

    public void commit(int nbRows) throws SQLException {
        if (this.type == TransactionType.COMMIT && this.sqlTransCommitNb != -1 && (double)nbRows % (double)this.sqlTransCommitNb == 0.0) {
            this.jdbcConnection.commit();
        }
    }

    public void commit() throws SQLException {
        if (this.type == TransactionType.COMMIT) {
            this.jdbcConnection.commit();
        }
    }

    private void debug(String message, Throwable t) {
        if (this.logger != null) {
            this.logger.debug(this.sessionName + " JdbcConnectionManager=>setConnection " + this.actionName + message, t);
        }
    }

    private boolean isAutoCommit() {
        return !(this.type != TransactionType.AUTOCOMMIT && this.type != TransactionType.AUTONOMOUS || this.isSelect && this.sqlReadAutocommitMode == 2);
    }

    private int prepareSetConnection(Map<String, Object> rSet) throws EngineExceptionI {
        int ret = 0;
        this.sqlTransType = (String)rSet.get(this.transactionTypeParamName);
        if (this.sqlTransType == null) {
            this.sqlTransType = "AUTOCOMMIT";
        }
        this.type = TransactionType.valueOf(this.sqlTransType);
        try {
            this.sqlTransactionIsolation = -1;
            String pTransIsolation = (String)rSet.get(this.transactionIsolationParamName);
            if (pTransIsolation != null) {
                if (pTransIsolation.equals("TRANSACTION_NONE")) {
                    this.sqlTransactionIsolation = 0;
                } else if (pTransIsolation.equals("TRANSACTION_READ_COMMITTED")) {
                    this.sqlTransactionIsolation = 2;
                } else if (pTransIsolation.equals("TRANSACTION_READ_UNCOMMITTED")) {
                    this.sqlTransactionIsolation = 1;
                } else if (pTransIsolation.equals("TRANSACTION_REPEATABLE_READ")) {
                    this.sqlTransactionIsolation = 4;
                } else if (pTransIsolation.equals("TRANSACTION_SERIALIZABLE")) {
                    this.sqlTransactionIsolation = 8;
                }
            }
        }
        catch (NullPointerException pTransIsolation) {
            // empty catch block
        }
        this.sqlTransName = (String)rSet.get(this.transactionNameParamName);
        if (this.sqlTransName == null) {
            this.sqlTransName = "T1";
        }
        this.sqlTransCommitNb = -1;
        Integer tmp = (Integer)rSet.get(this.transactionCommitNbParamName);
        if (tmp != null) {
            this.sqlTransCommitNb = tmp;
        }
        if (this.sqlActionType.equals("INSERT") || this.sqlActionType.equals("UPDATE") || this.sqlActionType.equals("DELETE")) {
            this.sqlServerBatchSize = -1;
            tmp = (Integer)rSet.get(this.batchSizeParamName);
            if (tmp != null) {
                this.sqlServerBatchSize = tmp;
            }
        }
        if (this.sqlActionType.equals("SELECT")) {
            this.sqlServerFetchSize = -1;
            tmp = (Integer)rSet.get(this.fetchSizeParamName);
            if (tmp != null) {
                this.sqlServerFetchSize = tmp;
            }
            this.sqlServerFetchSize = (Integer)rSet.get(this.fetchSizeParamName);
        }
        this.sqlSchemaName = (String)rSet.get(this.varSaveSchemaNameParamName);
        if (this.sqlSchemaName == null) {
            this.sqlSchemaName = "";
        }
        if (!this.sqlSchemaName.equals("")) {
            this.sqlSchemaName = String.valueOf(this.sqlSchemaName) + ".";
        }
        return ret;
    }

    private int prepareSetConnection(ResultSet rSet, ActionCodeTypeI action) throws EngineExceptionI {
        int ret = 0;
        try {
            this.sqlTransType = action.getLocalStringBindedParameter(rSet, this.transactionTypeParamName);
        }
        catch (NullPointerException e) {
            this.sqlTransType = "AUTOCOMMIT";
        }
        catch (EngineExceptionI e) {
            this.sqlTransType = "AUTOCOMMIT";
        }
        this.type = TransactionType.valueOf(this.sqlTransType);
        try {
            this.sqlTransactionIsolation = -1;
            String pTransIsolation = action.getLocalStringBindedParameter(rSet, this.transactionIsolationParamName);
            if (pTransIsolation != null) {
                if (pTransIsolation.equals("TRANSACTION_NONE")) {
                    this.sqlTransactionIsolation = 0;
                } else if (pTransIsolation.equals("TRANSACTION_READ_COMMITTED")) {
                    this.sqlTransactionIsolation = 2;
                } else if (pTransIsolation.equals("TRANSACTION_READ_UNCOMMITTED")) {
                    this.sqlTransactionIsolation = 1;
                } else if (pTransIsolation.equals("TRANSACTION_REPEATABLE_READ")) {
                    this.sqlTransactionIsolation = 4;
                } else if (pTransIsolation.equals("TRANSACTION_SERIALIZABLE")) {
                    this.sqlTransactionIsolation = 8;
                }
            }
        }
        catch (NullPointerException pTransIsolation) {
        }
        catch (EngineExceptionI pTransIsolation) {
            // empty catch block
        }
        try {
            this.sqlTransName = action.getLocalStringBindedParameter(rSet, this.transactionNameParamName);
        }
        catch (NullPointerException e) {
            this.sqlTransName = "T1";
        }
        catch (EngineExceptionI e) {
            this.sqlTransName = "T1";
        }
        try {
            this.sqlTransCommitNb = action.getLocalIntegerBindedParameter(rSet, this.transactionCommitNbParamName);
        }
        catch (NullPointerException e) {
            this.sqlTransCommitNb = new Integer(-1);
        }
        catch (EngineExceptionI e) {
            this.sqlTransCommitNb = new Integer(-1);
        }
        if (this.sqlActionType.equals("INSERT") || this.sqlActionType.equals("UPDATE") || this.sqlActionType.equals("DELETE")) {
            try {
                this.sqlServerBatchSize = action.getLocalIntegerBindedParameter(rSet, this.batchSizeParamName);
            }
            catch (EngineExceptionI e) {
                this.sqlServerBatchSize = -1;
            }
        }
        if (this.sqlActionType.equals("SELECT")) {
            try {
                this.sqlServerFetchSize = action.getLocalIntegerBindedParameter(rSet, this.fetchSizeParamName);
            }
            catch (EngineExceptionI e) {
                this.sqlServerFetchSize = -1;
            }
        }
        this.sqlSchemaName = action.getLocalStringBindedParameter(rSet, this.varSaveSchemaNameParamName, "");
        if (!this.sqlSchemaName.equals("")) {
            this.sqlSchemaName = String.valueOf(this.sqlSchemaName) + ".";
        }
        return ret;
    }

    public String getSqlSchemaName() {
        return this.sqlSchemaName;
    }

    public int prepareConnection(ResultSet rSet, ActionCodeTypeI action) throws EngineExceptionI {
        this.connectionName = action.getLocalStringParameter(this.connectionNameParamName, null);
        return this.prepareConnection(this.connectionName, rSet, action);
    }

    public int prepareConnection(String _connectionName, Map<String, Object> params) throws EngineExceptionI {
        return this.prepareConnection(_connectionName, params, null);
    }

    private int prepareConnection(String _connectionName, Object rSet, ActionCodeTypeI action) throws EngineExceptionI {
        int ret = 0;
        if (this.prefix == null) {
            this.prefix = "";
        }
        if (!this.sqlActionType.equals("DDL_DML")) {
            this.debug("Before Connection for : " + this.sqlActionType, null);
            this.connectionName = _connectionName;
            if (this.connectionName == null) {
                return -1;
            }
            try {
                ret = rSet instanceof Map ? this.prepareSetConnection((Map)rSet) : this.prepareSetConnection((ResultSet)rSet, action);
                if (ret == 0) {
                    ret = 0;
                }
            }
            catch (EngineExceptionI e) {
                this.debug("Engine Exception during connection establishement : ", e);
                throw new EngineExceptionI(Messages.getString("JdbcConnectionManager.0"), (Throwable)e);
            }
            this.debug("Connection is OK for : " + this.sqlActionType, null);
        }
        return ret;
    }

    public void rollback() throws EngineExceptionI {
        if (!this.sqlActionType.equals("DDL_DML")) {
            if (this.sqlActionType.equals("INSERT") || this.sqlActionType.equals("UPDATE") || this.sqlActionType.equals("DELETE")) {
                try {
                    if (this.jdbcConnection != null) {
                        this.jdbcConnection.rollback();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.closeBatchStatement();
        }
    }

    public PreparedStatement prepareStatement(String query) throws SQLException {
        this.batchPreparedStatement = this.jdbcConnection.prepareStatement(query);
        return this.batchPreparedStatement;
    }

    public void closeBatchStatement() throws EngineExceptionI {
        if (this.batchPreparedStatement != null) {
            try {
                try {
                    this.batchPreparedStatement.cancel();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.batchPreparedStatement.clearBatch();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.batchPreparedStatement.close();
                this.batchPreparedStatement = null;
            }
            catch (Exception e2) {
                this.batchPreparedStatement = null;
                throw new EngineExceptionI((Throwable)e2);
            }
        }
    }

    public Connection setConnection() throws EngineExceptionI {
        Connection retJDBCConnection;
        block41: {
            retJDBCConnection = null;
            retJDBCConnection = null;
            try {
                ConnectionManagerI connManager;
                block42: {
                    this.finalConnectionName = this.sqlTransType.equals("AUTOCOMMIT") ? this.connectionName + ".POOLED." + this.actionContext.getActionId() : (!this.sqlTransName.equals("") ? this.connectionName + "." + this.sqlTransName : this.connectionName);
                    if (retJDBCConnection != null) break block41;
                    this.debug("--- getting connection : " + this.finalConnectionName, null);
                    ReentrantLock lockObject = this.actionContext.getConnectionlock();
                    lockObject.lockInterruptibly();
                    try {
                        if (!this.actionContext.existsConnectionManager(this.connectionName)) {
                            this.debug("--- Connection not declared : " + this.finalConnectionName, null);
                            throw new EngineExceptionI(Messages.getString("JdbcConnectionManager.1") + this.connectionName);
                        }
                        connManager = this.actionContext.getConnectionManager(this.connectionName);
                        if (connManager == null) {
                            System.out.println("Connection MANAGER NULL !!!");
                            break block42;
                        }
                        String sTempParameter = null;
                        sTempParameter = connManager.getConnectionParameter(this.actionContext, "JDBC.BIND.MANAGE_SET_DATE_AS_TIMESTAMP");
                        if (sTempParameter != null) {
                            this.setDateAsTimestamp = Boolean.parseBoolean(sTempParameter);
                        }
                        if ((sTempParameter = connManager.getConnectionParameter(this.actionContext, "JDBC.BIND.MANAGE_SET_NSTRING_AS_STRING")) != null) {
                            this.setNVarcharAsVarchar = Boolean.parseBoolean(sTempParameter);
                        }
                        if ((sTempParameter = connManager.getConnectionParameter(this.actionContext, "JDBC.BIND.DISABLE_IMPLICIT_CONVERSION")) != null) {
                            this.disableImplicitConversion = Boolean.parseBoolean(sTempParameter);
                        }
                        sTempParameter = null;
                        if (this.sqlServerFetchSize <= 0) {
                            sTempParameter = connManager.getConnectionParameter(this.actionContext, "JDBC.FETCH_SIZE");
                            if (sTempParameter != null) {
                                try {
                                    this.sqlServerFetchSize = Integer.parseInt(sTempParameter);
                                }
                                catch (Exception e) {
                                    this.sqlServerFetchSize = -1;
                                }
                            }
                            if (this.sqlServerFetchSize <= 0) {
                                this.sqlServerFetchSize = this.actionContext.getEngineContext().getRuntimeContext().DEFAULT_FETCH_SIZE;
                            }
                        }
                        sTempParameter = null;
                        if (this.sqlServerBatchSize <= 0) {
                            String sBatchParameter = connManager.getConnectionParameter(this.actionContext, "JDBC.BATCH_SIZE");
                            if (sBatchParameter != null) {
                                try {
                                    this.sqlServerBatchSize = Integer.parseInt(sBatchParameter);
                                }
                                catch (Exception e) {
                                    this.sqlServerBatchSize = -1;
                                }
                            }
                            if (this.sqlServerBatchSize <= 0) {
                                this.sqlServerBatchSize = this.actionContext.getEngineContext().getRuntimeContext().DEFAULT_BATCH_SIZE;
                            }
                        }
                        if (!connManager.hasRuntimeDataSource()) {
                            this.debug("--- Adding Connection Container : " + this.finalConnectionName, null);
                            try {
                                RuntimeDatasource dataSource = this.actionContext.createJdbcContainer(connManager);
                                connManager.setRuntimeDataSource(dataSource);
                                this.debug("--- Opening Connection : " + this.finalConnectionName, null);
                                lockObject.unlock();
                                retJDBCConnection = (Connection)dataSource.getConnection(this.finalConnectionName).getUnderlyingConnection();
                                connManager.unlockAll();
                                break block42;
                            }
                            catch (Exception e) {
                                connManager.unlockAll();
                                throw new EngineExceptionI((Throwable)e);
                            }
                        }
                        RuntimeDatasource dataSource = connManager.getRuntimeDataSource();
                        this.debug("--- Getting existing Connection : " + this.finalConnectionName, null);
                        lockObject.unlock();
                        retJDBCConnection = (Connection)dataSource.getConnection(this.finalConnectionName).getUnderlyingConnection();
                        try {
                            ActionCodeTypeI.setAutoCommit((Connection)retJDBCConnection, (boolean)this.isAutoCommit());
                        }
                        catch (Exception exception) {}
                    }
                    finally {
                        if (lockObject.isHeldByCurrentThread() && lockObject.isLocked()) {
                            lockObject.unlock();
                        }
                    }
                }
                if (retJDBCConnection == null) {
                    throw new EngineExceptionI("Erreur : Connection non initialis\u00e9e");
                }
                try {
                    this.objectStartDelimiter = connManager.getConnectionParameter(this.actionContext, "TECH.OBJECT_START_DELIMITER");
                    if (this.objectStartDelimiter == null) {
                        this.objectStartDelimiter = this.actionContext.getEngineContext().getRuntimeContext().TECH_OBJECT_START_DELIMITER;
                    }
                }
                catch (EngineExceptionI e) {
                    this.objectStartDelimiter = this.actionContext.getEngineContext().getRuntimeContext().TECH_OBJECT_START_DELIMITER;
                }
                try {
                    this.objectEndDelimiter = connManager.getConnectionParameter(this.actionContext, "TECH.OBJECT_END_DELIMITER");
                    if (this.objectEndDelimiter == null) {
                        this.objectEndDelimiter = this.actionContext.getEngineContext().getRuntimeContext().TECH_OBJECT_END_DELIMITER;
                    }
                }
                catch (EngineExceptionI e) {
                    this.objectEndDelimiter = this.actionContext.getEngineContext().getRuntimeContext().TECH_OBJECT_END_DELIMITER;
                }
                try {
                    String _autocommitModeOnRead = connManager.getConnectionParameter(this.actionContext, "JDBC.READ_AUTOCOMMIT_MODE");
                    if (_autocommitModeOnRead != null && _autocommitModeOnRead.equals("CommitOrRollback")) {
                        this.sqlReadAutocommitMode = 2;
                        break block41;
                    }
                    this.sqlReadAutocommitMode = 1;
                }
                catch (EngineExceptionI e) {
                    this.sqlReadAutocommitMode = 1;
                }
            }
            catch (EngineExceptionI e) {
                throw e;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new EngineExceptionI((Throwable)e);
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
        if (retJDBCConnection != null && this.sqlTransactionIsolation != -1) {
            try {
                retJDBCConnection.setTransactionIsolation(this.sqlTransactionIsolation);
            }
            catch (SQLException e) {
                throw new EngineExceptionI(Messages.getString("JdbcConnectionManager.2") + this.connectionName + "'", (Throwable)e);
            }
        }
        this.jdbcConnection = retJDBCConnection;
        return this.jdbcConnection;
    }

    public void close() {
        if (this.sqlTransType != null && (this.sqlTransType.equals("AUTONOMOUS") || this.sqlTransType.equals("AUTOCOMMIT"))) {
            this.closeConnection(this.connectionName, this.sqlTransName, this.sqlTransType, true);
        }
    }

    public void closeConnection(String pConnectionName, String pTransName, String pTransType, boolean pCommitTrans) {
        try {
            ConnectionManagerI connManager = this.actionContext.getConnectionManager(pConnectionName);
            RuntimeDatasource dataSource = connManager.getRuntimeDataSource();
            if (dataSource != null) {
                dataSource.getConnection(this.finalConnectionName).close(pCommitTrans);
            }
        }
        catch (EngineExceptionI e) {
            this.logger.warn("Exception while closing connection", (Throwable)e);
        }
    }

    public boolean exists() {
        return this.connectionName != null;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    static enum TransactionType {
        AUTOCOMMIT,
        COMMIT,
        AUTONOMOUS,
        NOCOMMIT;

    }
}

