/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.command.parser;

import com.indy.engine.common.command.parser.CommandI;
import com.indy.engine.common.command.parser.CommandInstanceI;
import com.indy.engine.common.command.parser.CommandParserExceptionI;
import com.indy.engine.common.command.parser.ICommandExecutorI;
import com.indy.engine.common.command.parser.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandLineParserI {
    List<CommandI> lstCommand = new ArrayList<CommandI>();

    public void AddCommand(CommandI com) {
        this.lstCommand.add(com);
    }

    public CommandI getCommandNamed(String pCommandName) {
        CommandI com = null;
        for (CommandI ci : this.lstCommand) {
            if (!ci.getCommandName().equals(pCommandName)) continue;
            return ci;
        }
        return com;
    }

    public void executeCommandLine(String pRealCommand) throws CommandParserExceptionI, Exception {
        boolean commandFound = false;
        Iterator<CommandI> it = this.lstCommand.iterator();
        while (it.hasNext() && !commandFound) {
            CommandI tempCom = it.next();
            if (!pRealCommand.matches(tempCom.getCommandRegexp())) continue;
            commandFound = true;
            ICommandExecutorI ce = tempCom.getCommandExecutorI();
            Pattern generatedPattern = Pattern.compile(tempCom.getCommandRegexp());
            Matcher m2 = generatedPattern.matcher(pRealCommand);
            if (!m2.matches()) continue;
            CommandInstanceI ci = new CommandInstanceI(tempCom, m2, tempCom.getMetadataList());
            ce.execute(ci);
        }
        if (!commandFound) {
            throw new CommandParserExceptionI(Messages.getString("CommandLineParserI.0"));
        }
    }

    public List<CommandI> getLstCommands() {
        Collections.sort(this.lstCommand);
        return this.lstCommand;
    }
}

