/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.compiler.impl;

import com.indy.engine.common.compiler.impl.Messages;
import com.indy.engine.common.compiler.impl.StambiaJavaCompilerClassLoaderImpl;
import com.indy.engine.common.compiler.impl.StambiaJavaCompilerTools;
import com.indy.engine.core.common.compiler.StambiaJavaCompiler;
import com.semarchy.xdi.logging.Log4j2Writer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

class StambiaJavaCompilerImpl
implements StambiaJavaCompiler {
    private Map<String, JavaSourceFile> sources = new HashMap<String, JavaSourceFile>();
    List<String> options = new ArrayList<String>();
    ClassLoader parentClassLoader;
    boolean initClassPathFromClassLoader = true;
    boolean initClassPathFromClassLoaderDeeply = true;

    StambiaJavaCompilerImpl(ClassLoader parentClassLoader2) {
        this.parentClassLoader = parentClassLoader2;
    }

    public void addClassSource(String packageName, String className, String source) throws Exception {
        if (className == null || className.isEmpty()) {
            throw new Exception(Messages.getString("StambiaJavaCompilerImpl.0"));
        }
        if (source == null || source.isEmpty()) {
            throw new Exception(Messages.getString("StambiaJavaCompilerImpl.1"));
        }
        JavaSourceFile jsf = new JavaSourceFile(className, source);
        this.sources.put(StambiaJavaCompilerTools.computeClassName(packageName, className), jsf);
    }

    public void addOption(String option) {
        this.options.add(option);
    }

    public void setParentClassLoader(ClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
    }

    public ClassLoader compile() throws Exception {
        try (ForwardingJavaFileManager manager = null;){
            Object cl;
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            if (compiler == null) {
                throw new Exception(Messages.getString("StambiaJavaCompilerImpl.2"));
            }
            ArrayList<String> tempOptions = new ArrayList<String>(this.options);
            DiagnosticCollector diagnostics = new DiagnosticCollector();
            manager = new JavaCompilerManager(compiler.getStandardFileManager(diagnostics, null, null));
            if (this.initClassPathFromClassLoader && this.parentClassLoader != null) {
                String classpath = StambiaJavaCompilerTools.getClassPathFromURLClassLoader(this.parentClassLoader, this.initClassPathFromClassLoaderDeeply);
                tempOptions.add("-classpath");
                tempOptions.add(classpath);
                tempOptions.add("-verbose");
                cl = this.parentClassLoader;
                while (cl != null) {
                    if (cl instanceof StambiaJavaCompiler.CompilerClassLoader) {
                        ((JavaCompilerManager)manager).libs.add((StambiaJavaCompiler.CompilerClassLoader)cl);
                    }
                    cl = this.initClassPathFromClassLoaderDeeply ? ((ClassLoader)cl).getParent() : null;
                }
            }
            StambiaJavaCompilerClassLoaderImpl sjl = new StambiaJavaCompilerClassLoaderImpl(this.parentClassLoader);
            ((JavaCompilerManager)manager).classLoader = sjl;
            cl = null;
            Iterator<Map.Entry<String, JavaCompiledFile>> iterator = null;
            try (Log4j2Writer writer = new Log4j2Writer(this.getClass().getName());){
                JavaCompiler.CompilationTask task = compiler.getTask(writer, manager, diagnostics, tempOptions, null, this.sources.values());
                if (!task.call().booleanValue()) {
                    throw new Exception(Messages.getString("StambiaJavaCompilerImpl.3") + diagnostics.getDiagnostics().toString());
                }
            }
            catch (Throwable throwable) {
                if (cl == null) {
                    cl = throwable;
                } else if (cl != throwable) {
                    ((Throwable)cl).addSuppressed(throwable);
                }
                throw cl;
            }
            for (Map.Entry<String, JavaCompiledFile> entry : ((JavaCompilerManager)manager).bytesClasses.entrySet()) {
                if (entry.getValue().size() == 0) {
                    throw new Exception(Messages.getString("StambiaJavaCompilerImpl.4") + entry.getKey() + Messages.getString("StambiaJavaCompilerImpl.5"));
                }
                sjl.addClassFile(entry.getKey(), entry.getValue());
            }
            StambiaJavaCompilerClassLoaderImpl stambiaJavaCompilerClassLoaderImpl = sjl;
            return stambiaJavaCompilerClassLoaderImpl;
        }
    }

    class JavaCompiledFile
    extends SimpleJavaFileObject {
        private ByteArrayOutputStream bytes;

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.bytes != null) {
                return new ByteArrayInputStream(this.bytes.toByteArray());
            }
            return null;
        }

        public JavaCompiledFile(String qualifiedName) throws URISyntaxException {
            super(new URI(qualifiedName + ".class"), JavaFileObject.Kind.CLASS);
            this.bytes = new ByteArrayOutputStream();
        }

        @Override
        public OutputStream openOutputStream() {
            return this.bytes;
        }

        public byte[] getBytes() {
            return this.bytes.toByteArray();
        }

        public int size() {
            return this.bytes.size();
        }
    }

    private class JavaCompilerManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        Map<String, JavaCompiledFile> bytesClasses;
        public ClassLoader classLoader;
        List<StambiaJavaCompiler.CompilerClassLoader> libs;

        @Override
        public String inferBinaryName(JavaFileManager.Location paramLocation, JavaFileObject paramJavaFileObject) {
            if (paramJavaFileObject instanceof JavaCompiledFile) {
                String inferBinaryName = paramJavaFileObject.getName();
                inferBinaryName = inferBinaryName.substring(0, inferBinaryName.length() - 6);
                return inferBinaryName;
            }
            return super.inferBinaryName(paramLocation, paramJavaFileObject);
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location paramLocation, String packageName, Set<JavaFileObject.Kind> paramSet, boolean recurse) throws IOException {
            Iterable list;
            for (StambiaJavaCompiler.CompilerClassLoader sjl : this.libs) {
                list = sjl.getClassFiles(packageName);
                if (list == null) continue;
                return list;
            }
            list = super.list(paramLocation, packageName, paramSet, recurse);
            return list;
        }

        protected JavaCompilerManager(JavaFileManager paramM) {
            super(paramM);
            this.bytesClasses = new HashMap<String, JavaCompiledFile>();
            this.libs = new ArrayList<StambiaJavaCompiler.CompilerClassLoader>();
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String className) throws IOException {
            return StambiaJavaCompilerImpl.this.sources.get(StambiaJavaCompilerTools.computeClassName(packageName, className));
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String qualifiedName, JavaFileObject.Kind kind, FileObject outputFile) throws IOException {
            JavaCompiledFile classFile;
            try {
                classFile = new JavaCompiledFile(qualifiedName);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            this.bytesClasses.put(qualifiedName, classFile);
            return classFile;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return this.classLoader;
        }
    }

    private class JavaSourceFile
    extends SimpleJavaFileObject {
        String source;

        public JavaSourceFile(String name, String source) throws URISyntaxException {
            super(new URI(name + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.source = source;
        }

        @Override
        public String getCharContent(boolean ignoreEncodingErrors) {
            return this.source;
        }
    }
}

