/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.queue.impl;

import com.indy.engine.common.queue.impl.Messages;
import com.indy.engine.core.queue.IQueueConsumer;
import com.indy.engine.core.queue.IQueueProducer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;

public class MemoryBlockingQueue<T>
implements IQueueProducer<T> {
    public List<ArrayBlockingQueue> list = new ArrayList<ArrayBlockingQueue>();
    T endElement;

    public void put(T t) throws InterruptedException {
        for (ArrayBlockingQueue abq : this.list) {
            abq.put(t);
        }
    }

    public void putAll(Collection<T> t) throws Exception {
        if (t.size() == 0) {
            throw new IOException(Messages.getString("MemoryBlockingQueue.0"));
        }
        for (ArrayBlockingQueue abq : this.list) {
            abq.put(new ArrayList<T>(t));
        }
    }

    public IQueueConsumer<T> createConsumer() {
        final ArrayBlockingQueue abq = new ArrayBlockingQueue(10);
        IQueueConsumer cons = new IQueueConsumer<T>(){
            List<T> currentList;
            boolean end;
            int currentPosition = -1;

            public T take() throws InterruptedException {
                Object e;
                if (this.currentList != null) {
                    Object e2 = this.currentList.get(++this.currentPosition);
                    if (this.currentPosition + 1 == this.currentList.size()) {
                        this.currentList = null;
                        this.currentPosition = -1;
                    }
                    return e2;
                }
                if (this.end) {
                    return null;
                }
                Object o = abq.take();
                if (o instanceof List) {
                    this.currentList = (List)o;
                    e = this.currentList.get(++this.currentPosition);
                    if (this.currentPosition + 1 == this.currentList.size()) {
                        this.currentList = null;
                        this.currentPosition = -1;
                    }
                } else {
                    e = o;
                }
                if (e == MemoryBlockingQueue.this.endElement) {
                    this.end = true;
                    return null;
                }
                return e;
            }
        };
        this.list.add(abq);
        return cons;
    }

    public MemoryBlockingQueue(T endElement) {
        this.endElement = endElement;
    }

    public void close() throws IOException {
    }

    public void end() throws IOException, InterruptedException {
        this.put(this.endElement);
    }
}

