/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.swagger2;

import com.indy.engine.common.swagger2.IOpenAPI;
import com.indy.runtime.json.JsonNode;
import com.indy.runtime.json.JsonUtils;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;

public class SwaggerDefinition
implements IOpenAPI {
    @IOpenAPI.ToSerialize(name="swagger")
    String version = "2.0";
    @IOpenAPI.ToSerialize(name="basePath")
    String basePath;
    @IOpenAPI.ToSerialize(name="schemes")
    List<String> schemes = new ArrayList<String>();
    @IOpenAPI.ToSerialize(name="paths")
    Map<String, Path> paths = new TreeMap<String, Path>();
    @IOpenAPI.ToSerialize(name="definitions")
    Map<String, Definition> definitions = new TreeMap<String, Definition>();
    @IOpenAPI.ToSerialize(name="securityDefinitions")
    Map<String, Security> securityDefinition = new TreeMap<String, Security>();
    @IOpenAPI.ToSerialize(name="security")
    List<SecurityRef> security = null;
    @IOpenAPI.ToSerialize(name="info")
    Info info;

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public SwaggerDefinition(String basePath) {
        this.basePath = basePath;
    }

    public Path newPath(String pathAsString) {
        return this.paths.computeIfAbsent(pathAsString, k -> new Path());
    }

    public Definition newRawDefinition(String name, String checksum, String raw, boolean subDefinition) throws Exception {
        Object o = JsonUtils.jsonNodeToObject((String)raw);
        Definition def = this.newDefinition(name, checksum, o, subDefinition);
        def.raw = raw;
        return def;
    }

    private Definition newDefinition(String prefix, String checksum, Object object, boolean subDefinition) throws Exception {
        Definition def = null;
        String _prefix = IOpenAPI.computeName(prefix);
        Object computeName = _prefix;
        int index = 1;
        do {
            Definition definition;
            if ((definition = this.definitions.get(computeName)) != null && definition.checkSum != null && definition.checkSum.equals(checksum)) {
                def = definition;
                continue;
            }
            if (definition != null) {
                computeName = _prefix + "_" + ++index;
                continue;
            }
            def = new Definition();
            def.object = object;
            def.checkSum = checksum;
            def.name = computeName;
            this.definitions.put((String)computeName, def);
        } while (def == null);
        if (subDefinition) {
            for (Map.Entry<String, Object> entry : ((Map)def.object).entrySet()) {
                this.createSubDef(prefix, (Map)def.object, entry);
            }
        }
        return def;
    }

    private void createSubDef(String prefix, Map<String, Object> parent, Map.Entry<String, Object> entry) throws Exception {
        if (entry.getValue() instanceof Map) {
            Object type = ((Map)entry.getValue()).get("type");
            if (type instanceof String && type.equals("object")) {
                parent.remove(entry.getKey());
                String string = this.newDefinition((String)prefix, (String)entry.getKey(), (Object)entry.getValue(), (boolean)false).name;
                if (parent.get("type") != null && parent.get("type").equals("array")) {
                    parent.put("$ref", "#/definitions/" + string);
                } else {
                    TreeMap<String, CallSite> map = new TreeMap<String, CallSite>();
                    map.put("$ref", (CallSite)((Object)("#/definitions/" + string)));
                    parent.put(entry.getKey(), map);
                }
            }
            for (Map.Entry<String, Object> entry2 : ((Map)entry.getValue()).entrySet()) {
                this.createSubDef(prefix, (Map)entry.getValue(), entry2);
            }
        }
    }

    public void writeFile(String sTAMBIA_SWAGGER_20_PATH) throws IllegalArgumentException, IllegalAccessException, FileNotFoundException, XMLStreamException {
        Object o = IOpenAPI.serialize(this);
        JsonNode.serialize((Object)o, (OutputStream)new FileOutputStream(sTAMBIA_SWAGGER_20_PATH), (String)"UTF-8");
    }

    public void addSchemes(String string) {
        this.schemes.add(string);
    }

    public Info newInfo() {
        if (this.info == null) {
            this.info = new Info();
        }
        return this.info;
    }

    public Info getInfo() {
        return this.info;
    }

    public Map<String, Security> getSecurityDefinition() {
        return this.securityDefinition;
    }

    public List<SecurityRef> getSecurity() {
        return this.security;
    }

    public void setSecurity(List<SecurityRef> security) {
        this.security = security;
    }

    public static class Definition
    implements IOpenAPI.Serialize {
        public String name;
        String raw;
        String checkSum;
        Object object;

        @Override
        public Object serialize() {
            return this.object;
        }
    }

    @IOpenAPI.ToSerialize
    public static class Info {
        @IOpenAPI.ToSerialize(name="description")
        public String description;
        @IOpenAPI.ToSerialize(name="version")
        public String version;
        @IOpenAPI.ToSerialize(name="title")
        public String title;
        @IOpenAPI.ToSerialize(name="termsOfService")
        public String termsOfService;

        public String getTitle() {
            return this.title;
        }
    }

    @IOpenAPI.ToSerialize
    public static class Method {
        @IOpenAPI.ToSerialize(name="operationId")
        String operationId;
        @IOpenAPI.ToSerialize(name="responses")
        Map<String, Response> responses = new TreeMap<String, Response>();
        @IOpenAPI.ToSerialize(name="parameters")
        List<Parameter> parameters = new ArrayList<Parameter>();
        @IOpenAPI.ToSerialize(name="consumes")
        List<String> consumes = new ArrayList<String>();
        @IOpenAPI.ToSerialize(name="produces")
        List<String> produces = new ArrayList<String>();
        @IOpenAPI.ToSerialize(name="tags")
        Set<String> tags = new TreeSet<String>();

        public Response newResponse(String code) {
            Response response = new Response();
            response.code = code;
            this.responses.put(code, response);
            return response;
        }

        public Parameter newParameter(String string) {
            Parameter parameter = new Parameter(string);
            this.parameters.add(parameter);
            return parameter;
        }

        public void addProduces(String string) {
            this.produces.add(string);
        }

        public void addConsumes(String string) {
            this.consumes.add(string);
        }

        public void setOperationId(String name) {
            this.operationId = name;
        }

        public void addTags(Set<String> tags) {
            this.tags.addAll(tags);
        }
    }

    @IOpenAPI.ToSerialize
    public static class Parameter {
        @IOpenAPI.ToSerialize(name="name")
        String name;
        @IOpenAPI.ToSerialize(name="in")
        String in;
        @IOpenAPI.ToSerialize(name="schema")
        SchemaRef schemaRef;
        @IOpenAPI.ToSerialize(name="schema")
        Object schema;
        @IOpenAPI.ToSerialize(name="type")
        String type;
        @IOpenAPI.ToSerialize(name="required")
        public boolean required;
        @IOpenAPI.ToSerialize(name="enum")
        Object enumValues;

        public Parameter(String string) {
            this.name = string;
        }

        public void setIn(String in) {
            this.in = in;
        }

        public void newSchemaRef(String string) {
            this.schemaRef = new SchemaRef(string);
        }

        public void newSchema(String name, String raw, boolean global) throws Exception {
            this.schema = JsonUtils.jsonNodeToObject((String)raw);
        }

        public void setType(String type2) {
            this.type = type2;
        }

        public void setEnumValues(List<String> values) throws Exception {
            StringBuilder b = new StringBuilder();
            if (values != null && !values.isEmpty()) {
                for (String s : values) {
                    if (b.length() != 0) {
                        b.append(",");
                    }
                    b.append("\"" + s + "\"");
                }
                this.enumValues = JsonUtils.jsonNodeToObject((String)("[" + b.toString() + "]"));
            }
        }
    }

    @IOpenAPI.ToSerialize
    public static class Path
    implements IOpenAPI.Serialize {
        @IOpenAPI.ToSerialize(name="")
        Map<String, Method> methods = new TreeMap<String, Method>();

        public Method newMethod(String method) {
            Method _method = new Method();
            this.methods.put(method, _method);
            return _method;
        }

        @Override
        public Object serialize() {
            return this.methods;
        }
    }

    @IOpenAPI.ToSerialize
    public static class Response {
        String code;
        @IOpenAPI.ToSerialize(name="schema")
        SchemaRef schemaRef;
        @IOpenAPI.ToSerialize(name="schema")
        Object schema;
        @IOpenAPI.ToSerialize(name="description")
        public String description;
        @IOpenAPI.ToSerialize(name="type")
        public String type;

        public void newSchemaRef(String string) {
            this.schemaRef = new SchemaRef(string);
        }

        public void newSchema(String name, String raw, boolean global) throws Exception {
            this.schema = JsonUtils.jsonNodeToObject((String)raw);
        }
    }

    static class SchemaRef
    implements IOpenAPI.Serialize {
        String ref;

        public SchemaRef(String string) {
            this.ref = string;
        }

        @Override
        public Object serialize() {
            TreeMap<String, CallSite> map = new TreeMap<String, CallSite>();
            map.put("$ref", (CallSite)((Object)("#/definitions/" + this.ref)));
            return map;
        }
    }

    @IOpenAPI.ToSerialize
    public static class Security {
        @IOpenAPI.ToSerialize(name="type")
        public String type = "basic";
    }

    @IOpenAPI.ToSerialize
    public static class SecurityRef {
        @IOpenAPI.ToSerialize(name="BasicAuth", keepEmptyArray=true)
        List<String> l = new ArrayList<String>();
    }
}

