/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.api.impl.jdbc;

import com.indy.engine.core.actionCodes.convert.JdbcConverter;
import com.indy.engine.core.api.impl.CellMapProperties;
import com.indy.engine.core.api.impl.jdbc.JdbcReaderProperties;
import com.indy.engine.core.jdbc.IResultSetPreviousRowComparator;
import com.indy.runtime.api.ICellReader;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultSetPreviousRowComparator
implements IResultSetPreviousRowComparator {
    private ResultSet resultSet;
    private List<Integer> indexes;
    private Map<Integer, Object> values;
    private Map<Integer, ICellReader<ResultSet>> cellReaders;
    private boolean getDateAsTimestamp = false;

    public ResultSetPreviousRowComparator(ResultSet rs) {
        this.resultSet = rs;
        this.indexes = new ArrayList<Integer>();
        this.cellReaders = new HashMap<Integer, ICellReader<ResultSet>>();
        this.values = new HashMap<Integer, Object>();
    }

    public void declareKey(int columnPosition) throws EngineExceptionI {
        if (!this.values.isEmpty()) {
            throw new EngineExceptionI("Cannot declare a new key after a first compare()");
        }
        if (!this.indexes.contains(columnPosition)) {
            this.indexes.add(columnPosition);
        }
        if (!this.cellReaders.containsKey(columnPosition)) {
            try {
                CellMapProperties cellMapProperties = new CellMapProperties();
                cellMapProperties.sourceIndex = columnPosition;
                cellMapProperties.sourceName = this.resultSet.getMetaData().getColumnLabel(columnPosition);
                cellMapProperties.sourceType = this.resultSet.getMetaData().getColumnType(columnPosition);
                JdbcReaderProperties sourceProperties = new JdbcReaderProperties();
                sourceProperties.setDateAsTimestamp(this.getDateAsTimestamp);
                this.cellReaders.put(columnPosition, (ICellReader<ResultSet>)JdbcConverter.getResultSetCellReader((CellMapProperties)cellMapProperties, (JdbcReaderProperties)sourceProperties));
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
    }

    public boolean compare() throws EngineExceptionI {
        boolean keysAreEqual = true;
        if (this.values.isEmpty()) {
            keysAreEqual = false;
        }
        for (int index : this.indexes) {
            if (keysAreEqual) {
                keysAreEqual = this.compareValue(index);
            }
            if (keysAreEqual) continue;
            this.setValue(index);
        }
        return keysAreEqual;
    }

    private void setValue(int index) throws EngineExceptionI {
        try {
            this.values.put(index, this.getValue(index));
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    private boolean compareValue(int index) throws EngineExceptionI {
        Object newValue;
        try {
            newValue = this.getValue(index);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        Object oldValue = this.values.get(index);
        if (newValue == null && oldValue == null) {
            return true;
        }
        if (newValue == null || oldValue == null) {
            return false;
        }
        if (newValue instanceof byte[]) {
            byte[] newBytes = (byte[])newValue;
            if (oldValue instanceof byte[]) {
                byte[] oldBytes = (byte[])oldValue;
                return Arrays.equals(newBytes, oldBytes);
            }
        }
        return newValue.equals(oldValue);
    }

    private Object getValue(int index) throws Exception {
        return this.cellReaders.get(index).read((Object)this.resultSet);
    }

    public void configureGetDateAsTimestamp(boolean getDateAsTimestamp) {
        this.getDateAsTimestamp = getDateAsTimestamp;
    }
}

