/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.connection.jdbc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.indy.engine.core.externalvalueresolver.IExternalValueResolverPlugin;
import com.semarchy.xdi.runtime.connection.jdbc.AbstractDataSourceImpl;
import com.semarchy.xdi.runtime.connection.jdbc.AbstractDataSourceWrapperImpl;
import com.semarchy.xdi.runtime.connection.jdbc.DataSourceConfiguration;
import com.semarchy.xdi.runtime.connection.jdbc.DriverManagerDataSourceImpl;
import com.semarchy.xdi.runtime.connection.jdbc.HikariDataSourceImpl;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DataSourceManager {
    private static final DataSourceManager INSTANCE = new DataSourceManager();
    private CacheLoader<DataSourceConfiguration, AbstractDataSourceImpl> dataSourceCacheLoader = new CacheLoader<DataSourceConfiguration, AbstractDataSourceImpl>(){

        public AbstractDataSourceImpl load(DataSourceConfiguration config) {
            return this.doCreateDataSource(config);
        }

        private AbstractDataSourceImpl doCreateDataSource(DataSourceConfiguration configuration) {
            return configuration.isEnablePool() ? new HikariDataSourceImpl(configuration.jdbcParameters()) : new DriverManagerDataSourceImpl(configuration.jdbcParameters());
        }
    };
    private RemovalListener<DataSourceConfiguration, DataSource> removalListener = entry -> {
        Object object = entry.getValue();
        if (object instanceof AbstractDataSourceWrapperImpl) {
            AbstractDataSourceWrapperImpl wrapper = (AbstractDataSourceWrapperImpl)object;
            try {
                wrapper.close();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    };
    private LoadingCache<DataSourceConfiguration, AbstractDataSourceImpl> dataSourceCache = DataSourceManager.cacheBuilderSpecProperty("xdi.runtime.jdbcDataSourceCache", (CacheBuilder<Object, Object>)CacheBuilder.newBuilder()).removalListener(this.removalListener).build(this.dataSourceCacheLoader);

    private DataSourceManager() {
        Thread thread = new Thread(() -> this.dataSourceCache.invalidateAll());
        Runtime.getRuntime().addShutdownHook(thread);
    }

    public static DataSourceManager instance() {
        return INSTANCE;
    }

    private static CacheBuilder<Object, Object> cacheBuilderSpecProperty(String propName, CacheBuilder<Object, Object> defaultValue) {
        String propValue = System.getProperty(propName);
        if (propValue == null) {
            return defaultValue;
        }
        try {
            CacheBuilderSpec cacheBuilderSpec = CacheBuilderSpec.parse((String)propValue);
            return CacheBuilder.from((CacheBuilderSpec)cacheBuilderSpec);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public DataSource getDataSource(DataSourceConfiguration configuration) {
        AbstractDataSourceImpl ds = (AbstractDataSourceImpl)this.dataSourceCache.getUnchecked((Object)configuration);
        try {
            ds.refreshCredentials();
        }
        catch (IExternalValueResolverPlugin.ExternalValueResolverException e) {
            throw new CredentialResolutionException((Exception)((Object)e));
        }
        return ds;
    }

    private class CredentialResolutionException
    extends RuntimeException {
        CredentialResolutionException(Exception cause) {
            super("Failed to refresh datasource credentials", cause);
        }
    }
}

