/*
 * Decompiled with CFR 0.152.
 */
package com.indy.cross.registry;

import com.indy.cross.CrossFactory;
import com.indy.cross.CrossItem;
import com.indy.cross.CrossModel;
import com.indy.cross.DocumentRoot;
import com.indy.cross.registry.LineageObjectKey;
import com.indy.cross.registry.Messages;
import com.indy.cross.util.CrossResourceImpl;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.tools.MutexSchedulingRule;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.cache.CacheSourceEvent;
import com.semarchy.xdi.designer.core.services.registry.ICrossReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={IRegistryService.IRegistry.class, ICacheService.ICacheServiceListener.class}, enabled=false)
public class RegistryCrossItem
implements IRegistryService.IRegistry<ICrossReference>,
ICacheService.ICacheServiceListener,
ICacheService.IBatchedListener {
    private Set<String> fileID = new HashSet<String>();
    private ICacheService cacheService;
    private Map<URI, CrossModel> lineageToPersist = Collections.synchronizedMap(new HashMap());
    private final MutexSchedulingRule mutexRule = new MutexSchedulingRule();
    private boolean handlingEvents = false;
    private Job saveModelJob = new GenerateCrossModelJob();
    private boolean inited = false;

    @Activate
    public void init() {
        if (!this.cacheService.isInit()) {
            return;
        }
        try {
            final HashSet files = new HashSet();
            ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    switch (resource.getType()) {
                        case 4: {
                            if (resource.getProject().isOpen()) break;
                            return false;
                        }
                        case 2: {
                            if (!resource.getName().equals("indy.diagram")) break;
                            return false;
                        }
                        case 1: {
                            if (!"cross".equals(resource.getFileExtension())) break;
                            files.add((IFile)resource);
                        }
                    }
                    return true;
                }
            });
            for (IFile f : files) {
                URI lineageResource = Util.convertIFileToEMFURI((IFile)f);
                StringBuffer buf = new StringBuffer();
                int i = 1;
                while (i < lineageResource.segmentCount()) {
                    if (i != 2) {
                        buf.append("/");
                        buf.append(lineageResource.trimFileExtension().segment(i));
                    }
                    ++i;
                }
                URI uri = URI.createPlatformResourceURI((String)buf.toString(), (boolean)false);
                this.fileID.add(this.cacheService.getSourceId(uri));
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.inited = true;
    }

    protected void handlePersistCrossRefDemand(URI lineageURI, CrossModel it) {
        this.lineageToPersist.put(lineageURI, it);
    }

    public boolean registerFrom(String resourceFileId, IRegistryService.IRegistrationContribution resource) throws Exception {
        boolean refreshCrossRefFile;
        if (!resource.getURI().isPlatformResource()) {
            return false;
        }
        URI lineageResourceURI = Util.getResourceLineageURI((URI)resource.getURI());
        IFile file = Util.convertEMFURIToFile((URI)lineageResourceURI);
        IFile resourceFile = Util.convertEMFURIToFile((URI)resource.getURI());
        boolean bl = refreshCrossRefFile = !file.exists() || file.getLocation().toFile().lastModified() + 1000L < resourceFile.getLocation().toFile().lastModified();
        if (refreshCrossRefFile) {
            CrossModel root = null;
            List l = resource.createRegistryItemsFor(ICrossReference.class);
            if (l == null) {
                return false;
            }
            Iterator iterator = l.iterator();
            if (iterator.hasNext()) {
                Object o = iterator.next();
                root = (CrossModel)o;
            }
            if (root != null) {
                this.handlePersistCrossRefDemand(lineageResourceURI, root);
            }
        }
        this.fileID.add(resourceFileId);
        return true;
    }

    @Reference
    public void bind(ICacheService cacheService) {
        this.cacheService = cacheService;
        this.cacheService.addCacheServiceListener((ICacheService.ICacheServiceListener)this);
        this.cacheService.addEventListener((ICacheService.ICacheSourceEventListener)this);
    }

    public void unbind(ICacheService cacheService) {
        this.cacheService.removeCacheServiceListener((ICacheService.ICacheServiceListener)this);
        this.cacheService.removeEventListener((ICacheService.ICacheSourceEventListener)this);
        this.cacheService = null;
    }

    public boolean unregisterFrom(String resourceFileId) {
        return this.fileID.remove(resourceFileId);
    }

    public ICrossReference find(IRegistryService.IRegistryKey key) {
        throw new UnsupportedOperationException();
    }

    public List<ICrossReference> find(IRegistryService.IRegistryMatcher matcher) {
        if (!this.inited) {
            this.init();
        }
        ArrayList<ICrossReference> res = new ArrayList<ICrossReference>();
        if (matcher instanceof Matcher && this.fileID.contains(((Matcher)matcher).mapFileID)) {
            URI uri = this.cacheService.findResourceURIByFileId(((Matcher)matcher).mapFileID);
            URI lineageURI = Util.getResourceLineageURI((URI)uri);
            if (lineageURI != null) {
                ResourceSet rs = ((Matcher)matcher).resourceSet;
                try {
                    Resource r = rs.getResource(lineageURI, true);
                    CrossModel it = ((DocumentRoot)r.getContents().get(0)).getRoot();
                    for (CrossItem i : it.getRef()) {
                        if (!matcher.match((Object)i.getRegistrationKey())) continue;
                        res.add(i);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (matcher instanceof MapMatcher && this.fileID.contains(((MapMatcher)matcher).mapFileID)) {
            URI uri = this.cacheService.findResourceURIByFileId(((MapMatcher)matcher).mapFileID);
            URI lineageURI = Util.getResourceLineageURI((URI)uri);
            if (uri != null) {
                CrossResourceImpl r = new CrossResourceImpl(lineageURI);
                try {
                    r.load(new HashMap());
                    CrossModel it = ((DocumentRoot)r.getContents().get(0)).getRoot();
                    res.addAll((Collection<ICrossReference>)it.getRef());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return res;
    }

    public List<ICrossReference> getAll() {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.fileID.clear();
        this.inited = false;
    }

    public void addRegistryItemEventListener(IRegistryService.IRegistryItemEventListener listener) {
    }

    public void removeRegistryItemEventListener(IRegistryService.IRegistryItemEventListener listener) {
    }

    public void addRegistryBatchEventListener(IRegistryService.IRegistryBatchEventListener listener) {
    }

    public void removeRegistryBatchEventListener(IRegistryService.IRegistryBatchEventListener listener) {
    }

    public void handleEvent(CacheSourceEvent event) {
    }

    public void handBatchedEvents() {
        if (this.handlingEvents && !this.lineageToPersist.isEmpty()) {
            new GenerateCrossModelJob().schedule();
        }
    }

    public void handleCacheInitialized() {
        if (!this.inited) {
            this.init();
        }
        this.handlingEvents = true;
        new GenerateCrossModelJob().schedule();
    }

    public void handleCacheInitializing() {
        this.handlingEvents = false;
    }

    private class GenerateCrossModelJob
    extends WorkspaceJob {
        private Map<URI, CrossModel> rootMap;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GenerateCrossModelJob() {
            super(Messages.RegistryCrossItem_0);
            IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
            MutexSchedulingRule combinedRule = RegistryCrossItem.this.mutexRule;
            Map<URI, CrossModel> map = RegistryCrossItem.this.lineageToPersist;
            synchronized (map) {
                this.rootMap = new HashMap<URI, CrossModel>(RegistryCrossItem.this.lineageToPersist);
                for (URI u : this.rootMap.keySet()) {
                    IFile f = Util.convertEMFURIToFile((URI)u);
                    combinedRule = !f.getProject().exists() ? MultiRule.combine((ISchedulingRule)ruleFactory.createRule((IResource)f.getProject()), (ISchedulingRule)combinedRule) : MultiRule.combine((ISchedulingRule)ruleFactory.modifyRule((IResource)f.getProject()), (ISchedulingRule)combinedRule);
                    IFolder buildFolder = f.getProject().getFolder("indy.build");
                    if (!buildFolder.exists()) {
                        combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.createRule((IResource)buildFolder), (ISchedulingRule)combinedRule);
                    } else {
                        if (!buildFolder.isLinked()) {
                            combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.createRule((IResource)buildFolder), (ISchedulingRule)combinedRule);
                            combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.deleteRule((IResource)buildFolder), (ISchedulingRule)combinedRule);
                        }
                        combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.modifyRule((IResource)buildFolder), (ISchedulingRule)combinedRule);
                    }
                    combinedRule = MultiRule.combine((ISchedulingRule)ruleFactory.derivedRule((IResource)buildFolder), (ISchedulingRule)combinedRule);
                    combinedRule = f.exists() ? MultiRule.combine((ISchedulingRule)ruleFactory.createRule((IResource)f), (ISchedulingRule)combinedRule) : MultiRule.combine((ISchedulingRule)ruleFactory.modifyRule((IResource)f), (ISchedulingRule)combinedRule);
                }
                RegistryCrossItem.this.lineageToPersist.clear();
            }
            this.setRule((ISchedulingRule)combinedRule);
            this.setPriority(50);
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            for (URI uri : this.rootMap.keySet()) {
                IFile f = Util.convertEMFURIToFile((URI)uri);
                IFolder fold = f.getProject().getFolder("indy.build");
                Util.checkLinkedBuildFolder((IFolder)fold, (IProgressMonitor)monitor);
                Resource lineageResource = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
                DocumentRoot doc = CrossFactory.eINSTANCE.createDocumentRoot();
                doc.setRoot(this.rootMap.get(uri));
                lineageResource.getContents().add((Object)doc);
                HashMap options = new HashMap();
                try {
                    lineageResource.save(options);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                RegistryCrossItem.this.fileID.add(doc.getRoot().getFileID());
            }
            return Status.OK_STATUS;
        }
    }

    public static class MapMatcher
    implements IRegistryService.IRegistryMatcher {
        private String mapFileID;

        public MapMatcher(String mapFileID) {
            this.mapFileID = mapFileID;
        }

        public boolean match(Object o) {
            if (o instanceof LineageObjectKey) {
                return this.mapFileID.equals(((LineageObjectKey)o).getProviderFileID());
            }
            return false;
        }
    }

    public static class Matcher
    implements IRegistryService.IRegistryMatcher {
        private String mapFileID;
        private String mdFileID;
        private String mdEltID;
        private ResourceSet resourceSet;

        public Matcher(String mapFileID, String mdFIleID, String mdEltID, ResourceSet resourceSet) {
            this.mapFileID = mapFileID;
            this.mdEltID = mdEltID;
            this.mdFileID = mdFIleID;
            this.resourceSet = resourceSet;
        }

        public boolean match(Object o) {
            if (o instanceof LineageObjectKey) {
                return this.mdFileID.equals(((LineageObjectKey)o).getProviderFileID()) && this.mdEltID.equals(((LineageObjectKey)o).getEltID());
            }
            return false;
        }
    }
}

