/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.internal;

import com.indy.emf.compare.integration.internal.Messages;
import com.indy.emf.compare.integration.internal.StorageAdapter;
import com.indy.emf.compare.integration.map.CompareMapPackage;
import com.indy.emf.compare.integration.md.CompareMdPackage;
import com.indy.emf.compare.integration.proc.CompareProcPackage;
import com.indy.emf.compare.integration.tech.CompareTechPackage;
import com.indy.emf.compare.integration.tpc.CompareTpcPackage;
import com.indy.gmf.proc.ProcPackage;
import com.indy.ui.custom.out.Util;
import com.stambia.md.MdPackage;
import com.stambia.tech.TechPackage;
import com.stambia.tpc.TpcPackage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.hook.AbstractResourceSetHooks;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceFactoryRegistryImpl;
import org.eclipse.emf.ecore.util.BasicExtendedMetaData;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;

public class CompareResourceSetHook
extends AbstractResourceSetHooks {
    public void preLoadingHook(ResourceSet resourceSet, final Collection<? extends URI> uris) {
        super.preLoadingHook(resourceSet, uris);
        Resource.Factory.Registry reg = resourceSet.getResourceFactoryRegistry();
        if (!(reg instanceof BaseMapRegistry)) {
            EPackageRegistryImpl preg = new EPackageRegistryImpl();
            preg.put((Object)"http://www.indy.com/v2/map/compare", (Object)CompareMapPackage.eINSTANCE);
            preg.put((Object)"http://www.stambia.com/md/compare", (Object)CompareMdPackage.eINSTANCE);
            preg.put((Object)"http://www.example.org/proc/compare", (Object)CompareProcPackage.eINSTANCE);
            preg.put((Object)"http://www.stambia.com/tech/compare", (Object)CompareTechPackage.eINSTANCE);
            preg.put((Object)"http://www.stambia.com/tpc/compare", (Object)CompareTpcPackage.eINSTANCE);
            resourceSet.setPackageRegistry((EPackage.Registry)preg);
            resourceSet.setResourceFactoryRegistry((Resource.Factory.Registry)new BaseMapRegistry());
            resourceSet.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getNotifier() instanceof ResourceSet && notification.getEventType() == 3 && notification.getNewValue() instanceof Resource && !uris.contains(((Resource)notification.getNewValue()).getURI())) {
                        ((ResourceSet)notification.getNotifier()).getResources().remove(notification.getNewValue());
                    }
                }
            });
        }
    }

    class BaseMapRegistry
    extends ResourceFactoryRegistryImpl {
        BaseMapRegistry() {
        }

        protected Resource.Factory delegatedGetFactory(URI uri, String contentTypeIdentifier) {
            if (uri.fileExtension() != null) {
                return new CompareResourceFactory();
            }
            return super.delegatedGetFactory(uri, contentTypeIdentifier);
        }
    }

    private class CompareExtendedMetaData
    extends BasicExtendedMetaData {
        public CompareExtendedMetaData(String namespace, EPackage modelPackage) {
            EPackageRegistryImpl preg = new EPackageRegistryImpl();
            preg.put((Object)namespace, (Object)modelPackage);
            this.registry = preg;
        }

        private String getNamespace(String compareNameSpace) {
            if ("http://www.indy.com/v2/map/compare".equals(compareNameSpace)) {
                return "http://www.indy.com/v2/map";
            }
            if ("http://www.stambia.com/md/compare".equals(compareNameSpace)) {
                return "http://www.stambia.com/md";
            }
            if ("http://www.stambia.com/tech/compare".equals(compareNameSpace)) {
                return "http://www.stambia.com/tech";
            }
            if ("http://www.stambia.com/tpc/compare".equals(compareNameSpace)) {
                return "http://www.stambia.com/tpc";
            }
            if ("http://www.example.org/proc/compare".equals(compareNameSpace)) {
                return "http://www.example.org/proc";
            }
            return compareNameSpace;
        }

        public String getNamespace(EStructuralFeature eStructuralFeature) {
            String s = super.getNamespace(eStructuralFeature);
            return this.getNamespace(s);
        }

        public String getNamespace(EPackage ePackage) {
            String s = super.getNamespace(ePackage);
            return this.getNamespace(s);
        }
    }

    private class CompareResource
    extends XMLResourceImpl {
        EPackage modelPackage;

        CompareResource(URI uri, EPackage modelPackage) {
            super(uri);
            this.modelPackage = modelPackage;
        }

        protected XMLHelper createXMLHelper() {
            return new CompareXMLHelper((XMLResource)this);
        }

        protected XMLSave createXMLSave() {
            return new XMLSaveImpl(this.createXMLHelper()){

                protected String getDatatypeValue(Object value, EStructuralFeature f, boolean isAttribute) {
                    if (!isAttribute && f == CompareProcPackage.eINSTANCE.getActionProcess_Diagram() && value != null) {
                        return "<![CDATA[" + String.valueOf(value) + "]]>";
                    }
                    if (!isAttribute && f == CompareMapPackage.eINSTANCE.getMap_Diagram() && value != null) {
                        return "<![CDATA[" + String.valueOf(value) + "]]>";
                    }
                    return super.getDatatypeValue(value, f, isAttribute);
                }
            };
        }

        public void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
            URI uri = Util.convertIFileToEMFURI((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(StorageAdapter.inexistentResourcePath.addFileExtension(this.getURI().fileExtension())));
            if (this.getURI().equals(uri)) {
                return;
            }
            super.doLoad(inputStream, options);
        }

        public void save(Map<?, ?> options) throws IOException {
            HashMap map = new HashMap(options);
            map.put("ENCODING", "UTF-8");
            map.put("EXTENDED_META_DATA", new CompareExtendedMetaData(this.modelPackage.getNsURI(), this.modelPackage));
            map.put("SCHEMA_LOCATION", Boolean.TRUE);
            map.put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
            map.put("USE_LEXICAL_HANDLER", Boolean.TRUE);
            try {
                super.save(map);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IOException(Messages.CompareResourceSetHook_5 + String.valueOf(this.getURI()), ex);
            }
        }
    }

    private class CompareResourceFactory
    extends ResourceFactoryImpl {
        private CompareResourceFactory() {
        }

        public Resource createResource(URI uri) {
            String extension = uri.fileExtension();
            if (extension != null) {
                CompareResource resource = null;
                if ("map".equals(extension) || extension.startsWith("map%20")) {
                    resource = new CompareResource(uri, (EPackage)MdPackage.eINSTANCE);
                } else if ("proc".equals(extension) || extension.startsWith("proc%20")) {
                    resource = new CompareResource(uri, (EPackage)ProcPackage.eINSTANCE);
                } else if ("md".equals(extension) || extension.startsWith("md%20")) {
                    resource = new CompareResource(uri, (EPackage)MdPackage.eINSTANCE);
                } else if ("tech".equals(extension) || "tech_ext".equals(extension) || extension.startsWith("tech_ext%20") || extension.startsWith("tech%20")) {
                    resource = new CompareResource(uri, (EPackage)TechPackage.eINSTANCE);
                } else if ("tpc".equals(extension) || extension.startsWith("tpc%20")) {
                    resource = new CompareResource(uri, (EPackage)TpcPackage.eINSTANCE);
                }
                if (resource != null) {
                    resource.getDefaultSaveOptions().put("SCHEMA_LOCATION", Boolean.FALSE);
                    resource.getDefaultSaveOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                    resource.getDefaultLoadOptions().put("USE_ENCODED_ATTRIBUTE_STYLE", Boolean.TRUE);
                    resource.getDefaultLoadOptions().put("USE_LEXICAL_HANDLER", Boolean.TRUE);
                    resource.getDefaultLoadOptions().put("EXTENDED_META_DATA", Boolean.TRUE);
                    resource.getDefaultLoadOptions().put("SUPPRESS_DOCUMENT_ROOT", Boolean.TRUE);
                    return resource;
                }
            }
            return super.createResource(uri);
        }
    }

    private class CompareXMLHelper
    extends XMLHelperImpl {
        CompareXMLHelper(XMLResource resource) {
            super(resource);
        }

        public String getURI(String prefix) {
            if ("map".equals(prefix)) {
                return "http://www.indy.com/v2/map/compare";
            }
            if ("md".equals(prefix)) {
                return "http://www.stambia.com/md/compare";
            }
            if ("proc".equals(prefix)) {
                return "http://www.example.org/proc/compare";
            }
            if ("tech".equals(prefix)) {
                return "http://www.stambia.com/tech/compare";
            }
            if ("tpc".equals(prefix)) {
                return "http://www.stambia.com/tpc/compare";
            }
            return super.getURI(prefix);
        }

        public String getName(ENamedElement obj) {
            if (obj == CompareMapPackage.eINSTANCE.getMap()) {
                return "map";
            }
            if (obj == CompareMdPackage.eINSTANCE.getMdRootNode()) {
                return "node";
            }
            if (obj == CompareProcPackage.eINSTANCE.getActionProcess()) {
                return "process";
            }
            if (obj == CompareTechPackage.eINSTANCE.getTech()) {
                return "tech";
            }
            if (obj == CompareTpcPackage.eINSTANCE.getConf()) {
                return "conf";
            }
            return super.getName(obj);
        }
    }
}

