/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.internal;

import com.indy.environment.tool.URINode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;

public class InternalResourceAdapterFactory
implements IAdapterFactory {
    private Class[] adapters = new Class[]{IFileRevision.class};

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof URINode && adapterType == IFileRevision.class) {
            try {
                return (T)this.createFileRevision((URINode)adaptableObject);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private IFileRevision createFileRevision(URINode adaptableObject) throws Exception {
        return new URINodeFileRevision(adaptableObject);
    }

    public Class<?>[] getAdapterList() {
        return this.adapters;
    }

    class FileStorage
    implements IStorage {
        private File file;

        FileStorage(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public InputStream getContents() throws CoreException {
            try {
                return new FileInputStream(this.file);
            }
            catch (Exception ex) {
                throw new CoreException((IStatus)new Status(4, "com.emf.compare.integration", ex.getMessage(), (Throwable)ex));
            }
        }

        public IPath getFullPath() {
            try {
                return new Path(this.getFile().getCanonicalPath());
            }
            catch (IOException e) {
                return null;
            }
        }

        public String getName() {
            return this.file.getAbsolutePath();
        }

        public boolean isReadOnly() {
            return true;
        }
    }

    class URINodeFileRevision
    implements IFileRevision {
        URINode node;
        FileStorage storage;

        URINodeFileRevision(URINode node) throws Exception {
            this.node = node;
            URL url = FileLocator.toFileURL((URL)node.getUnderlyingURL());
            this.storage = new FileStorage(new File(url.getFile()));
        }

        public IStorage getStorage(IProgressMonitor monitor) throws CoreException {
            return this.storage;
        }

        public String getName() {
            return this.node.getName();
        }

        public URI getURI() {
            return this.storage.getFile().toURI();
        }

        public long getTimestamp() {
            return 0L;
        }

        public boolean exists() {
            return false;
        }

        public String getContentIdentifier() {
            return "";
        }

        public String getAuthor() {
            return "";
        }

        public String getComment() {
            return "";
        }

        public ITag[] getBranches() {
            return new ITag[0];
        }

        public ITag[] getTags() {
            return new ITag[0];
        }

        public boolean isPropertyMissing() {
            return false;
        }

        public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
            return this;
        }
    }
}

