/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.compare.integration.internal.preferences;

import com.indy.emf.compare.integration.internal.preferences.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.IItemDescriptor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class EMFCompareIntegrationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String EMFCOMPARE_PREF_DISABLED_POSTPROCESSORRS = "org.eclipse.emf.compare.preference.postprocessor.disabled";
    private Data data;
    private CheckboxTableViewer viewver;

    public EMFCompareIntegrationPreferencePage() {
    }

    public EMFCompareIntegrationPreferencePage(String title) {
        super(title);
    }

    public EMFCompareIntegrationPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
        this.data = new Data();
        this.initBean();
    }

    private void initBean() {
        this.data.stbPostProcessors.clear();
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.emf.compare.rcp");
        store.setSearchContexts(new IScopeContext[]{InstanceScope.INSTANCE, ConfigurationScope.INSTANCE});
        this.setPreferenceStore((IPreferenceStore)store);
        String disabledProcessors = store.getString(EMFCOMPARE_PREF_DISABLED_POSTPROCESSORRS);
        List<String> currentlyDisabledPostProcessors = disabledProcessors == null ? Collections.EMPTY_LIST : Arrays.asList(disabledProcessors.split(";"));
        for (IItemDescriptor desc : EMFCompareRCPPlugin.getDefault().getPostProcessorDescriptorRegistry().getItemDescriptors()) {
            this.data.stbPostProcessors.add(new PostProcessor(desc.getID(), desc.getLabel(), desc.getDescription(), !currentlyDisabledPostProcessors.contains(desc.getID()), desc.getID().startsWith("com.indy.emf.compare.integration")));
        }
    }

    private void initUI() {
        this.viewver.setInput(this.data.stbPostProcessors);
    }

    protected Control createContents(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        Group group = new Group(main, 0);
        group.setText(Messages.EMFCompareIntegrationPreferencePage_4);
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewver = CheckboxTableViewer.newCheckList((Composite)group, (int)67584);
        this.viewver.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.viewver.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewver.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((PostProcessor)element).label;
            }
        });
        this.viewver.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ((PostProcessor)event.getElement()).enabled = event.getChecked();
                EMFCompareIntegrationPreferencePage.this.viewver.setSelection((ISelection)new StructuredSelection(event.getElement()));
            }
        });
        this.viewver.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return ((PostProcessor)element).enabled;
            }
        });
        this.viewver.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ((PostProcessor)element).isSTb;
            }
        });
        final Label desc = new Label((Composite)group, 64);
        desc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewver.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    desc.setText("");
                } else {
                    desc.setText(((PostProcessor)event.getStructuredSelection().getFirstElement()).desc);
                }
            }
        });
        this.initUI();
        return main;
    }

    protected void performDefaults() {
        this.getPreferenceStore().setToDefault(EMFCOMPARE_PREF_DISABLED_POSTPROCESSORRS);
        this.initBean();
        this.initUI();
        super.performDefaults();
    }

    public boolean performOk() {
        StringBuffer b = new StringBuffer();
        for (PostProcessor p : this.data.stbPostProcessors) {
            if (p.enabled) continue;
            if (b.length() > 0) {
                b.append(";");
            }
            b.append(p.id);
        }
        this.getPreferenceStore().setValue(EMFCOMPARE_PREF_DISABLED_POSTPROCESSORRS, b.toString());
        return super.performOk();
    }

    class Data {
        List<PostProcessor> stbPostProcessors = new ArrayList<PostProcessor>();

        Data() {
        }
    }

    class PostProcessor {
        String label;
        String desc;
        String id;
        boolean enabled;
        boolean isSTb;

        PostProcessor(String id, String label, String desc, boolean enabled, boolean isStb) {
            this.label = label;
            this.desc = desc == null ? "" : desc;
            this.isSTb = isStb;
            this.enabled = enabled;
            this.id = id;
        }
    }
}

