/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.shared.configuration;

import com.indy.engine.shared.configuration.Messages;
import com.indy.engine.shared.configuration.VariableHandler;
import jakarta.xml.bind.JAXBContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationReader {
    private ConfigurationReader() {
    }

    private static Node getNodeFromExternalizedFile(Node child, String mainNodeName, DocumentBuilder docBuilder) throws ParseException, DOMException, VariableHandler.VariableResolutionException, IOException, SAXException {
        Node n = child.getAttributes().getNamedItem("file");
        if (n != null) {
            File f = new File(VariableHandler.updateString(n.getNodeValue()));
            if (!f.exists() || f.isDirectory()) {
                throw new ParseException(String.format(Messages.getString("ConfigurationReader.0"), f.getAbsoluteFile(), mainNodeName));
            }
            Throwable throwable = null;
            Object var6_7 = null;
            try (FileInputStream fis = new FileInputStream(f);){
                Document doc = docBuilder.parse(fis);
                NodeList nl = doc.getChildNodes();
                Node localChild = null;
                int j = 0;
                while (j < nl.getLength()) {
                    Node c = nl.item(j);
                    if (c.getNodeType() == 1 && child.getNodeName().equals(mainNodeName)) {
                        localChild = c;
                        break;
                    }
                    ++j;
                }
                if (localChild == null) {
                    throw new ParseException(String.format(Messages.getString("ConfigurationReader.1"), f.getAbsoluteFile(), mainNodeName));
                }
                return localChild;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return child;
    }

    public static <T> T parse(InputStream runtimeEngineParameters, String mainNodeName, Class<? extends T> type) throws ParseException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(runtimeEngineParameters);
            NodeList nl = doc.getChildNodes().item(0).getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                Node child = nl.item(i);
                if (child.getNodeType() == 1 && child.getNodeName().equals(mainNodeName)) {
                    Node toParse = ConfigurationReader.getNodeFromExternalizedFile(child, mainNodeName, docBuilder);
                    JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{type});
                    return (T)context.createUnmarshaller().unmarshal(toParse);
                }
                ++i;
            }
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException("Unexpected", e);
        }
        return null;
    }

    public static class ParseException
    extends Exception {
        ParseException(String message) {
            super(message);
        }

        ParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

